C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.8                                       C
C     This file last generated 94/10/18                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Store information about global grid size,
C     and partition the problem
C----------------------------------------------------------------
      subroutine set_global_domain(vec_inf,ibuf,nitems,leng_vec_inf)

C     Arguments
C----
      integer vec_inf(*),ibuf(*),nitems(1),leng_vec_inf

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     n_neighbrs,neighbour_nums(99),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     n_neighbrs,neighbour_nums,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi


C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Function
C----

C     Local
C----
      integer dim,totvrs

C     Set a default value for the size of the border
C----
      vec_inf(vec_inf(5)) = 1

      call force_range(nitems(1),2,2,
     >      'Only 2D problems allowed, illegal dim=$')

C     Based on the problem dimension, we can start constructing
C     the vec_inf descriptor vector
C----
      vec_inf(6) = 10
      vec_inf(5) = vec_inf(6)+3*nitems(1)
      vec_inf(7) = vec_inf(5)+nitems(1)+5
      vec_inf(vec_inf(5)+1) = nitems(1)

C     Store this as global information
C----
      call iicopy(vec_inf(vec_inf(5)+2),ibuf,vec_inf(vec_inf(5)+1))
      call iicopy(vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+1))

C     Set total number of variables
C----
      totvrs = 1
      do 20 dim=1,vec_inf(vec_inf(5)+1)
         if (vec_inf(vec_inf(5)+2+dim-1).eq.0) then
            call pe1i('Set global: found zero dimension$',dim)
         else
            totvrs = totvrs
     >           *vec_inf(vec_inf(5)+2+dim-1)
         endif
 20   continue
      call force_range(totvrs,1,-1,'Set dom siz: #points$')
      call force_range(vec_inf(vec_inf(5)),0,-1,'Set dom siz: border$')
      call set_global_variables(totvrs,vec_inf)

      if (dmp_channel_open) then
         call report_domain(vec_inf,dmpchn)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine demo_get_domain_slice(slice,pdim,vec_inf)

C     Arguments
C---- 
      integer pdim
      integer vec_inf(*),slice(pdim,*)
      
C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     n_neighbrs,neighbour_nums(99),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     n_neighbrs,neighbour_nums,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi

C     Functions
C----
      logical trace_setup,trace_matrices,tracer_proc

      
C     Local
C----
      integer llo,hhi,dim,siz
      double precision hh
      logical ts

      ts = trace_setup().or.trace_matrices()
      if (ts) then
         if (tracer_proc()) call pt0('Demo domain slice$')
         if (.not.tracer_proc()) call pd0('Demo domain slice$')
      endif

C     What part of the data do we have?
C---- 
      call force_range(pdim,vec_inf(vec_inf(5)+1),vec_inf(vec_inf(5)+1),
     >     'Demo domain slice, dimension mismatch$')
      call nulv(gxlo,pdim)
      call unitv(gxhi,pdim)
      do 10 dim=1,pdim
         llo = 1+proc_ijk(dim)
     >        *(vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)-1+dim)
     >        /pgrid_size(dim))
         if (proc_ijk(dim)+1.eq.pgrid_size(dim)) then
            hhi = vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)-1+dim)
         else
            hhi = (proc_ijk(dim)+1)
     >           *(vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)-1+dim)
     >           /pgrid_size(dim))
         endif
         slice(1,dim) = llo
         slice(2,dim) = hhi
         if (ts) call pd1i2i('Dimension$',dim,'range$',llo,hhi)
         siz = hhi-llo+1
         hh = 1.d0 / siz
         h  (pdim-dim+1) = hh
         xlo(pdim-dim+1) = llo*hh
         xhi(pdim-dim+1) = hhi*hh
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine set_domain_slice(vec_inf,pdim,slice)

C     Arguments
C---- 
      integer pdim
      integer vec_inf(*),slice(pdim,*)
      
C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     n_neighbrs,neighbour_nums(99),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     n_neighbrs,neighbour_nums,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi

C     Functions
C----
      logical trace_matrices,trace_setup, tracer_proc

C     Local
C----
      integer dim,tot

      if (trace_setup().and.tracer_proc())
     >     call pt0('Setting domain partition$')
      call force_range(pdim,vec_inf(vec_inf(5)+1),vec_inf(vec_inf(5)+1),
     >     'Set domain slice, dimension mismatch$')

C     What part of the data do we have?
C---- 
      tot = 1
      do 10 dim=1,pdim
         vec_inf(vec_inf(6)-1+dim) = slice(1,dim)
         vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)-1+dim) = slice(2,dim)
         vec_inf(vec_inf(5)+2+dim-1) = slice(2,dim)-slice(1,dim)+1
         tot = tot*vec_inf(vec_inf(5)+2-1+dim)
 10   continue
      vec_inf(2) = tot

      if (trace_matrices().or.trace_setup()) then
         call pd2i('Grid sizes (lo/hi) stored @$',
     >        vec_inf(6),
     >        vec_inf(6)+vec_inf(vec_inf(5)+1))
         do 20 dim=1,pdim
            call pd1i1i2i('Dimension$',dim,
     >           'size:$',vec_inf(vec_inf(5)+2+dim-1),
     >           'range:$',vec_inf(vec_inf(6)-1+dim),
     >           vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)-1+dim))
 20      continue
         call pd1i('Owned size$',vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine report_domain(vec_inf,chan)

C     Argument
C----
      integer vec_inf(*),chan

C     Local
C----
      integer dim

      dim = vec_inf(vec_inf(5)+1)

      write(chan,*) '================ Tensor product grid'
      call pc1iai('Global Sizes @$',vec_inf(6)+2*vec_inf(vec_inf(5)+1),
     >     'value$',vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     dim,chan)
      call pc1iai('Local near @$',vec_inf(6),
     >     'value$',vec_inf(vec_inf(6)),
     >     dim,chan)
      call pc1iai('Local far @$',vec_inf(6)+vec_inf(vec_inf(5)+1),
     >     'value$',vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)),
     >     dim,chan)

      return
      end
C----------------------------------------------------------------
C     Convert local (i,j) coordinate to global number;
C     assume fortran storage
C----------------------------------------------------------------
      function grd_lc2glb(i,j,vec_inf)

C     Arguments
C----
      integer i,j, grd_lc2glb,vec_inf(*)

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     n_neighbrs,neighbour_nums(99),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     n_neighbrs,neighbour_nums,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

      
      grd_lc2glb = (vec_inf(vec_inf(6)-1+2)-1+j-1)
     >     *vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)-1+1)
     >     + vec_inf(vec_inf(6)-1+1)-1+i

      return
      end
