C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      subroutine demo_int_grid_mat(matrix,leng_mat,
     >     mat_ptr,vec_inf,leng_vec_inf,comm_context,trace)

C     Arguments
C----
      double precision matrix(*)
      integer leng_mat,
     >     mat_ptr(*),vec_inf(*),leng_vec_inf,comm_context(*)
      logical trace


C     Local
C----
      integer problem_dimension
      parameter (problem_dimension=2)
      integer
     >     slice(problem_dimension,4),
     >     buffer(30),nitems(1)

      call demo_read_grid_size(buffer,nitems,comm_context)
      call set_global_domain(vec_inf,buffer,nitems,leng_vec_inf)
      call demo_get_domain_slice(slice,problem_dimension,vec_inf)
      call set_domain_slice(vec_inf,problem_dimension,slice)

C     Determine how many legs the stencil has, 
C     and what their offsets are
C----
      call demo_get_grid_offsets(mat_ptr,vec_inf)
      leng_mat = (mat_ptr(2)+1)*vec_inf(2)
      if (trace) call pd1i('Case 1: I need$',leng_mat)

C     Get demo pde values
      call pde_initialization(comm_context)

C     create diagonal storage matrix for demo
C----
      call demo_matrix_grid_create(matrix,mat_ptr,vec_inf)

      return
      end
