C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/02                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      subroutine demo_set_problem_format(buff,lo,hi)

C     Arguments
C----
      integer lo,hi
      integer buff(lo:hi)

C     The problem format.
C----
      integer              mat_source,rhs_source
      common /demo_prbfmt/ mat_source,rhs_source

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      call force_range(hi,7,-1,
     >     'Set prb fmt (demo): #items$')
      rhs_source    = buff(6)
      mat_source    = buff(7)

      if (log_channel_open) then
         write(logchn,*) 'Matrix source:',mat_source
      endif

      return
      end
C----------------------------------------------------------------
      subroutine demo_default_problem_format(buff,lo,hi)

C     Arguments
C----
      integer lo,hi
      integer buff(lo:hi)

      hi = 7
C     rhs : internal unit
      buff(6) = 1
C     matrix internal
      buff(7) = 1

      return
      end
C----------------------------------------------------------------
C     Regular 5-point matrix create symmetric
C     
C     output: 
C     tridiagonal diagonal part, upper and lower single diagonal;
C     note that phantom elements corresponding to lines bordering
C     on the domain have been filled in.
C     
C----------------------------------------------------------------
      subroutine demo_matrix_grid_create(matrix,mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*), vec_inf(*)
      double precision matrix(*)
      
C     Functions
C---- 
      logical tracer_proc,trace_progress

      if (tracer_proc().and.trace_progress())
     >     call pt0('Creating matrix$')
      call five_star_matrix(matrix(1),
     >     matrix(1+vec_inf(2)),mat_ptr,
     >     vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >     vec_inf(vec_inf(5)),vec_inf)
      if (tracer_proc().and.trace_progress())
     >     call pt0('Matrix created$')

      return
      end
C----------------------------------------------------------------
      subroutine five_star_matrix
     >     (diag,offs, mat_ptr, ipts,jpts,bord,vec_inf)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, mat_ptr(*),vec_inf(*)
      double precision
     >     diag(ipts,jpts),
     >     offs(ipts,jpts,*)
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi

C     Functions
C----
      double precision dcofx,dcofy, ccofx,ccofy, ucof
      logical trace_setup

C     Local
C---- 
      integer dia,row,col, noffs,i_off,j_off
      double precision curx,cury, sh_x,sh_y, contrib,dc,cc, cm
      
C     Sensibility check
C---- 
      call force_range(ipts,1,-1,'R5pmcs ipts$')
      call force_range(jpts,1,-1,'R5pmcs jpts$')

      noffs = mat_ptr(2)

C     Step through physical domain, evaluating coefficients
C     at x+h/2, y+h/2 points for symmetric matrix
C----
      cm = 1.d0
      if (mod(vec_inf(1),2).eq.1) cm = 2.d0
      call nulv(diag,ipts*jpts)

C     First set the constant term on the diagonal
C----
      curx = xlo(1)
      do 40 col=1,jpts
         cury = xlo(2)
         do 50 row=1,ipts
            diag(row,col) = -ucof(curx,cury)
            cury = cury+h(2)
 50      continue
         curx = curx+h(1)
 40   continue

C     Then set all diagonals, plus their part on the main diagonal
C----
      do 30 dia=1,noffs
         call nulv(offs(1,1,dia),(ipts+2*bord)*(jpts+2*bord))
         call get_dia_offset(i_off,j_off,mat_ptr,dia)
         curx = xlo(1)
         do 10 col=1,jpts
            cury = xlo(2)
            do 20 row=1,ipts
C     Current coordinate plus shift for offdiagonal
               sh_x = curx+i_off*h(1)/2
               sh_y = cury+j_off*h(2)/2
               dc = 0.d0
C     Diffusion in x direction
               contrib = abs(i_off)*dcofx(sh_x,sh_y)
               dc = dc+contrib
C     Diffusion in y direction
               contrib = abs(j_off)*dcofy(sh_x,sh_y)
               dc = dc+contrib
C     Convection coefficient
               sh_x = curx+i_off*h(1)
               sh_y = cury+j_off*h(2)
               cc = abs(i_off)*ccofx(sh_x,sh_y) +
     >              abs(j_off)*ccofy(sh_x,sh_y)
               diag(row,col) = diag(row,col)+cm*dc
               offs(row,col,dia) =
     >              -dc+sign(cc,(i_off+1.d-1)*(j_off+1.d-1))
               cury = cury+h(2)
 20         continue
            curx = curx+h(1)
 10      continue
         if (trace_setup()) call pd2i1d('Offdiag at offset$',
     >        i_off,j_off,'value$',offs(1,1,dia))
 30   continue
      if (trace_setup()) call pd1d('Main diag value$',diag(1,1))
      
      return
      end
C----------------------------------------------------------------
C     Diffusion coefficients
C----------------------------------------------------------------
      function dcofx(x,y)
      double precision x,y, dcofx

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      dcofx = ddx
      if (funnum.eq.stepfun) then
         dcofx = 1.d0
         if (x.gt.sx) dcofx = tx
      endif

      return
      end
C----------------------------------------------------------------
      function dcofy(x,y)
      double precision x,y, dcofy

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      dcofy = ddy
      if (funnum.eq.stepfun) then
         dcofy = 1.d0
         if (y.gt.sy) dcofy = ty
      endif

      return
      end
C----------------------------------------------------------------
C     Convection coefficients
C----------------------------------------------------------------
      function ccofx(x,y)
      double precision x,y, ccofx
      
C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ccofx = vx

      return
      end
C----------------------------------------------------------------
      function ccofy(x,y)
      double precision x,y, ccofy

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ccofy = vy

      return
      end
C----------------------------------------------------------------
C     Reaction coefficient
C----------------------------------------------------------------
      function ucof(x,y)
      double precision x,y, ucof

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ucof = alpha

      return
      end
C----------------------------------------------------------------
      subroutine set_pde_parameters(ibuf,ilen,buff,rlen)

C     Arguments
C----
      integer ilen,rlen
      integer ibuf(ilen)
      double precision buff(rlen)

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      funnum = ibuf(1)
      unsymm = ibuf(2)
      indef = ibuf(3)
      
      ddx = buff(1)
      ddy = buff(2)
      vx = buff(3)
      vy = buff(4)
      alpha = buff(5)
      sx = buff(6)
      tx = buff(7)
      sy = buff(8)
      ty = buff(9)

      if (log_channel_open) then

      write(logchn,*) '================ PDE'
      write(logchn,*) 
     >     'Define problem: (option/value, newline, parameters)'
      write(logchn,*) ' [1] DE: 0=Poisson (default)'
      write(logchn,*) '     1=const coef (supply ddx,ddy)'
      write(logchn,*) '     2=steps (supply sx,tx, sy,ty)'
      write(logchn,*) ' [2] Unsymmetry: 0=no (default)'
      write(logchn,*) '     1=yes (supply vx,vy)'
      write(logchn,*) ' [3] Indefiniteness: 0=no (default)'
      write(logchn,*) '     1=yes (supply alpha>0 shift down)'
      write(logchn,*) '------------------------------------'
      if (funnum.eq.0) then
         write(logchn,*) 'Poisson equation'
      else if (funnum.eq.1) then
         write(logchn,*) 'Constant coefficients',ddx,ddy
      endif
      if (unsymm.gt.0) then
         write(logchn,*) 'Unsymmetry:',vx,vy
      endif
      if (indef.gt.0) then
         write(logchn,*) 'Indefiniteness:',alpha
      endif

      endif

      return
      end
