C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.7                                       C
C     This file last generated 94/09/11                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      subroutine init_processor_grid(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems(1)

C     Global architecture info
C----
      integer
     >     nproc,pnum
      common /iume/
     >     nproc,pnum

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     n_neighbrs,neighbour_nums(99),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     n_neighbrs,neighbour_nums,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

      
C     Functions
C----
      logical trace_progress,has_trace

C     Local
C----
      integer dim

      call force_range(buffer(1),1,2,'Nit proc #dimens$')
      call force_range(nitems(1),1+buffer(1),1+buffer(1),
     >     'Nit Proc Grid #items$')

C     The processor grid dimension is (should be) buffer(1) <= 4
C     Just to make sure, we set the rest of the dimensions to length one.
C----
      pgrid_dimension = 4
      do 10 dim=1,buffer(1)
         pgrid_size(dim) = buffer(1+dim)
 10   continue
      do 20 dim=buffer(1)+1,pgrid_dimension
         pgrid_size(dim) = 1
 20   continue

      if (trace_progress().and.has_trace())
     >     call pdai('Processor grid size (ijkl)$',
     >     pgrid_size,pgrid_dimension)

      call force_range(pgrid_size(1),1,1 000,
     >     'Nit Proc Grid #iprocs$')
      call force_range(pgrid_size(2),1,1 000,
     >     'Nit Proc Grid #jprocs$')

      return
      end
