C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Variable Map.
C     
C     A routine 'var2proc' should be available to the rest
C     of the library; the other routines here are only to
C     set up the information for this particular implementation
C     of var2proc.
C
C----------------------------------------------------------------
      function int_var2proc(ivar)

C     Arguments
C----
      integer ivar, int_var2proc

C     Common block with map array:
C     case1: 1..nproc pairs of lo_var,hi_var
C     case3: sequence of (location,length) pairs
C----
      dimension var2proc_map(-1 : 3*2000)
      integer
     >     varloc,var2proc_map,map_length
      common /var2proc_com/
     >     varloc,var2proc_map,map_length

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Functions
C----
      integer no_processors

C     Local
C----
      integer elem,first, proc, step_proc, max_proc
      integer saved_proc,saved_step
      common /save_var2proc/saved_proc,saved_step

      int_var2proc = -1
      max_proc = no_processors()-1

      do 110 step_proc=0,max_proc
         proc = saved_proc+step_proc
         proc = mod(proc,max_proc+1)
         call get_consec_of_proc(first,elem,proc)
         if (ivar.ge.first .and. ivar.le.first+elem-1) then
            int_var2proc = proc
            saved_proc = proc
            goto 130
         endif
 110  continue
 130  continue

      call force_range(proc,0,nproc-1,'>>>>Var2proc number$')

      return
      end
C----------------------------------------------------------------
      block data save_v2pi
      integer saved_proc,saved_step
      common /save_var2proc/saved_proc,saved_step
      data saved_proc,saved_step/0,1/
      end
C----------------------------------------------------------------
C     Variables of a processor; proc num is 0,1,...
C----------------------------------------------------------------
      subroutine get_consec_of_proc(first,length,proc)

C     Arguments
C----
      integer first,length,proc

C     Common block with map array:
C     case1: 1..nproc pairs of lo_var,hi_var
C     case3: sequence of (location,length) pairs
C----
      dimension var2proc_map(-1 : 3*2000)
      integer
     >     varloc,var2proc_map,map_length
      common /var2proc_com/
     >     varloc,var2proc_map,map_length

      first = varloc+var2proc_map(2*(proc+1)-1)-1
      length = var2proc_map(2*(proc+1))

      return
      end
C----------------------------------------------------------------
C     Set variables of a processor; proc num is 0,1,...
C----------------------------------------------------------------
      subroutine set_consec_of_proc(first,length,proc,
     >     vec_inf,leng_vec_inf)

C     Arguments
C----
      integer first,length,proc, vec_inf(*),leng_vec_inf

C     Common block with map array:
C     case1: 1..nproc pairs of lo_var,hi_var
C     case3: sequence of (location,length) pairs
C----
      dimension var2proc_map(-1 : 3*2000)
      integer
     >     varloc,var2proc_map,map_length
      common /var2proc_com/
     >     varloc,var2proc_map,map_length

C     Functions
C----
      logical trace_setup,thisme

      var2proc_map(2*(proc+1)-1) = first
      var2proc_map(2*(proc+1)) = length

      if (trace_setup()) call pd1i2i('Proc$',proc,
     >     'has vars from/leng$',first,length)

      if (thisme(proc)) then
         if (10*(vec_inf(1)/10).eq.30) then
            call cprs_set_owned_stretch
     >           (vec_inf,leng_vec_inf,first,length)
         else if (10*(vec_inf(1)/10).eq.20) then
            call diag_set_owned_stretch
     >           (vec_inf,leng_vec_inf,first,length)
         endif
      endif

      return
      end
C----------------------------------------------------------------
      block data init_varloc
C     Common block with map array:
C     case1: 1..nproc pairs of lo_var,hi_var
C     case3: sequence of (location,length) pairs
C----
      dimension var2proc_map(-1 : 3*2000)
      integer
     >     varloc,var2proc_map,map_length
      common /var2proc_com/
     >     varloc,var2proc_map,map_length
      data varloc/1/
      end
