C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     Preconditioner routines for grid storage
C================================================================
      subroutine local_solve_lower_grid(y,prec,x,tmp,
     >     prec_inf,vec_inf, isize,jsize,bord, offs,n_off,sets,
     >     xterms,trans,trace)

C     Arguments
C----
      integer prec_inf(*),vec_inf(*),
     >     isize,jsize,bord, n_off,sets(2,n_off),
     >     xterms
      double precision 
     >     y   (1-bord:isize+bord,1-bord:jsize+bord),
     >     x   (1-bord:isize+bord,1-bord:jsize+bord),
     >     tmp (1-bord:isize+bord,1-bord:jsize+bord),
     >     prec(isize,jsize),offs(isize,jsize,n_off)
      logical trans,trace

C     Local
C----
      integer col,row, cnt, boti,topi,diri, botj,topj,dirj,term
      integer
     >     n_bac,n_for, bacs(99),fors(99),
     >     o_bac(2,99),o_for(2,99),
     >     dir(4),loc_for,loc_bac
      double precision sum

C     Loop bound statement functions
C---- 
      integer top,bot, hi,lo,dr
      top(hi,lo,dr)=hi*((dr+1)/2)-lo*((dr-1)/2)
      bot(hi,lo,dr)=lo*((dr+1)/2)-hi*((dr-1)/2)

      call iicopy(dir,prec_inf(1),vec_inf(vec_inf(5)+1))
      loc_for = 1+vec_inf(vec_inf(5)+1)
      n_for = prec_inf(loc_for)
      call iicopy(fors,prec_inf(loc_for+1),n_for)
      call iicopy(o_for,prec_inf(loc_for+n_for+1),
     >     vec_inf(vec_inf(5)+1)*n_for)
      loc_bac = loc_for+1+(vec_inf(vec_inf(5)+1)+1)*n_for
      n_bac = prec_inf(loc_bac)
      call iicopy(bacs,prec_inf(loc_bac+1),n_bac)
      call iicopy(o_bac,prec_inf(loc_bac+n_bac+1),
     >     vec_inf(vec_inf(5)+1)*n_bac)

      botj = bot(jsize,1,dir(2))
      topj = top(jsize,1,dir(2))
      dirj = dir(2)
      boti = bot(isize,1,dir(1))
      topi = top(isize,1,dir(1))
      diri = dir(1)

C====
C     Regular Solve
C====
      if (.not.trans) then
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 11 col=botj,topj,dirj
               do 21 row=boti,topi,diri
                  sum = x(row,col)
                  do 31 cnt=1,n_bac
                     sum = sum - offs(row,col,bacs(cnt))
     >                    *y(row+o_bac(1,cnt),col+o_bac(2,cnt))
 31               continue
                  y(row,col) = sum*prec(row,col)
 21            continue
 11         continue
C----
C     By Expansion
C----
         else
            do 110 term=1,xterms
               cnt = 1
               if (term.eq.1) then
                  call g2gprod(y,offs(1,1,bacs(cnt)),x,
     >                 isize,jsize,bord,
     >                 0,0,o_bac(1,cnt),o_bac(2,cnt))
                  do 111 cnt=2,n_bac
                     call g2gupdate(y,offs(1,1,bacs(cnt)),x,
     >                    isize,jsize,bord,
     >                    0,0,o_bac(1,cnt),o_bac(2,cnt))
 111              continue
               else
                  call g2gprod(y,offs(1,1,bacs(cnt)),tmp,
     >                 isize,jsize,bord,
     >                 0,0,o_bac(1,cnt),o_bac(2,cnt))
                  do 112 cnt=2,n_bac
                     call g2gupdate(y,offs(1,1,bacs(cnt)),tmp,
     >                    isize,jsize,bord,
     >                    0,0,o_bac(1,cnt),o_bac(2,cnt))
 112              continue
               endif
               call g2gprod(y,prec,y, isize,jsize,bord, 0,0,0,0)
               if (term.eq.xterms) then
                  call grid_axby(y,1.d0,x,-1.d0,y,
     >                 isize,jsize,bord,bord)
               else
                  call grid_axby(tmp,1.d0,x,-1.d0,y,
     >                 isize,jsize,bord,bord)
               endif
 110        continue
         endif
      else
C====
C     Transpose Solve
C====
         if (xterms.eq.0) then
C----
C     Recursive
C----
            do 12 col=botj,topj,dirj
               do 22 row=boti,topi,diri
                  y(row,col) = x(row,col)
                  sum = prec(row,col)*y(row,col)
                  do 32 cnt=1,n_for
                     x(row+o_for(1,cnt),col+o_for(2,cnt)) =
     >                    x(row+o_for(1,cnt),col+o_for(2,cnt)) -
     >                    offs(row,col,fors(cnt))*sum
 32               continue
 22            continue
 12         continue
C----
C     By Expansion
C----
         else
            do 210 term=1,xterms
               if (term.eq.1) then
                  call g2gprod(tmp,prec,x,isize,jsize,bord,0,0,0,0)
                  call grid_cler(y,isize,jsize,bord)
               else
                  call g2gprod(tmp,prec,y,isize,jsize,bord,0,0,0,0)
               endif
               call grid_ax(y,1.d0,x, isize,jsize,bord,bord)
               do 211 cnt=1,n_for
                  call g2gdndate(y,offs(1,1,fors(cnt)),tmp,
     >                 isize,jsize,bord,
     >                 o_for(1,cnt),o_for(2,cnt),0,0)
 211           continue
 210        continue
         endif
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_solve_upper_grid(y,prec,x,tmp,
     >     prec_inf,vec_inf, isize,jsize,bord, offs,n_off,sets,
     >     xterms,trans,trace)

C     Arguments
C----
      integer prec_inf(*),vec_inf(*),
     >     isize,jsize,bord, n_off,sets(2,n_off),
     >     xterms
      double precision 
     >     y   (1-bord:isize+bord,1-bord:jsize+bord),
     >     x   (1-bord:isize+bord,1-bord:jsize+bord),
     >     tmp (1-bord:isize+bord,1-bord:jsize+bord),
     >     prec(isize,jsize),offs(isize,jsize,n_off)
      logical trans,trace

C     Local
C----
      integer col,row, cnt,term
      integer
     >     n_bac,n_for, bacs(99),fors(99),
     >     o_bac(2,99),o_for(2,99),
     >     dir(4),loc_for,loc_bac
      double precision sum

C     Loop bound statement functions
C---- 
      integer top,bot, hi,lo,dr
      top(hi,lo,dr)=hi*((dr+1)/2)-lo*((dr-1)/2)
      bot(hi,lo,dr)=lo*((dr+1)/2)-hi*((dr-1)/2)

      call iicopy(dir,prec_inf(1),vec_inf(vec_inf(5)+1))
      loc_for = 1+vec_inf(vec_inf(5)+1)
      n_for = prec_inf(loc_for)
      call iicopy(fors,prec_inf(loc_for+1),n_for)
      call iicopy(o_for,prec_inf(loc_for+n_for+1),
     >     vec_inf(vec_inf(5)+1)*n_for)
      loc_bac = loc_for+1+(vec_inf(vec_inf(5)+1)+1)*n_for
      n_bac = prec_inf(loc_bac)
      call iicopy(bacs,prec_inf(loc_bac+1),n_bac)
      call iicopy(o_bac,prec_inf(loc_bac+n_bac+1),
     >     vec_inf(vec_inf(5)+1)*n_bac)

C====
C     Transpose Solve
C====
      if (trans) then
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 10 col=top(jsize,1,dir(2)),bot(jsize,1,dir(2)),-dir(2)
               do 20 row=top(isize,1,dir(1)),bot(isize,1,dir(1)),-dir(1)
                  y(row,col) = prec(row,col)*x(row,col)
                  do 35 cnt=1,n_bac
                     x(row+o_bac(1,cnt),col+o_bac(2,cnt)) =
     >                    x(row+o_bac(1,cnt),col+o_bac(2,cnt)) -
     >                    offs(row,col,bacs(cnt))*y(row,col)
 35               continue
 20            continue
 10         continue
C----
C     By Expansion
C----
         else
            do 210 term=1,xterms
               if (term.eq.1) then
                  call g2gprod(tmp,prec,x,isize,jsize,bord,0,0,0,0)
                  call grid_cler(y,isize,jsize,bord)
               else
                  call g2gprod(tmp,prec,y,isize,jsize,bord,0,0,0,0)
               endif
               call grid_ax(y,1.d0,x, isize,jsize,bord,bord)
               do 211 cnt=1,n_bac
                  call g2gdndate(y,offs(1,1,bacs(cnt)),tmp,
     >                 isize,jsize,bord,
     >                 o_bac(1,cnt),o_bac(2,cnt),0,0)
 211           continue
 210        continue
         endif
C====
C     Regular Solve
C====
      else
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 101 col=top(jsize,1,dir(2)),
     >           bot(jsize,1,dir(2)),-dir(2)
               do 102 row=top(isize,1,dir(1)),
     >              bot(isize,1,dir(1)),-dir(1)
                  sum = 0.d0
                  do 103 cnt=1,n_for
                     sum = sum + offs(row,col,fors(cnt))
     >                    *y(row+o_for(1,cnt),col+o_for(2,cnt))
 103               continue
                  y(row,col) = x(row,col)-sum*prec(row,col)
 102            continue
 101         continue
C----
C     By Expansion
C----
         else
            do 110 term=1,xterms
               cnt = 1
               if (term.eq.1) then
                  call g2gprod(y,offs(1,1,fors(cnt)),x,
     >                 isize,jsize,bord,
     >                 0,0,o_for(1,cnt),o_for(2,cnt))
                  do 111 cnt=2,n_for
                     call g2gupdate(y,offs(1,1,fors(cnt)),x,
     >                    isize,jsize,bord,
     >                    0,0,o_for(1,cnt),o_for(2,cnt))
 111              continue
               else
                  call g2gprod(y,offs(1,1,fors(cnt)),tmp,
     >                 isize,jsize,bord,
     >                 0,0,o_for(1,cnt),o_for(2,cnt))
                  do 112 cnt=2,n_for
                     call g2gupdate(y,offs(1,1,fors(cnt)),tmp,
     >                    isize,jsize,bord,
     >                    0,0,o_for(1,cnt),o_for(2,cnt))
 112              continue
               endif
               call g2gprod(y,prec,y, isize,jsize,bord, 0,0,0,0)
               if (term.eq.xterms) then
                  call grid_axby(y,1.d0,x,-1.d0,y,
     >                 isize,jsize,bord,bord)
               else
                  call grid_axby(tmp,1.d0,x,-1.d0,y,
     >                 isize,jsize,bord,bord)
               endif
 110        continue
         endif
      endif

      return
      end
C----------------------------------------------------------------
C     Create incomplete LU factorization;
C     pass boundary data to neighbour processors;
C     pass upper/lower subdiagonal as for/backward connection,
C     depending on step in j direction.
C----------------------------------------------------------------
      subroutine creat_local_ilu_g(prec_diag,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,tmp,vec_inf, factor)
      
C     Arguments
C---- 
      integer prec_inf(*),mat_ptr(*),vec_inf(*),leng_prec_inf
      double precision prec_diag(*),matrix(*),tmp(*)
      logical factor
      
      
C     Functions
C----
      logical iobtuse,trace_setup

C     Local
C----
      integer loc_for,loc_bac, cnt,n_off,
     >     n_bac,n_for, bacs(99),fors(99),
     >     o_bac(2,99),o_for(2,99)

      n_bac = 0
      n_for = 0
      n_off = mat_ptr(2)
      call force_range(leng_prec_inf,1+vec_inf(vec_inf(5)+1)+
     >     (vec_inf(vec_inf(5)+1)+1)*n_off,-1,
     >     'Prec inf for local ilu Grid$')
      do 5 cnt=1,n_off
         if (iobtuse(prec_inf(1),
     >        mat_ptr(3+(cnt-1)*vec_inf(vec_inf(5)+1)),
     >        vec_inf(vec_inf(5)+1))) then
            n_bac = n_bac+1
            bacs(n_bac) = cnt
            call iicopy(o_bac(1,n_bac),
     >           mat_ptr(3+(cnt-1)*vec_inf(vec_inf(5)+1)),2)
         else
            n_for = n_for+1
            fors(n_for) = cnt
            call iicopy(o_for(1,n_for),
     >           mat_ptr(3+(cnt-1)*vec_inf(vec_inf(5)+1)),2)
         endif
 5    continue

      if (trace_setup()) then
         call pdai('LU-solv grd uses for$',fors,n_for)
         do 6 cnt=1,n_for
            call pd1iai('- forw:$',cnt,
     >           'off:$',o_for(1,cnt),vec_inf(vec_inf(5)+1))
 6       continue
         call pdai('LU-solv grd uses bac$',bacs,n_bac)
         do 7 cnt=1,n_bac
            call pd1iai('- bacw:$',cnt,
     >           'off:$',o_bac(1,cnt),vec_inf(vec_inf(5)+1))
 7       continue
      endif

      loc_for = 1+vec_inf(vec_inf(5)+1)
      prec_inf(loc_for) = n_for
      call iicopy(prec_inf(loc_for+1),fors,n_for)
      call iicopy(prec_inf(loc_for+n_for+1),o_for,
     >     vec_inf(vec_inf(5)+1)*n_for)
      loc_bac = loc_for+1+(vec_inf(vec_inf(5)+1)+1)*n_for
      prec_inf(loc_bac) = n_bac
      call iicopy(prec_inf(loc_bac+1),bacs,n_bac)
      call iicopy(prec_inf(loc_bac+n_bac+1),o_bac,
     >     vec_inf(vec_inf(5)+1)*n_bac)

      if (factor) then
         call bvcopy_ob(tmp,vec_inf,prec_diag)
         call bvcler(tmp,vec_inf)
         call ilu2fc(tmp,
     >        matrix(1+vec_inf(2)),
     >        mat_ptr(2),mat_ptr(3),
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        prec_inf(1),prec_inf(1+1))
         call bvcopy_bo(prec_diag,vec_inf,tmp)
      else
         call vinvert(prec_diag,
     >        vec_inf(vec_inf(5)+2)*vec_inf(vec_inf(5)+2+1))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine ilu2fc(prec,offs,noff,offsets,
     >     ipts,jpts,bord, id,jd)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, id,jd, noff,offsets(2,*)
      double precision 
     >     prec (1-bord:ipts+bord,1-bord:jpts+bord),
     >     offs   (ipts,jpts,*)
      
C     Functions
C----
      logical trace_matrices,trace_setup

C     Local
C---- 
      integer dia,row,col, nd, prow,pcol,
     >     nforw,forward(99), nbacw,bacward(99),
     >     n_mirr,th_one(99), th_other(99)
      
C     Loop bounds functions
C---- 
      integer itop,ibot,jtop,jbot, top,bot, hi,lo,dir
      top(hi,lo,dir)=hi*((dir+1)/2)-lo*((dir-1)/2)
      bot(hi,lo,dir)=lo*((dir+1)/2)-hi*((dir-1)/2)
      
C     Sensibility check
C---- 
      call force_range(ipts,1,-1,'ILU2fc ipts$')
      call force_range(jpts,1,-1,'ILU2fc jpts$')
      call force_range(bord,0,-1,'ILU2fc bord$')
      
C     What offdiagonals are in the forward direction?
C----
      nforw = 0
      nbacw = 0
      do 210 dia=1,noff
         if (offsets(2,dia)*jd.gt.0 .or.
     >        (offsets(2,dia)*jd.eq.0 .and.
     >        offsets(1,dia)*id.gt.0))
     >        then
            nforw = nforw+1
            forward(nforw) = dia
         else
            nbacw = nbacw+1
            bacward(nbacw) = dia
         endif
 210  continue
      n_mirr = 0
      do 220 dia=1,nbacw
         do 230 nd=1,noff
            if (offsets(1,dia)+offsets(1,nd).eq.0 .and.
     >           offsets(2,dia)+offsets(2,nd).eq.0) then
               n_mirr = n_mirr+1
               th_one(n_mirr) = bacward(dia)
               th_other(n_mirr) = nd
            endif
 230     continue
 220  continue

C     Absolute bounds and loop bounds;
C---- 
         itop=top(ipts,1,id)
         ibot=bot(ipts,1,id)
         jtop=top(jpts,1,jd)
         jbot=bot(jpts,1,jd)
      
      if (trace_matrices().or.trace_setup()) then
         call pd3i('Domain bounds dim#1 (from/by/to)$',
     >        ibot,id,itop)
         call pd3i('Domain bounds dim#2 (from/by/to)$',
     >        jbot,jd,jtop)
         call pdai('Offsets$',offsets,2*noff)
         call pdai('Forward diags:$',forward,nforw)
         call pdai('Bacward diags:$',bacward,nbacw)
         call pdaiai('Mirroring pairs$',th_one,n_mirr,th_other,n_mirr)
      endif


C     Backwards looking factorization:
C     each point collects info from whoever influences her.
C     For the overlapping factorization we are cautious
C     about not exceeding array bounds
C---- 
      do 10 col=jbot,jtop,jd
         do 20 row=ibot,itop,id
            do 30 dia=1,n_mirr
               nd = th_one(dia)
               prow = row+offsets(1,nd)
               pcol = col+offsets(2,nd)
               prec(row,col) = prec(row,col) -
     >              offs(row,col,th_one(dia))
     >              * prec(prow,pcol)
     >              * offs(prow,pcol,th_other(dia))
 30         continue
            prec(row,col) = 1.d0/prec(row,col)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine local_grid_solve_colour(x,diag, colour,flow, 
     >     map, isize,jsize,bord, offs,n_off,sets,
     >     trans,trace)
      
C     Arguments
C---- 
      integer colour,flow,
     >     isize,jsize,bord, n_off,sets(2,n_off),
     >     map(1-bord:isize+bord,1-bord:jsize+bord)
      double precision diag(isize,jsize),offs(isize,jsize,n_off),
     >     x   (1-bord:isize+bord,1-bord:jsize+bord)
      logical trans,trace

C     Local
C---- 
      integer ivar,jvar,dia,col
      logical lower_colour,higher_colour, up_flow
      double precision sum

      higher_colour(col) = (up_flow.and.col.gt.colour) .or.
     >     (.not.up_flow.and.col.lt.colour)
      lower_colour(col) = (up_flow.and.col.lt.colour) .or.
     >     (.not.up_flow.and.col.gt.colour)

      up_flow = flow.eq.+1

      do 10 ivar=1,isize
         do 11 jvar=1,jsize
            if (map(ivar,jvar).ne.colour) goto 15
            if (trans) then
               if (up_flow) then
C     Solve I+U^tD^{-1}
                  sum = diag(ivar,jvar)*x(ivar,jvar)
               else
C     Solve D+L^t
                  x(ivar,jvar) = diag(ivar,jvar)*x(ivar,jvar)
                  sum = x(ivar,jvar)
               endif
               do 120 dia=1,n_off
                  if (higher_colour(map(ivar+sets(1,dia),
     >                 jvar+sets(2,dia))))
     >                 x(ivar+sets(1,dia),jvar+sets(2,dia)) = 
     >                 x(ivar+sets(1,dia),jvar+sets(2,dia))
     >                 - offs(ivar,jvar,n_off)*sum
 120           continue
            else
               if (up_flow) then
C     Solve D+L
                  sum = x(ivar,jvar)
               else
C     Solve I+D^-1U
                  sum = 0.d0
               endif
               do 20 dia=1,n_off
                  if (lower_colour(map(ivar+sets(1,dia),
     >                 jvar+sets(2,dia))))
     >                 sum = sum-offs(ivar,jvar,n_off)
     >                 *x(ivar+sets(1,dia),jvar+sets(2,dia))
 20            continue
               if (up_flow) then
                  x(ivar,jvar) = diag(ivar,jvar)*sum
               else
                  x(ivar,jvar) = x(ivar,jvar)+diag(ivar,jvar)*sum
               endif
            endif
 15         continue
 11      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Preprocessing: make zero rowsums on border and
C     internal edge lines
C----------------------------------------------------------------
      subroutine predgz(prec,b1,f1,bn,fn, ipts,jpts,bord)
      
C     Arguments
C---- 
      integer ipts,jpts, bord
      double precision prec(ipts,jpts),
     >     b1(ipts,jpts),f1(ipts,jpts),
     >     bn(ipts,jpts),fn(ipts,jpts)
      
C     Local
C---- 
      integer row,col

      do 10 col=1-bord,0
         row = 1
         prec(row,col) = -(f1(row,col)+fn(row,col))
         row = ipts
         prec(row,col) = -(b1(row,col)+fn(row,col))
         do 15 row=2,ipts-1
            prec(row,col) = -(f1(row,col)+b1(row,col)+fn(row,col))
 15      continue
 10   continue

      do 20 col=jpts+1,jpts+bord
         row = 1
         prec(row,col) = -(f1(row,col)+bn(row,col))
         row = ipts
         prec(row,col) = -(b1(row,col)+bn(row,col)) 
        do 25 row=2,ipts-1
            prec(row,col) = -(f1(row,col)+b1(row,col)+bn(row,col))
 25      continue
 20   continue
      
      do 30 row=1-bord,0
         col = 1
         prec(row,col) = -(f1(row,col)+fn(row,col))
         col = jpts
         prec(row,col) = -(f1(row,col)+bn(row,col))
         do 35 col=2,jpts-1
            prec(row,col) = -(fn(row,col)+bn(row,col)+f1(row,col))
 35      continue
 30   continue

      do 40 row=ipts+1,ipts+bord
         col = 1
         prec(row,col) = -(b1(row,col)+fn(row,col))
         col = jpts
         prec(row,col) = -(b1(row,col)+bn(row,col))
         do 45 col=2,jpts-1
            prec(row,col) = -(fn(row,col)+bn(row,col)+b1(row,col))
 45      continue
 40   continue
      
      return
      end
