C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     Preconditioner routines for diagonal storage
C================================================================
      subroutine local_solve_lower_diag(y,prec,x,tmp,
     >     prec_inf,length, matrix,vec_inf, xterms,trans,trace)

C     Arguments
C----
      integer vec_inf(*), prec_inf(*),length,xterms
      double precision y(*),prec(*),x(*),matrix(length,*),tmp(*)
      logical trans,trace

C     Local
C----
      integer dia,elt,var, l_bac,n_bac,l_for,n_for, term,own,
     >     pleft,prght,q1,q2
      double precision sum

      pleft(q1,q2) = q2-1+2*q1
      prght(q1,q2) = q2-1+2*q1+1

      own = vec_inf(vec_inf(5))
C====
C     Transpose Solve
C====
      if (trans) then
         l_for = prec_inf(1)
         n_for = prec_inf(l_for)
         if (trace) call pd0('local solve up-trans diag$')
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 20 elt=1,length
               var = own+elt-1
               y(var) = x(var)
               sum = prec(elt)*x(var)
               do 40 dia=1,n_for
                  x(elt+prec_inf(prght(dia,l_for))-1) = 
     >                 x(elt+prec_inf(prght(dia,l_for))-1)
     >                 -matrix(elt,prec_inf(pleft(dia,l_for)))*sum
 40            continue
 20         continue
C----
C     By Expansion
C----
         else
            if (trace) call pd1i('- expanded, #terms=$',xterms)
            do 120 term=1,xterms
               if (term.eq.1) then
                  call vvprod(tmp(own),prec,x(own),length)
                  call bvcler(y,vec_inf)
               else
                  call vvprod(tmp(own),prec,y(own),length)
               endif
               call vvcopy(y(own),x(own),length)
               do 121 dia=1,n_for
                  call vvdndate(y(prec_inf(prght(dia,l_for))),
     >                 tmp(own),
     >                 matrix(1,prec_inf(pleft(dia,l_for))),length)
 121           continue
 120        continue
         endif
C====
C     Regular Solve
C====
      else
         l_bac = prec_inf(2)
         n_bac = prec_inf(l_bac)
         if (trace) call pd0('local solve lower diag$')
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 10 elt=1,length
               var = own+elt-1
               sum = x(var)
               do 30 dia=1,n_bac
                  sum = sum
     >                 -matrix(elt,prec_inf(pleft(dia,l_bac)))
     >                 *y(elt+prec_inf(prght(dia,l_bac))-1)
 30            continue
               y(var) = prec(elt)*sum
 10         continue
C----
C     By Expansion
C----
         else
            if (trace) call pd1i('- expanded, #terms=$',xterms)
            do 130 term=1,xterms
               dia = 1
               if (term.eq.1) then
                  call vvprod(y(own),
     >                 x(prec_inf(prght(dia,l_bac))),
     >                 matrix(1,prec_inf(pleft(dia,l_bac))),length)
                  do 111 dia=2,n_bac
                     call vvupdate(y(own),
     >                    x(prec_inf(prght(dia,l_bac))),
     >                    matrix(1,prec_inf(pleft(dia,l_bac))),length)
 111              continue
               else
                  call vvprod(y(own),
     >                 tmp(prec_inf(prght(dia,l_bac))),
     >                 matrix(1,prec_inf(pleft(dia,l_bac))),length)
                  do 110 dia=2,n_bac
                     call vvupdate(y(own),
     >                    tmp(prec_inf(prght(dia,l_bac))),
     >                    matrix(1,prec_inf(pleft(dia,l_bac))),length)
 110              continue
               endif
               call vvprod(y(own),prec,y(own),length)
               if (term.eq.xterms) then
                  call vmv(y(own),x(own),y(own),length)
               else
                  call vmv(tmp(own),x(own),y(own),length)
               endif
 130        continue
         endif
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_solve_upper_diag(y,prec,x,tmp, prec_inf,length,
     >     matrix,vec_inf, xterms,trans,unnorm,trace)

C     Arguments
C----
      integer vec_inf(*), prec_inf(*),length,xterms
      double precision y(*),prec(*),x(*), matrix(length,*),tmp(*)
      logical trans,unnorm,trace

C     Local
C----
      integer dia,elt,var, l_bac,n_bac,l_for,n_for, term,own,
     >     pleft,prght,q1,q2
      double precision sum

      pleft(q1,q2) = q2-1+2*q1
      prght(q1,q2) = q2-1+2*q1+1

      own = vec_inf(vec_inf(5))
C====
C     Transpose Solve
C====
      if (trans) then
         l_bac = prec_inf(2)
         n_bac = prec_inf(l_bac)
         if (trace) call pd0('local solve lo-trans diag$')
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 20 elt=length,1,-1
               var = own+elt-1
               y(var) = prec(elt)*x(var)
               do 40 dia=1,n_bac
                  x(elt+prec_inf(prght(dia,l_bac))-1) =
     >                 x(elt+prec_inf(prght(dia,l_bac))-1)
     >                 -matrix(elt,prec_inf(pleft(dia,l_bac)))
     >                 *y(var)
 40            continue
 20         continue
C----
C     By Expansion
C----
         else
            if (trace) call pd1i('- expanded, #terms=$',xterms)
            do 120 term=1,xterms
               if (term.eq.1) then
                  call vvprod(tmp(own),prec,x(own),length)
                  call bvcler(y,vec_inf)
               else
                  call vvprod(tmp(own),prec,y(own),length)
               endif
               call vvcopy(y(own),x(own),length)
               do 121 dia=1,n_bac
                  call vvdndate(y(prec_inf(prght(dia,l_bac))),
     >                 tmp(own),
     >                 matrix(1,prec_inf(pleft(dia,l_bac))),length)
 121           continue
 120        continue
         endif
C====
C     Regular Solve
C====
      else
         l_for = prec_inf(1)
         n_for = prec_inf(l_for)
         if (trace) call pd0('local solve upper diag$')
C----
C     Recursive
C----
         if (xterms.eq.0) then
            do 10 elt=length,1,-1
               var = own+elt-1
               sum = 0.d0
               do 30 dia=1,n_for
                  sum = sum
     >                 +matrix(elt,prec_inf(pleft(dia,l_for)))
     >                 *y(elt+prec_inf(prght(dia,l_for))-1)
 30            continue
               y(var) = x(var)-prec(elt)*sum
 10         continue
C----
C     By Expansion
C----
         else
            if (trace) call pd1i('- expanded, #terms=$',xterms)
            do 130 term=1,xterms
               dia = 1
               if (term.eq.1) then
                  call vvprod(y(own),
     >                 x(prec_inf(prght(dia,l_for))),
     >                 matrix(1,prec_inf(pleft(dia,l_for))),length)
                  do 111 dia=2,n_for
                     call vvupdate(y(own),
     >                    x(prec_inf(prght(dia,l_for))),
     >                    matrix(1,prec_inf(pleft(dia,l_for))),length)
 111              continue
               else
                  call vvprod(y(own),
     >                 tmp(prec_inf(prght(dia,l_for))),
     >                 matrix(1,prec_inf(pleft(dia,l_for))),length)
                  do 110 dia=2,n_for
                     call vvupdate(y(own),
     >                    tmp(prec_inf(prght(dia,l_for))),
     >                    matrix(1,prec_inf(pleft(dia,l_for))),length)
 110              continue
               endif
               call vvprod(y(own),prec,y(own),length)
               if (term.eq.xterms) then
                  call vmv(y(own),x(own),y(own),length)
               else
                  call vmv(tmp(own),x(own),y(own),length)
               endif
 130        continue
         endif
      endif

      return
      end
C----------------------------------------------------------------
      subroutine creat_local_ilu_d(prec,prec_inf,leng_prec_inf,
     >     matrix,length,mat_ptr,mat_idx,
     >     tmp,vec_inf,factor)

C     Arguments
C---- 
      integer length,mat_ptr(*),mat_idx(*), vec_inf(*),
     >     prec_inf(*),leng_prec_inf
      double precision prec(*),matrix(length,*),tmp(*)
      logical factor
      
C     Functions
C----
      logical tracer_proc,trace_setup

C     Local
C----
      integer dia,odia,elt,nelt, ndia,ondia, shft,oshft,
     >     n_bac,loc_bac,n_for,loc_for, locc,
     >     pleft,prght,q1,q2

      pleft(q1,q2) = q2-1+2*q1
      prght(q1,q2) = q2-1+2*q1+1

      if (tracer_proc()) then
         if (factor) call pt0('- dia ilu$')
         if (.not.factor) call pt0('- dia ssor$')
      endif

C     Set up info about left/right diagonals.
C----
      call force_range(leng_prec_inf,2*mat_ptr(1)+4,-1,
     >     'Prec inf, space for ilu_d$')
      n_bac = 0
      n_for = 0
      locc  = 0
      do 10 dia=1,mat_ptr(1)
         if (mat_ptr(1+dia).lt.0) then
            n_bac = n_bac+1
         else if (mat_ptr(1+dia).gt.0) then
            n_for = n_for+1
         else
            locc = dia
         endif
 10   continue
      call force_range(locc,1,0,'Matrix diagonal not found; location$')
      if (mod(vec_inf(1),2).eq.1.and.n_bac.gt.0) then
         call pe0('Symmetric storage, no back diagonals allowed$')
         call stop_connections('creat local ilu diag$')
      endif
      loc_for = 3
      prec_inf(1) = loc_for
      prec_inf(loc_for) = n_for
      loc_bac = prght(n_for,loc_for)+1
      prec_inf(2) = loc_bac
      prec_inf(loc_bac) = n_bac

      n_bac = 0
      n_for = 0
      do 20 dia=1,mat_ptr(1)
         if (mat_ptr(1+dia).lt.0) then
            n_bac = n_bac+1
            prec_inf(pleft(n_bac,loc_bac)) = dia
            prec_inf(prght(n_bac,loc_bac)) = mat_idx(dia)
         else if (mat_ptr(1+dia).gt.0) then
            n_for = n_for+1
            prec_inf(pleft(n_for,loc_for)) = dia
            prec_inf(prght(n_for,loc_for)) = mat_idx(dia)
         endif
 20   continue
      if (trace_setup()) then
         call pdai('Back diagonals: no/start$',
     >        prec_inf(prec_inf(2)+1),2*prec_inf(prec_inf(2)))
         call pdai('For diagonals: no/start$',
     >        prec_inf(prec_inf(1)+1),2*prec_inf(prec_inf(1)))
      endif

C     Now create the diagonal
C----
      if (factor) then
         do 30 elt=1,length
            prec(elt) = 1.d0/prec(elt)
            do 32 dia=1,n_for
               ndia = prec_inf(pleft(dia,loc_for))
               shft = mat_ptr(1+ndia)
               do 34 odia=1,n_bac
                  ondia = prec_inf(pleft(odia,loc_bac))
                  oshft = mat_ptr(1+ondia)
                  nelt = elt+shft
                  if (shft+oshft.eq.0
     >                 .and. 
     >                 nelt.le.length) then
                     prec(nelt) = prec(nelt)
     >                    -matrix(nelt,ondia)
     >                    *prec(elt)
     >                    *matrix(elt,ndia)
                  endif
 34            continue
 32         continue
 30      continue
      else
         call vinvert(prec,length)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_dia_solve_colour(x,diag, colour,flow, 
     >     matrix,length,mat_ptr,mat_idx,vec_inf, trans)
      
C     Arguments
C---- 
      integer vec_inf(*),length,mat_ptr(*),mat_idx(*), colour,flow
      double precision x(*), diag(*),matrix(length,*)
      logical trans
      
C     Local
C---- 
      integer own_var,loc_var,dia,other_loc, colr
      double precision sum
      logical lower_colour,higher_colour, up_flow

      higher_colour(colr) = (up_flow.and.colr.gt.colour) .or.
     >     (.not.up_flow.and.colr.lt.colour)
      lower_colour(colr) = (up_flow.and.colr.lt.colour) .or.
     >     (.not.up_flow.and.colr.gt.colour)

      up_flow = flow.eq.+1

      do 10 own_var=1,vec_inf(2)
         loc_var = own_var+vec_inf(vec_inf(5))-1
         if (vec_inf(vec_inf(8)+loc_var).ne.colour) goto 15
         if (trans) then
            if (up_flow) then
C     Solve I+U^tD^{-1}
               sum = diag(own_var)*x(loc_var)
            else
C     Solve D+L^t
               x(loc_var) = diag(own_var)*x(loc_var)
               sum = x(loc_var)
            endif
            do 120 dia=1,mat_ptr(1)
               other_loc = mat_idx(dia)+own_var-1
               if (higher_colour(vec_inf(vec_inf(8)+other_loc)))
     >              x(other_loc) = x(other_loc) 
     >              - matrix(own_var,dia)*sum
 120        continue
         else
            if (up_flow) then
C     Solve D+L
               sum = x(loc_var)
            else
C     Solve I+D^-1U
               sum = 0.d0
            endif
            do 20 dia=1,mat_ptr(1)
               other_loc = mat_idx(dia)+own_var-1
               if (lower_colour(vec_inf(vec_inf(8)+other_loc)))
     >              sum = sum-matrix(own_var,dia)*x(other_loc)
 20         continue
            if (up_flow) then
               x(loc_var) = diag(own_var)*sum
            else
               x(loc_var) = x(loc_var)+diag(own_var)*sum
            endif
         endif
 15      continue
 10   continue
      
      return
      end
