C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Indirect addressing Lower solve
C----------------------------------------------------------------
      subroutine local_solve_lower_i_by_columns(y,diag,x,tmp,
     >     dloc,bdlc, matrix,mat_ptr,mat_idx,vec_inf, xterms,trace)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*), dloc(*),bdlc(*),
     >     xterms
      double precision x(*),y(*),diag(*),matrix(*),tmp(*)
      logical trace

C     Local
C---- 
      integer var,col, first,last, term
      double precision sum

      if (trace) call pd0('Solve lower I-UtD-1 by columns$')

C     Solve I-U^tD^{-1};
      if (xterms.eq.0) then
         do 10 var=1,vec_inf(2)
            call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
            y(var) = x(var)
            sum = diag(var)*x(var)
            do 20 col = first+dloc(var),last
               x(mat_idx(col)) = x(mat_idx(col)) - matrix(col)*sum
 20         continue
            if (bdlc(var).le.0) goto 31
            call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
            do 30 col = first+bdlc(var)-1,last
               x(mat_idx(col)) = x(mat_idx(col)) - matrix(col)*sum
 30         continue
 31         continue
 10      continue
      else
         if (trace) call pd1i('- expanded, #terms=$',xterms)
         do 100 term=1,xterms
            if (term.eq.1) then
               call vvprod(tmp,diag,x,vec_inf(2))
               call bvcler(y,vec_inf)
            else
               call vvprod(tmp,diag,y,vec_inf(2))
            endif
            call vvcopy(y,x,vec_inf(2))
            do 110 var=1,vec_inf(2)
               call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
               do 120 col = first+dloc(var),last
                  y(mat_idx(col)) = y(mat_idx(col)) 
     >                 - matrix(col)*tmp(var)
 120           continue
               if (bdlc(var).le.0) goto 131
               call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
               do 130 col = first+bdlc(var)-1,last
                  y(mat_idx(col)) = y(mat_idx(col)) 
     >                 - matrix(col)*tmp(var)
 130           continue
 131           continue
 110        continue
 100     continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_solve_lower_i_by_rows(y,diag,x,tmp,
     >     dloc,bdlc, matrix,mat_ptr,mat_idx,vec_inf, xterms,trace)
      
C     Arguments
C---- 
      integer vec_inf(*), dloc(*),bdlc(*),
     >     mat_ptr(*),mat_idx(*), xterms
      double precision x(*),y(*),diag(*),matrix(*),tmp(*)
      logical trace

C     Local
C---- 
      integer var,col, first,last, term
      double precision sum

      if (trace) call pd0('Solve lower D-L by row$')
C     Solve D-L
      if (xterms.eq.0) then
         do 10 var=1,vec_inf(2)
            sum = x(var)
            call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
            do 20 col=first,first+dloc(var)-2
               sum = sum-matrix(col)*y(mat_idx(col))
 20         continue
            if (bdlc(var).le.0) goto 31
            call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
            do 30 col=first,first+bdlc(var)-2
               sum = sum-matrix(col)*y(mat_idx(col))
 30         continue
 31         continue
            y(var) = diag(var)*sum
 10      continue
      else
         if (trace) call pd1i('- expanded, #terms=$',xterms)
         do 100 term=1,xterms
            if (term.eq.1) then
               do 110 var=1,vec_inf(2)
                  sum = 0.d0
                  call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
                  do 120 col=first,first+dloc(var)-2
                     sum = sum+matrix(col)*x(mat_idx(col))
 120              continue
                  if (bdlc(var).le.0) goto 131
                  call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
                  do 130 col=first,first+bdlc(var)-2
                     sum = sum+matrix(col)*x(mat_idx(col))
 130              continue
 131              continue
                  y(var) = diag(var)*sum
 110           continue
            else
               do 210 var=1,vec_inf(2)
                  sum = 0.d0
                  call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
                  do 220 col=first,first+dloc(var)-2
                     sum = sum+matrix(col)*tmp(mat_idx(col))
 220              continue
                  if (bdlc(var).le.0) goto 231
                  call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
                  do 230 col=first,first+bdlc(var)-2
                     sum = sum+matrix(col)*tmp(mat_idx(col))
 230              continue
 231              continue
                  y(var) = diag(var)*sum
 210           continue
            endif
            if (term.eq.xterms) then
               call vmv(y,x,y,vec_inf(2))
            else
               call vmv(tmp,x,y,vec_inf(2))
            endif
 100     continue
      endif

      return
      end
C----------------------------------------------------------------
C     Indirect addressing Upper solve
C----------------------------------------------------------------
      subroutine local_solve_upper_i_by_columns(y,diag,x,tmp,
     >     dloc,bdlc, matrix,mat_ptr,mat_idx,vec_inf, xterms,trace)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*), dloc(*),bdlc(*),
     >     xterms
      double precision x(*),y(*),diag(*),matrix(*),tmp(*)
      logical trace

C     Local
C---- 
      integer var,col, first,last, term
      
      if (trace) call pd0('Solve upper D-Lt by column$')

C     Solve D-L^t
      if (xterms.eq.0) then
         do 10 var=vec_inf(2),1,-1
            call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
            y(var) = diag(var)*x(var)
            do 20 col=first,first+dloc(var)-2
               x(mat_idx(col)) = x(mat_idx(col)) - matrix(col)*y(var)
 20         continue
            if (bdlc(var).le.0) goto 31
            call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
            do 30 col=first,first+bdlc(var)-2
               x(mat_idx(col)) = x(mat_idx(col)) - matrix(col)*y(var)
 30         continue
 31         continue
 10      continue
      else
         if (trace) call pd1i('- expanded, #terms=$',xterms)
         do 100 term=1,xterms
            if (term.eq.1) then
               call vvprod(tmp,diag,x,vec_inf(2))
               call bvcler(y,vec_inf)
            else
               call vvprod(tmp,diag,y,vec_inf(2))
            endif
            call vvcopy(y,x,vec_inf(2))
            do 110 var=1,vec_inf(2)
               call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
               do 120 col=first,first+dloc(var)-2
                  y(mat_idx(col)) = y(mat_idx(col)) 
     >                 - matrix(col)*tmp(var)
 120           continue
               if (bdlc(var).le.0) goto 131
               call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
               do 130 col=first,first+bdlc(var)-2
                  y(mat_idx(col)) = y(mat_idx(col)) 
     >                 - matrix(col)*tmp(var)
 130           continue
 131           continue
 110        continue
 100     continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_solve_upper_i_by_rows(y,diag,x,tmp,
     >     dloc,bdlc, matrix,mat_ptr,mat_idx,vec_inf, xterms,trace)
      
C     Arguments
C---- 
      integer vec_inf(*), dloc(*),bdlc(*),
     >     mat_ptr(*),mat_idx(*),xterms
      double precision x(*),y(*),diag(*),matrix(*),tmp(*)
      logical trace

C     Local
C---- 
      integer var,col, first,last, term
      double precision sum
      
C     Solve I-D^{-1}U
      if (xterms.eq.0) then
         if (trace) call pd0('Solve upper (normd) I-D-1U by row$')
         do 10 var=vec_inf(2),1,-1
            sum = 0.d0
            call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
            do 20 col=first+dloc(var),last
               sum = sum+matrix(col)*y(mat_idx(col))
 20         continue
            if (bdlc(var).le.0) goto 31
            call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
            do 30 col=first+bdlc(var)-1,last
               sum = sum+matrix(col)*y(mat_idx(col))
 30         continue
 31         continue
            y(var) = x(var)-diag(var)*sum
 10      continue
      else
         if (trace) call pd1i('- expanded, #terms=$',xterms)
         do 100 term=1,xterms
            if (term.eq.1) then
               do 110 var=1,vec_inf(2)
                  sum = 0.d0
                  call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
                  do 120 col=first+dloc(var),last
                     sum = sum+matrix(col)*x(mat_idx(col))
 120              continue
                  if (bdlc(var).le.0) goto 131
                  call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
                  do 130 col=first+bdlc(var)-1,last
                     sum = sum+matrix(col)*x(mat_idx(col))
 130              continue
 131              continue
                  y(var) = diag(var)*sum
 110           continue
            else
               do 210 var=1,vec_inf(2)
                  sum = 0.d0
                  call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
                  do 220 col=first+dloc(var),last
                     sum = sum+matrix(col)*tmp(mat_idx(col))
 220              continue
                  if (bdlc(var).le.0) goto 231
                  call crs_get_row_brd(first,last, var,vec_inf,mat_ptr)
                  do 230 col=first+bdlc(var)-1,last
                     sum = sum+matrix(col)*tmp(mat_idx(col))
 230              continue
 231              continue
                  y(var) = diag(var)*sum
 210           continue
            endif
            if (term.eq.xterms) then
               call vmv(y,x,y,vec_inf(2))
            else
               call vmv(tmp,x,y,vec_inf(2))
            endif
 100     continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine local_solve_unnorm_up_i_by_rows(y,diag,x,tmp,
     >     dloc,bdlc, matrix,mat_ptr,mat_idx,vec_inf, xterms,trace)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*), dloc(*),bdlc(*),
     >     xterms
      double precision x(*),y(*),diag(*),matrix(*),tmp(*)
      logical trace

C     Local
C---- 
      integer var,col, first,last
      double precision sum
      
C     Solve D-U
      if (trace) call pd0('Solve upper (unnorm) D-U by row$')
      if (xterms.eq.0) then
         do 10 var=vec_inf(2),1,-1
            call crs_get_row_own(first,last, var,vec_inf,mat_ptr)
            sum = 0.d0
            do 20 col=first+dloc(var),last
               sum = sum+matrix(col)*y(mat_idx(col))
 20         continue
            if (bdlc(var).le.0) goto 31
            do 30 col=first+bdlc(var)-1,last
               sum = sum+matrix(col)*y(mat_idx(col))
 30         continue
 31         continue
            y(var) = diag(var)*(x(var)-sum)
 10      continue
      else
         call pe0('No expansion implemented$')
         call stop_connections('local unnorm up i by rows$')
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine creat_local_ilu_i(prec, matrix,mat_ptr,mat_idx,
     >     tmp,vec_inf)

C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),vec_inf(*)
      double precision prec(*),matrix(*),tmp(*)
      
C     Functions
C----
      logical tracer_proc

C     Local
C----
      integer own,col,var,oth,dum,
     >     frstcl,frstel, diacol,
     >     own2loc,rowlen
      double precision diag,fill,lowr

      if (tracer_proc()) call pt0('- crs ilu$')
      call nulv(prec,vec_inf(3))
      do 10 own=1,vec_inf(2)
         var = own2loc(own,vec_inf)
         call crs_get_ir_pointer(frstcl,frstel,rowlen, var,mat_ptr)
C     find the diagonal in this row
         diacol = mat_ptr(2*vec_inf(2)+2+var-1)
         diag = matrix(frstcl+diacol-1)
C     add accumulated fill, and invert the pivot
         diag = prec(var)+diag
         if (diag.lt.0.d0) then
            call pt1i('ILUicr negative pivot at local var',var)
            diag = -diag
         endif
         diag = 1.d0 / diag
         prec(var) = diag
C     go through the rest of the row
         do 40 col=diacol+1,rowlen
            oth = mat_idx(frstcl+col-1)
C     dig up element (var,oth)
            fill = diag*matrix(frstel+col-1)
            call crs_element_from_row(lowr,dum, oth,var,
     >           matrix,mat_ptr,mat_idx)
C     if (oth,var) exists then fill-in
            if (dum.gt.0) then
               fill = fill*lowr
               prec(oth) = prec(oth)-fill
C               call rwadel(fill,oth,oth, matrix,mat_ptr)
            endif
 40      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine local_crs_solve_colour(x,diag, colour,flow, 
     >     matrix,mat_ptr,mat_idx,vec_inf, trans)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*), colour,flow
      double precision x(*), diag(*),matrix(*)
      logical trans
      
C     Local
C---- 
      integer own,var,col,loc, ifirst,rfirst,rowlen
      double precision sum
      logical lower_colour,higher_colour, up_flow

      higher_colour(col) = (up_flow.and.col.gt.colour) .or.
     >     (.not.up_flow.and.col.lt.colour)
      lower_colour(col) = (up_flow.and.col.lt.colour) .or.
     >     (.not.up_flow.and.col.gt.colour)

      up_flow = flow.eq.+1

      do 10 own=1,vec_inf(2)
         var = own
         if (vec_inf(vec_inf(8)+var).ne.colour) goto 15
         call crs_get_ir_pointer(ifirst,rfirst,rowlen, var,mat_ptr)
         if (trans) then
            if (up_flow) then
C     Solve I+U^tD^{-1}
               sum = diag(var)*x(var)
            else
C     Solve D+L^t
               x(var) = diag(var)*x(var)
               sum = x(var)
            endif
            do 120 col=1,rowlen
               loc = mat_idx(ifirst+col-1)
               if (higher_colour(vec_inf(vec_inf(8)+loc)))
     >              x(loc) = x(loc) - matrix(rfirst+col-1)*sum
 120        continue
         else
            if (up_flow) then
C     Solve D+L
               sum = x(var)
            else
C     Solve I+D^-1U
               sum = 0.d0
            endif
            do 20 col=1,rowlen
               loc = mat_idx(ifirst+col-1)
               if (lower_colour(vec_inf(vec_inf(8)+loc)))
     >              sum = sum-matrix(rfirst+col-1)*x(loc)
 20         continue
            if (up_flow) then
               x(var) = diag(var)*sum
            else
               x(var) = x(var)+diag(var)*sum
            endif
         endif
 15      continue
 10   continue
      
      return
      end
