C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C
C Solve a preconditioned system Mx=y
C
C================================================================
      subroutine set_preconditioner_params(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems(1)

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      call force_range(nitems(1),3,-1,'NITprc #items$')
      pat = buffer(1)
      loc = buffer(2)
      xterms = buffer(3)
      
      if (log_channel_open) call report_prec(logchn)

      return
      end
C----------------------------------------------------------------
      subroutine report_prec(chan)

C     Argument
C----
      integer chan

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      write(chan,*) '================ Preconditioner'
      write(chan,*) '[1] Pattern: 0=nix 1=parallel '
      write(chan,*) '    2=one sweep 3=double sweep 4=colours'
      write(chan,*) '[2] Local preconditioner: 1=Jacobi '
      write(chan,*) '    2=SOR 3=SSOR 4=ILU'
      write(chan,*)
     >     '[3] Neumann Expansion of local fact;'
      write(chan,*) '    0=no, >0=nterms'
      write(chan,*) '--------------------------------'
      write(chan,*) '-- Global pattern:',pat
      if (pat.eq.0) return
      write(chan,*) '-- Local factorization:',loc
      if (xterms.gt.0) write(chan,*)
     >     '-- Neumann expansion; #terms=',xterms

      return
      end
C----------------------------------------------------------------
      subroutine default_preconditioner_params(buffer,nitems)
      
C     Arguments
C----
      integer buffer(*),nitems(1)

      nitems(1) = 3

      buffer(1) = 0
      buffer(2) = 1
      buffer(3) = 0

      return
      end
C----------------------------------------------------------------
C     Master routine 
C----------------------------------------------------------------
      subroutine solve_preconditioner(y,x,vec_inf, prec,prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con, comm_context,
     >     tmp1,tmp2, iter, trans,trace,dump)
      
C     Arguments
C---- 
      integer prec_inf(*), mat_ptr(*),mat_idx(*),mat_con(*),
     >     vec_inf(*), iter, trans,comm_context(*)
      double precision prec(*),matrix(*), x(*),y(*), tmp1(*),tmp2(*)
      logical trace,dump

C     Preconditioner connectivity information
C----
      integer prcclr,prcphl,prcnst,prcphs,prcnfp
      common /conprc/prcclr,prcphl,prcnst,prcphs,prcnfp

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

C     Number of nonzeros in the matrix
C----
      integer nnzero
      common /prec_nnzero/nnzero

C     Functions
C---- 
      logical prec_null
      integer n_colours

C     Local
C----
      integer count,tot_colr
      logical qtrans,at_once

C     Different cases: 0/1/2 sweeps
C====
C     No preconditioning: the outer routine is supposed to do a copy,
C     or have optimised this case out.
C     (there is a test case, which just copies. this is for debugging.)
C----
      if (prec_null()) then
         if (trace) call pd0('No preconditioning$')
         goto 99
      else if (pat.eq.5) then
         call bvcopy(y,vec_inf,x)
         goto 99
      endif

      qtrans = trans.eq.1
      at_once = pat.eq.1

C     One sweep, only forward
C----
      if (pat.eq.2) then
         if (trace) call pd0('Prec 1 sweep$')
         call bvcopy(tmp1,vec_inf,x)
         call prec_sweep_solve(y,tmp1,vec_inf,tmp2,
     >        prec,prec_inf,+1,at_once,
     >        matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >        qtrans,iter,trace)
         goto 99      
C     Double sweep; forward and backward
C---- 
      else if (pat.eq.3.or.pat.eq.1) then
         if (trace) call pd0('Prec 2 sweeps; #1$')
         if (xterms.gt.0 .and. .not.qtrans) then
            call jacsol(tmp1,x,vec_inf, prec,prec_inf)
         else
            call bvcopy(tmp1,vec_inf,x)
         endif
         call prec_sweep_solve(tmp2,tmp1,vec_inf,y,
     >        prec,prec_inf,+1,at_once,
     >        matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >        qtrans,iter,trace)
         if (dump) then
            if (qtrans) call dump_vector(tmp2,
     >           vec_inf,'t-halfprec$',iter)
            if (.not.qtrans) call dump_vector(tmp2,
     >           vec_inf,'halfprec$',iter)
         endif
        if (trace) call pd0('Prec 2 sweeps; #2$')
         call prec_sweep_solve(y,tmp2,vec_inf,tmp1,
     >       prec,prec_inf,-1,at_once,
     >        matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >       qtrans,iter,trace)
         if (xterms.gt.0.and.qtrans)
     >        call jacsol(y,y,vec_inf, prec,prec_inf)
         goto 99
C     Multi-colour sweeps
C----
      else if (pat.eq.4) then
         call bvcopy(y,vec_inf,x)
         tot_colr = n_colours(vec_inf)
         if (trace) call pd1i('Prec multicolour$',tot_colr)
         do 10 count=1,tot_colr
            call prec_colour_solve(y,vec_inf,count,count.eq.tot_colr,
     >           prec,prec_inf,+1,
     >           matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >           qtrans,iter,trace)
 10      continue
         do 20 count=tot_colr,1,-1
            call prec_colour_solve(y,vec_inf,count,count.eq.1,
     >           prec,prec_inf,-1,
     >           matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >           qtrans,iter,trace)
 20      continue
      else
         call pe1i('>> Unknown preconditioner type$',pat)
         call stop_connections('solve prec$')
      endif

 99   continue
      call addflp(nnzero)

      return
      end
C----------------------------------------------------------------
C     Solve a sweep
C     
C     skeleton structure:
C     get data, solve local part of sweep, send data;
C     independent of space dimensions.
C     
C----------------------------------------------------------------
      subroutine prec_sweep_solve
     >     (y,x,vec_inf,tmp, prec,prec_inf, flow,at_once,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     trans,iter,trace)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),mat_con(*),prec_inf(*),
     >     vec_inf(*), iter, flow,comm_context(*)
      double precision y(*),x(*), matrix(*),prec(*),tmp(*)
      logical trans,trace,at_once

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Local
C----
      logical trans_or_by_columns

      if (10*(vec_inf(1)/10).eq.10) then
         trans_or_by_columns = 
     >        (mod(vec_inf(1),2).ne.1 .and. trans) .or.
     >        (mod(vec_inf(1),2).eq.1 .and. flow.eq.+1)
      else if (10*(vec_inf(1)/10).eq.30) then
C     For compressed problems we consider the storage by rown as regular,
C     therefore 'transposed' corresponds to the by-column cases.
         trans_or_by_columns =
     >        (vec_inf(1)-30.eq.4 .and. .not.trans) .or.
     >        (vec_inf(1)-30.eq.2 .and. trans) .or.
     >        (mod(vec_inf(1),2).eq.1 .and..not. flow.eq.+1)
      else if (10*(vec_inf(1)/10).eq.20) then
         trans_or_by_columns =
     >        (mod(vec_inf(1),2).ne.1 .and. trans) .or.
     >        (mod(vec_inf(1),2).eq.1 .and. flow.eq.+1)
      else
         call strange_matrix_fmt(vec_inf,'Prec sweep solve$')
      endif

C     Clear the boundary of the output (regular) or input (trans/bycol)
C----
      if (trans_or_by_columns) then
         call bvcler(x,vec_inf)
      else
         call bvcler(y,vec_inf)
      endif

C     Get incoming data
C---- 
      if (at_once) goto 11
      tx_trace_int = iter
      if (trans_or_by_columns) then
         tx_trace_string = 'Sweep solve: get edge in iter$'
         call vector_recv_edge(x,vec_inf,1,
     >        mat_con,comm_context,flow,11)
      else
         tx_trace_string = 'Sweep solve: get border in iter$'
         call vector_recv_bord(y,vec_inf,2,
     >        mat_con,comm_context,flow,11)
      endif
 11   continue

C     Compute local part of sweep
C
C     Up flow is by increasing variable number: solve forward.
C     Down flow by decreasing variable number: solve backward;
C     for this case change the normalization conditioner for 
C     compressed symmetric storage.
C---- 
      if (flow.eq.+1) then
         call local_solve_forward(y,x,vec_inf,tmp, prec,prec_inf,
     >        matrix,mat_ptr,mat_idx, trans_or_by_columns,trace)
      else
         call local_solve_backward(y,x,vec_inf,tmp, prec,prec_inf,
     >        matrix,mat_ptr,mat_idx,
     >        trans_or_by_columns,trans_or_by_columns,trace)
      endif

C     Send data
C---- 
      if (at_once) goto 21
      tx_trace_int = iter
      if (trans_or_by_columns) then
C     whatchit: x! why? y? why y?
         tx_trace_string = 'Sweep solve: send border in iter$'
         call vector_send_bord(x,vec_inf,2,
     >        mat_con,comm_context,flow,04)
      else
         tx_trace_string = 'Sweep solve: send edge in iter$'
         call vector_send_edge(y,vec_inf,1,
     >        mat_con,comm_context,flow,04)
      endif
 21   continue

      return
      end
C----------------------------------------------------------------
C     Solve local part of forward sweep on this processor
C----------------------------------------------------------------
      subroutine local_solve_forward(y,x,vec_inf,tmp, prec,prec_inf,
     >     matrix,mat_ptr,mat_idx,trans_bycol,trace)

C     Arguments
C----
      integer prec_inf(*), mat_ptr(*),mat_idx(*), vec_inf(*)
      double precision prec(*),matrix(*), x(*),y(*),tmp(*)
      logical trans_bycol,trace

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      call force_range(xterms,0,-1,'Neumann xp terms$')

C     Cases for forward sweep
C====
C     1/ Jacobi
C----
      if (loc.eq.1) then
         if (trace) call pd0('- local fwd jacobi$')
         call jacsol(y,x,vec_inf, prec,prec_inf)
         goto 99
C     2/ SOR, 3/ SSOR, 4/ ILU
C----
      else if (loc.eq.2.or.loc.eq.3
     >        .or.loc.eq.4) then
         if (trace) then
            if (trans_bycol) then
               call pd0('Solve forward trans/bycol$')
            else
               call pd0('Solve forward notrans$')
            endif
         endif
         call local_solve_lower(y,x,vec_inf,tmp, prec,prec_inf,
     >        matrix,mat_ptr,mat_idx, xterms,trans_bycol,trace)
         goto 99
      else
         call pe1i('>> Unknown preconditioner type$',loc)
         call stop_connections('local slv forw$')
      endif

 99   continue
      return
      end
C----------------------------------------------------------------
C     Solve local part of backward sweep on this processor
C----------------------------------------------------------------
      subroutine local_solve_backward(y,x,vec_inf,tmp, prec,prec_inf,
     >     matrix,mat_ptr,mat_idx, trans_bycol,unnorm,trace)
      
C     Arguments
C---- 
      integer prec_inf(*), mat_ptr(*),mat_idx(*), vec_inf(*)
      double precision prec(*),matrix(*), x(*),y(*),tmp(*)
      logical trans_bycol,unnorm,trace

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      call force_range(xterms,0,-1,'Neumann xp terms$')
C     Cases for backward sweep
C====
C     1/ Jacobi & 2/ SOR
C     everything was already done in the forward sweep;
C     just do a copy.
C---- 
      if (loc.eq.1.or.loc.eq.2) then
         if (trace) call pd0('- local back jacobi; copy$')
         call vvcopy(y,x, vec_inf(3))
         goto 99      
C     3/ SSOR, 4/ ILU
C---- 
      else if (loc.eq.3.or.loc.eq.4) then
         if (trace) then
            if (trans_bycol) then
               call pd0('Solve backward trans/bycol$')
            else
               call pd0('Solve backward notrans$')
            endif
         endif
         call local_solve_upper(y,x,vec_inf,tmp, prec,prec_inf,
     >        matrix,mat_ptr,mat_idx, xterms,trans_bycol,unnorm,trace)
         goto 99      
      else
         call pe1i('>> Unknown preconditioner type$',loc)
         call stop_connections('local slv back$')
      endif

 99   continue
      return
      end
C----------------------------------------------------------------
C     Scalar L solve
C----------------------------------------------------------------
      subroutine local_solve_lower(y,x,vec_inf,tmp, prec,prec_inf,
     >     mat,mat_ptr,mat_idx, xterms,trans_bycol,trace)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*),prec_inf(*),
     >     xterms
      double precision x(*),y(*), prec(*),mat(*),tmp(*)
      logical trans_bycol,trace

      if (10*(vec_inf(1)/10).eq.10) then
C     Find proper off diagonals depending on step direction
C     and whether or not this is translated
C---- 
         call local_solve_lower_grid(y,prec,x,tmp,
     >        prec_inf,vec_inf,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        mat(1+vec_inf(2)),mat_ptr(2),mat_ptr(3),
     >        xterms,trans_bycol,trace)
      else if (10*(vec_inf(1)/10).eq.30) then
         if (trans_bycol) then
            call local_solve_lower_i_by_columns
     >           (y,prec,x,tmp,
     >           mat_ptr(2*vec_inf(2)+2),
     >           mat_ptr(3*vec_inf(2)+2),
     >           mat,mat_ptr,mat_idx,vec_inf, xterms,trace)
         else
            call local_solve_lower_i_by_rows
     >           (y,prec,x,tmp,
     >           mat_ptr(2*vec_inf(2)+2),
     >           mat_ptr(3*vec_inf(2)+2),
     >           mat,mat_ptr,mat_idx,vec_inf, xterms,trace)
         endif
      else if (10*(vec_inf(1)/10).eq.20) then
         call local_solve_lower_diag(y,prec,x,tmp,
     >        prec_inf,vec_inf(2), mat,vec_inf,
     >        xterms,trans_bycol,trace)
      else
         call strange_matrix_fmt(vec_inf,'local solve lower$')
      endif
      
      return
      end
C----------------------------------------------------------------
C     Scalar U solve
C----------------------------------------------------------------
      subroutine local_solve_upper(y,x,vec_inf,tmp,
     >     prec,prec_inf,mat,mat_ptr,mat_idx,
     >     xterms,trans_bycol,unnorm,trace)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*),prec_inf(*),
     >     xterms
      double precision x(*),y(*), prec(*),mat(*),tmp(*)
      logical trans_bycol,unnorm,trace

      if (10*(vec_inf(1)/10).eq.10) then
C     Find proper off diagonals depending on step direction
C     and whether or not this is translated
C---- 
         call local_solve_upper_grid(y,prec,x,tmp,
     >        prec_inf,vec_inf,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        mat(1+vec_inf(2)),mat_ptr(2),mat_ptr(3),
     >        xterms,trans_bycol,trace)
      else if (10*(vec_inf(1)/10).eq.30) then
         if (trans_bycol) then
            call local_solve_upper_i_by_columns
     >           (y,prec,x,tmp,
     >           mat_ptr(2*vec_inf(2)+2),
     >           mat_ptr(3*vec_inf(2)+2),
     >           mat,mat_ptr,mat_idx,vec_inf, xterms,trace)
         else
            if (unnorm) then
               call local_solve_unnorm_up_i_by_rows
     >              (y,prec,x,tmp,
     >              mat_ptr(2*vec_inf(2)+2),
     >              mat_ptr(3*vec_inf(2)+2),
     >              mat,mat_ptr,mat_idx,vec_inf, xterms,trace)
            else
               call local_solve_upper_i_by_rows
     >              (y,prec,x,tmp,
     >              mat_ptr(2*vec_inf(2)+2),
     >              mat_ptr(3*vec_inf(2)+2),
     >              mat,mat_ptr,mat_idx,vec_inf, xterms,trace)
            endif
         endif
      else if (10*(vec_inf(1)/10).eq.20) then
         call local_solve_upper_diag(y,prec,x,tmp,
     >        prec_inf,vec_inf(2), mat,vec_inf,
     >        xterms,trans_bycol,unnorm,trace)
      else
         call strange_matrix_fmt(vec_inf,'local solve upper$')
      endif
      
      return
      end
C----------------------------------------------------------------
C Point Jacobi
C----------------------------------------------------------------
      subroutine jacsol(y,x,vec_inf, prec,prec_inf)

C Arguments
C----
      integer prec_inf(*),vec_inf(*)
      double precision x(*),y(*),prec(*)

      if (10*(vec_inf(1)/10).eq.10) then
         call g2gprod(y,prec,x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        0,0,0,0)
      else if (10*(vec_inf(1)/10).eq.30) then
         call vvprod(y(vec_inf(vec_inf(5))),
     >        prec, x(vec_inf(vec_inf(5))), vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call vvprod(y(vec_inf(vec_inf(5))),
     >        prec, x(vec_inf(vec_inf(5))), vec_inf(2))
      else
         call strange_matrix_fmt(vec_inf,'jacsol$')
      endif

      return
      end
C================================================================
C     Create preconditioner
C================================================================
      subroutine creat_prec_none(prec,
     >     prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 0

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_full_jacobi(prec,
     >     prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 1
      buffer(2) = 1

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_ssor_jacobi(prec,
     >     prec_inf,leng_prec_inf,terms_expand,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     terms_expand,
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 1
      buffer(2) = 3
      buffer(3) = terms_expand

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_ilu_jacobi(prec,
     >     prec_inf,leng_prec_inf,terms_expand,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     terms_expand,
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 1
      buffer(2) = 4
      buffer(3) = terms_expand

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_full_ssor(prec,
     >     prec_inf,leng_prec_inf,terms_expand,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     terms_expand,
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 3
      buffer(3) = terms_expand
      buffer(2) = 3

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_full_ilu(prec,
     >     prec_inf,leng_prec_inf,terms_expand,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     terms_expand,
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 3
      buffer(2) = 4
      buffer(3) = terms_expand

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_par_ssor(prec,
     >     prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 4
      buffer(2) = 3

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_prec_par_ilu(prec,
     >     prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*)

C     Local
C----
      integer buffer(10),nitems(1)

      call default_preconditioner_params(buffer,nitems(1))

      buffer(1) = 4
      buffer(2) = 4

      call set_preconditioner_params(buffer,nitems(1))

      call creat_preconditioner(
     >     prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     vec_inf,leng_vec_inf)

      return
      end
C----------------------------------------------------------------
      subroutine creat_preconditioner_inner(prec,
     >     prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,
     >     mat_con,comm_context,
     >     vec_inf,leng_vec_inf, clr_buff1,clr_buff2)
      
C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     mat_ptr(*),mat_idx(*),mat_con(*),comm_context(*),
     >     vec_inf(*),leng_vec_inf
      double precision prec(*),matrix(*), clr_buff1(*),clr_buff2(*)
      
C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Functions
C---- 
      logical prec_null, tracer_proc,trace_progress,
     >     trace_matrices,trace_setup

C     Local
C----
      logical trace

C     Is there enough room to store the info?
C----
      trace = tracer_proc().and.
     >     (trace_progress().or.trace_setup())

C     Set elimination direction;
C     For all orderings: step inward;
C     hopefully iterands will stay radially symmetric this way
C---- 
      prec_inf(1)   = +1
      prec_inf(1+1) = +1

      if (prec_null()) return
      if (trace) call pt0('Creating preconditioner$')

      if (pat.eq.4) call init_multicolour
     >     (vec_inf,leng_vec_inf,mat_con,comm_context,
     >     mat_ptr,mat_idx, clr_buff1,clr_buff2, trace)

C     Copy diagonal of matrix to separate diagonal
C----
      call extract_matrix_diagonal
     >     (prec,mat_ptr(2*vec_inf(2)+2),
     >     vec_inf,matrix,mat_ptr,mat_idx)
      if (trace_matrices()) call dump_vector_o
     >     (prec,vec_inf,'preprecdiag$',0)

C     At present, we always factor blocks in parallel.
C     This is only a slight distortion of the truth
C----
         call bvcler(clr_buff1,vec_inf)
         call creat_prec_local(prec,prec_inf,leng_prec_inf,
     >        matrix,mat_ptr,mat_idx, clr_buff1,vec_inf)

 99   continue
      call compute_nnzero_prec(mat_ptr,vec_inf)
      if (tracer_proc()) call pt0('Preconditioner created$')
      if (trace_matrices()) 
     >     call dump_preconditioner(prec,prec_inf,vec_inf)
      
      return
      end
C----------------------------------------------------------------
C     Create the sweep part of the preconditioner
C----------------------------------------------------------------
      subroutine creat_prec_sweep(prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     tmp,vec_inf)
      
C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     mat_ptr(*),mat_idx(*),vec_inf(*),mat_con(*),comm_context(*)
      double precision prec(*),matrix(*),tmp(*)
      
C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Local
C---- 
      integer diag,vs

C     Get incoming pivots, and whatever else
C---- 
      if (10*(vec_inf(1)/10).eq.10) then
         vs = vec_inf(3)
         do 10 diag=1,mat_ptr(2)
            tx_trace_string = 'Fact bord coeffs$'
            tx_trace_int = diag
            call vector_make_border
     >           (matrix(diag*vs),vec_inf,
     >           mat_con,comm_context)
 10      continue
         tx_trace_string = 'Fact recv pivots$'
         tx_trace_int = 0
         call bvcler(prec,vec_inf)
         call vector_recv_bord(prec,vec_inf,2,
     >        mat_con,comm_context,+1,11)
      endif
      
C     Compute local part of sweep
C---- 
      call creat_prec_local(prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx, tmp,vec_inf)
      
C     Send outgoing pivots, and whatever else
C---- 
      if (10*(vec_inf(1)/10).eq.10) then
         tx_trace_string = 'Fact send pivots$'
         tx_trace_int = 0
         call vector_send_edge(prec,vec_inf,1,
     >        mat_con,comm_context,+1,04)
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine compute_nnzero_prec(mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*)

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

C     Number of nonzeros in the matrix
C----
      integer nnzero
      common /prec_nnzero/nnzero

C     Functions
C----
      integer get_nnzero
      integer locv,tri

      locv = vec_inf(2)
      if (locv.eq.1) then
         nnzero = locv
      else 
         tri = (get_nnzero()+locv)/2
         if (locv.eq.2) then
            nnzero = tri
         else
            if (xterms.le.0 .or. pat.eq.4) then
               nnzero = 2*tri
            else
               nnzero = locv+2*(locv+xterms*tri)
            endif
         endif
      endif

      return
      end
C----------------------------------------------------------------
C     Create the local part of the preconditioner
C----------------------------------------------------------------
      subroutine creat_prec_local(prec,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx, tmp, vec_inf)
      
C     Arguments
C---- 
      integer prec_inf(*),leng_prec_inf,
     >     mat_ptr(*),mat_idx(*), vec_inf(*)
      double precision prec(*),matrix(*),tmp(*)
      
C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

C     Cases for preconditioner local factorization type:
C---- 
C      
C     Jacobi, SOR, SSOR: invert diagonal
C---- 
      if (loc.eq.1.or.loc.eq.2
     >     .or.loc.eq.3) then
         if (10*(vec_inf(1)/10).eq.10) then
            call creat_local_ilu_g(prec,prec_inf,leng_prec_inf,
     >           matrix,mat_ptr, tmp, vec_inf,.false.)
C     Diagonal storage SSOR: analyze what diagonals are forward, what back
C----
         else if (10*(vec_inf(1)/10).eq.20) then
            call creat_local_ilu_d(prec,prec_inf,leng_prec_inf,
     >           matrix,vec_inf(2),mat_ptr,mat_idx,
     >           tmp, vec_inf,.false.)
         else
            call vinvert(prec,vec_inf(2))
         endif
         goto 99
C     Point Incomplete LU
C---- 
      else if (loc.eq.4) then
         if (10*(vec_inf(1)/10).eq.10) then
            call creat_local_ilu_g(prec,prec_inf,leng_prec_inf,
     >           matrix,mat_ptr, tmp, vec_inf,.true.)
         else if (10*(vec_inf(1)/10).eq.20) then
            call creat_local_ilu_d(prec,prec_inf,leng_prec_inf,
     >           matrix,vec_inf(2),mat_ptr,mat_idx,
     >           tmp, vec_inf,.true.)
         else if (10*(vec_inf(1)/10).eq.30) then
            call creat_local_ilu_i(prec, matrix,mat_ptr,mat_idx,
     >           tmp, vec_inf)
         else
            call strange_matrix_fmt(vec_inf,'Creat prec local$')
         endif
         goto 99
      endif

 99   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine prec_colour_solve
     >     (x,vec_inf,colour,last_colour, prec,prec_inf, flow,
     >     matrix,mat_ptr,mat_idx,mat_con,comm_context,
     >     trans,iter,trace)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),mat_con(*),prec_inf(*),vec_inf(*),
     >     iter,colour, flow,comm_context(*)
      double precision x(*),
     >     matrix(*),prec(*)
      logical last_colour,trans,trace

C     Dump quantities
C----
      integer dmp_trace_val
      common /dmp_trace/dmp_trace_val

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Functions and locals
C----
      integer num

C     Preliminary exchange own->brd for regular case
C----
      if (.not.trans) then
         tx_trace_string = 'Colour solve: data for colour$'
         tx_trace_int = colour
         call vector_make_border(x,vec_inf,
     >        mat_con,comm_context)
      else
         call bvcler(x,vec_inf)
      endif

C     Compute local part of sweep
C----
      if (trace) call pd2i('Colour solve$',colour,flow)
      if (10*(vec_inf(1)/10).eq.10) then
         call local_grid_solve_colour(x,prec,colour,flow,
     >        vec_inf(vec_inf(8)+1),
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),
     >        matrix(1+vec_inf(2)),mat_ptr(2),mat_ptr(3),
     >        trans,trace)
      else if (10*(vec_inf(1)/10).eq.30) then
         call local_crs_solve_colour(x,prec,colour,flow,
     >        matrix,mat_ptr,mat_idx,vec_inf, trans)
      else if (10*(vec_inf(1)/10).eq.20) then
         call local_dia_solve_colour(x,prec,colour,flow,
     >        matrix,vec_inf(2),mat_ptr,mat_idx,
     >        vec_inf,trans)
      else
         call strange_matrix_fmt(vec_inf,'colour solve$')
      endif

C     After the fact update brd->own for transpose case
C---- 
      if (trans.and..not.last_colour) then
         tx_trace_string = 'Colour solve: data for colour$'
         tx_trace_int = colour
         call vector_update_edge(x,vec_inf,
     >        mat_con,comm_context)
      endif

      if (.not.dmp_trace_val.ge.4.or.iter.gt.1) return
      if (flow.eq.+1) then
         num = 100+10*iter+colour
      else
         num = 200+10*iter+colour
      endif
      if (trans) then
         call dump_vector(x,vec_inf,'colvect$',num)
      else
         call dump_vector(x,vec_inf,'colvec$',num)
      endif

      return
      end
C----------------------------------------------------------------
C     Allocate preconditioner
C----------------------------------------------------------------
      subroutine allocate_preconditioner(lp,prec_inf,leng_prec_inf,
     >     vec_inf,work,prec_buffer,nprec_items)
      
C     Arguments
C---- 
      integer lp,prec_inf(*),vec_inf(*),leng_prec_inf,
     >     nprec_items(1),prec_buffer(*)
      double precision work(*)

C     Functions
C---- 
      integer alcate
      logical trace_setup,tracer_proc

C     Local
C---- 
      integer vec,loc
      
      if (trace_setup().and.tracer_proc())
     >     call pt0('Alloc preconditioner$')
      call set_preconditioner_params(prec_buffer,nprec_items)
      vec=vec_inf(2)
      
      goto 99
      
 99   continue

      loc = alcate(vec,'alloc prec main diag$',work)
      lp = loc

      return
      end
C----------------------------------------------------------------
C     Dump preconditioner
C----------------------------------------------------------------
      subroutine dump_preconditioner(prec,prec_inf,vec_inf)
      
C     Arguments
C---- 
      integer prec_inf(*),vec_inf(*)
      double precision prec(*)
      
C     Local 
C---- 
      integer siz
      
      siz=vec_inf(3)
      
      call dump_vector_o
     >     (prec,vec_inf, 'precdiag $',0)
      goto 99
      
 99   continue
      
      return
      end
C----------------------------------------------------------------
C Access preconditioner information
C----------------------------------------------------------------
      function prec_null()

C     Arguments
C----
      logical prec_null

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      prec_null = pat.eq.0

      return
      end
C----------------------------------------------------------------
C     For use in 'C' conditionals; mostly in precreate.c
C----------------------------------------------------------------
      function i_prec_multicolour()

C     Arguments
C----
      integer i_prec_multicolour

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      if (pat.eq.4) then
         i_prec_multicolour = 1
      else
         i_prec_multicolour = 0
      endif

      return
      end
C----------------------------------------------------------------
      function prcfsw()

C     Arguments
C----
      logical prcfsw

C     Preconditioner definition
C---- 
      integer
     >     pat,loc,xterms
      common /prcdef/
     >     pat,loc,xterms

      prcfsw=.true.

      return
      end
C----------------------------------------------------------------
C     This routine is called from the C routine that
C     mallocs the colour buffer
C----------------------------------------------------------------
      subroutine report_colour_buffs(b1,b2)

C     Arguments
C----
      integer b1,b2

C     Functions
C----
      logical trace_matrices

      if (trace_matrices())
     >     call pd2i('Allocating colour buffer; sizes$',b1,b2)

      return
      end
