C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      subroutine mvp_grd(y, diag,offs, x,
     >     ipts,jpts,bord, mat_ptr,
     >     trans,update,do_diag)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, mat_ptr(*),
     >     trans
      double precision 
     >     y   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     x   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     diag(ipts,jpts), offs(ipts,jpts,*)
      logical update,do_diag
      
C     Local
C---- 
      integer offd,n_offs,i_off,j_off
      
      n_offs = mat_ptr(2)

C     Multiply by diagonal (or not); separate for update and not
C---- 
      if (do_diag.and.update) then
         call g2gupdate(y,diag,x,ipts,jpts,bord,0,0,0,0)
      else if (do_diag) then
         call g2gprod(y,diag,x,ipts,jpts,bord,0,0,0,0)
      else if (.not.update) then
         call grid_zero(y,ipts,jpts,1)
      endif

C     Multiply by offdiagonals
C----
      if (trans.eq.1) then
         if (.not.update) call grid_cler(y,ipts,jpts,bord)
         do 130 offd=1,n_offs
            call get_dia_offset(i_off,j_off,mat_ptr,offd)
            call force_range(abs(i_off),0,bord,'I-offset mvp_d$')
            call force_range(abs(j_off),0,bord,'J-offset mvp_d$')
            call g2gupdate(y,offs(1,1,offd),x,
     >           ipts,jpts,bord, i_off,j_off,0,0)
 130     continue
      else
         do 30 offd=1,n_offs
            call get_dia_offset(i_off,j_off,mat_ptr,offd)
            call force_range(abs(i_off),0,bord,'I-offset mvp_d$')
            call force_range(abs(j_off),0,bord,'J-offset mvp_d$')
            call g2gupdate(y,offs(1,1,offd),x,
     >           ipts,jpts,bord, 0,0,i_off,j_off)
 30      continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine g2gupdate(y,mat,x,ipts,jpts,bord,iof1,jof1,iof2,jof2)

C     Arguments
C----
      integer ipts,jpts,bord, iof1,jof1,iof2,jof2
      double precision 
     >     y   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     x   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     mat(ipts,jpts)

C     Local
C----
      integer row,col

      do 10 col=1,jpts
         do 20 row=1,ipts
            y(row+iof1,col+jof1) = y(row+iof1,col+jof1)
     >           + mat(row,col)*x(row+iof2,col+jof2)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine g2gdndate(y,mat,x,ipts,jpts,bord,iof1,jof1,iof2,jof2)

C     Arguments
C----
      integer ipts,jpts,bord, iof1,jof1,iof2,jof2
      double precision 
     >     y   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     x   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     mat(ipts,jpts)

C     Local
C----
      integer row,col

      do 10 col=1,jpts
         do 20 row=1,ipts
            y(row+iof1,col+jof1) = y(row+iof1,col+jof1)
     >           - mat(row,col)*x(row+iof2,col+jof2)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine g2gprod(y,mat,x,ipts,jpts,bord,iof1,jof1,iof2,jof2)

C     Arguments
C----
      integer ipts,jpts,bord, iof1,jof1,iof2,jof2
      double precision 
     >     y   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     x   (1-bord:ipts+bord,1-bord:jpts+bord),
     >     mat(ipts,jpts)

C     Local
C----
      integer row,col

      do 10 col=1,jpts
         do 20 row=1,ipts
            y(row+iof1,col+jof1) = 
     >           mat(row,col)*x(row+iof2,col+jof2)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine process_grid_matrix(mat_con,leng_mat_con,
     >     mat_ptr,vec_inf,leng_vec_inf)

C     Arguments
C----
      integer mat_con(*),leng_mat_con,
     >     mat_ptr(*),vec_inf(*),leng_vec_inf

C     Local
C----
      integer offd,i_off,j_off,bord, dim,tot,btot
      logical trace_setup

      bord = 0
      do 10 offd=1,mat_ptr(2)
         call get_dia_offset(i_off,j_off,mat_ptr,offd)
         bord = max(bord,abs(i_off),abs(j_off))
 10   continue
      vec_inf(vec_inf(5)) = bord

      tot = 1
      btot = 1
      do 20 dim=1,vec_inf(vec_inf(5)+1)
         tot = tot*vec_inf(vec_inf(5)+2-1+dim)
         btot = btot*(vec_inf(vec_inf(5)+2-1+dim)+2*bord)
 20   continue
      vec_inf(2) = tot
      vec_inf(3) = btot
      if (trace_setup()) call pd2i('Number of owned/local vars$',
     >        vec_inf(2),vec_inf(3))

      call grid_traffic_patterns(mat_con,leng_mat_con,vec_inf)

      return
      end
C----------------------------------------------------------------
C     Set up info for 5point internally created matrix
C     locmat = location of matrix in memory array.
C----------------------------------------------------------------
      subroutine demo_get_grid_offsets(mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*),vec_inf(*)
      
C     Local
C---- 
      integer fivep_offsets(2,4), first_off,ndia
      data fivep_offsets/0,-1, -1,0, +1,0, 0,+1/
      
C     In the demo so far, only 2 space dimensions
C----
      mat_ptr(1) = 2

C     The number of diagonals depends on whether this is symmetric or not
C----
      if (mod(vec_inf(1),2).eq.1) then
         ndia = 2
         first_off = 3
      else
         ndia = 4
         first_off = 1
      endif
      mat_ptr(2) = ndia

      call iicopy(mat_ptr(3),
     >     fivep_offsets(1,first_off),2*ndia)

      return
      end
C----------------------------------------------------------------
      subroutine get_dia_offset(i_off,j_off,mat_ptr,diag)

C     Arguments
C----
      integer i_off,j_off,mat_ptr(*),diag

      i_off = mat_ptr(3+2*(diag-1))
      j_off = mat_ptr(3+2*diag-1)

      return
      end
C----------------------------------------------------------------
      function compute_nnzero_grid(mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*),compute_nnzero_grid

      compute_nnzero_grid = 
     >     (mat_ptr(2)+1)*vec_inf(2)

      return
      end
C----------------------------------------------------------------
C     Dump orthogonally stored matrix;
C----------------------------------------------------------------
      subroutine dump_matx_grid(matrix,mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*),vec_inf(*)
      double precision matrix(*)
      
C     Local
C----
      integer dia,loc,iof,jof
      character*10 numbers
      character*13 dia_string
      data dia_string,numbers/'diag-<  ,  >$','0123456789'/

      call pd1i('matrix at$',1)
      call dump_vector_o(matrix(1),vec_inf, 'matdia$',0)

      do 10 dia=1,mat_ptr(2)
         loc = dia*vec_inf(2)+1
         call get_dia_offset(iof,jof,mat_ptr,dia)
         call pd1i1i('Off diag$',dia,' at$',loc)
         call pd2i('-- offsets$',iof,jof)
         if (iof.lt.0) then
            dia_string(7:7) = '-'
            iof = -iof
         else
            dia_string(7:7) = '+'
         endif
         dia_string(8:8) = numbers(iof+1:iof+1)
         if (jof.lt.0) then
            dia_string(10:10) = '-'
            jof = -jof
         else
            dia_string(10:10) = '+'
         endif
         dia_string(11:11) = numbers(jof+1:jof+1)
         call dump_vector_o(matrix(loc), vec_inf, dia_string,0)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine init_grd_multicolour(vec_inf,leng_vec_inf,
     >      mat_con,comm_context,mat_ptr,rand,trans, trace)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,mat_con(*),
     >     comm_context(*),mat_ptr(*)
      double precision rand(*),trans(*)
      logical trace

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Function
C----
      double precision irand
      integer grd_lc2glb, locfun
      logical trace_matrices,trace_setup,tracer_proc

C     Local
C----
      integer isiz,jsiz,bord,tot_var, var,other_var,
     >     num, num1,num2,x1,x2,
     >     key, i_clr,cur_clr,n_clr, this_loc,this_var,this_clr,
     >     first_el,class, max_colour
      integer
     >     grid_lo(4),grid_hi(4),global_grid_hi(4)
      logical all_coloured(1),colour_now
      double precision ran

      locfun(num1,num2) = (num2-(1-bord))*(isiz+2*bord)+num1+bord

      if (trace) call pt0('Creating grid multicolouring$')
      vec_inf(8) = vec_inf(7)
      vec_inf(7) = vec_inf(7)+vec_inf(2)
      isiz = vec_inf(vec_inf(5)+2)
      jsiz = vec_inf(vec_inf(5)+2+1)
      bord = vec_inf(vec_inf(5))
      tot_var = vec_inf(3)
      call force_range(vec_inf(8)+tot_var,1,leng_vec_inf,
     >     'DIA multiclr not enough buffer$')
      call iicopy(grid_lo,vec_inf(vec_inf(6)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(grid_hi,
     >     vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(global_grid_hi,
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))

C     Generate random numbers and zero all colours
C----
      num = 0
      do 15 num2=1-bord,jsiz+bord
         do 10 num1=1-bord,isiz+bord
            num = num+1
C     Calculate a random number based on global var no
            var = grd_lc2glb(num1,num2,vec_inf)
            ran = irand(var)
            rand(num) = ran
            vec_inf(vec_inf(8)+num) = 0
            trans(num) = 0.d0
 10      continue
 15   continue
      if (trace_matrices()) call dump_vector(rand,vec_inf,'Rand$',0)

C     A priori bound on number of colours
C----
      max_colour = vec_inf(4)
      call force_range(max_colour,1,0,
     >     'Init multicolour; domain size undeclared$')
      if (trace) call pt1i('Max colour$',max_colour)

C     Now start making classes
C----
      class = 1
 20   continue
      if (trace.and.trace_setup())
     >     call pt1i('Applying colour $',class)
      all_coloured(1) = .true.
      do 35 num2=1,jsiz
         do 30 num1=1,isiz
            var = locfun(num1,num2)
C     If this node is uncoloured, there is still work to be done
            if (vec_inf(vec_inf(8)+var).ne.0) goto 31
            all_coloured(1) = .false.
            colour_now = .true.
C     Relate this node to its neighbours, make sure to exclude boundary
            do 45 x2=-1,+1
               if (num2+grid_lo(2)-1+x2.le.0 .or. 
     >              num2+grid_lo(2)-1+x2.gt.global_grid_hi(2)) goto 46
               do 40 x1=-1,+1
                  if (num1+grid_lo(1)-1+x1.le.0 .or.
     >                 num1+grid_lo(1)-1+x1.gt.global_grid_hi(1))
     >                 goto 47
                  if (abs(x1+x2).ne.1) goto 47
c     other_var = locfun(num1+x1,num2+x2)
                  other_var = var+x2*(isiz+2*bord)+x1
C     If its random no. is less than that of an uncoloured neighbour, skip
                  if (rand(var).lt.rand(other_var)
     >                 .and. vec_inf(vec_inf(8)+other_var).eq.0)
     >                 colour_now = .false.
 47               continue
 40            continue
 46            continue
 45         continue
C     If its random no. is higher than of uncoloured neighbours, colour now
            if (colour_now) trans(var) = dble(class)
 31         continue
 30      continue
 35   continue

C     Tell other people what you've just done
      tx_trace_string = 'Colouring$'
      tx_trace_int = class
      call vector_make_border(trans,vec_inf,
     >     mat_con,comm_context)
      if (trace_matrices())
     >     call dump_vector(trans,vec_inf,'Colr$',class)
      do 50 var=1,tot_var
         vec_inf(vec_inf(8)+var) = int(trans(var)+1.d-1)
 50   continue
      if (class.gt.max_colour+1) then
         if (tracer_proc()) call pe0('>>>> Too many colours needed$')
         goto 91
      endif

C     If *everyone* has stopped, stop. Otherwise go on.
      call qgand(all_coloured,comm_context,trace_matrices())
      if (all_coloured(1)) goto 90
      class = class+1
      goto 20
 90   continue
      if (trace) call pd1i('No. colours:$',class)
      if (log_channel_open)
     >     call pc1i('>> Precond with no. colours:$',class,logchn)
 91   continue
      vec_inf(vec_inf(8)) = class

C     Now start making groups of nodes of the same colour
C----
      vec_inf(9) = vec_inf(8)+tot_var+1
      call force_range(vec_inf(9)+2*vec_inf(vec_inf(8))+tot_var+1,
     >     1,leng_vec_inf,'Colour groups: vec_inf overflow$')

C     leave space for pointers
      first_el = vec_inf(9)+2*vec_inf(vec_inf(8))+1

C     encode as (colour,variable)
      key = tot_var+1
      do 100 var=1,tot_var
         vec_inf(first_el+var-1) = vec_inf(vec_inf(8)+var)*key+var
 100  continue

C     sort
      call isort(vec_inf(first_el),tot_var)

C     decode and set up pointers to colour groups
      cur_clr = 0
      n_clr = 0
      do 110 num=1,tot_var
         this_loc = first_el+num-1
         this_var = mod(vec_inf(this_loc),key)
         this_clr = vec_inf(this_loc)/key
         if (this_clr.ne.cur_clr) then
            if (cur_clr.gt.0) vec_inf(vec_inf(9)+2*cur_clr) = n_clr
            n_clr = 0
            do 120 i_clr=cur_clr+1,this_clr-1
               vec_inf(vec_inf(9)+2*i_clr-1) = this_loc
               vec_inf(vec_inf(9)+2*i_clr) = 0
 120        continue
            cur_clr = this_clr
            vec_inf(vec_inf(9)+2*cur_clr-1) = this_loc
         endif
         vec_inf(this_loc) = this_var
         n_clr = n_clr+1
 110  continue

      return
      end
C----------------------------------------------------------------
C     Connectivity stuff
C----------------------------------------------------------------
      subroutine proc_proc_interface_d(width,height,bord,
     >     direction,step,source,vec_inf)

C     Arguments
C----
      integer width,height,bord, direction,step,source,vec_inf(*)

      call distance_to_proc(direction,step,source)
      width  = vec_inf(vec_inf(5)+2+2-direction)
      height = vec_inf(vec_inf(5)+2+direction-1)
      bord = vec_inf(vec_inf(5))

      return
      end
C----------------------------------------------------------------
      subroutine receiving_procs_g(surrs,nsurr,maxsur,vec_inf)

C     Arguments
C----
      integer maxsur
      integer surrs(maxsur),nsurr,vec_inf(*)

C     Function
C----
      integer problem_dimension,neighbour_proc

C     Local
C----
      integer dim,step,other, step_ijk(4)

      nsurr = 0
      do 10 dim=1,problem_dimension(vec_inf)
         call inulv(step_ijk,4)
         do 20 step=-1,+1,2
            step_ijk(dim) = step
            other = neighbour_proc(step_ijk)
            if (other.ge.0) then
               nsurr = nsurr+1
               call force_range(nsurr,0,maxsur,
     >              '>> Recving procs_g too many$')
               surrs(nsurr) = other
            endif
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine sending_procs_g(surrs,nsurr,maxsur,vec_inf)

C     Arguments
C----
      integer maxsur
      integer surrs(maxsur),nsurr,vec_inf(*)

      call receiving_procs_g(surrs,nsurr,maxsur,vec_inf)

      return
      end
C----------------------------------------------------------------
      function grid_buffer_size(vec_inf,mat_con)

C     Arguments
C----
      integer vec_inf(*),mat_con(*),grid_buffer_size

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Functions
C----
      logical thisme

C     Local
C----
      integer iprc,source,local_size,idum1,idum2,idum3,bord

      grid_buffer_size = 0
      do 10 iprc=1,mat_con(mat_con(2))
         source = mat_con(mat_con(2)+iprc)
         if (.not.thisme(source)) then
            call proc_proc_interface_d(local_size,idum1,bord,
     >           idum2,idum3,source,vec_inf)
            grid_buffer_size = max(grid_buffer_size,local_size+2*bord)
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine grid_traffic_patterns(mat_con,leng_mat_con,vec_inf)

C     Arguments
C----
      integer mat_con(*),leng_mat_con,vec_inf(*)

C     Local
C----
      integer buffer(99),nproc,iprc,
     >     width,height,bord,direction,step, first_free
      logical trace_setup

      first_free = 6
      mat_con(2) = first_free
      call sending_procs_g(buffer,nproc,99,vec_inf)
      call force_range(leng_mat_con,
     >     first_free+2*(nproc+1),-1,
     >     'Grid traffic pattern, leng_mat_con1$')
      mat_con(4) = mat_con(2)+nproc+1
      first_free = mat_con(4)+nproc+1
      mat_con(mat_con(2)) = nproc
      do 10 iprc=1,nproc
         mat_con(mat_con(2)+iprc) = buffer(iprc)
         call proc_proc_interface_d(width,height,bord,
     >        direction,step,buffer(iprc),vec_inf)
         mat_con(mat_con(4)+iprc) = width
 10   continue

      mat_con(3) = first_free
      call receiving_procs_g(buffer,nproc,99,vec_inf)
      call force_range(leng_mat_con,
     >     first_free+2*(nproc+1),-1,
     >     'Grid traffic pattern, leng_mat_con2$')
      mat_con(5) = mat_con(3)+nproc+1
      first_free = mat_con(5)+nproc+1
      mat_con(mat_con(3)) = nproc
      do 20 iprc=1,nproc
         mat_con(mat_con(3)+iprc) = buffer(iprc)
         call proc_proc_interface_d(width,height,bord,
     >        direction,step,buffer(iprc),vec_inf)
         mat_con(mat_con(5)+iprc) = width
 20   continue

      if (trace_setup()) then
         call pd1i1i('Bord procs @$',mat_con(2),
     >        '#=$',mat_con(mat_con(2)))
         call pdai('- nums:$',
     >        mat_con(mat_con(2)+1),mat_con(mat_con(2)))
         call pd1i1i('Edge procs @$',mat_con(3),
     >        '#=$',mat_con(mat_con(3)))
         call pdai('- nums:$',
     >        mat_con(mat_con(3)+1),mat_con(mat_con(3)))
      endif

      return
      end
C================================================================
C
C     Communication part
C
C     Guide to the meaning of various parameters.
C     `act' indicates what to do with incoming data:
C     9: ignore
C     1: copy in place
C     2: add to data in place
C     3: average with data in place.
C     `part' indicates what part of the domain if affected:
C     1: edge part (owned variables)
C     2: border part (non-owned variables)
C
C================================================================
      subroutine vector_gen_sg(x,vec_inf,target,tmp,type,
     >     comm_context,
     >     part,send,trace_tx,dump_tx)

C     Arguments
C----
      double precision x(*),tmp(*)
      integer target,type,part, vec_inf(*),comm_context(*)
      logical send,trace_tx,dump_tx

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Local
C----
      integer domain_top,direction,step, height,width,
     >    ipts,jpts,bord,bord_lo,bord_hi,size,
     >    info,idum

C     Is the target in i/j direction and back/forward?
C     3-direction is orthogonal direction (2D only)
C----
      call proc_proc_interface_d(width,height,bord,
     >     direction,step,target,vec_inf)
      ipts = vec_inf(vec_inf(5)+2)
      jpts = vec_inf(vec_inf(5)+2+1)

      if (step.gt.0) then
         domain_top = height
         if (part.eq.2) then
            bord_lo = domain_top+1
            bord_hi = domain_top+bord
         else
            bord_lo = domain_top-bord+1
            bord_hi = domain_top
         endif
      else
         domain_top = 1
         if (part.eq.2) then
            bord_lo = 1-bord
            bord_hi = 0
         else
            bord_lo = 1
            bord_hi = bord
         endif
      endif

      if (trace_tx) then
         if (part.eq.1) then
            call pd00(tx_trace_string,'(edge_part)$')
         else
            call pd00(tx_trace_string,'(bord part)$')
         endif
      endif

      size = bord*(width+2*bord)
      call pvmfsetsbuf(
     >     comm_context(5+comm_context(2)+max(target,0)),idum)
      call bncpo2(x, 
     >     ipts,jpts,bord,bord_lo,bord_hi, direction)
      if (send) then
         call pvmfsend(
     >        comm_context(3+target),type,info)
         if (info.lt.0) call pe0('trouble sending$')
         call pvmffreebuf(
     >        comm_context(5+comm_context(2)+max(target,0)),info)
         if (info.lt.0) call pe0('trouble freeing$')
         if (trace_tx) call pd1i('- buffer sent to$',target)
      endif
      if (info.lt.0) call stop_connections('vect gen sd error$')

      return
      end
C----------------------------------------------------------------
C copy a boundary strip for output
C----------------------------------------------------------------
      subroutine bncpo2(trans,
     >     ipts,jpts,bord,bord_lo,bord_hi, dir)

C     argument dir is 1 for i, 2 for j
C----
      integer
     >     ipts,jpts,bord,bord_lo,bord_hi,dir
      double precision 
     >     trans(1-bord:ipts+bord,1-bord:jpts+bord)


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C local
C----
      integer point,srclin,line, info

C copy lines to temporary array, walking from the border in
C----
      do 10 srclin=bord_lo,bord_hi
         line = srclin-bord_lo+1
         if (dir.eq.2) then
            call force_range(srclin,1-bord,jpts+bord,
     >           'source out of bounds$')
            call pvmfpack(REAL8,trans(1-bord,srclin),
     >           ipts+2*bord,1,info)
            if (info.lt.0)
     >           call pe00('bnd copy2$','PUT out of memory$')
         else
            call force_range(srclin,1-bord,ipts+bord,
     >           'source out of bounds$')
            do 40 point=1-bord,jpts+bord
               call pvmfpack(REAL8,trans(srclin,point),
     >              1,1,info)
               if (info.lt.0)
     >              call pe00('bnd copy2$','PUT out of memory$')
 40         continue
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine vector_gen_rg(x,vec_inf,source,tmp,type,comm_context,
     >     part,receive,act,trace_tx,dump_tx)

C     Arguments
C----
      double precision x(*),tmp(*)
      integer source,type,part,act, vec_inf(*),comm_context(*)
      logical receive,trace_tx,dump_tx

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string


C     Local
C----
      integer domain_bot,direction,step, height,width,
     >     ipts,jpts,bord,bord_lo,bord_hi,size, info
      logical straight_home
      character*30 tx_string,act_string
      data tx_string/'recv_d; rcvd part=< > act=< >$'/,
     >     act_string/'cav     0'/

C     Is the target in i/j direction and back/forward?
C     3-direction is orthogonal direction (2D only)
C----
      call proc_proc_interface_d(width,height,bord,
     >     direction,step,source,vec_inf)
      ipts = vec_inf(vec_inf(5)+2)
      jpts = vec_inf(vec_inf(5)+2+1)

      if (step.gt.0) then
         domain_bot = height
         if (part.eq.1) then
            bord_lo = domain_bot-bord+1
            bord_hi = domain_bot
         else
            bord_lo = domain_bot+1
            bord_hi = domain_bot+bord
         endif
      else
         domain_bot = 1
         if (part.eq.1) then
            bord_lo = 1
            bord_hi = bord
         else
            bord_lo = 1-bord
            bord_hi = 0
         endif
      endif

      if (trace_tx) then
         if (part.eq.1) then
            tx_string(20:20) = 'e'
         else
            tx_string(20:20) = 'b'
         endif
         tx_string(28:28) = act_string(act:act)
         call pd00(tx_trace_string,tx_string)
      endif
      size = bord*(width+2*bord)
      straight_home = direction.eq.2 .and. act.eq.1
      if (receive) then
         call pvmfsetrbuf(0,info)
         call pvmfrecv(-1,type,comm_context(7+2*comm_context(2)+source))
      else
         call pvmfsetrbuf(comm_context(7+2*comm_context(2)+source),info)
      endif
      call bncpi2(x, tmp,width,straight_home,
     >     ipts,jpts,bord,bord_lo,bord_hi, direction,
     >     act,dump_tx)

      return
      end
C----------------------------------------------------------------
C Copy a boundary strip as input
C----------------------------------------------------------------
      subroutine bncpi2(trans,
     >     strip,lij,straight_home,
     >     ipts,jpts,bord,bord_lo,bord_hi, dir,
     >     act,dump_tx)

C     arguments
C     dir is 1 for i, 2 for j
C----
      integer ipts,jpts,bord,bord_lo,bord_hi,lij, dir,act
      double precision 
     >     strip(1-bord:lij+bord,bord),
     >     trans(1-bord:ipts+bord,1-bord:jpts+bord)
      logical dump_tx,straight_home



c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C local
C----
      integer line,point,tarlin,info

C move lines from temporary array, walking from the border out;
C act = 'c' --> copy; 'a' --> add; 'v' --> average; '0' --> ignore
C----
      if (act.eq.9) return
      if (straight_home) then
         call pvmfunpack(REAL8,
     >        trans(1-bord,bord_lo),bord*(lij+2*bord),1,info)
         if (dump_tx)
     >        call pdar('- recvd values$',
     >        trans(1-bord,bord_lo),bord*(lij+2*bord))
         return
      else
         call pvmfunpack(REAL8,         
     >        strip,bord*(lij+2*bord),1,info)
         if (dump_tx)
     >        call pdar('- recvd values$',strip,bord*(lij+2*bord))
      endif
      if (info.lt.0) call pe00('BNDcp2i$','GET buffer empty$')
      do 10 tarlin=bord_lo,bord_hi
         line = tarlin-bord_lo+1
         if (dir.eq.2) then
            if (act.eq.2) then
               do 20 point=1-bord,ipts+bord
                  trans(point,tarlin) = 
     >                 strip(point,line)+trans(point,tarlin)
 20            continue
            else if (act.eq.3) then
               do 23 point=1-bord,ipts+bord
                  trans(point,tarlin) = 
     >                 .5d0*(strip(point,line)+trans(point,tarlin))
 23            continue
            else if (.not.straight_home) then
               do 26 point=1-bord,ipts+bord
                  trans(point,tarlin) = strip(point,line)
 26            continue
            endif
         else
            if (act.eq.2) then
               do 40 point=1-bord,jpts+bord
                  trans(tarlin,point) = 
     >                 strip(point,line)+trans(tarlin,point)
 40            continue
            else if (act.eq.3) then
               do 43 point=1-bord,jpts+bord
                  trans(tarlin,point) = 
     >                 .5d0*(strip(point,line)+trans(tarlin,point))
 43            continue
            else
               do 46 point=1-bord,jpts+bord
                  trans(tarlin,point) = strip(point,line)
 46            continue
            endif
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump a 2D vector to the dump channel
C----------------------------------------------------------------
      subroutine dump_vector_g(x,i0,i1,j0,j1, vec_inf,
     >     ibeg,iend,jbeg,jend, txt,itxt)

C     Arguments
C---- 
      integer i0,i1,j0,j1,ibeg,iend,jbeg,jend, itxt,vec_inf(*)
      character*(*) txt
      double precision x(i0:i1,j0:j1)

C     Local
C----
      integer row,col

C     Dump the internal part of the vector
C----
      call pd1iai('Dump vector; origin @$',vec_inf(6),
     >     'loc:$',vec_inf(vec_inf(6)),2)
      do 10 col=jbeg,jend
         do 20 row=ibeg,iend
            call pdi2id(txt,itxt,
     >           'i,j:$',
     >           vec_inf(vec_inf(6))+row-1,
     >           vec_inf(vec_inf(6)+1)+col-1,
     >           'val:$',x(row,col))
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump the border of a 2D vector
C----------------------------------------------------------------
      subroutine dump_border_g(x,i0,i1,j0,j1,vec_inf,
     >     ibeg,iend,jbeg,jend, txt,itxt)

C     Arguments
C---- 
      integer i0,i1,j0,j1,ibeg,iend,jbeg,jend, itxt,vec_inf(*)
      character*(*) txt
      double precision x(i0:i1,j0:j1)

C     Local
C----
      integer row,col, trow,tcol,
     >     grid_lo(4),grid_hi(4),global_grid_hi(4)
      character*20 b_txt

      b_txt(1:2) = 'b_'
      col = index(txt,'$')
      b_txt(3:2+col) = txt(1:col)
      call iicopy(grid_lo,vec_inf(vec_inf(6)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(grid_hi,
     >     vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))
      call iicopy(global_grid_hi,
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+1))

C     Dump the four borders
C----
      do 11 col=j0,jbeg-1
         tcol = grid_lo(2)+col-1
         if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 13
         do 12 row=i0,i1
            trow = grid_lo(1)+row-1
            if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 14
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 14         continue
 12      continue
 13      continue
 11   continue
      do 21 col=jend+1,j1
         tcol = grid_lo(2)+col-1
         if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 23
         do 22 row=i0,i1
            trow = grid_lo(1)+row-1
            if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 24
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 24         continue
 22      continue
 23      continue
 21   continue
      do 31 row=i0,ibeg-1
         trow = grid_lo(1)+row-1
         if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 33
         do 32 col=j0,j1
            tcol = grid_lo(2)+col-1
            if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 34
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 34         continue
 32      continue
 33      continue
 31   continue
      do 41 row=iend+1,i1
         trow = grid_lo(1)+row-1
         if (trow.lt.1 .or. trow.gt.global_grid_hi(1)) goto 43
         do 42 col=j0,j1
            tcol = grid_lo(2)+col-1
            if (tcol.lt.1 .or. tcol.gt.global_grid_hi(2)) goto 44
            call pdi2id(b_txt,itxt,
     >           'i,j:$',trow,tcol,'val:$',x(row,col))
 44         continue
 42      continue
 43      continue
 41   continue

      return
      end
