C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C
C     Diagonal storage routines
C
C     The vec_inf array contains the following information
C     about the structure of diagonal vectors
C
C     As usual,
C     -- vec_inf(2) = number of owned variables
C     -- vec_inf(3) = number of local variables
C     Further structure starts at location vec_inf(5);
C     embedding information starts at location vec_inf(6).
C
C     Structure information:
C     -- vec_inf(vec_inf(5)) = location of first owned variable
C     among the local variables
C     -- vec_inf(vec_inf(5)+1) = the number of segments comprising the
C     local variables
C     -- vec_inf(vec_inf(5)+1+1) = list of (start,end) pairs of
C     variable stretches
C
C     Embedding information:
C     -- vec_inf(vec_inf(6)) = global number of first owned variable
C
C================================================================
C----------------------------------------------------------------
C     Matrix-vector multiply by diagonals
C
C     Guide to matrix parts:
C     0 (all): involve all of your local variables
C     2 (brd): involve only bordering variables
C     1 (own): involve only your owned variables
C----------------------------------------------------------------
      subroutine mvp_dia(y, matrix,mat_ptr,mat_idx, x,vec_inf,
     >     length,
     >     trans,update,do_diag)

C     Arguments
C----
      integer mat_ptr(*),mat_idx(*),vec_inf(*), length,
     >     trans
      double precision x(*),y(*), matrix(length,*)
      logical update,do_diag

C     Local
C----
      integer dia,target

      if (trans.eq.1) then
         if (.not.update) call nulv(y,vec_inf(3))
         do 50 dia=1,mat_ptr(1)
            target = mat_idx(dia)
            if (.not.do_diag.and.mat_ptr(1+dia).eq.0) goto 51
            call vvupdate(y(target),
     >           matrix(1,dia),x(vec_inf(vec_inf(5))),length)
 51         continue
 50      continue
      else
         if (.not.update) call nulv(y,vec_inf(3))
         do 10 dia=1,mat_ptr(1)
            target = mat_idx(dia)
            if (.not.do_diag.and.mat_ptr(1+dia).eq.0) goto 11
            call vvupdate(y(vec_inf(vec_inf(5))),
     >           matrix(1,dia),x(target),length)
 11         continue
 10      continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine diag_set_owned_stretch(vec_inf,leng_vec_inf,
     >      first,length)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,first,length

C     Functions
C----
      logical trace_setup

C     Write the (global) numbers into the region of owned variables
C----
      call force_range(leng_vec_inf,7,-1,
     >     'Length vec_inf; diag_set_owned_stretch$')
      vec_inf(6) = 10+1
      vec_inf(5) = vec_inf(6)+1
      vec_inf(2)    = length
      vec_inf(vec_inf(6)) = first
      if (trace_setup()) then
         call pd2i('Diag owned stretch set to from/len$',first,length)
         call pd2i('-further info struct/embed @$',
     >        vec_inf(5),vec_inf(6))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine matrix_diag_norm_est(a_norm,matrix,
     >     mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*)
      double precision a_norm,matrix(*)

C     Local
C----
      integer main,dia

C     Find the main diagonal
C----
      main = 1
      do 10 dia=1,mat_ptr(1)
         if (mat_ptr(1+dia).eq.0) then
            main = dia
            goto 11
         endif
 10   continue
 11   continue

C     Take the scaled norm of the main diagonal
C----
      call inprod(a_norm,matrix(1+(main-1)*vec_inf(2)),
     >     matrix(1+(main-1)*vec_inf(2)),vec_inf(2))
      a_norm = sqrt(a_norm / vec_inf(2)) *2

      return
      end
C----------------------------------------------------------------
      function compute_nnzero_diag(mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*), compute_nnzero_diag

      compute_nnzero_diag = mat_ptr(1)*vec_inf(3)

      return
      end
C================================================================
C
C     Communication part
C
C     Guide to the meaning of various parameters.
C     'act' indicates what to do with incoming data:
C     9: ignore
C     1: copy in place
C     2: add to data in place
C     3: average with data in place.
C     'part' indicates what part of the domain if affected:
C     1: edge part (owned variables)
C     2: border part (non-owned variables)
C
C================================================================
C----------------------------------------------------------------
C     Send indirectly addressed vector elements
C----------------------------------------------------------------
      subroutine vector_gen_sd(x,vec_inf,mat_con,
     >     target,iprc, tmp,type,comm_context,
     >     part,send,
     >     trace,dump)


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Arguments
C----
      double precision x(*),tmp(*)
      integer target,iprc,type,part,
     >     vec_inf(*),mat_con(*),comm_context(*)
      logical send, trace,dump

C     Local
C----
      integer first,last,nvar, info,idum


C     Get variable numbers of sending vars
C----
      if (part.eq.1) then
         if (mat_con(mat_con(3)+2*iprc).eq.-2) then
            first = 1
            last = 0
         else
            first = mat_con(mat_con(5)-1+2*iprc)
            last = mat_con(mat_con(5)-1+2*iprc+1)
         endif
      else if (part.eq.2) then
         if (mat_con(mat_con(2)+2*iprc).eq.-2) then
            first = 1
            last = 0
         else
            first = mat_con(mat_con(4)-1+2*iprc)
            last = mat_con(mat_con(4)-1+2*iprc+1)
         endif
      else
         call pe1i('Vector SD strange part$',part)
      endif
      nvar = last-first+1

      if (dump.or.trace) then
         if (part.eq.1) then
            call pd00(tx_trace_string,'(edge part)$')
         else
            call pd00(tx_trace_string,'(bord part)$')
         endif
         call pd1i1i2i('- to:$',target,'type$',type,
     >        'vars range:$',first,last)
         if (dump) call pdar('- values:$',x(first),nvar)
      endif

 20   continue
      call pvmfsetsbuf(
     >     comm_context(5+comm_context(2)+max(target,0)),idum)
      call pvmfpack(REAL8,x(first),nvar,1,info)
      if (info.lt.0) call pe00('pvm send dia$','PUT out of memory$')
      if (.not.send) return

C     Send
C----
      call pvmfsend(comm_context(3+target),type,info)
      if (info.lt.0) call pe0('trouble sending$')
      call pvmffreebuf(
     >     comm_context(5+comm_context(2)+max(target,0)),info)
      if (info.lt.0) call pe0('trouble freeing$')
      if (trace) call pd1i('- sent to$',target)
      if (info.lt.0) call stop_connections('vect gen sg error$')

      return
      end
C----------------------------------------------------------------
C     Receive indirectly addressed boundary elements
C----------------------------------------------------------------
      subroutine vector_gen_rd(x,vec_inf,mat_con,
     >     source,iprc, tmp,type,comm_context,
     >     part,receive,act,
     >     trace,dump)

C     Arguments
C----
      double precision x(*),tmp(*)
      integer source,iprc,type,part,act,
     >     vec_inf(*),mat_con(*),comm_context(*)
      logical receive, trace,dump

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Local
C----
      integer first,last,nvar,info

C     Get variable numbers of receiving vars:
C     'part' indicates what part of ourselves we received
C----
      if (part.eq.1) then
         if (mat_con(mat_con(3)+2*iprc).eq.-2) then
            first = 1
            last = 0
         else
            first = mat_con(mat_con(5)-1+2*iprc)
            last = mat_con(mat_con(5)-1+2*iprc+1)
         endif
      else if (part.eq.2) then
         if (mat_con(mat_con(2)+2*iprc).eq.-2) then
            first = 1
            last = 0
         else
            first = mat_con(mat_con(4)-1+2*iprc)
            last = mat_con(mat_con(4)-1+2*iprc+1)
         endif
      else
         call pe1i('Vector RD strange part$',part)
      endif
      nvar = last-first+1

      if (dump.or.trace) then
         if (part.eq.1) then
            call pd00(tx_trace_string,'(edge_part)$')
         else
            call pd00(tx_trace_string,'(bord part)$')
         endif
         call pd1i1i2i('- from:$',source,'type$',type,
     >        'vars range:$',first,last)
      endif

C     Receive,
C----
      if (receive) then
         call pvmfsetrbuf(0,info)
         call pvmfrecv(-1,type,comm_context(7+2*comm_context(2)+source))
      else
         call pvmfsetrbuf(comm_context(7+2*comm_context(2)+source),info)
      endif

C     Now that we've received, unpack the data to its proper location
C     (if the receive was only a post, or the data was received
C     straight in place, we never get here)
C----
      if (act.eq.1) then
         call pvmfunpack(REAL8,x(first),nvar,1,info)
         if (trace) call pd0('- recvd$')
         if (dump) call pdar('- values$',x(first),nvar)
      else if (act.eq.2) then
         call pvmfunpack(REAL8,tmp,nvar,1,info)
         if (trace) call pd0('- recvd$')
         if (dump) call pdar('- recvd values$',tmp,nvar)
         call vpv(x(first),x(first),tmp,nvar)
      else
         call pe1i('Vector UNpack strange act$',act)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine diag_traffic_patterns(mat_con,leng_mat_con,
     >     comm_context,mat_ptr,mat_idx,vec_inf,leng_vec_inf)

C     Arguments
C----
      integer mat_con(*),leng_mat_con,comm_context(*),
     >     mat_ptr(*),mat_idx(*),
     >     vec_inf(*),leng_vec_inf

C     Functions
C----
      integer my_procnum,no_processors,
     >     left,rght, pleft,prght
      logical between, trace_setup

C     Local
C----
      integer proc,oproc,nprocs,me, first,last,length,
     >     field,maxvar,cur,
     >     the_left,the_rght, diag,
     >     q1,q2,q3, buffer(30)
      logical ts

      between(q1,q2,q3) = q1.ge.q2 .and. q1.le.q3
      left(q1) = vec_inf(5)+1+1-2+2*q1
      rght(q1) = vec_inf(5)+1+1-1+2*q1
      pleft(q1,q2) = q2-1+2*q1
      prght(q1,q2) = q2-1+2*q1+1

      call diag_offs_chek(mat_ptr)
      ts = trace_setup()
      me = my_procnum()
      nprocs = no_processors()
      if (ts) call pd0('>>>> Diag analyse traffic patterns$')
      call force_range(vec_inf(5)+1+1,7+1,-1,
     >     'Location of var fields$')
      call force_range(leng_vec_inf,
     >     vec_inf(5)+1+1+2*mat_ptr(1),1,
     >     'Diag traffic patterns: leng_vec_inf')
      length = vec_inf(2)
      first  = vec_inf(vec_inf(6))

C     Make a list of first variables of the stretches that the
C     different diagonals need
C----
      vec_inf(vec_inf(5)+1) = mat_ptr(1)
      do 10 field=1,vec_inf(vec_inf(5)+1)
         vec_inf(vec_inf(5)+1+1-1+field) = first+mat_ptr(1+field)
 10   continue
      if (ts) call pdai('Starting variables of segments$',
     >     vec_inf(vec_inf(5)+1+1-1+1),vec_inf(vec_inf(5)+1))

C     Sort that list in increasing order of starting variable
C----
      call isort(vec_inf(vec_inf(5)+1+1),
     >     vec_inf(vec_inf(5)+1))
      if (ts) call pdai('Starting variables of segments (sorted)$',
     >     vec_inf(vec_inf(5)+1+1-1+1),vec_inf(vec_inf(5)+1))

C     Now expand the list into a list of intervals
C----
      do 20 field=vec_inf(vec_inf(5)+1),1,-1
         vec_inf(left(field)) = vec_inf(vec_inf(5)+1+1-1-1+1+field)
         vec_inf(rght(field)) = vec_inf(left(field))+length-1
 20   continue
      if (ts) call pdai('Ranges of variables touched1$',
     >     vec_inf(vec_inf(5)+1+1-1+1),
     >     2*vec_inf(vec_inf(5)+1))

C     Merge intervals if they partly overlap, that is,
C     if the right end point is in the next interval
C     (actually it can be from one step left to one right)
C----
      field=1
 30   continue
      if (field.ge.vec_inf(vec_inf(5)+1)) goto 31
      if (vec_inf(rght(field)).ge.vec_inf(left(field+1))-1) then
         vec_inf(left(field+1)) = vec_inf(left(field))
         vec_inf(rght(field+1)) =
     >        max(vec_inf(rght(field)),vec_inf(rght(field+1)))
         call ishift(vec_inf(left(field+1)),
     >        2*(vec_inf(vec_inf(5)+1)-field),-2)
         vec_inf(vec_inf(5)+1) = vec_inf(vec_inf(5)+1)-1
         goto 30
      endif
      field = field+1
      goto 30
 31   continue

      if (ts) call pdai('Ranges of variables touched2$',
     >     vec_inf(vec_inf(5)+1+1-1+1),
     >     2*vec_inf(vec_inf(5)+1))

C     Now we now how many fields we really have, set the free pointer
C----
      vec_inf(7) = vec_inf(5)+1+1-1+1
     >     +2*vec_inf(vec_inf(5)+1)

C     Count the number of local variables by adding field lengths
C----
      length = 0
      do 40 field=1,vec_inf(vec_inf(5)+1)
         length = length+vec_inf(rght(field))-vec_inf(left(field))+1
 40   continue
      vec_inf(3) = length
      if (ts) call pd1i('Total number of local vars:$',length)

C     Establish connections between processors
C----
      call diag_border_traffic(mat_con,comm_context,vec_inf,
     >     nprocs,me,ts)

C     Now start the shouting match to tell this to the others
C     and construct the outgoing information
C----
      maxvar = vec_inf(4)
      mat_con(5) = prght(mat_con(mat_con(2)),mat_con(2))+1
      mat_con(mat_con(5)) = 0
      do 80 oproc=0,nprocs-1
         if (oproc.eq.me) goto 81
C     Construct what you want from the other
         buffer(1) = 0
         do 85 proc=1,mat_con(mat_con(2))
            if (mat_con(pleft(proc,mat_con(2))).eq.oproc) then
               buffer(1) = buffer(1)+1
               field = mat_con(prght(proc,mat_con(2)))
               buffer(pleft(buffer(1),1)) =
     >              mat_con(pleft(field,mat_con(4)))
               buffer(prght(buffer(1),1)) =
     >              mat_con(prght(field,mat_con(4)))
            endif
 85      continue
         if (ts)
     >        call pd1i('== Establish communication with proc$',oproc)
C     Tell the other what you want
         call incomm(buffer(1),1,me,oproc,comm_context,
     >        'I want from other proc$')
         if (buffer(1).gt.0) then
            if (ts) call pd1iai('- i want from proc$',oproc,
     >           'data$',buffer,1+2*buffer(1))
            call incomm(buffer(2),2*buffer(1),me,oproc,comm_context,
     >           '- asking from proc$')
         endif
C     Now listen what he wants back, and encode if anything
         call incomm(buffer(1),1,oproc,me,comm_context,
     >        'Other proc wants from me$')
         if (buffer(1).gt.0) then
            call incomm(buffer(2),2*buffer(1),oproc,me,comm_context,
     >           '- being asked from proc$')
            if (ts) call pd1iai('- i will send to proc$',oproc,
     >           'data$',buffer,1+2*buffer(1))
            do 86 cur=1,buffer(1)
               field = mat_con(mat_con(5))+1
               mat_con(mat_con(5)) = field
               mat_con(pleft(field,mat_con(5))) =
     >              oproc*maxvar + buffer(pleft(cur,1))
               mat_con(prght(field,mat_con(5))) = buffer(prght(cur,1))
 86         continue
         endif
 81      continue
 80   continue
C     Decode and construct the edg_procs
      mat_con(3) = prght(mat_con(mat_con(5)),mat_con(5))+1
      mat_con(mat_con(3)) = 0
      do 82 field=1,mat_con(mat_con(5))
         proc = mat_con(pleft(field,mat_con(5)))/maxvar
         mat_con(pleft(field,mat_con(5))) =
     >        mod(mat_con(pleft(field,mat_con(5))),maxvar)
         cur = mat_con(mat_con(3))+1
         mat_con(mat_con(3)) = cur
         mat_con(pleft(cur,mat_con(3))) = proc
         mat_con(prght(cur,mat_con(3))) = field
 82   continue

      if (ts) then
         call pd1i('No edg_procs:$',mat_con(mat_con(3)))
         do 83 proc=1,mat_con(mat_con(3))
            field = mat_con(prght(proc,mat_con(3)))
            call pd1i2i
     >           ('We send to proc$',mat_con(pleft(proc,mat_con(3))),
     >           'the range$',mat_con(pleft(field,mat_con(5))),
     >           mat_con(prght(field,mat_con(5))))
 83      continue
      endif

C     And now for the fun part: we've been talking in global
C     numbering so far. Translate everything to local now
C----
      if (ts) call pd0('- localise brd_data$')
      do 90 proc=1,mat_con(mat_con(4))
         first = mat_con(pleft(proc,mat_con(4)))
         last = mat_con(prght(proc,mat_con(4)))
         length = last-first+1
         cur = 1
         do 91 field=1,vec_inf(vec_inf(5)+1)
            the_left = vec_inf(left(field))
            the_rght = vec_inf(rght(field))
            if (between(first,the_left,the_rght)) then
               mat_con(pleft(proc,mat_con(4))) = cur+first-the_left
               mat_con(prght(proc,mat_con(4))) = 
     >              mat_con(pleft(proc,mat_con(4)))+length-1
               goto 92
            else
               cur = cur+the_rght-the_left+1
            endif
 91      continue
         call pe1i1i('Could not fit in-stretch$',proc,'@var$',first)
 92      continue
 90   continue

      if (ts) call pd0('- localise edg_data$')
      do 95 proc=1,mat_con(mat_con(5))
         first = mat_con(pleft(proc,mat_con(5)))
         last = mat_con(prght(proc,mat_con(5)))
         length = last-first+1
         cur = 1
         do 96 field=1,vec_inf(vec_inf(5)+1)
            the_left = vec_inf(left(field))
            the_rght = vec_inf(rght(field))
            if (between(first,the_left,the_rght)) then
               mat_con(pleft(proc,mat_con(5))) = cur+first-the_left
               mat_con(prght(proc,mat_con(5))) = 
     >              mat_con(pleft(proc,mat_con(5)))+length-1
               goto 97
            else
               cur = cur+the_rght-the_left+1
            endif
 96      continue
         call pe1i1i('Could not fit ex-stretch$',proc,'@var$',first)
 97      continue
 95   continue

      call dia_add_null_procs(mat_con,ts)

      if (ts) then
         call pd1i('No brd_procs:$',mat_con(mat_con(2)))
         do 93 proc=1,mat_con(mat_con(2))
            field = mat_con(prght(proc,mat_con(2)))
            if (field.eq.-2) then
               call pd1i('Null msg from proc$',
     >              mat_con(pleft(proc,mat_con(2))))
            else
               call pd1i2i('We get from proc$',
     >              mat_con(pleft(proc,mat_con(2))),
     >              'the range$',
     >              mat_con(pleft(field,mat_con(4))),
     >              mat_con(prght(field,mat_con(4))))
            endif
 93      continue
         call pd1i('No edg_procs:$',mat_con(mat_con(3)))
         do 98 proc=1,mat_con(mat_con(3))
            field = mat_con(prght(proc,mat_con(3)))
            if (field.eq.-2) then
               call pd1i('Null msg to proc$',
     >              mat_con(pleft(proc,mat_con(3))))
            else
               call pd1i2i('We send to proc$',
     >              mat_con(pleft(proc,mat_con(3))),
     >              'the range$',
     >              mat_con(pleft(field,mat_con(5))),
     >              mat_con(prght(field,mat_con(5))))
            endif
 98      continue
      endif

C     Also express the diagonal offsets in local terms
C----
      if (ts) call pd0('- localise diag start points$')
      do 100 diag=1,mat_ptr(1)
         first = vec_inf(vec_inf(6))+mat_ptr(1+diag)
         cur = 1
         do 101 field=1,vec_inf(vec_inf(5)+1)
            the_left = vec_inf(left(field))
            the_rght = vec_inf(rght(field))
            if (between(first,the_left,the_rght)) then
               mat_idx(diag) = cur+first-the_left
               goto 102
            else
               cur = cur+the_rght-the_left+1
            endif
 101     continue
         call pe1i1i('Could not fit diag$',diag,'@var$',first)
 102     continue
 100  continue

      if (ts) then
         do 103 diag=1,mat_ptr(1)
            field = mat_con(prght(proc,mat_con(2)))
            call pd1i1i1i
     >           ('Diag$',diag,'with offset$',mat_ptr(1+diag),
     >           'starts at$',mat_idx(diag))
 103     continue
      endif

C     Where does the stretch of owned variables start?
C     (we could have done this before, by testing for a zero offset)
C----
      first = vec_inf(vec_inf(6))
      if (ts) call pd1i('Fit owned vars from$',first)
      cur = 1
      do 110 field=1,vec_inf(vec_inf(5)+1)
         the_left = vec_inf(left(field))
         the_rght = vec_inf(rght(field))
         if (between(first,the_left,the_rght)) then
            vec_inf(vec_inf(5)) = cur+first-the_left
            goto 112
         else
            cur = cur+the_rght-the_left+1
         endif
 110  continue
      call pe1i('Could not fit owned vars from',first)
 112  continue
      if (ts) call pd1i('Owned variables start @$',
     >     vec_inf(vec_inf(5)))

      if (ts) call pd0('<<<< analysis completed$')

      return
      end
C----------------------------------------------------------------
C     It is very convenient to have the sets of border and edge procs
C     to be the same, even if it means sending some zero messages
C     every once in a while. That's what we're establishing here.
C----------------------------------------------------------------
      subroutine dia_add_null_procs(mat_con,trace)

C     Arguments
C----
      integer mat_con(*)
      logical trace

C     Local
C----
      integer nprocs,proc,oproc,
     >     field,iprc,cur,tprocs(99)

C     First find edge processors that are not yet border processors
C----
      nprocs = 0
      do 120 proc=1,mat_con(mat_con(3))
         iprc = proc
         cur = mat_con(mat_con(3)-1+2*iprc)
         do 121 oproc=1,mat_con(mat_con(2))
            iprc = oproc
            if (mat_con(mat_con(2)-1+2*iprc)
     >           .eq.cur) goto 122
 121     continue
         nprocs = nprocs+1
         tprocs(nprocs) = cur
 122     continue
 120  continue

C     If we've found anything, shift the edge data and
C     create dummy border procs
C----
      if (nprocs.gt.0) then
         if (trace) call pdai('No-bord edge procs:$',tprocs,nprocs)
         field = mat_con(3)+2*mat_con(mat_con(3))
     >        - mat_con(5) + 1
         call ishift(mat_con(mat_con(5)),field,nprocs)
         mat_con(5) = mat_con(5)+nprocs
         mat_con(3) = mat_con(3)+nprocs
         do 123 proc=1,nprocs
            iprc = mat_con(mat_con(2)) +1
            mat_con(mat_con(2)) = iprc
            mat_con(mat_con(2)-1+2*iprc) = tprocs(proc)
            mat_con(mat_con(2)+2*iprc) = -2
 123     continue
      endif

C     Now find border processors that are not yet edge processors
C----
      nprocs = 0
      do 130 proc=1,mat_con(mat_con(2))
         iprc = proc
         cur = mat_con(mat_con(2)-1+2*iprc)
         do 131 oproc=1,mat_con(mat_con(3))
            iprc = oproc
            if (mat_con(mat_con(3)-1+2*iprc)
     >           .eq.cur) goto 132
 131     continue
         nprocs = nprocs+1
         tprocs(nprocs) = cur
 132     continue
 130  continue

C     This time we dont' have to shift anything, just add new procs
C----
      if (nprocs.gt.0) then
         if (trace) call pdai('No-edge bord procs:$',tprocs,nprocs)
         do 133 proc=1,nprocs
            iprc = mat_con(mat_con(3)) +1
            mat_con(mat_con(3)) = iprc
            mat_con(mat_con(3)-1+2*iprc) = tprocs(proc)
            mat_con(mat_con(3)+2*iprc) = -2
 133     continue
      endif

      return
      end
C----------------------------------------------------------------
C     Now find what other processors have to offer us,
C     and encode their intervals.
C     Two versions: with and without prior knowledge
C----------------------------------------------------------------
      subroutine diag_border_traffic(mat_con,comm_context,vec_inf,
     >     nprocs,me,ts)

C     Arguments
C----
      integer mat_con(*),comm_context(*),vec_inf(*),nprocs,me
      logical ts

C     Locals and functions
C----
      integer first,length,field,cur,cvr, proc,
     >     buffer1(30),buffer2(30),
     >     q1,q2,q3,q4, pleft,prght
      logical overlap

      pleft(q1,q2) = q2-1+2*q1
      prght(q1,q2) = q2-1+2*q1+1
      overlap(q1,q2,q3,q4) = (.not.q2.lt.q3) .and. (.not.q1.gt.q4)

C     Case of consecutive stretches per processor,
C     but unknown mapping
C----

      mat_con(4) = 6
      mat_con(mat_con(4)) = 0
      mat_con(2) = mat_con(4)+1
      mat_con(mat_con(2)) = 0
      length = vec_inf(2)
      first  = vec_inf(vec_inf(6))
      do 10 proc=0,nprocs-1
         if (proc.eq.me) goto 11
C     tell the other one about your fields
         call iicopy(buffer1,
     >        vec_inf(vec_inf(5)+1),
     >        2*vec_inf(vec_inf(5)+1)+1)
         call incomm(buffer1,1,me,proc,comm_context,
     >        'Declare #fields$')
         call incomm(buffer1(2),2*buffer1(1),
     >        me,proc,comm_context,'Declare fields$')
C     now listen to him tell you about his fields
         call incomm(buffer1,1,proc,me,comm_context,
     >        'Get #fields$')
         call incomm(buffer1(2),2*buffer1(1),proc,me,comm_context,
     >        'Get fields$')
C     intersect the other's fields with your owned range
         buffer2(1) = 0
         do 20 field=1,buffer1(1)
            if (overlap(first,first+length-1,
     >           buffer1(pleft(field,1)),buffer1(prght(field,1))))
     >           then
               cur = buffer2(1)+1
               buffer2(1) = cur
               buffer2(pleft(cur,1)) = 
     >              max(first,buffer1(pleft(field,1)))
               buffer2(prght(cur,1)) = 
     >              min(first+length-1,buffer1(prght(field,1)))
            endif
 20      continue
C     tell him about it
         call incomm(buffer2,1,me,proc,comm_context,
     >        'Declare #borders$')
         call incomm(buffer2(2),2*buffer2(1),me,proc,comm_context,
     >        'Declare borders$')
C     listen to what he has to say about your fields
         call incomm(buffer2,1,proc,me,comm_context,
     >        'Get #borders$')
         call incomm(buffer2(2),2*buffer2(1),proc,me,
     >        comm_context,'Get borders$')
         call ishift(mat_con(mat_con(2)),
     >        2*mat_con(mat_con(2))+1,2*buffer2(1))
         mat_con(2) = mat_con(2)+2*buffer2(1)
         do 30 field=1,buffer2(1)
            cur = mat_con(mat_con(4))+1
            mat_con(mat_con(4)) = cur
            mat_con(pleft(cur,mat_con(4))) = buffer2(pleft(field,1))
            mat_con(prght(cur,mat_con(4))) = buffer2(prght(field,1))
            cvr = mat_con(mat_con(2))+1
            mat_con(mat_con(2)) = cvr
            mat_con(pleft(cvr,mat_con(2))) = proc
            mat_con(prght(cvr,mat_con(2))) = cur
 30      continue
 11      continue
 10   continue

      if (ts) then
         call pd1i('No brd_procs:$',mat_con(mat_con(2)))
         do 71 proc=1,mat_con(mat_con(2))
            field = mat_con(prght(proc,mat_con(2)))
            call pd1i2i
     >           ('We get from proc$',mat_con(pleft(proc,mat_con(2))),
     >           'the range$',mat_con(pleft(field,mat_con(4))),
     >           mat_con(prght(field,mat_con(4))))
 71      continue
      endif

      return
      end
C----------------------------------------------------------------
C     Find local/non-owned variables from a bordering processor
C     (local numbering: iprc=1..brd_procs)
C----------------------------------------------------------------
      subroutine diag_bord_vars_by_proc(first,nvar,iprc,mat_con)

C     Arguments
C----
      integer first,nvar, mat_con(*),iprc

      call force_range(iprc,1,mat_con(mat_con(2)),'Brd proc num$')
      first = mat_con(mat_con(4)-1+2*iprc)
      nvar  = mat_con(mat_con(4)-1+2*iprc+1)-first+1

      return
      end
C----------------------------------------------------------------
C     Find owned variables that are bordering on other processor
C     (local numbering: iprc=1..brd_procs)
C----------------------------------------------------------------
      subroutine diag_edge_vars_by_proc(first,nvar, iprc,mat_con)

C     Arguments
C----
      integer first,nvar, mat_con(*),iprc

      call force_range(iprc,1,mat_con(mat_con(3)),'Edg proc num$')
      first = mat_con(mat_con(5)-1+2*iprc)
      nvar  = mat_con(mat_con(5)-1+2*iprc+1)-first+1

      return
      end
C----------------------------------------------------------------
      subroutine diag_offs_chek(mat_ptr)

C     Arguments & local
C----
      integer mat_ptr(*),test(99),ntest

      call force_range(mat_ptr(1),1,0,'Diag format, mat_ptr(1)$')
      ntest = mat_ptr(1)
      call iicopy(test,mat_ptr(2),ntest)
      call isort1(test,ntest)
      call force_range(mat_ptr(1),ntest,ntest,
     >     'Diag format, duplicate offsets$')

      return
      end
C----------------------------------------------------------------
      function diag_buffer_size(mat_con,trace)

C     Arguments
C----
      integer mat_con(*),diag_buffer_size
      logical trace

C     Local
C----
      integer proc,first,nvar

      diag_buffer_size = 0
      if (trace) call pd2i('Diag buffer size over edg/brd procs$',
     >     mat_con(mat_con(3)),mat_con(mat_con(2)))
      do 10 proc=1,mat_con(mat_con(3))
         call diag_edge_vars_by_proc(first,nvar,proc,mat_con)
         diag_buffer_size = max(diag_buffer_size,nvar)
 10   continue
      do 20 proc=1,mat_con(mat_con(2))
         call diag_bord_vars_by_proc(first,nvar,proc,mat_con)
         diag_buffer_size = max(diag_buffer_size,nvar)
 20   continue
      if (trace) call pd1i('- result size:$',diag_buffer_size)

      return
      end
C----------------------------------------------------------------
      function dia_lc2glb(num,vec_inf)

C     Arguments
C----
      integer dia_lc2glb,num,vec_inf(*)

C     Local
C----
      integer field,sum,nsum,
     >     the_left,the_rght, left,rght,q1,q2,q3
      logical between

      left(q1) = vec_inf(5)+1+1-1-1+2*q1
      rght(q1) = vec_inf(5)+1+1-1-1+2*q1+1
      between(q1,q2,q3) = q1.ge.q2 .and. q1.le.q3

      call force_range(num,1,vec_inf(3),'Local var no$')
      sum = 0
      do 110 field=1,vec_inf(vec_inf(5)+1)
         the_left = vec_inf(left(field))
         the_rght = vec_inf(rght(field))
         sum = sum+1
         nsum = sum+the_rght-the_left
         if (between(num,sum,nsum)) then
            dia_lc2glb = the_left + (num-sum)
            goto 112
         else
            sum = nsum
         endif
 110  continue
      call pe1i('Unable to find global no for var$',num)
      call stop_connections('dia loc -> glob$')
 112  continue

      return
      end
C----------------------------------------------------------------
      subroutine init_dia_multicolour(vec_inf,leng_vec_inf,mat_con,
     >     comm_context,mat_ptr,mat_idx, rand,trans, trace)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,mat_con(*),comm_context(*),
     >     mat_ptr(*),mat_idx(*)
      double precision rand(*),trans(*)
      logical trace

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Functions
C----
      integer dia_lc2glb
      double precision irand
      logical trace_matrices,trace_setup,tracer_proc

C     Local
C----
      integer n_loc_var,n_own_var, loc_var,own_var,glb_var,
     >     other_loc_var,other_glb_var,
     >     dia,class,maxvar,max_colour, first_el,
     >     this_loc,this_var,this_clr,cur_clr,n_clr, i_clr
      logical colour_now,all_coloured(1)
      double precision ran

      if (trace) call pt0('>> Creating dia multi-colouring$')

      n_own_var = vec_inf(2)
      n_loc_var = vec_inf(3)

C     Where do we store colour info?
C----
      vec_inf(8) = vec_inf(7)
      vec_inf(7) = vec_inf(8)+n_loc_var+1
      call force_range(vec_inf(7)-1,1,leng_vec_inf,
     >     'Nit multi clr: vec_inf overflow$')

C     Initialize colours to 0
C----
      call inulv(vec_inf(vec_inf(8)+1),n_loc_var)
      call nulv(trans,n_loc_var)

C     Generate random numbers
C----
      do 10 loc_var=1,n_loc_var
         glb_var = dia_lc2glb(loc_var,vec_inf)
         if (glb_var.gt.0) then
            ran = irand(glb_var)
            rand(loc_var) = ran
         endif
 10   continue
      if (trace_matrices()) call dump_vector(rand,vec_inf,'Rand$',0)

C     A priori bound on number of colours:
C     global number of variables
C----
      maxvar = vec_inf(4)
      max_colour = maxvar
      if (trace.and.trace_setup()) call pd1i('Max colour$',max_colour)

C     Now start making classes
C----
      class = 1
 20   continue
      if (tracer_proc().and.trace_setup())
     >     call pt1i('Applying colour $',class)
      all_coloured(1) = .true.
      do 30 own_var=1,n_own_var
         loc_var = own_var+vec_inf(vec_inf(5))-1
         if (vec_inf(vec_inf(8)+loc_var).eq.0) then
            glb_var = vec_inf(vec_inf(6))+own_var-1
            all_coloured(1) = .false.
C     investigate uncoloured nodes
            colour_now = .true.
            do 35 dia=1,mat_ptr(1)
               other_loc_var = mat_idx(dia)+own_var-1
               other_glb_var = glb_var+mat_ptr(1+dia)
               if (other_loc_var.gt.0 .and. other_glb_var.le.maxvar
     >              .and. other_loc_var.ne.loc_var)
     >              then
                  call force_range(other_loc_var,1,n_loc_var,
     >                 'Other local var$')
                  if (rand(loc_var).lt.rand(other_loc_var)
     >              .and. vec_inf(vec_inf(8)+other_loc_var).eq.0)
     >              colour_now = .false.
               endif
 35         continue
            if (colour_now) then
               trans(loc_var) = dble(class)
            endif
         endif
 30   continue
      tx_trace_string = 'Colouring$'
      tx_trace_int = class
      call vector_make_border(trans,vec_inf,
     >     mat_con,comm_context)
      if (trace_matrices()) then
         if (all_coloured(1)) then
            call pd1i('I am still colouring: no @$',class)
         else
            call pd1i('I am still colouring: yes @$',class)
         endif
         call dump_vector(trans,vec_inf,'Colr$',class)
      endif
      do 50 loc_var=1,n_loc_var
         vec_inf(vec_inf(8)+loc_var) = int(trans(loc_var)+1.d-1)
 50   continue
      if (class.gt.max_colour+1) then
         if (tracer_proc()) call pe0('>>>> Too many colours needed$')
         goto 91
      endif
      call qgand(all_coloured,comm_context,trace_matrices())
      if (all_coloured(1)) goto 90
      class = class+1
      goto 20
 90   continue
      if (trace) call pt1i('>> Created with no. colours:$',class)
      if (log_channel_open)
     >     call pc1i('>> Precond with no. colours:$',class,logchn)
 91   continue
      vec_inf(vec_inf(8)) = class

C     Now start making groups of nodes of the same colour
C----
      vec_inf(9) = vec_inf(8)+n_loc_var+1
      call force_range(vec_inf(9)+2*vec_inf(vec_inf(8))+n_own_var+1,
     >     1,leng_vec_inf,'Colour groups: vec_inf overflow$')

C     leave space for pointers
      first_el = vec_inf(9)+2*vec_inf(vec_inf(8))+1

C     encode as (colour,variable)
      do 100 own_var=1,n_own_var
         loc_var = own_var+vec_inf(vec_inf(6))-1
         vec_inf(first_el+own_var-1) =
     >        vec_inf(vec_inf(8)+loc_var)*(max_colour+1)+loc_var
 100  continue

C     sort
      call isort(vec_inf(first_el),n_own_var)

C     decode and set up pointers to colour groups
      cur_clr = 0
      n_clr = 0
      do 110 own_var=1,n_own_var
         this_loc = first_el+own_var-1
         this_var = mod(vec_inf(this_loc),max_colour+1)
         this_clr = vec_inf(this_loc)/(max_colour+1)
         if (this_clr.ne.cur_clr) then
            if (cur_clr.gt.0) vec_inf(vec_inf(9)+2*cur_clr) = n_clr
            n_clr = 0
            do 120 i_clr=cur_clr+1,this_clr-1
               vec_inf(vec_inf(9)+2*i_clr-1) = this_loc
               vec_inf(vec_inf(9)+2*i_clr) = 0
 120        continue
            cur_clr = this_clr
            vec_inf(vec_inf(9)+2*cur_clr-1) = this_loc
         endif
         vec_inf(this_loc) = this_var
         n_clr = n_clr+1
 110  continue

      return
      end
C----------------------------------------------------------------
      subroutine dump_matx_diag(matrix,mat_ptr,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),vec_inf(*)
      double precision matrix(*)

C     Local
C----
      integer siz,dia

      siz = vec_inf(2)
      call force_range(siz,1,0,'Dump; local problem size$')
      do 10 dia=1,mat_ptr(1)
         call pd1i1i('Diagonal$',dia,'@offset$',mat_ptr(1+dia))
         call pdar('values:$',matrix(1+(dia-1)*siz),siz)
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump a diagonal vector to outchn
C----------------------------------------------------------------
      subroutine dump_vector_d(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',vec_inf(vec_inf(6))+ivar-1,
     >        'val:$',x(vec_inf(vec_inf(5))+ivar-1))
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine dump_vector_od(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',vec_inf(vec_inf(6))+ivar-1,
     >        'val:$',x(ivar))
 10   continue

      return
      end










