C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     
C     Compressed Row Storage routines
C     
C     The structure of a compressed vector is as follows.
C     vec_inf(vec_inf(6)...): list of global numbers of the local
C     problem variables. The owned variables are the initial segment of
C     this, so vec_inf(vec_inf(5)) is always one.
C
C================================================================
C----------------------------------------------------------------
C     CRS matrix vector product
C
C     Guide to matrix parts:
C     0 (all): involve all of your local variables
C     2 (brd): involve only bordering variables
C     1 (own): involve only your owned variables
C----------------------------------------------------------------
      subroutine mvp_crs(y, matrix,mat_ptr,mat_idx, x,vec_inf,
     >     trans,update,do_diag)

C     Arguments
C----
      integer mat_ptr(*),mat_idx(*),vec_inf(*),
     >     trans
      double precision x(*),y(*), matrix(*)
      logical update,do_diag

C     Local
C----
      integer var,col, first,last
      double precision sum

      if (trans.eq.1) then
         if (.not.update) call nulv(y,vec_inf(3))
         do 50 var=1,vec_inf(2)
            first = mat_ptr(var)
            last = mat_ptr(var+1)-1
            if (first.gt.last) goto 51
            if (do_diag) then
               do 60 col=first,last
                  y(mat_idx(col)) = y(mat_idx(col))+matrix(col)*x(var)
 60            continue
            else
               do 61 col=first+1,last
                  y(mat_idx(col)) = y(mat_idx(col))+matrix(col)*x(var)
 61            continue
            endif
 51         continue
 50      continue
      else
         do 10 var=1,vec_inf(2)
            sum = 0.d0
            first = mat_ptr(var)
            last = mat_ptr(var+1)-1
            if (first.gt.last) goto 11
            if (do_diag) then
               do 20 col=first,last
                  sum = sum+matrix(col)*x(mat_idx(col))
 20            continue
            else
               do 21 col=first+1,last
                  sum = sum+matrix(col)*x(mat_idx(col))
 21            continue
            endif
            if (update) then
               y(var) = y(var)+sum
            else
               y(var) = sum
            endif
 11         continue
 10      continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine global_to_local_remap_row(row,accpt,
     >     row_no,local_var_no, row_len, vec_inf)
      
C     Arguments
C---- 
      integer row(*),accpt(*), row_no,local_var_no,row_len, vec_inf(*)

C     Functions
C----
      logical isbrdv, trace_setup

C     Local
C----
      integer iread
      logical trouble

      trouble = .false.
      if (trace_setup()) 
     >     call pd1iai('Remap row/col$',row_no,'$',row,row_len)
      do 130 iread=1,row_len
C     For all columns:
C     try to match the variable row(iread) to a touched variable;
C     and remap, no match is an error
         if (.not.isbrdv(row(iread),row(iread),vec_inf)) then
            call pe2i('CRSmat no b element found$',
     >           row_no,iread)
            trouble = .true.
         endif
 130  continue
      if (trouble) call pdai('Troubling row/col:$',row,row_len)
      if (trace_setup()) call pdai('-result$',row,row_len)

      return
      end
C----------------------------------------------------------------
C     If you have a matrix block row, use that to figure out
C     the bordering variables.
C     At this point, the matrix has not yet been remapped.
C----------------------------------------------------------------
      subroutine border_vars_from_matrix_slice
     >     (vec_inf,leng_vec_inf,mat_ptr,mat_idx)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,mat_ptr(*),mat_idx(*)

C     Functions
C----
      integer crs_lc2glb
      logical isownv,trace_setup

C     Local
C----
      integer own_var,loc_var,glb_var, first,row_len,col,
     >     total,local,lc_bord,no_bord,
     >     idum,free,free_save
      logical ts

      ts = trace_setup()

C     How many border vars, and where are they written?
C----
      no_bord = 0
      free = vec_inf(6)+vec_inf(3)
      free_save = free
      vec_inf(7) = free

C     Get all owned rows, and pick them apart
C----
      do 10 own_var=1,vec_inf(2)
         loc_var = own_var
         glb_var = crs_lc2glb(loc_var,vec_inf)
         call crs_get_pointer(first,row_len,loc_var,mat_ptr)
         if (ts)
     >        call pdai('Getting brdr from$',mat_idx(first),row_len)
         local = 0
         lc_bord = 0
         do 20 col=1,row_len
            if (.not.isownv(idum,mat_idx(first+col-1),vec_inf)) then
               vec_inf(free+local) = -mat_idx(first+col-1)
               lc_bord = lc_bord+1
               local = local+1
            endif
 20      continue
         mat_ptr(1*vec_inf(2)+2+own_var-1) = row_len-lc_bord+1
         if (ts.and.local.gt.0) call pd1iai('-#brd vrs.$',lc_bord,
     >        ' result$',vec_inf(free),local)
         free = free+local
         no_bord = no_bord+lc_bord
 10   continue
      total = no_bord

C     Sort border vars and weed out duplicates
C----
      if (ts) call pd1i1i
     >     ('Adding brd/edg variables; #=$',total,
     >     'last location touched =$',vec_inf(2)+total)
      call isort1(vec_inf(free_save),total)
      no_bord = 0
      do 30 col=1,total
         if (vec_inf(free_save+col-1).gt.0) goto 31
         vec_inf(free_save+col-1) = -vec_inf(free_save+col-1)
         no_bord = no_bord+1
 30   continue
 31   continue
      call isort(vec_inf(free_save),no_bord)
      if (ts) call pd1iai('- after weeding doubles: #=$',total,
     >     'vars$',vec_inf(free_save),total)

      vec_inf(7) = free_save+no_bord
      vec_inf(3) = vec_inf(2)+no_bord

      return
      end
C----------------------------------------------------------------
C     Do a remap from global to local numbering
C----------------------------------------------------------------
      subroutine remap_local_matrix(mat_ptr,mat_idx,
     >     matrix,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),mat_idx(*),vec_inf(*)
      double precision matrix(*)

C     Has this matrix been remapped?
C----
      integer crs_remap
      common /crs_remapb/crs_remap

C     Functions
C----
      logical trace_matrices

C     Local
C----
      integer own_var,loc_var,glb_var, first,row_len, dum_buf(1)
      logical has_remap
      parameter (has_remap=.false.)

      if (has_remap) goto 20
      vec_inf(vec_inf(5)) = 1
      if (trace_matrices()) call pd1i
     >     ('Remap local matrix #vars = $',vec_inf(2))
      do 10 own_var=1,vec_inf(2)
         loc_var = own_var
         glb_var = vec_inf(vec_inf(6)-1+own_var)
         call crs_get_pointer(first,row_len,loc_var,mat_ptr)
C     do a remap; since we own this row, we don't pass an accept array
         call global_to_local_remap_row(mat_idx(first),dum_buf,
     >        glb_var,loc_var,row_len,vec_inf)
         call irsort(mat_idx(first),matrix(first),row_len)
 10   continue

 20   continue

C     Mark as remapped
C----
      crs_remap = 1

      return
      end
C----------------------------------------------------------------
      block data crs_remap_i
C     Has this matrix been remapped?
C----
      integer crs_remap
      common /crs_remapb/crs_remap
      data crs_remap/0/
      end
C----------------------------------------------------------------
C     Traffic patterns
C----------------------------------------------------------------
      subroutine cprs_set_traffic_patterns(mat_con,leng_mat_con,
     >     comm_context, vec_inf,leng_vec_inf, mat_ptr,mat_idx)
      
C     Arguments
C---- 
      integer mat_con(*),leng_mat_con,comm_context(*),
     >     vec_inf(*),mat_ptr(*),mat_idx(*),leng_vec_inf
      
C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Functions
C----
      integer glob2loc,
     >    no_processors,my_procnum,msgtyp
      logical isownv,isbrdv, trace_setup,trace_matrices

C     Local
C---- 
      integer ivar,jvar, iown,iloc,ilen(1),icol,
     >     iglob,jglob, istor,jstor,
     >     maxvar,maxprc, idum,nssp,bufmax(1),
     >     cryp1,cryp2,cryp3, n_inp,n_outp, my_pnum,
     >     iprc,this_proc,last_inp,last_outp,other_proc,
     >     proc_list(99),nprocs,ibuffer(11 000),
     >     in_items,out_items, leave,free,edg_data_old
      logical ssp,ts
      integer zero_var(1)
      data zero_var/0/

C     Setup
C---- 
      ts = trace_setup()
      mat_con(4) = 6
      mat_con(mat_con(4)) = 0
      maxprc = no_processors()
      cryp3 = maxprc+1
      my_pnum = my_procnum()
      ssp = .false.

C     Go through all rows and note (i,j) pairs of non-owned vars
C----
      if (ts) call pd0('Collect in/out traffic in rows$')
      maxvar = -1
      do 10 iown=1,vec_inf(2)
         ivar = iown
         iglob = vec_inf(vec_inf(6)-1+ivar)
         istor = ivar
         istor = iglob
         maxvar = max(maxvar,iglob)
         call crs_get_pointer(iloc,ilen(1),ivar,mat_ptr)
         if (ts)  call pd1iai('Row (glb)$',
     >        vec_inf(vec_inf(6)-1+ivar),
     >        'columns:$',mat_idx(iloc),ilen(1))
         do 20 icol=1,ilen(1)
            jvar = mat_idx(iloc+icol-1)
            jglob = vec_inf(vec_inf(6)-1+jvar)
            jstor = jvar
            jstor = jglob
            maxvar = max(maxvar,jglob)
            if (.not.isownv(idum,jglob,vec_inf)) then
               other_proc = 0
C     encode j incoming
               mat_con(mat_con(4)) = mat_con(mat_con(4))+1
               mat_con(mat_con(4)+mat_con(mat_con(4))) = 
     >              2*jstor*cryp3 + other_proc
C     encode i outgoing if the pattern is symmetric
               if (ssp) then
                  mat_con(mat_con(4)) = mat_con(mat_con(4))+1
                  mat_con(mat_con(4)+mat_con(mat_con(4))) =
     >                 (2*istor+1)*cryp3 + other_proc
                  call force_range(mat_con(mat_con(4)),1,leng_mat_con,
     >                 'All Traffic: mat_con overflow1$')
               endif
            endif
 20      continue
 10   continue

      nssp=0
      if (ssp) nssp=1
      bufmax(1) = mat_con(mat_con(4))
      call ingmax(bufmax,1,comm_context)
      call inbcst(bufmax,1,comm_context,
     >     'CPRS brd dat, max buf size$')
      call cprs_border_traffic(
     >     mat_con(mat_con(4)+1),mat_con(mat_con(4)),bufmax(1),
     >     vec_inf(vec_inf(6)),vec_inf(2),
     >     maxprc,my_pnum,comm_context,cryp3,nssp)

C     Recode to triplet (in/out,procno,varno)
C----
      cryp1 = (maxvar+1)
      cryp2 = (maxvar+1)*(maxprc+1)
      do 15 icol=1,mat_con(mat_con(4))
         ivar = mat_con(mat_con(4)+icol)
         other_proc = mod(ivar,cryp3)
         istor = ivar/cryp3
C     maybe remap back from global to local
            if (.not.isbrdv(ivar,istor/2,vec_inf)) continue
         if (mod(istor,2).eq.0) then
            ivar = ivar + other_proc*cryp1
         else
            ivar = ivar + other_proc*cryp1 + cryp2
         endif
         mat_con(mat_con(4)+icol) = ivar
 15   continue

C     Sort non-owned variables by processor and local number;
C     weed out duplicates
C---- 
      call isort1(mat_con(mat_con(4)+1),mat_con(mat_con(4)))
      
C     Figure out the number of in/out processors.
C     Decoded data is not written back.
C----
      n_inp = 0
      n_outp = 0
      in_items = 0
      out_items = 0
      last_inp = -1
      last_outp = -1
      do 40 ivar=1,mat_con(mat_con(4))
C     The first case (.gt.cryp2) only happens if the pattern is symmetric;
C     for unsymmetric patterns we figure out the out-data later
         if (mat_con(mat_con(4)+ivar).gt.cryp2) then
            out_items = out_items+1
            mat_con(mat_con(4)+ivar) =
     >           mat_con(mat_con(4)+ivar)-cryp2
            this_proc = mat_con(mat_con(4)+ivar) / cryp1
            call force_range(this_proc,0,maxprc-1,
     >           '>>>> Nit alltraffic procno1$')
            if (this_proc.ne.last_outp) then
               n_outp = n_outp+1
               last_outp = this_proc
            endif
         else
            in_items = in_items+1
            this_proc = mat_con(mat_con(4)+ivar) / cryp1
            call force_range(this_proc,0,maxprc-1,
     >           '>>>> Nit alltraffic procno2$')
            if (this_proc.ne.last_inp) then
               n_inp = n_inp+1
               last_inp = this_proc
            endif
         endif
 40   continue

C     How much in data is there?
C     (if ssp, then out data comes immediately after this;
C     it will be shifted right later.
C     if not ssp, we figure out the out data with all-to-all
C     exchange of info; below.)
C----
      mat_con(mat_con(4)) = in_items
      leave = 1+in_items
      free = mat_con(4)+leave
      edg_data_old = free

C     The in-processors come first after the data; leave room for
C     triplets consisting of (proc_no,start_loc,no_vars)
C----
      mat_con(2) = free
      leave = 3*n_inp+1
      free = mat_con(2)+leave

C     If we already have the out data (ie, if ssp), we shift it right
C     to make room for in-processor triplets
C----
      mat_con(5) = free
      if (ssp) then
         call force_range(mat_con(5)+out_items,1,leng_mat_con,
     >        'All traffic: mat_con overflow3a$')
         call ishift(mat_con(edg_data_old),out_items,
     >        mat_con(5)-edg_data_old+1)
      else
         call force_range(mat_con(5),1,leng_mat_con,
     >        'All traffic: mat_con overflow3b$')
      endif
C     (we couldn't write this before, because ssp out data
C     might have been in the way)
      mat_con(mat_con(2)) = n_inp

C     Extract local variable numbers of in-traffic
C     and record starting loc and length of a processor's vars
C---- 
      last_inp = -1
      iprc = 1
      do 30 ivar=1,mat_con(mat_con(4))
         this_proc = mat_con(mat_con(4)+ivar) / cryp1
         if (this_proc.ne.last_inp) then
            if (last_inp.ne.-1) then
               mat_con(mat_con(2)+iprc) = in_items
               iprc = iprc+1
            endif
            in_items = 0
            mat_con(mat_con(2)+iprc) = this_proc
            iprc = iprc+1
            mat_con(mat_con(2)+iprc) = ivar
            iprc = iprc+1
            last_inp = this_proc
         endif
         mat_con(mat_con(4)+ivar) =
     >        mod( mat_con(mat_con(4)+ivar) , cryp1 )
         in_items = in_items+1
 30   continue
      mat_con(mat_con(2)+iprc) = in_items

      if (trace_matrices().or.ts) call raw_dump_in_data(mat_con)

C     If we don't have the out data yet (ie, if not ssp),
C     we do all-to-all communication
C     Global idea:
C     Send msgs to everyone who will eventually be sending to you,
C     telling them what you expect from them
C----
      if (.not.ssp) then
         last_inp = -1
C     Figure out who are your brd_procs
         call crs_border_procs(proc_list,nprocs,99,mat_con)
         if (com_trace_val.ge.1)
     >        call pdai('Requests to$',proc_list,nprocs)
         do 60 iprc=1,nprocs
            other_proc = proc_list(iprc)
C     For processors in between brd_procs,
C     tell them you don't need anything
            do 65 this_proc=last_inp+1,other_proc-1
               if (my_pnum.ne.this_proc) call insend(zero_var,1,
     >              msgtyp(my_pnum,this_proc),this_proc,comm_context,
     >              'Tell him we don''t need nuttin$')
 65         continue
            last_inp = other_proc
            call cprs_bord_vars_by_proc(iloc,ilen(1),iprc,mat_con)
            do 64 ivar=1,ilen(1)
               ibuffer(ivar) =
     >              vec_inf(vec_inf(6)-1+mat_con(iloc-1+ivar))
 64         continue
            call insend(ilen(1),1,msgtyp(my_pnum,other_proc),
     >           other_proc,comm_context, 'Tell him we need so much$')
            call insend(ibuffer,ilen(1),msgtyp(my_pnum,other_proc),
     >           other_proc,comm_context, 'Tell him we need this$')
 60      continue
C     Trailing processors that you don't need anything from
         do 66 this_proc=last_inp+1,maxprc-1
            if (my_pnum.ne.this_proc) call insend(zero_var,1,
     >           msgtyp(my_pnum,this_proc),this_proc,comm_context,
     >           'Tell him we don''t need nuttin$')
 66      continue
C     Now go through all processors, and hear what they want from you
         n_outp = 0
         out_items = 0
         do 67 other_proc=0,maxprc-1
            if (my_pnum.ne.other_proc) then
               idum = 1
               call inrecv(ilen(1),idum,
     >              msgtyp(other_proc,other_proc),other_proc,
     >              'How much do you want from me?$')
               if (ilen(1).gt.0) then
                  n_outp = n_outp+1
                  call inrecv(mat_con(mat_con(5)+1+out_items),ilen(1),
     >                 msgtyp(other_proc,other_proc),other_proc,
     >                 'What do you want from me?$')
                  idum = mat_con(5)+1+out_items
                  do 68 iloc=idum,idum+ilen(1)-1
                     mat_con(iloc) = glob2loc(mat_con(iloc),vec_inf)
     >                    +other_proc*cryp1
 68               continue
                  out_items = out_items+ilen(1)
               endif
            endif
 67      continue
         if (com_trace_val.ge.1.and.ts) 
     >        call pdai('Encoded out data$',
     >        mat_con(mat_con(5)+1),out_items)
      endif

C     Write the number of out items, and determine where we can
C     write the processor data
      mat_con(mat_con(5)) = out_items
      leave = out_items+1
      free =  mat_con(5)+leave
      mat_con(3) = free
      mat_con(mat_con(3)) = n_outp

      call force_range(mat_con(3)+3*n_outp+1,1,leng_mat_con,
     >     'All Traffic mat_con overflow2$')

C     Extract local variable numbers of out-traffic
C     and record starting loc and length of a processor's vars
C---- 
      last_outp = -1
      iprc = 1
      do 50 ivar=1,mat_con(mat_con(5))
         this_proc = mat_con(mat_con(5)+ivar) / cryp1
         if (this_proc.ne.last_outp) then
            if (last_outp.ne.-1) then
               mat_con(mat_con(3)+iprc) = out_items
               iprc = iprc+1
            endif
            out_items = 0
            mat_con(mat_con(3)+iprc) = this_proc
            iprc = iprc+1
            mat_con(mat_con(3)+iprc) = ivar
            iprc = iprc+1
            last_outp = this_proc
         endif
         mat_con(mat_con(5)+ivar) =
     >        mod( mat_con(mat_con(5)+ivar) , cryp1 )
         out_items = out_items+1
 50   continue
      mat_con(mat_con(3)+iprc) = out_items

      if (trace_matrices().or.ts) call raw_dump_ex_data(mat_con)

      call crs_add_null_procs(mat_con,ts)

      return
      end
C----------------------------------------------------------------
C     It is very convenient to have the sets of border and edge procs
C     to be the same, even if it means sending some zero messages
C     every once in a while. That's what we're establishing here.
C----------------------------------------------------------------
      subroutine crs_add_null_procs(mat_con,trace)

C     Arguments
C----
      integer mat_con(*)
      logical trace

C     Local
C----
      integer nprocs,proc,oproc, 
     >     field,iprc,cur,tprocs(99)

C     First find edge processors that are not yet border processors
C----
      nprocs = 0
      do 120 proc=1,mat_con(mat_con(3))
         iprc = proc
         cur = mat_con(mat_con(3)+1+3*(iprc-1))
         do 121 oproc=1,mat_con(mat_con(2))
            iprc = oproc
            if (mat_con(mat_con(2)+1+3*(iprc-1))
     >           .eq.cur) goto 122
 121     continue
         nprocs = nprocs+1
         tprocs(nprocs) = cur
 122     continue
 120  continue

C     If we've found anything, shift the edge data and
C     create dummy border procs
C----
      if (nprocs.gt.0) then
         if (trace) call pdai('No-bord edge procs:$',tprocs,nprocs)
         field = mat_con(3)+3*mat_con(mat_con(3))
     >        - mat_con(5) + 1
         call ishift(mat_con(mat_con(5)),field,3*nprocs)
         mat_con(5) = mat_con(5)+3*nprocs
         mat_con(3) = mat_con(3)+3*nprocs
         do 123 proc=1,nprocs
            iprc = mat_con(mat_con(2)) +1
            mat_con(mat_con(2)) = iprc
            mat_con(mat_con(2)+1+3*(iprc-1)) = tprocs(proc)
            mat_con(mat_con(2)+2+3*(iprc-1)) = -1
            mat_con(mat_con(2)+3+3*(iprc-1)) = 0
 123     continue
      endif

C     Now find border processors that are not yet edge processors
C----
      nprocs = 0
      do 130 proc=1,mat_con(mat_con(2))
         iprc = proc
         cur = mat_con(mat_con(2)+1+3*(iprc-1))
         do 131 oproc=1,mat_con(mat_con(3))
            iprc = oproc
            if (mat_con(mat_con(3)+1+3*(iprc-1))
     >           .eq.cur) goto 132
 131     continue
         nprocs = nprocs+1
         tprocs(nprocs) = cur
 132     continue
 130  continue

C     This time we dont' have to shift anything, just add new procs
C----
      if (nprocs.gt.0) then
         if (trace) call pdai('No-edge bord procs:$',tprocs,nprocs)
         do 133 proc=1,nprocs
            iprc = mat_con(mat_con(3)) +1
            mat_con(mat_con(3)) = iprc
            mat_con(mat_con(3)+1+3*(iprc-1)) = tprocs(proc)
            mat_con(mat_con(3)+2+3*(iprc-1)) = -1
            mat_con(mat_con(3)+3+3*(iprc-1)) = 0
 133     continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine cprs_border_traffic_inner(brd_data,
     >     buffer1,buffer2,my_len,maxlen, myvars,nmyvars,
     >     nproc,me,comm_context,cryp,nssp)

C     Arguments
C----
      integer brd_data(*),buffer1(*),buffer2(*),
     >     myvars(*),nmyvars,my_len,maxlen,nproc,me,
     >     comm_context(*),cryp,nssp

C     Function
C----
      logical elemp,trace_setup

C     Local
C----
      integer loclen,ifound(1),loc,ivar,eloc, dproc,proc_a,proc_b
      logical ts

      ts = trace_setup()

C     Put your border data in the buffer
C----
      call iicopy(buffer1,brd_data,my_len)

C     For all other procs, send your buffer, and receive theirs,
C     annotate their border if vars are yours, receive their annotation
C----
      do 10 dproc=0,nproc-1
         proc_a = mod(me+1+dproc,nproc)
         proc_b = mod(nproc+me-1-dproc,nproc)
C     tell a processor after you about your variables
         call incomm(my_len,1,me,proc_a,comm_context,
     >        'Declare #vars$')
         call incomm(buffer1,my_len,me,proc_a,comm_context,
     >        'Declare vars$')
C     now listen to one before you about his vars
         call incomm(loclen,1,proc_b,me,comm_context,
     >        'Get #vars$')
         call incomm(buffer2,loclen,proc_b,me,comm_context,
     >        'Get vars$')
C     go through the buffer, and annotate the variables that are yours
         loc = 1
         ifound(1) = 0
 20      continue
         ivar = (buffer2(loc)/cryp)/2
C OPTIMISE THIS !!!!!!!
         if (elemp(ivar,eloc,myvars,nmyvars)) then
            ifound(1) = 1
            buffer2(loc) = buffer2(loc) + me
            if (nssp.eq.1) buffer2(loc+1) = buffer2(loc+1) + me
         endif
         loc = loc+1+nssp
         if (loc.le.loclen) goto 20
C     send the result back to the other guy
         call incomm(ifound,1,me,proc_b,comm_context,
     >        'Did I annotate?$')
         if (ifound(1).gt.0) call incomm(buffer2,
     >        loclen,me,proc_b,comm_context,
     >        'Annotated other vars$')
C     and maybe get a result, which is your border
         call incomm(ifound,1,proc_a,me,comm_context,
     >        'Annotated my vars$')
         if (ifound(1).gt.0) call incomm(buffer1,
     >        my_len,proc_a,me,comm_context,
     >        'Annotated my vars$')
 11      continue
 10   continue

C     copy the buffer back into your border data
C----
      call iicopy(brd_data,buffer1,my_len)

      return
      end
C----------------------------------------------------------------
C     Local to global numbering map
C----------------------------------------------------------------
      function crs_lc2glb(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), crs_lc2glb

      crs_lc2glb = vec_inf(vec_inf(6)-1+num)

      return
      end
C----------------------------------------------------------------
      function glob2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), glob2loc

C     Local
C----
      integer step

      glob2loc = -1
      do 10 step=1,vec_inf(3)
         if (num.eq.vec_inf(vec_inf(6)-1+step)) then
            glob2loc = step
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
C     Local owned to local numbering map
C----------------------------------------------------------------
      function own2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), own2loc

      if (num.eq.0) then
         own2loc = 0
      else
         own2loc = vec_inf(2+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Local border to local numbering map
C----------------------------------------------------------------
      function brd2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), brd2loc

      if (num.eq.0) then
         brd2loc = 0
      else
         brd2loc = vec_inf(
     >        vec_inf(6)+vec_inf(2)-1+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Local border to global numbering map
C----------------------------------------------------------------
      function brd2glb(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), brd2glb

      if (num.eq.0) then
         brd2glb = 0
      else
         brd2glb = vec_inf(vec_inf(6)-1+vec_inf(2)-1+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Test whether (global) variable is owned
C----------------------------------------------------------------
      function isownv(loc,num,vec_inf)
      
C     Arguments
C---- 
      logical isownv
      integer loc,num,vec_inf(*)
      
C     Local
C---- 
      integer idum
      
      isownv = .false.
      do 110 idum=1,vec_inf(2)
         if (num.eq.vec_inf(vec_inf(6)-1+idum)) then
            isownv = .true.
            loc = idum
            return
         endif
 110  continue
      
      return
      end
C----------------------------------------------------------------
C     Test whether (global) variable is bordering
C     (including owned; use previous routine to filter out that case)
C     (this walks through all local vars; this way it can be used
C     to remap the bordvars themselves)
C----------------------------------------------------------------
      function isbrdv(loc,num,vec_inf)
      
C     Arguments
C---- 
      logical isbrdv
      integer loc,num, vec_inf(*)

C     Has this matrix been remapped?
C----
      integer crs_remap
      common /crs_remapb/crs_remap
      
C     Local
C---- 
      integer idum
      
         isbrdv = .false.
         do 120 idum=1,vec_inf(3)
            if (num.eq.vec_inf(vec_inf(6)-1+idum)) then
               isbrdv = .true.
               loc = idum
               return
            endif
 120     continue
      
      return
      end
C----------------------------------------------------------------
C     Location of rows; both in mat_ptr and matrix
C----------------------------------------------------------------
      subroutine crs_get_pointer(loc,len, var,mat_ptr)

C     Arguments
C----
      integer loc,len, var,mat_ptr(*)

      loc = mat_ptr(var)
      len = mat_ptr(var+1)-loc

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_part(first,last, var,
     >          vec_inf,mat_ptr,part)

C     Arguments
C----
      integer first,last, var,vec_inf(*),mat_ptr(*), part

      if (part.eq.0) then
         first = mat_ptr(var)
         last = mat_ptr(var+1)-1
      else if (part.eq.1) then
         first = mat_ptr(var)
         last = mat_ptr(var)
     >        +mat_ptr(1*vec_inf(2)+2+var-1)-2
      else if (part.eq.2) then
         first = mat_ptr(var)
     >        +mat_ptr(1*vec_inf(2)+2+var-1)-1
         last = mat_ptr(var+1)-1
      endif

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_all(first,last, var,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*)

      first = mat_ptr(var)
      last = mat_ptr(var+1)-1

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_own(first,last, var,
     >          vec_inf,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*),vec_inf(*)

      first = mat_ptr(var)
      last = mat_ptr(var)
     >     +mat_ptr(1*vec_inf(2)+2+var-1)-2

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_brd(first,last, var,
     >          vec_inf,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*),vec_inf(*)

      first = mat_ptr(var)
     >     +mat_ptr(1*vec_inf(2)+2+var-1)-1
      last = mat_ptr(var+1)-1

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_ir_pointer(iloc,rloc,len, var,mat_ptr)

C     Arguments
C----
      integer iloc,rloc,len, var,mat_ptr(*)

      iloc = mat_ptr(var)
      len  = mat_ptr(var+1)-iloc
      rloc = iloc

      return
      end
C----------------------------------------------------------------
      function compute_nnzero_cprs(mat_ptr,vec_inf)

C     Arguments and whatever
C----
      integer mat_ptr(*),vec_inf(*),compute_nnzero_cprs,
     >     first,last,var

      compute_nnzero_cprs = 0
      do 10 var=1,vec_inf(2)
         call crs_get_row_all(first,last,var,mat_ptr)
         compute_nnzero_cprs = compute_nnzero_cprs+last-first+1
 10   continue
      
      return
      end
C----------------------------------------------------------------
C     Get element from column 'elt' out of row 'var'. Amazingly enough
C     this does not rely on sorting the indices.
C----------------------------------------------------------------
      subroutine crs_element_from_row(rdi,idi,
     >      var,elt, matrix,mat_ptr,mat_idx)

C     Arguments
C----
      integer idi, var,elt, mat_ptr(*),mat_idx(*)
      double precision rdi, matrix(*)

C     Local
C----
      integer iloc,rloc,len, col

      call crs_get_ir_pointer(iloc,rloc,len,var,mat_ptr)
      
      rdi = 0.d0
      idi = -1
      do 10 col=1,len
         if (mat_idx(iloc+col-1).eq.elt) then
            rdi = matrix(rloc+col-1)
            idi = col
            goto 20
         endif
 10   continue
 20   continue

      return
      end
C----------------------------------------------------------------
      subroutine crs_element_loc_from_row(idi,
     >      var,elt, mat_ptr,mat_idx)

C     Arguments
C----
      integer idi, var,elt, mat_ptr(*),mat_idx(*)

C     Local
C----
      integer iloc,len, col

      call crs_get_pointer(iloc,len,var,mat_ptr)
      
      idi = -1
      do 10 col=1,len
         if (mat_idx(iloc+col-1).eq.elt) then
            idi = col
            goto 20
         endif
 10   continue
 20   continue

      return
      end
C----------------------------------------------------------------
C     Get the matrix diagonal, or at least its location
C----------------------------------------------------------------
      subroutine extract_diagonal_loc(dloc,bdlc,
     >     vec_inf,mat_ptr,mat_idx)

C     Arguments
C----
      integer dloc(*),bdlc(*),
     >     vec_inf(*),mat_ptr(*),mat_idx(*)

C     Local
C----
      integer row,grow,col, first,last
      
      do 10 row=1,vec_inf(2)
         grow = vec_inf(vec_inf(6)-1+row)
         call crs_get_row_own(first,last,row,vec_inf,mat_ptr)
         do 20 col = first,last
            if (vec_inf(vec_inf(6)-1+mat_idx(col)).eq.grow) then
               dloc(row) = col-first+1
               goto 21
            endif
 20      continue
 21      continue
         call crs_get_row_brd(first,last,row,vec_inf,mat_ptr)
         if (vec_inf(vec_inf(6)-1+mat_idx(last)).lt.grow) then
            bdlc(row) = last-first+2
         else
            bdlc(row) = -1
            do 30 col = first,last
               if (vec_inf(vec_inf(6)-1+mat_idx(col)).gt.grow) then
                  bdlc(row) = col-first+1
                  goto 31
               endif
 30         continue
 31         continue
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine extract_cprs_matrix_diagonal
     >     (xtr,dloc,matrix,mat_ptr,vec_inf)

C     Arguments
C----
      integer dloc(*),mat_ptr(*),vec_inf(*)
      double precision xtr(*),matrix(*)

C     Local
C----
      integer row,rfirst,dum

      do 10 row=1,vec_inf(2)
         call crs_get_pointer(rfirst,dum,row,mat_ptr)
         xtr(row) = matrix(rfirst+dloc(row)-1)
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine local_max_connections(maxc,vec_inf,mat_ptr)

C     Arguments
C----
      integer maxc,vec_inf(*),mat_ptr(*)

C     Local
C----
      integer row,locvar,loc,len

      maxc = -1
      do 10 row=1,vec_inf(2)
         locvar = row
         call crs_get_pointer(loc,len,locvar,mat_ptr)
         maxc = max(len-1,maxc)
 10   continue

      return
      end
C================================================================
C
C     Communication part
C
C     Guide to the meaning of various parameters.
C     `act' indicates what to do with incoming data:
C     9: ignore
C     1: copy in place
C     2: add to data in place
C     3: average with data in place.
C     `part' indicates what part of the domain if affected:
C     1: edge part (owned variables)
C     2: border part (non-owned variables)
C
C================================================================
C----------------------------------------------------------------
C     Send indirectly addressed vector elements
C----------------------------------------------------------------
      subroutine vector_gen_si(x,vec_inf,mat_con,
     >     target,iprc, tmp,type,comm_context,
     >     part,send,
     >     trace,dump)

C     Arguments
C----
      double precision x(*),tmp(*)
      integer target,iprc,type,part,
     >     vec_inf(*),mat_con(*),comm_context(*)
      logical send, trace,dump


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     Local
C----
      integer first,nvar,ivar,idum,info


C     Get variable numbers of sending vars:
C     If 'i' we are exchanging an interior
C     if 'b' we are exchanging a boundary
C----
      if (part.eq.1) then
         if (mat_con(mat_con(3)+2+3*(iprc-1)).eq.-1) then
            first = 1
         else
            first = mat_con(5)+mat_con(mat_con(3)+2+3*(iprc-1))
         endif
         nvar = mat_con(mat_con(3)+3+3*(iprc-1))
      else if (part.eq.2) then
         if (mat_con(mat_con(2)+2+3*(iprc-1)).eq.-1) then
            first = 1
         else
            first = mat_con(4)+mat_con(mat_con(2)+2+3*(iprc-1))
         endif
         nvar = mat_con(mat_con(2)+3+3*(iprc-1))
      else
         call pe1i('Vector SI strange part$',part)
      endif

      if (dump.or.trace) then
         if (part.eq.1) then
            call pd00(tx_trace_string,'(edge_part)$')
         else
            call pd00(tx_trace_string,'(bord part)$')
         endif
      endif
      if (dump) then
         call pdiga('to:$',target,
     >        'vars:$',mat_con(first),nvar,vec_inf)
      else if (trace) then
         call pd1i1i('to:$',target,'#vars:$',nvar)
      endif

C     Pack the variables into a send buffer
C----
      call pvmfsetsbuf(
     >     comm_context(5+comm_context(2)+max(target,0)),idum)
      do 10 ivar=1,nvar
         call pvmfpack(REAL8,
     >        x(mat_con(first+ivar-1)),1,1,info)
 10   continue
      if (trace)
     >     call pd1i2i(' words:$',nvar,'to/type:$',target,type)
      if (dump) call pdair('- values to buffer:$',
     >     x,mat_con(first),nvar)

 20   continue
      if (.not.send) return

      call pvmfsend(comm_context(3+target),
     >     type,info)
      if (info.lt.0) call pe0('trouble sending$')
      call pvmffreebuf(
     >     comm_context(5+comm_context(2)+max(target,0)),info)
      if (info.lt.0) call pe0('trouble freeing$')
      if (trace) call pd1i('- sent to$',target)      
      if (info.lt.0) call stop_connections('vect gen si error$')

      return
      end
C----------------------------------------------------------------
C     Receive indirectly addressed boundary elements
C----------------------------------------------------------------
      subroutine vector_gen_ri(x,vec_inf,mat_con,
     >     source,iprc, tmp,type,comm_context,
     >     part,receive,act,
     >     trace,dump)

C     Arguments
C----
      double precision x(*),tmp(*)
      integer source,iprc,type,part,act,
     >     vec_inf(*),mat_con(*),comm_context(*)
      logical receive, trace,dump

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Local
C----
      integer first,ivar,nvar,info

C     Get variable numbers of receiving vars:
C     'part' indicates what part of ourselves we received
C----
      if (part.eq.2) then
         if (mat_con(mat_con(2)+2+3*(iprc-1)).eq.-1) then
            first = 1
         else
            first = mat_con(4)+mat_con(mat_con(2)+2+3*(iprc-1))
         endif
         nvar  = mat_con(mat_con(2)+3+3*(iprc-1))
      else if (part.eq.1) then
         if (mat_con(mat_con(3)+2+3*(iprc-1)).eq.-1) then
            first = 1
         else
            first = mat_con(5)+mat_con(mat_con(3)+2+3*(iprc-1))
         endif
         nvar  = mat_con(mat_con(3)+3+3*(iprc-1))
      else
         call pe1i('Vector RI strange part$',part)
      endif

      if (dump.or.trace) then
         if (part.eq.1) then
            call pd00(tx_trace_string,'(edge_part)$')
         else
            call pd00(tx_trace_string,'(bord part)$')
         endif
      endif
      if (dump) then
         call pdiga('from:$',source,
     >        'vars:$',mat_con(first),nvar,vec_inf)
         call pd1i2i('- words:$',nvar,'from/type:$',source,type)
      else if (trace) then
         call pd1i1i('from:$',source,'#vars:$',nvar)
         call pd1i2i('- words:$',nvar,'from/type:$',source,type)
      endif

      if (receive) then
         call pvmfsetrbuf(0,info)
         call pvmfrecv(-1,type,comm_context(7+2*comm_context(2)+source))
         if (trace) call pd0('- recvd$')
      else
         call pvmfsetrbuf(comm_context(7+2*comm_context(2)+source),info)
      endif

C     Unpack the receive buffer into the vector variable
C----
      call pvmfunpack(REAL8,tmp,nvar,1,info)
      if (info.lt.0) call pe0('Recv cprs trouble unpacking$')
      if (act.eq.1) then
         do 10 ivar=1,nvar
            x(mat_con(first+ivar-1)) = tmp(ivar)
 10      continue
      else if (act.eq.2) then
         do 20 ivar=1,nvar
            x(mat_con(first+ivar-1)) =
     >           x(mat_con(first+ivar-1))+tmp(ivar)
 20      continue
      else
         call pe1i('Vector UNpack strange act$',act)
      endif

      return
      end
C================================================================
C     Access functions for CRS format
C================================================================
C----------------------------------------------------------------
C     What is the local number of an insending processor?
C----------------------------------------------------------------
      function brd_proc_glob2loc(proc,mat_con)

C     Arguments
C----
      integer proc,mat_con(*), brd_proc_glob2loc

C     Local
C----
      integer prc2lc

      brd_proc_glob2loc = prc2lc(proc,mat_con(2),mat_con)

      return
      end
C----------------------------------------------------------------
C     What is the local number of an outreceiving processor?
C----------------------------------------------------------------
      function edg_proc_glob2loc(proc,mat_con)

C     Arguments
C----
      integer proc,mat_con(*), edg_proc_glob2loc

C     Local
C----
      integer prc2lc

      edg_proc_glob2loc = prc2lc(proc,mat_con(3),mat_con)

      return
      end
C----------------------------------------------------------------
      function prc2lc(proc,inex,mat_con)

C     Arguments
C----
      integer proc,inex,mat_con(*), prc2lc

C     Local
C----
      integer iproc

      prc2lc = -1
      do 10 iproc=1,mat_con(inex)
         if (mat_con(inex+1+3*(iproc-1)).eq.proc) then
            prc2lc = iproc
            goto 20
         endif
 10   continue
 20   continue

      return
      end
C----------------------------------------------------------------
C     Get the numbers of all in/sending out/receiving processors
C     connected to this one.
C----------------------------------------------------------------
      subroutine sending_procs_i(surrs,nsurr,maxsur,mat_con)

C     Arguments
C----
      integer maxsur
      integer mat_con(*),surrs(maxsur),nsurr

C     Local
C----
      integer iprc

      nsurr = mat_con(mat_con(2))
      call force_range(nsurr,0,maxsur,'>> Send procs_i too many$')
      do 10 iprc=1,nsurr
         surrs(iprc) = mat_con(mat_con(2)+1+3*(iprc-1))
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine receiving_procs_i(surrs,nsurr,maxsur,mat_con)

C     Arguments
C----
      integer maxsur
      integer mat_con(*),surrs(maxsur),nsurr

C     Local
C----
      integer iprc

      nsurr = mat_con(mat_con(3))
      do 10 iprc=1,mat_con(mat_con(3))
         surrs(iprc) = mat_con(mat_con(3)+1+3*(iprc-1))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Find local/non-owned variables from a bordering processor
C     (local numbering: iprc=1..brd_procs)
C----------------------------------------------------------------
      subroutine cprs_bord_vars_by_proc(first,nvar,iprc,mat_con)

C     Arguments
C----
      integer first,nvar, mat_con(*),iprc

      first = mat_con(4)+mat_con(mat_con(2)+2+3*(iprc-1))
      nvar  = mat_con(mat_con(2)+3+3*(iprc-1))

      return
      end
C----------------------------------------------------------------
C     Find owned variables that are bordering on other processor
C     (local numbering: iprc=1..brd_procs)
C----------------------------------------------------------------
      subroutine cprs_edge_vars_by_proc(first,nvar, iprc,mat_con)

C     Arguments
C----
      integer first,nvar, mat_con(*),iprc

      first = mat_con(5)+mat_con(mat_con(3)+2+3*(iprc-1))
      nvar  = mat_con(mat_con(3)+3+3*(iprc-1))

      return
      end
C----------------------------------------------------------------
      function cprs_buffer_size(mat_con,trace)

C     Arguments
C----
      integer mat_con(*),cprs_buffer_size
      logical trace

C     Local
C----
      integer proc,first,nvar

      cprs_buffer_size = 0
      if (trace) call pd2i('Cprs buffer size over edg/brd procs$',
     >     mat_con(mat_con(3)),mat_con(mat_con(2)))
      do 10 proc=1,mat_con(mat_con(3))
         call cprs_edge_vars_by_proc(first,nvar,proc,mat_con)
         cprs_buffer_size = max(cprs_buffer_size,nvar)
 10   continue
      do 20 proc=1,mat_con(mat_con(2))
         call cprs_bord_vars_by_proc(first,nvar,proc,mat_con)
         cprs_buffer_size = max(cprs_buffer_size,nvar)
 20   continue
      if (trace) call pd1i('- result size:$',cprs_buffer_size)

      return
      end
C----------------------------------------------------------------
C     Trace the result of building a crs matrix
C     and the traffic pattern corresponding to it
C----------------------------------------------------------------
      subroutine crs_trace_dump(matrix,
     >     vec_inf,mat_ptr,mat_idx,mat_con,lvl)
      
C     Arguments
C---- 
      integer vec_inf(*),mat_ptr(*),mat_idx(*),mat_con(*), lvl
      double precision matrix(*)
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Local
C---- 
      integer idum,iprc,the_prc,ivar,locvar, iloc,ilen,n_rows,
     >     first,last

      if (mod(lvl,10).eq.0 .or. mod(lvl,10).eq.1) then
         write(dmpchn,*) 'Owned variables @',2
         write(dmpchn,*) (vec_inf(vec_inf(6)-1+idum),
     >        idum=1,vec_inf(2))
         if (lvl.ge.10) goto 10
         write(dmpchn,*) 'Local numbers of border vars'
         write(dmpchn,*)
     >        (vec_inf(vec_inf(6)+vec_inf(2)-1+idum),
     >        idum=1,vec_inf(3)-vec_inf(2))
         write(dmpchn,*) 
     >        'Global numbers of owned & bordering vars @',vec_inf(6)
         write(dmpchn,*)
     >        (vec_inf(vec_inf(6)-1+idum),idum=1,vec_inf(3))
 10      continue
      endif
      
      if (mod(lvl,10).eq.0 .or. mod(lvl,10).eq.2) then
         write(dmpchn,*) 'Local matrix:'
         n_rows = vec_inf(2)
         do 300 ivar=1,n_rows
            locvar = ivar
            write(dmpchn,302)
     >           locvar,vec_inf(vec_inf(6)-1+locvar),
     >           mat_ptr(2*vec_inf(2)+2+ivar-1),
     >           mat_ptr(3*vec_inf(2)+2+ivar-1)
 302        format(1x,'> Row',1xi3,'->',i4,'; diag/bdia @',1xi3,',',i3)
            call crs_get_row_own(first,last,ivar,vec_inf,mat_ptr)
            write(dmpchn,301) 'o',
     >           (mat_idx(idum),
     >           vec_inf(vec_inf(6)-1+mat_idx(idum)),
     >           matrix(idum),
     >           idum=first,last)
            call crs_get_row_brd(first,last,ivar,vec_inf,mat_ptr)
            write(dmpchn,301) 'b',
     >           (mat_idx(idum),
     >           vec_inf(vec_inf(6)-1+mat_idx(idum)),
     >           matrix(idum),
     >           idum=first,last)
 301        format(1x,a1,
     >           100(1x,'(',i3,'->',i4,',',f9.4,')'))
 300     continue
      endif
      
      if (mod(lvl,10).eq.0 .or. mod(lvl,10).eq.3) then
         
         write(dmpchn,*) 'In / sending procs: @',mat_con(2)
         
         do 100 iprc=1,mat_con(mat_con(2))
            the_prc = mat_con(mat_con(2)+1+3*(iprc-1))
            if (mat_con(mat_con(2)+2+3*(iprc-1)).eq.-1) then
               call pd1i('Null msg from$',the_prc)
            else
               call cprs_bord_vars_by_proc(iloc,ilen, iprc,mat_con)
               write(dmpchn,*) the_prc,':',
     >              (vec_inf(vec_inf(6)-1+mat_con(iloc+idum-1)),
     >              idum=1,ilen)
            endif
            if (the_prc.lt.0.or.the_prc.ge.nproc)
     >           write(dmpchn,*) '** invalid proc no **'
 100     continue
         
      endif
      
      if (mod(lvl,10).eq.0 .or. mod(lvl,10).eq.4) then
         
         write(dmpchn,*) 'Out / receiving procs: @',mat_con(3)
         
         do 200 iprc=1,mat_con(mat_con(3))
            the_prc = mat_con(mat_con(3)+1+3*(iprc-1))
            if (mat_con(mat_con(3)+2+3*(iprc-1)).eq.-1) then
               call pd1i('Null msg to$',the_prc)
            else
               call cprs_edge_vars_by_proc(iloc,ilen, iprc,mat_con)
               write(dmpchn,*) the_prc,':',
     >              (vec_inf(vec_inf(6)-1+mat_con(iloc+idum-1)),
     >              idum=1,ilen)
            endif
            if (the_prc.lt.0.or.the_prc.ge.nproc)
     >           write(dmpchn,*) '** invalid proc no **'
 200     continue
         
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine raw_dump_in_data(mat_con)

C     Arguments
C----
      integer mat_con(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

      write(dmpchn,*) 'Raw input data'
      call pd2i('Inp/d at$',mat_con(2),mat_con(4))
      call pdai('In procs$',
     >     mat_con(mat_con(2)+1),3*mat_con(mat_con(2)))
      call pdai('In data$',
     >     mat_con(mat_con(4)+1),mat_con(mat_con(4)))

      return
      end
C----------------------------------------------------------------
      subroutine raw_dump_ex_data(mat_con)

C     Arguments
C----
      integer mat_con(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

      write(dmpchn,*) 'Raw output data'
      call pd2i('Exp/d at$',mat_con(3),mat_con(5))
      call pdai('Ex procs$',
     >     mat_con(mat_con(3)+1),3*mat_con(mat_con(3)))
      call pdai('Ex data$',
     >     mat_con(mat_con(5)+1),mat_con(mat_con(5)))

      return
      end
C----------------------------------------------------------------
      subroutine init_crs_multicolour(vec_inf,leng_vec_inf,mat_con,
     >     comm_context,mat_ptr,mat_idx, rand,trans, trace)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,mat_con(*),comm_context(*),
     >     mat_ptr(*),mat_idx(*)
      double precision rand(*),trans(*)
      logical trace

C     Tranceive trace information
C----
      integer tx_trace_int
      common /tx_int_block/tx_trace_int
      character*85 tx_trace_string
      common /tx_string_block/tx_trace_string

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Functions
C----
      double precision irand
      logical trace_matrices,trace_setup,tracer_proc

C     Local
C----
      integer loc_var,own_var,brd_var,
     >     num,var,other_var, col,class,max_colour, first_el,no_el,
     >     this_loc,this_var,this_clr,cur_clr,n_clr, i_clr
      logical colour_now,all_coloured(1)
      double precision ran

      if (trace) call pt0('>> Creating crs multi-colouring$')

      own_var = vec_inf(2)
      loc_var = vec_inf(3)
      brd_var = vec_inf(3)-vec_inf(2)

C     Where do we store colour info?
C----
      vec_inf(8) = vec_inf(7)
      vec_inf(7) = vec_inf(8)+loc_var+1
      call force_range(vec_inf(7)-1,1,leng_vec_inf,
     >     'Nit multi clr: vec_inf overflow$')

C     Initialize colours to 0
C----
      call inulv(vec_inf(vec_inf(8)+1),loc_var)
      call nulv(trans,loc_var)

C     Generate random numbers
C----
      do 10 num=1,loc_var
         var = vec_inf(vec_inf(6)-1+num)
         ran = irand(var)
         rand(num) = ran
 10   continue
      if (trace_matrices()) call dump_vector(rand,vec_inf,'Rand$',0)

C     A priori bound on number of colours:
C     global number of variables
C----
      max_colour = vec_inf(4)
      if (trace.and.trace_setup()) call pd1i('Max colour$',max_colour)

C     Now start making classes
C----
      class = 1
 20   continue
      if (tracer_proc()) call pt1i('Applying colour $',class)
      all_coloured(1) = .true.
      do 30 num=1,own_var
         var = num
         if (vec_inf(vec_inf(8)+var).eq.0) then
            all_coloured(1) = .false.
C     investigate uncoloured nodes
            call crs_get_pointer(first_el,no_el,var,mat_ptr)
            colour_now = .true.
            do 35 col=1,no_el
               other_var = mat_idx(first_el+col-1)
               if (rand(var).lt.rand(other_var)
     >              .and. vec_inf(vec_inf(8)+other_var).eq.0)
     >              colour_now = .false.
 35         continue
            if (colour_now) then
               trans(var) = dble(class)
            endif
         endif
 30   continue
      tx_trace_string = 'Colouring$'
      tx_trace_int = class
      call vector_make_border(trans,vec_inf,
     >     mat_con,comm_context)
      if (trace_matrices()) then
         if (all_coloured(1)) then
            call pd1i('I am still colouring: no @$',class)
         else
            call pd1i('I am still colouring: yes @$',class)
         endif
         call dump_vector(trans,vec_inf,'Colr$',class)
      endif
      do 50 var=1,loc_var
         vec_inf(vec_inf(8)+var) = int(trans(var)+1.d-1)
 50   continue
      if (class.gt.max_colour+1) then
         if (tracer_proc()) call pe0('>>>> Too many colours needed$')
         goto 91
      endif
      call qgand(all_coloured,comm_context,trace_matrices())
      if (all_coloured(1)) goto 90
      class = class+1
      goto 20
 90   continue
      if (trace) call pt1i('>> Created with no. colours:$',class)
      if (log_channel_open)
     >     call pc1i('>> Precond with no. colours:$',class,logchn)
 91   continue
      vec_inf(vec_inf(8)) = class

C     Now start making groups of nodes of the same colour
C----
      vec_inf(9) = vec_inf(8)+vec_inf(3)+1
      call force_range(vec_inf(9)+2*vec_inf(vec_inf(8))+vec_inf(2)+1,
     >     1,leng_vec_inf,'Colour groups: vec_inf overflow$')

C     leave space for pointers
      first_el = vec_inf(9)+2*vec_inf(vec_inf(8))+1

C     encode as (colour,variable)
      do 100 num=1,vec_inf(2)
         var = num
         vec_inf(first_el+num-1) =
     >        vec_inf(vec_inf(8)+var)*(max_colour+1)+var
 100  continue

C     sort
      call isort(vec_inf(first_el),vec_inf(2))

C     decode and set up pointers to colour groups
      cur_clr = 0
      n_clr = 0
      do 110 num=1,vec_inf(2)
         this_loc = first_el+num-1
         this_var = mod(vec_inf(this_loc),max_colour+1)
         this_clr = vec_inf(this_loc)/(max_colour+1)
         if (this_clr.ne.cur_clr) then
            if (cur_clr.gt.0) vec_inf(vec_inf(9)+2*cur_clr) = n_clr
            n_clr = 0
            do 120 i_clr=cur_clr+1,this_clr-1
               vec_inf(vec_inf(9)+2*i_clr-1) = this_loc
               vec_inf(vec_inf(9)+2*i_clr) = 0
 120        continue
            cur_clr = this_clr
            vec_inf(vec_inf(9)+2*cur_clr-1) = this_loc
         endif
         vec_inf(this_loc) = this_var
         n_clr = n_clr+1
 110  continue

      return
      end
C----------------------------------------------------------------
C     Dump a Compressed Row Storage matrix
C----------------------------------------------------------------
      subroutine dump_matx_cprs(matrix,mat_ptr,mat_idx,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),mat_idx(*),vec_inf(*)
      double precision matrix(*)

C     Local
C----
      integer own,var,glb,col,oth, ifirst,rfirst,rowlen

      do 10 own=1,vec_inf(2)
         var = own
         glb = vec_inf(vec_inf(6)-1+var)
         call crs_get_ir_pointer(ifirst,rfirst,rowlen, var,mat_ptr)
         do 20 col=1,rowlen
            oth = vec_inf(vec_inf(6)-1+mat_idx(ifirst+col-1))
            if (oth.eq.glb)
     >           call pdiid('matdia$',0,
     >           'var:$',glb, 'val:$',matrix(rfirst+col-1))
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump an indirect vector to outchn
C----------------------------------------------------------------
      subroutine dump_vector_i(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',vec_inf(vec_inf(6)-1+ivar),
     >        'val:$',x(ivar))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump border vars
C----------------------------------------------------------------
      subroutine dump_border_i(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar,brd2glb,brd2loc

      do 10 ivar=1,vec_inf(3)-vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',brd2glb(ivar,vec_inf),
     >        'val:$',x(brd2loc(ivar,vec_inf)))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Read an indirect vector
C----------------------------------------------------------------
      subroutine load_global_vector_i(x,vec_inf,itmp)

C     Arguments
C---- 
      integer vec_inf(*),itmp(*)
      double precision x(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Functions
C----
      integer own2loc

C     Local
C----
      integer ivar,file_vars,my_var,local_vars,total
      double precision val

      local_vars = vec_inf(2)

C     How many variables are there? 
C     Check this against what we know
C----
      read(inchan,*,end=99) file_vars
      total = vec_inf(4)
      call force_range(file_vars,total,total,
     >     'Load Global Vector; wrong #vars$')

C     First determine what global numbers we need:
C     convert locally owned numbers and sort them
C----
      do 10 ivar=1,local_vars
         itmp(ivar) = vec_inf(vec_inf(6)-1+ivar)
 10   continue
      call isort(itmp,local_vars)

C     Read global number and value;
C     if this is for us, store it
C----
      my_var = 1
      do 20 ivar=1,file_vars
         read(inchan,*,end=98) val
         if (ivar.eq.itmp(my_var)) then
            x(own2loc(my_var,vec_inf)) = val
            if (my_var.lt.local_vars) my_var=my_var+1
         endif
 20   continue

      return
 99   call pe0('>>>> Load Global: no first line found $')
      call stop_connections('load global vector$')
      return
 98   call pe1i('>>>> Load Global: eof at variable$',ivar)
      call stop_connections('load global vector$')
      return
      end
C----------------------------------------------------------------
C     first step:
C     vec_inf(vectot) = #variables for all processors
C     vec_inf(2) = #owned variables
C     next stretch of locations contains owned vars
C     (they will changed to local numbers in the next step)
C----------------------------------------------------------------
      subroutine cprs_set_owned_stretch(vec_inf,leng_vec_inf,
     >      first,length)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,first,length

C     Local
C----
      integer count
      logical trace_setup

C     Write the (global) numbers into the region of owned variables
C----
      call force_range(leng_vec_inf-2,1,0,
     >     'Set owned stretch |vec_inf| (1)$')
      call force_range(length,1,leng_vec_inf-2,
     >     'Set owned stretch, #vars$')
      vec_inf(2) = length
      vec_inf(3) = length
      vec_inf(vec_inf(5)) = 1
      vec_inf(7) = vec_inf(5)+1

      do 10 count=1,length
         vec_inf(vec_inf(6)-1+count) = first+count-1
 10   continue

      if (trace_setup()) then
         call pdai('Set my stretch to$',
     >        vec_inf(vec_inf(6)),vec_inf(2))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine cprs_set_my_vars(vec_inf,leng_vec_inf,
     >      buffer,buf_len)

C     Arguments
C----
      integer vec_inf(*),leng_vec_inf,buffer(*),buf_len

C     Functions
C----
      logical trace_setup

C     Initialize pointers for structure and embedding information
C----
      vec_inf(5) = 10
      vec_inf(6) = vec_inf(5)+1

C     Copy the buffer into the region of owned variables;
C     these will still be global numbers
C----
      call force_range(vec_inf(6),10,0,
     >     'Set owned vars, loc of jset$')
      call force_range(leng_vec_inf,vec_inf(6)+buf_len,0,
     >     'Set owned vars |vec_inf| (1)$')
      vec_inf(2) = buf_len
      vec_inf(3) = buf_len
      vec_inf(vec_inf(5)) = 1

      call iicopy(vec_inf(vec_inf(6)),buffer,vec_inf(2))
      if (trace_setup()) then
         call pdai('Set my vars to$',
     >        vec_inf(vec_inf(6)),vec_inf(2))
      endif

      return
      end
