/*===============================================================*
*                                                                *
*     This file is part of the                                   *
*     Distributed Iterative Systems Solvers library              *
*     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              *
*                                                                *
*     Current version: 0.9                                       *
*     This file last generated 94/11/04                          *
*                                                                *
*================================================================*/
#include "cg_headers.h"
void CG(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   CG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   CG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void CGNE(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   CGNE_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   CGNE_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void MINRES(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   MINRES_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   MINRES_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void BICG(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   BICG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   BICG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void QMR(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   QMR_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   QMR_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void NSCG(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res, restart, trunc, mgs)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
int  *restart;
int  *trunc;
int  *mgs;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   NSCG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,restart,trunc,mgs,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   NSCG_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,restart,trunc,mgs,
      &test, &need_mem, work );

   free(work);
}
void GMRES(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res, restart, trunc, mgs)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
int  *restart;
int  *trunc;
int  *mgs;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   GMRES_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,restart,trunc,mgs,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   GMRES_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,restart,trunc,mgs,
      &test, &need_mem, work );

   free(work);
}
void CGS(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   CGS_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   CGS_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}
void BCGS(rm, im, id, cm, cnt, rp, ip, itv, rhs, iv, suc, prc, maxi, stopq, stopt, ghist, dh1, dh2, res)
double  *rm;
int  *im;
int  *id;
int  *cm;
int  *cnt;
double  *rp;
int  *ip;
double  *itv;
double  *rhs;
int  *iv;
int  *suc;
double  *prc;
int  *maxi;
int  *stopq;
int  *stopt;
double  *ghist;
int  *dh1;
int  *dh2;
double  *res;
{
   double *work;
   int need_mem, test;

   test = 1; need_mem = 0;
   BCGS_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );
   work = (double *) malloc(need_mem*sizeof(*work));
   test = 0;

   BCGS_INNER(rm,im,id,cm,cnt,
      rp,ip, itv,rhs, iv,
      suc,prc, maxi,stopq,stopt,
      ghist,dh1,dh2,res,
      &test, &need_mem, work );

   free(work);
}

