C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C
C Communication Routines
C
C================================================================
C----------------------------------------------------------------
C     Inner product of distributed vectors
C
C     Calls to cddot compute only the local result and store this;
C     the first call to ddotv after a sequence of cddot
C     performs the joint sum/broadcast of all local results,
C     subsequent calls to ddotv only query results.
C     The last parameter of cddot and ddotv identifies the inner prod,
C     it has to be at least one.
C
C----------------------------------------------------------------
      subroutine cddot(x,y, vec_inf,dots,maxdot,dotnum,
     >     comm_context,where)

C     Arguments
C---- 
      integer vec_inf(*),dotnum,maxdot,comm_context(*)
      double precision x(*),y(*),dots(*)
      character*(*) where
      
C     Storage for local dots
C----
      integer hidot,stage,dots_base,init
      common /acdoti/hidot,stage,dots_base,init

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val


C     Local
C---- 
      double precision dot

      call force_range_t(dotnum,1,maxdot,
     >     'cDDot max dot number$',where)
      if (stage.eq.2 .or. init.eq.1) then
         stage = 1
         call nulv(dots,maxdot)
         hidot = 0
         init = 0
      endif

      call bvddot(dot, x,y, vec_inf)
      if (com_trace_val.ge.1)
     >     call pd01i(where,'at loc$',dotnum)
      if (com_trace_val.ge.2)
     >     call pd1d('- value$',dot)
      if (dots(dotnum).ne.0.d0)
     >     call pe01i(where,'Warning: overwriting dot @$',dotnum)
      dots(dotnum) = dot
      hidot = max(hidot,dotnum)

      return
      end
C----------------------------------------------------------------
      subroutine cnorm(x, vec_inf,dots,maxdot, dotnum,comm_context,
     >     where)
      
C     Arguments
C---- 
      integer vec_inf(*),dotnum,maxdot,comm_context(*)
      double precision x(*),dots(*)
      character*(*) where
      
C     Storage for local dots
C----
      integer hidot,stage,dots_base,init
      common /acdoti/hidot,stage,dots_base,init

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val


C     Local
C---- 
      double precision dot

      call force_range_t(dotnum,1,maxdot,
     >     'cDDot max dot number$',where)
      if (stage.eq.2 .or. init.eq.1) then
         stage = 1
         call nulv(dots,maxdot)
         hidot = 0
         init = 0
      endif

      call bvddot(dot, x,x, vec_inf)
      if (com_trace_val.ge.1)
     >     call pd01i(where,'at loc$',dotnum)
      if (com_trace_val.ge.2)
     >     call pd1d('- value$',dot)
      if (dots(dotnum).ne.0.d0)
     >     call pe01i(where,'Warning: overwriting dot @$',dotnum)
      dots(dotnum) = dot
      hidot = max(hidot,dotnum)

      return
      end
C----------------------------------------------------------------
      subroutine ddotv(dot,dots,dotnum,comm_context)

C     Arguments
C----
      integer dotnum,comm_context(*)
      double precision dot,dots(*)

C     Local (only to satisfy ftnchek)
C----
      double precision tdot(1)

      call ddotvs(tdot,1,dots,dotnum,comm_context)
      dot = tdot(1)

      return
      end
C----------------------------------------------------------------
      subroutine ddotvs(dot,ndot,dots,dotnum,comm_context)

C     Arguments
C----
      integer dotnum,ndot,comm_context(*)
      double precision dot(*),dots(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Storage for local dots
C----
      integer hidot,stage,dots_base,init
      common /acdoti/hidot,stage,dots_base,init

      if (stage.eq.1) then
         stage = 2
         if (com_trace_val.ge.1)
     >        call pd1i('dots, #=$',hidot)
         call dpgsum(dots,hidot,comm_context,'Gsum ddot$')
         call dpbcst(dots,hidot,comm_context,'BCST ddot$')
      endif

      if (ndot.eq.1) then
         dot(1) = dots(dotnum)
      else
         call vvcopy(dot,dots(dotnum),ndot)
      endif

      return
      end
C----------------------------------------------------------------
      block data iddot

C     Storage for local dots
C----
      integer hidot,stage,dots_base,init
      common /acdoti/hidot,stage,dots_base,init
      data hidot,stage,init/1,2,1/
      end
C----------------------------------------------------------------
C     Edge/Border communication routines
C
C     Meaning of various parameters:
C     -- ns: indicate what kind of processor, and combinations of same
C     are involved. 1 only edge proc; 2 only border;
C     4 twice edge; 5 border, then edge; 7 edge, then border;
C     8 twice border.
C     -- select: possibly use only processor in or contrary to
C     direction of sweep. +1 select up; -1 select down;
C     0 select all.
C     -- tx_act: what kind of transmission to be performed.
C     Acts for multiple vector transmissions:
C     01 Initialise buffer and pack data; 02 pack only;
C     03 pack and send buffer off; 04 initialise, pack, and send;
C     Acts for single vector transmissions:
C     11 receive and unpack; 12 only unpack
C     -- data_act: what to do with incoming data
C     9 ignore; 1 copy into place;
C     2 add to data in place; 3 average with data in place.
C----------------------------------------------------------------
      subroutine vector_send_edge(x,vec_inf,ns,mat_con,comm_context,
     >     select,tx_act)

C     Arguments
C----
      integer select,tx_act, vec_inf(*),ns,
     >     mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Send edge$')

      call vector_part_x(x,vec_inf,ns,mat_con,comm_context,select,
     >     1,tx_act,1)

      return
      end
C----------------------------------------------------------------
      subroutine vector_send_bord(x,vec_inf,ns,mat_con,comm_context,
     >     select,tx_act)

C     Arguments
C----
      integer select,tx_act, vec_inf(*),ns,
     >     mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Send border$')

      call vector_part_x(x,vec_inf,ns,mat_con,comm_context,
     >     select,2,tx_act,1)

      return
      end
C----------------------------------------------------------------
      subroutine vector_recv_edge(x,vec_inf,ns,mat_con,comm_context,
     >     select,tx_act)

C     Arguments
C----
      integer select,tx_act, vec_inf(*),ns,
     >     mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Recv edge$')

      call vector_part_x(x,vec_inf,ns,mat_con,comm_context,
     >     select,1,tx_act,2)

      return
      end
C----------------------------------------------------------------
      subroutine vector_recv_bord(x,vec_inf,ns,mat_con,comm_context,
     >     select,tx_act)

C     Arguments
C----
      integer select,tx_act, vec_inf(*),ns,
     >     mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Recv border$')

      call vector_part_x(x,vec_inf,ns,mat_con,comm_context,
     >     select,2,tx_act,1)

      return
      end
C----------------------------------------------------------------
      subroutine vector_make_border(x,vec_inf,
     >     mat_con,comm_context)

C     Arguments
C----
      integer vec_inf(*),
     >     mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Make border$')

      call vector_part_x(x,vec_inf,1,mat_con,comm_context,
     >     0,1,04,1)
      call vector_part_x(x,vec_inf,2,mat_con,comm_context,
     >     0,2,11,1)

      return
      end
C----------------------------------------------------------------
      subroutine vector_update_edge(x,vec_inf,
     >     mat_con,comm_context)

C     Arguments
C----
      integer vec_inf(*), mat_con(*),comm_context(*)
      double precision x(*)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      if (com_trace_val.ge.1) call pd0('Update edge$')

      call vector_part_x(x,vec_inf,2,mat_con,comm_context,
     >        0,2,04,1)
      call vector_part_x(x,vec_inf,1,mat_con,comm_context,
     >        0,1,11,2)

      return
      end
C----------------------------------------------------------------
      subroutine vector_part_x_inner(x,vec_inf,n_simul,
     >     part,select,tx_act,data_act,
     >     mat_con,comm_context, tmp,buff,buflen)

C     Arguments
C----
      integer part,select,tx_act,data_act, vec_inf(*),n_simul,
     >     mat_con(*),comm_context(*), buflen
      double precision x(*),tmp(*),
     >     buff(buflen)

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Functions
C----
      integer send_type,recv_type

C     Local
C----
      logical up_traffic,do_traffic, send_act,recv_act,
     >     do_init,do_send,do_recv, trace_tx,dump_tx
      integer isurr,nsurr,surrs(99,3),iprc,
     >     other,type
      character*85 tx_act_string,data_act_string,
     >     send_msg,recv_msg,the_msg,procs_msg
      integer c_loc,a_loc,d_loc
      parameter (c_loc=16,a_loc=32,d_loc=24)
      data send_msg/'Going to send < > dir=< > to$'/,
     >     recv_msg/'Going to recv < > dir=< > act=< > from$'/,
     >     tx_act_string/'ipms      ru'/,
     >     data_act_string/'cav     0'/
      logical has_surrs
      data has_surrs/.false./

C     Initialization
C----
      trace_tx = com_trace_val.ge.1
      dump_tx = com_trace_val.ge.2

C     What kind of action is it we're doing
C----
      up_traffic = select.ne.-1
      do_traffic = select.ne.+1
      do_send = tx_act.eq.03.or.tx_act.eq.04
      send_act = do_send.or.tx_act.eq.01.or.tx_act.eq.02
      do_recv = tx_act.eq.11
      recv_act = do_recv.or.tx_act.eq.12
      do_init = tx_act.eq.01.or.tx_act.eq.04.or.do_recv

C     Catch a few aberrant cases
C----
      if (send_act.and.recv_act) goto 102
      if (.not.send_act.and..not.recv_act) goto 103

C     Set up data regarding how much to expect from other processors.
C     This depends on whether it is edge or border data.
C----
      if (has_surrs) goto 104
      has_surrs = .true.

      call inulv(surrs,3*99)
      do 1 iprc=1,mat_con(mat_con(3))
         if (10*(vec_inf(1)/10).eq.30) then
            surrs(iprc,1) = mat_con(mat_con(3)+1+3*(iprc-1))
            surrs(iprc,2) = mat_con(mat_con(3)+3+3*(iprc-1))
            surrs(iprc,3) = mat_con(mat_con(2)+1+3*(iprc-1))
            surrs(iprc,4) = mat_con(mat_con(2)+3+3*(iprc-1))
         else if (10*(vec_inf(1)/10).eq.20) then
            surrs(iprc,1) = mat_con(mat_con(3)-1+2*iprc)
            if (mat_con(mat_con(3)+2*iprc).eq.-2) then
               surrs(iprc,2) = 0
            else
               surrs(iprc,2) =
     >              mat_con(mat_con(5)-1+2*iprc+1)
     >              -mat_con(mat_con(5)-1+2*iprc)+1
            endif
            surrs(iprc,3) = mat_con(mat_con(2)-1+2*iprc)
            if (mat_con(mat_con(2)+2*iprc).eq.-2) then
               surrs(iprc,4) = 0
            else
               surrs(iprc,4) =
     >              mat_con(mat_con(4)-1+2*iprc+1)
     >              -mat_con(mat_con(4)-1+2*iprc)+1
            endif
         else if (10*(vec_inf(1)/10).eq.10) then
            surrs(iprc,1) = mat_con(mat_con(3)+iprc)
            surrs(iprc,2) = mat_con(mat_con(5)+iprc)
            surrs(iprc,3) = mat_con(mat_con(2)+iprc)
            surrs(iprc,4) = mat_con(mat_con(4)+iprc)
         endif
 1    continue
      nsurr = mat_con(mat_con(3))

 104  continue

C     Set the trace messages
C----
      if (trace_tx) then
         if (part.eq.1) then
            procs_msg = '(edge procs)$'
         else
            procs_msg = '(border procs)$'
         endif
         if (send_act) then
            the_msg = send_msg
         else
            the_msg = recv_msg
         endif
         the_msg(c_loc:c_loc) = tx_act_string(tx_act:tx_act)
         if (up_traffic.and..not.do_traffic) then
            the_msg(d_loc:d_loc) = 'u'
         else if (do_traffic.and..not.up_traffic) then
            the_msg(d_loc:d_loc) = 'd'
         else
            the_msg(d_loc:d_loc) = '-'
         endif
         if (recv_act) the_msg(a_loc:a_loc) = 
     >        data_act_string(data_act:data_act)
         call pd0ai(the_msg,procs_msg,surrs,nsurr)
      endif

C     If this is a receiving action, jump over the send part
C----
      if (recv_act) goto 90
C====
C     Send part
C====
      do 10 isurr=1,nsurr
         if (part.eq.1) then
            other = surrs(isurr,1)
         else
            other = surrs(isurr,3)
         endif
         if (up_traffic.and.do_traffic) goto 12
         if (.not.(send_act.eqv.up_traffic.eqv.(other.gt.pnum))) goto 11
 12      continue
         if (do_init) call pvmfmkbuf(PVMDEFAULT,
     >        comm_context(5+comm_context(2)+other))
         if (do_send) then
            type = send_type(other)
         else
            type = -37
         endif
         if (10*(vec_inf(1)/10).eq.10) then
            call vector_gen_sg(x,vec_inf,
     >           other,tmp,type,comm_context,
     >           part,do_send,
     >           trace_tx,dump_tx)
         else if (10*(vec_inf(1)/10).eq.30) then
            call vector_gen_si(x,vec_inf,mat_con,
     >           other,isurr,tmp,type,comm_context,
     >           part,do_send,
     >           trace_tx,dump_tx)
         else if (10*(vec_inf(1)/10).eq.20) then
            call vector_gen_sd(x,vec_inf,mat_con,
     >           other,isurr,tmp,type,comm_context,
     >           part,do_send,
     >           trace_tx,dump_tx)
         else
            call strange_matrix_fmt(vec_inf,
     >           'Part-x snd matrix format$')
         endif
 11      continue
 10   continue
 90   continue

C     If this is a send action, jump over the receive part
C----
      if (send_act) goto 95
C====
C     Receive part
C====
      do 20 isurr=1,nsurr
         if (part.eq.1) then
            other = surrs(isurr,1)
         else
            other = surrs(isurr,3)
         endif
         if (up_traffic.and.do_traffic) goto 22
         if (.not.(recv_act.eqv.do_traffic.eqv.(other.gt.pnum))) goto 21
 22      continue
         if (do_recv) then
            type = recv_type(other)
         else
            type = -37
         endif
         if (10*(vec_inf(1)/10).eq.10) then
            call vector_gen_rg(x,vec_inf,
     >           other,tmp,type,comm_context,
     >           part,do_recv,data_act,
     >           trace_tx,dump_tx)
         else if (10*(vec_inf(1)/10).eq.30) then
            call vector_gen_ri(x,vec_inf,mat_con,
     >           other,isurr,tmp,type,comm_context,
     >           part,do_recv,data_act,
     >           trace_tx,dump_tx)
         else if (10*(vec_inf(1)/10).eq.20) then
            call vector_gen_rd(x,vec_inf,mat_con,
     >           other,isurr,tmp,type,comm_context,
     >           part,do_recv,data_act,
     >           trace_tx,dump_tx)
         else
            call strange_matrix_fmt(vec_inf,
     >           'Part-x rcv matrix format$')
         endif
 21      continue
 20   continue
 95   continue

      return
 102  call pe0('Simultaneous send and receive$')
      goto 99
 103  call pe0('Neither send nor receive$')
      goto 99
 99   continue
      call stop_connections('gen_x$')
      return
      end
C----------------------------------------------------------------
      subroutine crs_border_procs(surrs,nsurr,maxsur,mat_con)

C     Arguments
C----
      integer maxsur
      integer mat_con(*),surrs(maxsur),nsurr

C     Local
C----
      integer iprc

      nsurr = mat_con(mat_con(2))
      do 4 iprc=1,mat_con(mat_con(2))
         surrs(iprc) = mat_con(mat_con(2)+1+3*(iprc-1))
 4    continue

      return
      end
C----------------------------------------------------------------
C     Select a processors depending on whether it is in the right
C     direction of the communication stream.
C----------------------------------------------------------------
      function select_proc(num,send,recv,updir,dodir)

C     Arguments
C----
      logical select_proc,send,recv,updir,dodir
      integer num

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      select_proc =
     >     (send.eqv.updir.eqv.(num.gt.pnum))

      return
      end
C----------------------------------------------------------------
      function no_processors()

C     Argument
C----
      integer no_processors

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      no_processors = nproc
      call force_range(nproc,1,0,'Number of procs$')

      return
      end
C----------------------------------------------------------------
      function my_procnum()

C     Argument
C----
      integer my_procnum

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      my_procnum = pnum
      call force_range(pnum,0,nproc-1,'My proc num$')

      return
      end
C----------------------------------------------------------------
      subroutine compute_buffer_needed(vec_inf,mat_con)

C     Argument
C----
      integer vec_inf(*),mat_con(*)

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Function
C----
      logical trace_setup
      integer no_processors,
     >     diag_buffer_size,cprs_buffer_size,grid_buffer_size

C     Local
C----
      integer total_size
      logical ts

C     Go over all processors
C----
      ts = trace_setup()
      total_size = 0
      if (10*(vec_inf(1)/10).eq.20) then
         total_size = diag_buffer_size(mat_con,ts)
      else if (10*(vec_inf(1)/10).eq.30) then
         total_size = cprs_buffer_size(mat_con,ts)
      else if (10*(vec_inf(1)/10).eq.10) then
         total_size = grid_buffer_size(vec_inf,mat_con)
      else
         call strange_matrix_fmt(vec_inf,'Unknown format$')
      endif

      if (ts) call pd1i('Needed buffer space:$',total_size)
      buffer_size = total_size
      neighbr_buffer_size = total_size
      if (no_processors().gt.1)
     >     call warn_range(buffer_size,1,0,'Comm Buffer size$')

      return
      end
C----------------------------------------------------------------
      subroutine get_mvp_comm_space(work,comm,vec_inf,mat_con)

C     Arguments
C----
      integer work,comm,vec_inf(*),mat_con(*)

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Functions
C----
      logical trace_progress,trace_setup
      integer no_processors

      if (no_processors().le.1) then
         work = 1
         comm = 1
      else
         work = 2*buffer_size
         comm = 4*mat_con(mat_con(2)) * buffer_size
      endif
      if (trace_progress().or.trace_setup())
     >     call pd1i1i('Temp space needed: (work)$',work,'comm$',comm)
      call force_range(work,1,0,'MVP work space$')
      call force_range(comm,1,0,'MVP comm space$')

      return
      end
C----------------------------------------------------------------
      subroutine incomm(buf,siz,ori,tar,comm_context,where)

C     Arguments
C----
      integer buf(*),siz,ori,tar,comm_context(*)
      character*(*) where

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Local
C----
      integer msgtyp,type

      if (pnum.eq.ori) then
         type = msgtyp(ori,tar)
         if (com_trace_val.ge.1) call pd03i(where,
     >        'to/type/size$',tar,type,siz)
         if (com_trace_val.ge.2) call pdai('- values$',buf,siz)
         call insend(buf,siz,type,tar,comm_context,where)
      else if (pnum.eq.tar) then
         type = msgtyp(ori,ori)
         if (com_trace_val.ge.1) call pd03i(where,
     >        'from/type/size$',tar,type,siz)
         call inrecv(buf,siz,type,ori,where)
         if (com_trace_val.ge.2) call pdai('- values$',buf,siz)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine init_processor_grid(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems(1)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Functions
C----
      logical trace_progress,has_trace

C     Local
C----
      integer dim

      call force_range(buffer(1),1,2,'Nit proc #dimens$')
      call force_range(nitems(1),1+buffer(1),1+buffer(1),
     >     'Nit Proc Grid #items$')

C     The processor grid dimension is (should be) buffer(1) <= 4
C     Just to make sure, we set the rest of the dimensions to length one.
C----
      pgrid_dimension = 4
      do 10 dim=1,buffer(1)
         pgrid_size(dim) = buffer(1+dim)
 10   continue
      do 20 dim=buffer(1)+1,pgrid_dimension
         pgrid_size(dim) = 1
 20   continue

      if (trace_progress().and.has_trace())
     >     call pdai('Processor grid size (ijkl)$',
     >     pgrid_size,pgrid_dimension)
      call pdai('Grid:$',pgrid_size,pgrid_dimension)

      call force_range(pgrid_size(1),1,1 000,
     >     'Nit Proc Grid #iprocs$')
      call force_range(pgrid_size(2),1,1 000,
     >     'Nit Proc Grid #jprocs$')
      call force_range(pgrid_size(1)*pgrid_size(2),nproc,nproc,
     >     'Nit Proc Grid #(i*j)procs$')

C     Compute your dimensional coordinates in the processor grid
C     from your linear number.
C----
      do 30 dim=1,4
         proc_ijk(dim) = 0
 30   continue
      proc_ijk(1) = pnum/pgrid_size(2)
      proc_ijk(2) = mod(pnum,pgrid_size(2))


      if (trace_progress().and.has_trace())
     >      call pdai('I am processor (ijkl)$',
     >      proc_ijk,pgrid_dimension)
      call pdai('Me:$',proc_ijk,pgrid_dimension)


      return
      end
C----------------------------------------------------------------
C     Neighbouring processor
C----------------------------------------------------------------
      function neighbour_proc(step)

C     Argument
C----
      integer neighbour_proc,step(4)

C     Local
C----
      integer num2d, i,j

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Number of processor at grid location i,j
C---- 
      num2d(i,j) = i*pgrid_size(2) + j
      if ( (proc_ijk(1)+step(1).lt.0) .or. 
     > (proc_ijk(1)+step(1).ge.pgrid_size(1)) .or.
     > (proc_ijk(2)+step(2).lt.0) .or. 
     > (proc_ijk(2)+step(2).ge.pgrid_size(2)) ) then
         neighbour_proc = -1
      else
         neighbour_proc = num2d(proc_ijk(1)+step(1),proc_ijk(2)+step(2))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine processor_num2ijk(ijk,num)

C     Argument
C----
      integer num,ijk(4)

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
      ijk(1) = num/pgrid_size(2)
      ijk(2) = mod(num,pgrid_size(2))

      return
      end
C----------------------------------------------------------------
      subroutine distance_to_proc(direction,step,other)

C     Arguments
C----
      integer direction,step,other

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

C     Local
C----
      integer other_ijk(4),dim,steps(4)

      call processor_num2ijk(other_ijk,other)
      direction = 0
      do 10 dim=1,pgrid_dimension
         steps(dim) = other_ijk(dim)-proc_ijk(dim)
         if (steps(dim).ne.0 .and. direction.eq.0) direction = dim
 10   continue
      step = steps(direction)

      return
      end
C----------------------------------------------------------------
C Close connectivity softly
C----------------------------------------------------------------
      subroutine close_connections

C     Function
C----
      logical trace_progress

C     Local
C----
      integer info

      call close_channels
      if (trace_progress()) call pt0('Component signing off$')
      call pvmfexit(info)

      return
      end
C----------------------------------------------------------------
C Close connectivity brusquely
C----------------------------------------------------------------
      subroutine stop_connections(msg_string)

C     Function
C----
      character*(*) msg_string

C     Local
C----
      integer info

      call close_channels
      call pt00('++ Component terminating:$',msg_string)
      call pt0('++ See local.data/err* for more info ++$')
      call pvmfexit(info)
      stop

      end
C----------------------------------------------------------------
C     Is this me? 
C     Used most of the time as thisme(0): the central process
C----------------------------------------------------------------
      function thisme(testnm)

C     Argument
C----
      logical thisme
      integer testnm

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      thisme = pnum.eq.testnm

      return
      end
C================================================================
C     Generate a msgtype;
C     messages ori->tar are encoded on ori and tar
C     as cnt(other)*max_msg_types+sender
C     
C     Send:       type = msgtyp(ori,tar)
C     
C     Recv:       type = msgtyp(ori,ori)
C     
C================================================================
C----------------------------------------------------------------
C     Type for message between two processors
C     update the counter of the other party,
C     which is < iprocs*jprcs
C----------------------------------------------------------------
      function msgtyp(sender,other)
      
      integer sender,other, msgtyp
      
C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

      if (sender.eq.other) then
         msgtyp = low + msgcnt(other,1)*range + sender
         if (msgtyp.ge.hi.and.hi.gt.low) then
            msgcnt(other,1) = 0
         else
            msgcnt(other,1) = msgcnt(other,1)+1
         endif
      else
         msgtyp = low + msgcnt(other,2)*range + sender
         if (msgtyp.ge.hi.and.hi.gt.low) then
            msgcnt(other,2) = 0
         else
            msgcnt(other,2) = msgcnt(other,2)+1
         endif
      endif
      call force_range(msgtyp,0,-1,'Message type$')

      return
      end
C----------------------------------------------------------------
      subroutine set_msgid_range(origin,top)

C     Argument
C----
      integer origin,top

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Function
C----
      logical tracer_proc

      low = origin
      hi = top
      if (top-origin.lt.10*range .and. tracer_proc())
     >     call pt1i('>>>> Warning: recomended type range at least$',
     >     10*range)

      return
      end
C----------------------------------------------------------------
C Type for broadcast message,
C----------------------------------------------------------------
      function bmsgtp()

      integer bmsgtp

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Local
C----
      integer btyp

      btyp=range-1

      bmsgtp = low + msgcnt(btyp,1)*range+btyp
      if (msgcnt(btyp,1).ge.hi.and.hi.gt.low) then
         msgcnt(btyp,1) = low
      else
         msgcnt(btyp,1) = msgcnt(btyp,1)+1
      endif
      call force_range(bmsgtp,0,-1,'Bcst message type$')

      return
      end
C----------------------------------------------------------------
C Type for special broadcast message (pvm reader mode)
C----------------------------------------------------------------
      function rmsgtp()

      integer rmsgtp

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Local
C----
      integer rtyp

      rtyp=range-2

      rmsgtp = low + msgcnt(rtyp,1)*range+rtyp
      msgcnt(rtyp,1) = msgcnt(rtyp,1)+1
      call force_range(rmsgtp,0,-1,'Reader message type$')

      return
      end
C----------------------------------------------------------------
      function send_type(other)

C     Arguments and such
C----
      integer send_type,msgtyp,other

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      send_type = msgtyp(pnum,other)

      return
      end
C----------------------------------------------------------------
      function recv_type(other)

C     Arguments and such
C----
      integer recv_type,msgtyp,other

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      recv_type = msgtyp(other,other)

      return
      end
C----------------------------------------------------------------
      subroutine msgtyp_set_hproc(hproc)

C     Arguments
C----
      integer hproc

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

      range = hproc+2

      return
      end
C----------------------------------------------------------------
C     Initialize msg counters
C----------------------------------------------------------------
      block data blcmtp
C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi
      integer totsiz
      parameter (totsiz=2*(2000+1))
      data msgcnt/totsiz*1/
      data low,hi/1,0/
      end
C----------------------------------------------------------------
      block data init_proc_grid

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      data pgrid_dimension,pgrid_size
     >     /2,1,1,0,0/

      end

