/*===============================================================*
*                                                                *
*     This file is part of the                                   *
*     Distributed Iterative Systems Solvers library              *
*     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              *
*                                                                *
*     Current version: 0.9                                       *
*     This file last generated 94/11/04                          *
*                                                                *
*================================================================*/
#include "cg_headers.h"
/*************************** clock00 ******************************/
/* This routine used for PVM.  It should return wall clock time,  */
/* and the argument is cputime.                                   */
/******************************************************************/
double CLOCK00(cputime)
double  *cputime;
{
#include<stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
   struct timeval tp;
   struct rusage ruse;

   if ( gettimeofday(&tp, NULL) )  /* info for wall clock time */
      fprintf(stderr, "\nTIMER00 ERROR: gettimeofday not working\n");

   if ( getrusage(RUSAGE_SELF, &ruse) ) /* info for cputime */
      fprintf(stderr, "\nTIMER00 ERROR: getrusage not working\n");

   *cputime = ruse.ru_utime.tv_sec + ruse.ru_utime.tv_usec / 1000000.0;
   return( (double) (tp.tv_sec + tp.tv_usec/1000000.0) ); /* returns wall clock
time */
}


