C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     Auxiliary routines for distributed block vectors
C       
C================================================================

C----------------------------------------------------------------
C     Inner product routines: only local part,
C     communication is in file 'comm'
C----------------------------------------------------------------
      subroutine bvddot(dot, x,y,vec_inf)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*), dot
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_ddot(dot, x,y,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.30) then
         call inprod(dot, x(vec_inf(vec_inf(5))),
     >        y(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call inprod(dot, x(vec_inf(vec_inf(5))),
     >        y(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine grid_ddot(dot, x,y, ipts,jpts,bord)

C Arguments
C----
      integer ipts,jpts,bord
      double precision dot,
     >     x(1-bord:ipts+bord,1-bord:jpts+bord),
     >     y(1-bord:ipts+bord,1-bord:jpts+bord)

C Local
C----
      integer row,col

      dot = 0.d0
      do 10 col=1,jpts
         do 20 row=1,ipts
            dot = dot+x(row,col)*y(row,col)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Zero a vector with boundary
C----------------------------------------------------------------
      subroutine bvzero(x,vec_inf)

C     Arguments
C----
      integer vec_inf(*)
      double precision x(*)

      if (10*(vec_inf(1)/10).eq.10) then
         call grid_zero(x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)))
      else
         call nulv(x, vec_inf(3))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine grid_zero(x, ipts,jpts,bord)

C Arguments
C----
      integer ipts,jpts,bord
      double precision 
     >     x(1-bord:ipts+bord,1-bord:jpts+bord)

C Local
C----
      integer row,col

      do 10 col=1-bord,jpts+bord
         do 20 row=1-bord,ipts+bord
            x(row,col)=0.d0
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     One a vector with boundary
C----------------------------------------------------------------
      subroutine bvunit(x,vec_inf)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_unit(x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.30) then
         call unitv(x(vec_inf(vec_inf(5))), vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call unitv(x(vec_inf(vec_inf(5))), vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine grid_unit(x, ipts,jpts,bord)

C Arguments
C----
      integer ipts,jpts,bord
      double precision 
     >     x(1-bord:ipts+bord,1-bord:jpts+bord)

C Local
C----
      integer row,col

      do 10 col=1,jpts
         do 20 row=1,ipts
            x(row,col)=1.d0
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Invert boundary vector
C     (we don't use this for inverting the preconditioner diagonal,
C     because that one starts @ 1 for the non-grid case)
C----------------------------------------------------------------
      subroutine bvinvert(x,vec_inf)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_invert(x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)))
      else  if (10*(vec_inf(1)/10).eq.30) then
         call vinvert(x(vec_inf(vec_inf(5))),vec_inf(2))
      else  if (10*(vec_inf(1)/10).eq.20) then
         call vinvert(x(vec_inf(vec_inf(5))),vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine grid_invert(x, ipts,jpts,bord)

C Arguments
C----
      integer ipts,jpts,bord
      double precision 
     >     x(1-bord:ipts+bord,1-bord:jpts+bord)

C Local
C----
      integer row,col

      do 10 col=1,jpts
         do 20 row=1,ipts
            x(row,col)=1.d0/x(row,col)
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine vinvert(x, nvar)

C     Arguments
C----
      integer nvar
      double precision x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,nvar
         x(ivar) = 1.d0/x(ivar)
 10   continue

      return
      end
C----------------------------------------------------------------
C     Scalar multiple of vector with boundary:
C     y = alp*x
C----------------------------------------------------------------
      subroutine bvax(y,vec_inf, alp,x)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*),alp
      
      if (alp.eq.1.d0) then
         call bvcopy(y,vec_inf,x)
      else if (10*(vec_inf(1)/10).eq.10) then
         call grid_ax(y, alp,x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),vec_inf(vec_inf(5)))
      else  if (10*(vec_inf(1)/10).eq.30) then
         call ax(y(vec_inf(vec_inf(5))), 
     >        alp, x(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      else  if (10*(vec_inf(1)/10).eq.20) then
         call ax(y(vec_inf(vec_inf(5))), 
     >        alp, x(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine grid_ax(y, alp,x, ipts,jpts,bordy,bordx)

C Arguments
C----
      integer ipts,jpts,bordy,bordx
      double precision alp,
     >     x(1-bordx:ipts+bordx,1-bordx:jpts+bordx),
     >     y(1-bordy:ipts+bordy,1-bordy:jpts+bordy)

C Local
C----
      integer row,col

      if (alp.eq.1.d0) then
         do 10 col=1,jpts
            do 20 row=1,ipts
               y(row,col)=x(row,col)
 20         continue
 10      continue
      else
         do 110 col=1,jpts
            do 120 row=1,ipts
               y(row,col)=alp*x(row,col)
 120         continue
 110      continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine biax(y, alp,x, owns,nvar)

C     Arguments
C----
      integer owns(*),nvar
      double precision y(*), alp, x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,nvar
         y(owns(ivar)) = alp*x(owns(ivar))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Copy vector with boundary
C----------------------------------------------------------------
      subroutine bvcopy(y,vec_inf,x)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_ax(y, 1.d0, x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.30) then
         call vvcopy(y(vec_inf(vec_inf(5))),
     >        x(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call vvcopy(y(vec_inf(vec_inf(5))),
     >        x(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
C     Copy ordinary vector to bordered vector
C----------------------------------------------------------------
      subroutine bvcopy_ob(y,vec_inf,x)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_ax(y, 1.d0, x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),0)
      else if (10*(vec_inf(1)/10).eq.30) then
         call vvcopy(y(vec_inf(vec_inf(5))),x, vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call vvcopy(y(vec_inf(vec_inf(5))),x, vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
C     Copy bordered vector to ordinary
C----------------------------------------------------------------
      subroutine bvcopy_bo(y,vec_inf,x)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_ax(y, 1.d0, x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),0,
     >        vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.30) then
         call vvcopy(y,x(vec_inf(vec_inf(5))), vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call vvcopy(y,x(vec_inf(vec_inf(5))), vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine bvsub_ob(z,vec_inf,x,y)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*),z(*)
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_axby(z, 1.d0,x,-1.d0,y,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),0)
      else if (10*(vec_inf(1)/10).eq.30) then
         call vvsub(z(vec_inf(vec_inf(5))),
     >        x(vec_inf(vec_inf(5))),y, vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call vvsub(z(vec_inf(vec_inf(5))),
     >        x(vec_inf(vec_inf(5))),y, vec_inf(2))
      endif
      
      return
      end
C----------------------------------------------------------------
C     Scalar multiples of vectors with boundary:
C     z= alp*x + bet*y
C     conceivably optimization for alp,bet=+-1 is beneficial
C----------------------------------------------------------------
      subroutine bvaxby(z,vec_inf, alp,x,bet,y)
      
C     Arguments
C---- 
      integer vec_inf(*)
      double precision x(*),y(*),z(*), alp,bet
      
      if (10*(vec_inf(1)/10).eq.10) then
         call grid_axby(z, alp,x,bet,y,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)),vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.30) then
         call axby(z(vec_inf(vec_inf(5))),
     >        alp,x(vec_inf(vec_inf(5))),
     >        bet,y(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      else if (10*(vec_inf(1)/10).eq.20) then
         call axby(z(vec_inf(vec_inf(5))),
     >        alp,x(vec_inf(vec_inf(5))),
     >        bet,y(vec_inf(vec_inf(5))),
     >        vec_inf(2))
      endif

      return
      end
C----------------------------------------------------------------
      subroutine grid_axby(z,alp,x,bet,y, ipts,jpts,bordx,bordy)
      
C     Arguments
C---- 
      integer ipts,jpts,bordx,bordy
      double precision alp,bet,
     >     x(1-bordx:ipts+bordx,1-bordx:jpts+bordx),
     >     y(1-bordy:ipts+bordy,1-bordy:jpts+bordy),
     >     z(1-bordx:ipts+bordx,1-bordx:jpts+bordx)
      
C     Local
C---- 
      integer row,col
      
      if (alp.eq.1.d0) then
         if (bet.eq.1.d0) then
            do 310 col=1,jpts
               do 320 row=1,ipts
                  z(row,col)=x(row,col)+y(row,col)
 320           continue
 310        continue
         else
            do 10 col=1,jpts
               do 20 row=1,ipts
                  z(row,col)=x(row,col)+bet*y(row,col)
 20            continue
 10         continue
         endif
      else if (bet.eq.1.d0) then
         do 110 col=1,jpts
            do 120 row=1,ipts
               z(row,col)=alp*x(row,col)+y(row,col)
 120        continue
 110     continue
      else
         do 210 col=1,jpts
            do 220 row=1,ipts
               z(row,col)=alp*x(row,col)+bet*y(row,col)
 220        continue
 210     continue
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine nulv(x, n)

      integer n,i
      double precision x(n)

      if (n.le.0) return
      do 10 i=1,n
         x(i) = 0.d0
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine inulv(x, n)

      integer n,i, x(n)

      do 10 i=1,n
         x(i) = 0
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine bvcler(x,vec_inf)

C     Arguments
C----
      integer vec_inf(*)
      double precision x(*)

      if (10*(vec_inf(1)/10).eq.10) then
         call grid_cler(x,
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >        vec_inf(vec_inf(5)))
      else if (10*(vec_inf(1)/10).eq.20) then
         call zerov(x(1), vec_inf(vec_inf(5))-1)
         call zerov(x(vec_inf(vec_inf(5))+vec_inf(2)),
     >        vec_inf(3)-(vec_inf(vec_inf(5))+vec_inf(2))+1)
      else if (10*(vec_inf(1)/10).eq.30) then
         call zerov(x(vec_inf(2)+1),
     >        vec_inf(3)-vec_inf(2))
      else
         call strange_matrix_fmt(vec_inf,'bvcler$')
      endif

      return
      end
C----------------------------------------------------------------
      subroutine grid_cler(x, ipts,jpts,bord)

      integer ipts,jpts,bord, pt,ln
      double precision x(1-bord:ipts+bord,1-bord:jpts+bord)

      do 10 ln=1,bord
         do 20 pt=1-bord,ipts+bord
            x(pt,1-ln) = 0.d0
            x(pt,jpts+ln) = 0.d0
 20      continue
         do 30 pt=1-bord,jpts+bord
            x(1-ln,pt) = 0.d0
            x(ipts+ln,pt) = 0.d0
 30      continue
 10   continue

      return
      end
C================================================================
C
C Ordinary Matrix and Vector Manipulation
C
C================================================================
      subroutine vvcopy(y,x,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         y(i)=x(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vivcopy(y,x,ix,n)
      
C     Arguments
C---- 
      integer n,ix(*)
      double precision x(n),y(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         y(i)=x(ix(i))
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine iicopy(y,x,n)
      
C     Arguments
C---- 
      integer n
      integer x(n),y(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         y(i)=x(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vvsub(z,y,x,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=y(i)-x(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vvdiv(z,y,x,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=y(i)/x(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine unitv(x,n)

C     Argument
C----
      integer n
      double precision x(n)

C     Local
C----
      integer i

      do 10 i=1,n
         x(i) = 1.d0
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine zerov(x,n)

C     Argument
C----
      integer n
      double precision x(n)

C     Local
C----
      integer i

      do 10 i=1,n
         x(i) = 0.d0
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine inprod(res,x,y,n)

C     Arguments
C----
      integer n
      double precision x(n),y(n),res

C     Local
C----
      integer el

      res = 0.d0
      do 10 el=1,n
         res = res + x(el)*y(el)
 10   continue

      return
      end
C----------------------------------------------------------------
C     Integer sort-of-inner-product routine
C----------------------------------------------------------------
      function iobtuse(v1,v2,len)

C     Arguments
C----
      integer v1(*),v2(*),len
      logical iobtuse

C     Local
C----
      integer dim

      iobtuse = .false.
      do 10 dim=len,1,-1
         if (v1(dim)*v2(dim).lt.0) then
            iobtuse = .true.
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine ax(z,a,x,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),z(n), a
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=a*x(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine axby(z,a,x,b,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n), a,b
      
C     Local
C---- 
      integer i
      
      if (a.eq.1.d0) then
         if (b.eq.1.d0) then
            do 10 i=1,n
               z(i)=x(i)+y(i)
 10         continue
         else
            do 20 i=1,n
               z(i)=x(i)+b*y(i)
 20         continue
         endif
      else if (b.eq.1.d0) then
         do 30 i=1,n
            z(i)=a*x(i)+y(i)
 30      continue
      else
         do 40 i=1,n
            z(i)=a*x(i)+b*y(i)
 40      continue
      endif

      return
      end
C----------------------------------------------------------------
      subroutine vpv(z,x,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=x(i)+y(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vmv(z,x,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=x(i)-y(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine axbycz(plof,a,x,b,y,c,z,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n), a,b,c, plof(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         plof(i)=a*x(i)+b*y(i)+c*z(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vvupdate(z,x,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=z(i)+x(i)*y(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vvdndate(z,x,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=z(i)-x(i)*y(i)
 10   continue
      
      return
      end
C----------------------------------------------------------------
      subroutine vvprod(z,x,y,n)
      
C     Arguments
C---- 
      integer n
      double precision x(n),y(n),z(n)
      
C     Local
C---- 
      integer i
      
      do 10 i=1,n
         z(i)=x(i)*y(i)
 10   continue
      
      return
      end
C================================================================
C     Sequence handling routines
C     (generalization of axby and such)
C================================================================
C----------------------------------------------------------------
      subroutine twot_update(v1,where,iwhere, v2,vm,
     >     vec_inf,vlen,vloc, coef,ncoef, dump,trace)

C     Arguments
C----
      integer vlen,vloc, ncoef,vec_inf(*),iwhere
      double precision v1(*),v2(*),vm(*), coef(*)
      logical dump,trace
      character*(*) where

C     Locals and functions
C----
      double precision post

      if (trace) call pdar('2-term upd, cofs$',coef,ncoef)
      post = 1.d0/coef(1)
      call axby(v1, post,vm, -post*coef(2),v2, vlen)
      call addflp(3*vloc)
      if (dump) call dump_vector(v1,vec_inf, where,iwhere)

      return
      end
C----------------------------------------------------------------
      subroutine threet_update(v1,where,iwhere, v2,v3,vm,
     >     vec_inf,vlen,vloc, coef,ncoef, dump,trace)

C     Arguments
C----
      integer vlen,vloc, ncoef,vec_inf(*),iwhere
      double precision v1(*),v2(*),v3(*),vm(*), coef(*)
      logical dump,trace
      character*(*) where

C     Locals and functions
C----
      double precision post

      if (trace) call pdar('3-term upd, cofs$',coef,ncoef)
      post = 1.d0/coef(1)
      if (ncoef.gt.2) then
         call axbycz(v1, post,vm,
     >        -post*coef(2),v2, -post*coef(3),v3, vlen)
         call addflp(5*vloc)
      else
         call axby(v1, post,vm,
     >        -post*coef(2),v2, vlen)
         call addflp(3*vloc)
      endif
      if (dump) call dump_vector(v1,vec_inf, where,iwhere)

      return
      end
C----------------------------------------------------------------
C     Update a contiguous sequence of vectors
C     wrapped storage is assumed for the sequence
C----------------------------------------------------------------
      subroutine sequpdate(block,blen,vlen,vloc, itno,r_itno,vec_inf,
     >     cc,cv,vec,cs,ncs,post, trace,tarloc)

C     Arguments
C----
      integer blen,vlen,vloc,itno,r_itno, vec_inf(*), ncs, tarloc
      double precision block(vlen,blen), vec(vlen),cc,cv,cs(ncs), post
      logical trace

C     Locals and functions
C----
      integer iter,nsteps, vciblk,tar,nv

      nsteps = min(ncs,blen-2,itno-1)
      tar = vciblk(r_itno+1,blen)
      if (trace) then
         call pd1i1i('Sequpdt; tar=$',tar,'#old=$',nsteps)
         call pd1d1dar('old-c$',cc,'vec-c$',cv,'cofs$',cs,ncs)
      endif

      if (itno.le.0) then
         tarloc = 1
         call bvax(block(1,tar),vec_inf,cv*post,vec)
         nv = 1
      else
         tarloc = (tar-1)*vlen+1
         call bvaxby(block(1,tar),vec_inf,
     >        cc*post,block(1,vciblk(r_itno,blen)),
     >        cv*post,vec)
         nv = 3
      endif
      do 10 iter=1,nsteps
         call bvaxby(block(1,tar),vec_inf,1.d0,block(1,tar),
     >        cs(iter)*post,block(1,vciblk(r_itno-iter,blen)))
 10   continue
      call addflp((2*nsteps+nv)*vloc)

      return
      end
C----------------------------------------------------------------
      subroutine requpdate(block,where,
     >     blen,vlen,vloc,itno,vec_inf,
     >     cv,vec,cs,ncs, trace,tarloc)

C     Arguments
C----
      integer blen,vlen,vloc, itno, vec_inf(*), ncs, tarloc
      double precision block(vlen,blen), vec(vlen),cv,cs(ncs)
      character*(*) where
      logical trace

C     Locals and functions
C----
      integer iter,ntrail, tar,last, vciblk,id
      double precision post

      vciblk(id) = 1+mod(id-1,blen)

      ntrail = max(0,min(ncs-1,blen,itno-1))
      tar = vciblk(itno)
      tarloc = (tar-1)*vlen+1
      last = vciblk(itno-ntrail)
      post = 1.d0/cs(1)
      if (trace) then
         call pd0(where)
         call pd3i('Req_updt; tar/last/trail$',tar,last,ntrail)
         call pdar('- cofs$',cs,ncs)
      endif

      if (ntrail.eq.0) then
         call bvax(block(1,tar),vec_inf,cv*post,vec)
      else
         call bvaxby(block(1,tar),vec_inf,
     >        -cs(ncs)*post,block(1,last),
     >        cv*post,vec)
      endif
      do 10 iter=1,ntrail-1
         call bvaxby(block(1,tar),vec_inf,1.d0,block(1,tar),
     >        -post*cs(iter+1),
     >        block(1,vciblk(itno-iter)))
 10   continue
      call addflp((2*ntrail+1)*vloc)

      return
      end
C----------------------------------------------------------------
      subroutine lanczos_update(block1,where1,q,block2,where2,
     >     blen,vlen,vloc, itno,r_itno,vec_inf, trc,
     >     cc,cv,vec1,vec2,cs,ncs,post)

C     Arguments
C----
      integer blen,vlen,vloc, itno,r_itno, vec_inf(*), ncs, idum
      double precision block1(vlen,blen),block2(vlen,blen),
     >     vec1(vlen),vec2(vlen), cc,cv,cs(ncs), post
      logical q,trc
      character*(*) where1,where2

      if (trc) call pd0(where1)
      call sequpdate(block1,blen,vlen,vloc, itno,r_itno,vec_inf,
     >     cc,cv,vec1,cs,ncs,post,trc,idum)
      if (q) then
         if (trc) call pd0(where2)
         call sequpdate(block2,blen,vlen,vloc, itno,r_itno,vec_inf,
     >        cc,cv,vec2,cs,ncs,post,trc,idum)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine lanczos_req_update(block1,where1,q,block2,where2,
     >     blen,vlen,vloc, itno,r_itno,vec_inf, trc,
     >     cv,vec1,vec2,cs,ncs)

C     Arguments
C----
      integer blen,vlen,vloc, itno,r_itno, vec_inf(*), ncs
      double precision block1(vlen,blen),block2(vlen,blen),
     >     vec1(vlen),vec2(vlen), cv,cs(ncs)
      logical q,trc
      character*(*) where1,where2

C     Local
C----
      integer idum

      call requpdate(block1,where1,
     >     blen,vlen,vloc, itno,vec_inf,
     >     cv,vec1,cs,ncs,trc,idum)
      if (q) then
         call requpdate(block2,where2,
     >        blen,vlen,vloc, itno,vec_inf,
     >        cv,vec2,cs,ncs,trc,idum)
      endif

      return
      end
C================================================================
C     Runtime error prevention
C================================================================
C----------------------------------------------------------------
C     Vector location in block; should be inlined.
C----------------------------------------------------------------
      function vciblk(vec,wid)

C     Argument
C----
      integer vciblk,vec,wid

      if (wid.eq.0) then
         vciblk = 1
      else
         vciblk = 1+mod(vec-1,wid)
      endif

      return
      end
C----------------------------------------------------------------
C     Force an integer in a range
C     (validity check on input; in hostless model
C     we can not say 'try again'.)
C----------------------------------------------------------------
      subroutine force_range(test,lo,hi,string)
      
C     Arguments
C---- 
      integer test,lo,hi
      character*(*) string
      
      if (test.lt.lo .or. (hi.ge.lo .and. test.gt.hi)) then
         if (hi.lt.lo) then
            call pe1i1i(string,test,'((intended range >= $',lo)
         else if (hi.eq.lo) then
            call pe1i1i(string,test,'((intended value $',lo)
         else
            call pe1i2i(string,test,'((intended range $',lo,hi)
         endif
         call stop_connections('range error$')
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine warn_range(test,lo,hi,string)
      
C     Arguments
C---- 
      integer test,lo,hi
      character*(*) string
      
      if (test.lt.lo .or. (hi.ge.lo .and. test.gt.hi)) then
         if (hi.lt.lo) then
            call pe1i1i(string,test,'((intended range >= $',lo)
         else if (hi.eq.lo) then
            call pe1i1i(string,test,'((intended value $',lo)
         else
            call pe1i2i(string,test,'((intended range $',lo,hi)
         endif
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine force_range_t(test,lo,hi,string,where)
      
C     Arguments
C---- 
      integer test,lo,hi
      character*(*) where,string
      
      if (test.lt.lo .or. (hi.ge.lo .and. test.gt.hi)) then
         if (hi.lt.lo) then
            call pe1i1i0(string,test,'((intended range >= $',lo,where)
         else if (hi.eq.lo) then
            call pe1i1i0(string,test,'((intended value $',lo,where)
         else
            call pe1i2i0(string,test,'((intended range $',lo,hi,where)
         endif
         call stop_connections('range error$')
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine force_range_i(test,lo,hi,string,iwhere)
      
C     Arguments
C---- 
      integer test,lo,hi,iwhere
      character*(*) string
      
      if (test.lt.lo .or. (hi.ge.lo .and. test.gt.hi)) then
         if (hi.lt.lo) then
            call pe1i2i(string,test,
     >           '((intended range >= $',lo,iwhere)
         else if (hi.eq.lo) then
            call pe1i2i(string,test,
     >           '((intended value $',lo,iwhere)
         else
            call pe1i3i(string,test,
     >           '((intended range $',lo,hi,iwhere)
         endif
         call stop_connections('range error$')
      endif
      
      return
      end
C----------------------------------------------------------------
      subroutine frcrn3(test,lo,hi,string,wher1,wher2)
      
C     Arguments
C---- 
      integer test,lo,hi,wher1,wher2
      character*(*) string
      
      if (test.lt.lo .or. (hi.ge.lo .and. test.gt.hi)) then
         call pt3i(string,test,wher1,wher2)
         call stop_connections('range error$')
      endif
      
      return
      end
C================================================================
C     Sort
C================================================================
      subroutine isort(ar,len)

C     Arguments
C----
      integer len
      integer ar(len)

C     Local
C----
      integer pass,count, save
      logical changes

      do 10 pass=1,len-1
         changes = .false.
         do 20 count=1,len-pass
            if (ar(count).gt.ar(count+1)) then
               changes = .true.
               save = ar(count)
               ar(count) = ar(count+1)
               ar(count+1) = save
            endif
 20      continue
         if (.not.changes) goto 30
 10   continue
 30   continue

      return
      end
C----------------------------------------------------------------
C     Sort, weeding out duplicates
C----------------------------------------------------------------
      subroutine isort1(ar,len)

C     Arguments
C----
      integer len
      integer ar(len)

C     Local
C----
      integer iread,iwrite

      call isort(ar,len)

      if (len.lt.2) return
      iwrite = 1
      iread = 1
 10   continue
      ar(iwrite) = ar(iread)
 20   if (ar(iread).eq.ar(iwrite) .and. iread.le.len) then
         iread = iread+1
         goto 20
      endif
      if (iread.le.len) then
         iwrite = iwrite+1
         goto 10
      endif
      len = iwrite

      return
      end
C----------------------------------------------------------------
C     Sort two integer sequences on the first
C----------------------------------------------------------------
      subroutine iisort(ar,rar,len)

C     Arguments
C----
      integer len
      integer ar(len),rar(len)

C     Local
C----
      integer pass,count, save,rsave

      do 10 pass=1,len-1
         do 20 count=1,len-pass
            if (ar(count).gt.ar(count+1)) then
               save = ar(count)
               rsave = rar(count)
               ar(count) = ar(count+1)
               rar(count) = rar(count+1)
               ar(count+1) = save
               rar(count+1) = rsave
            endif
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Sort real and integer array simultaneously;
C     sort on the ints
C----------------------------------------------------------------
      subroutine irsort(ar,rar,len)

C     Arguments
C----
      integer len
      integer ar(len)
      double precision rar(len)

C     Local
C----
      integer pass,count, save
      double precision rsave

      do 10 pass=1,len-1
         do 20 count=1,len-pass
            if (ar(count).gt.ar(count+1)) then
               save = ar(count)
               rsave = rar(count)
               ar(count) = ar(count+1)
               rar(count) = rar(count+1)
               ar(count+1) = save
               rar(count+1) = rsave
            endif
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Same, but return the permutation vector
C----------------------------------------------------------------
      subroutine irsortx(ar,rar,iar,len)

C     Arguments
C----
      integer len
      integer ar(len),iar(len)
      double precision rar(len)

C     Local
C----
      integer pass,count, save
      double precision rsave

      do 5 count=1,len
         iar(count) = count
 5    continue
      do 10 pass=1,len-1
         do 20 count=1,len-pass
            if (ar(count).gt.ar(count+1)) then
               save = ar(count)
               rsave = rar(count)
               ar(count) = ar(count+1)
               rar(count) = rar(count+1)
               ar(count+1) = save
               rar(count+1) = rsave
C     also save the original location of the data items
               save = iar(count)
               iar(count) = iar(count+1)
               iar(count+1) = save
            endif
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Sort integer block on the first component
C----------------------------------------------------------------
      subroutine ibsort(ar,wd,len)

C     Arguments
C----
      integer wd,len
      integer ar(wd,len)

C     Local
C----
      integer pass,count, save1,save2

      do 10 pass=1,len-1
         do 20 count=1,len-pass
            if (ar(1,count).gt.ar(1,count+1)) then
               save1 = ar(1,count)
               save2 = ar(2,count)
               ar(1,count) = ar(1,count+1)
               ar(2,count) = ar(2,count+1)
               ar(1,count+1) = save1
               ar(2,count+1) = save2
            endif
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Shift real sequence
C----------------------------------------------------------------
      subroutine rshift(vec,len,shift)

C     Arguments
C----
      integer len,shift
      double precision vec(*)

C     Local
C----
      integer loc

      if (shift.gt.0) then
         do 10 loc=len,1,-1
            vec(loc+shift) = vec(loc)
 10      continue
      else if (shift.lt.0) then
         do 20 loc=1,len
            vec(loc+shift) = vec(loc)
 20      continue
      endif

      return
      end
C----------------------------------------------------------------
C     Shift integer sequence
C----------------------------------------------------------------
      subroutine ishift(vec,len,shift)

C     Arguments
C----
      integer vec(*),len,shift

C     Local
C----
      integer loc

      if (shift.gt.0) then
         do 10 loc=len,1,-1
            vec(loc+shift) = vec(loc)
 10      continue
      else if (shift.lt.0) then
         do 20 loc=1,len
            vec(loc+shift) = vec(loc)
 20      continue
      endif

      return
      end
C----------------------------------------------------------------
      function elemp(elem,the_loc,vec,len)

C     Arguments
C----
      integer vec(*),len,elem,the_loc
      logical elemp

C     Local
C----
      integer loc

      elemp = .false.
      do 10 loc=1,len
         if (elem.eq.vec(loc)) then
            the_loc = loc
            elemp = .true.
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      function elemv(elem,vec,len)

C     Arguments
C----
      integer vec(*),len,elem
      integer elemv

C     Local
C----
      integer loc

      do 10 loc=1,len
         if (elem.eq.vec(loc)) then
            elemv = loc
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
C     Vector size
C     this includes bordering variables:
C     for dimensioned problems a vector is of the structure
C     (1-bord:ipts+bord) x (1-bord:jpts+bord) x ...
C     for compressed row storage vec_inf(3) contains #local vars;
C     vec_inf(@(vecown)+1,...) tells you which of them are owned.
C----------------------------------------------------------------
      function vector_size(vec_inf)

C     Arguments
C---- 
      integer vector_size,vec_inf(*)
      
C     Functions
C----
      integer problem_dimension

C     Local
C---- 
      integer dim,bord

      vector_size = 0
      if (10*(vec_inf(1)/10).eq.10) then
         bord=vec_inf(vec_inf(5))
         vector_size = 1
         do 10 dim=1,problem_dimension(vec_inf)
            vector_size = 
     >           vector_size * (vec_inf(vec_inf(5)+2+dim-1)+2*bord)
 10      continue
      else
         vector_size = vec_inf(3)
      endif
      call force_range(vector_size,1,0,'Vector size$')

      return
      end
C----------------------------------------------------------------
      function local_problem_size(vec_inf)

C     Arguments
C---- 
      integer local_problem_size,vec_inf(*)
      
C     Functions
C----
      integer problem_dimension

C     Local
C---- 
      integer dim

      local_problem_size = 0
      if (10*(vec_inf(1)/10).eq.10) then
         local_problem_size = 1
         do 10 dim=1,problem_dimension(vec_inf)
            local_problem_size = 
     >           local_problem_size * vec_inf(vec_inf(5)+2+dim-1)
 10      continue
      else
         local_problem_size = vec_inf(2)
      endif

      return
      end
C----------------------------------------------------------------
C
C     Allocation routines
C     
C     Every alloced block is prefixed by a label of length 4.
C     Location 1 is free, 2 doesn't do much either
C     location 3 contains a stamp: 4711, or -4711 for the last block,
C     location 4 contains the size of the block,
C     this makes it possible to traverse the whole memory, pointer chasing.
C
C----------------------------------------------------------------
      subroutine reset_allocation(work,bottom,rwork)

C     Argument
C----
      integer rwork,bottom
      double precision work(*)

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

      top    = bottom
      maxmem = rwork
      if (.not.mem_probe) work(2) = maxmem

      return
      end
C----------------------------------------------------------------
      function alcate(siz,where,work)

C Arguments
C----
      integer siz,alcate
      character*(*) where
      double precision work(*)

C     Allocation tracing
C----
      integer alloc_mode
      common /alc_trace/alloc_mode

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

C Perform allocation and write buffer admin block
C----
      if (.not.mem_probe) then
         work(top+3-1) = 4711
         work(top+4-1) = siz
      endif
      if (mem_trace_val.ge.2) then
         alcate = top+4+siz
         top = top+3*siz+4
      else
         alcate = top+4
         top = top+siz+4
      endif

      if (alloc_mode.ge.1) then
         if (mem_probe) then
            call pd1i1i(where,siz,' probing at:$',alcate)
         else
            call pd1i1i(where,siz,' allocing at:$',alcate)
         endif
      endif

      if (siz.le.0)
     >     call pe1i0('Allocating$',siz,where)

      if (.not.mem_probe) then
         if (top.gt.maxmem) then
            call pe2i('Allocation memory overflow$',maxmem,top)
            call pe01i('(allocating$',where,siz)
            call stop_connections('memory violation$')
         else
            work(top+3-1) = -4711
         endif
      endif

      return
      end
C----------------------------------------------------------------
      function stacktop()

C     Argument
C----
      integer stacktop

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

      stacktop = top

      return
      end
C----------------------------------------------------------------
      function first_open_memloc()

C     Argument
C----
      integer first_open_memloc

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

      first_open_memloc = top+4

      return
      end
C----------------------------------------------------------------
      function needed_memory()

C     Argument
C----
      integer needed_memory

C     Dump quantities
C----
      integer dmp_trace_val
      common /dmp_trace/dmp_trace_val

C     Function
C----
      integer stacktop

      needed_memory = stacktop()-1+4
      if (dmp_trace_val.ge.3)
     >     call pd1i('Memory needed:$',needed_memory)

      return
      end
C----------------------------------------------------------------
      subroutine set_mem_probe(act)

C     Argument
C----
      integer act

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

      mem_probe = act.eq.1

      return
      end
C----------------------------------------------------------------
C     Do a memory test: this detects overwriting of buffer labels
C----------------------------------------------------------------
      subroutine test_memory_array(work_array,where,iwhere,loud)

C     Arguments
C----
      double precision work_array(*)
      character*(*) where
      integer iwhere
      logical loud

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Allocation stack pointer: 
C     first free address & last allocatable & shift wrt base
C---- 
      integer top,maxmem
      common /alloc/top,maxmem
      logical mem_probe
      common /qalloc/mem_probe

C     Local
C----
      integer labloc,sizloc,datloc, size, dum
      double precision tstval1,tstval2
      logical isclean

C     Memory test admin
C----
      logical hastold,hasdump
      common /memtst/hastold,hasdump

      isclean(dum) = abs(work_array(labloc)-dum).lt.0.01

      if (hastold) return

      labloc = 3
      sizloc = 4
 
 10   continue
      if (isclean(-4711)) then
C     succesful completion
         if (loud) call pd1i0(where,iwhere,'Memory ok$')
         goto 30
      else if (mem_trace_val.ge.2) then
         if (.not.isclean(4711)) goto 20
         size = int(work_array(sizloc)+1.d-2)
         datloc = labloc-3+1+4
         call inprod(tstval1,
     >        work_array(datloc),work_array(datloc),size)
         datloc = datloc+2*size
         call inprod(tstval2,
     >        work_array(datloc),work_array(datloc),size)
         if (tstval1.gt.1.e-10 .or. tstval2.gt.1.e-10) then
            call pt1d('Bleed down$',tstval1)
            call pt1d('Bleed up$',tstval2)
            goto 20
         endif
         labloc = labloc+3*size+4
         sizloc = sizloc+3*size+4
         goto 10
      else if (isclean(4711)) then
C     succesful progress
         size = int(work_array(sizloc)+1.d-2)
         labloc = labloc+size+4
         sizloc = sizloc+size+4
         goto 10
      endif

C     Trouble!
C----
 20   continue
      call pe1i(where,iwhere)
      call pe1i1d('>=>=> Corrupted mem block at$',labloc+4-3+1,
     >     '?size?$',work_array(sizloc))
      hastold = .true.
      call dump_memory_array(work_array,top,where,iwhere)

C     Exit
C----
 30   continue

      return
      end
C----------------------------------------------------------------
      subroutine dump_memory_array(work_array,top,where,iwhere)

C     Arguments
C----
      integer top
      double precision work_array(*)
      character*(*) where
      integer iwhere

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Memory test admin
C----
      logical hastold,hasdump
      common /memtst/hastold,hasdump

C     Local
C----
      integer loc,name_length
      character*50 dump_file
      data dump_file
     >     /'                                                  '/

      if (hasdump) return
C     calculate the string length of the full file name
      name_length = 28+3
      call unique_file(dump_file,
     >     'pvm3/examples/cg/local.data/mem.dmp$',name_length)
      call to_tmp_channel(dump_file)
      call pc1i(where,iwhere,tmp_channel)

      do 10 loc=1,top
         write(tmp_channel,*) loc,work_array(loc)
 10   continue

      hasdump = .true.

      return
      end
C----------------------------------------------------------------
      block data init_alloc_reporting

C     Memory test admin
C----
      logical hastold,hasdump
      common /memtst/hastold,hasdump
      data hastold,hasdump/.false.,.false./

      end
C----------------------------------------------------------------
      function irand(num)

C     Arguments
C----
      integer num
      double precision irand

      integer saved_num,seed(4)
      common /rand_save/saved_num,seed

C     Local
C----
      integer count
      double precision dlaran

      if (num.lt.saved_num .or. saved_num.le.0) then
         saved_num = 0
         seed(1) = 1
         seed(2) = 2
         seed(3) = 3
         seed(4) = 5
      endif
      do 10 count=saved_num+1,num
         irand = dlaran(seed)
 10   continue
      saved_num = num

      return
      end
      block data irand_init
      integer saved_num,seed(4)
      common /rand_save/saved_num,seed
      data saved_num/0/
      end
