C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Initialize connectivity and figure out where you are in 
C     the grand scheme of things
C----------------------------------------------------------------
      subroutine demo_read_processor_grid(buffer,nitems,comm_context)

C     Arguments
C----
      integer buffer(*),nitems(1),comm_context(*)
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Communication parameters
C----
      integer lrmode
      common /compar/lrmode

C     Functions
C----
      logical i_input_small,tracer_proc
      logical all_input_small
      
C     Local
C---- 
      integer pdim,dim, ijkp(4),arch

C     If I am the inputting process, read architecture 
C     connectivity information.
C---- 
      if (i_input_small()) then

         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'con.dat',7,'>>> Getting processor grid$')

 10      continue
         lrmode = 0
         arch = 0

         read(inchan,*,end=999) pdim
         read(inchan,*,end=998) (ijkp(dim),dim=1,pdim)

 20      continue

         call close_in_chan('<<< Got proc grid$')

         if (log_channel_open.and.tracer_proc()) then
            write(logchn,*) 
     >           '------------------------------------------'
            write(logchn,*) 'Number of processors in ijkl direction:'
            write(logchn,*) '----',(ijkp(dim),dim=1,pdim)
         endif

         buffer(1) = pdim
         do 30 dim=1,pdim
            buffer(1+dim) = ijkp(dim)
 30      continue

      endif

      nitems(1) = 1+buffer(1)

C     Spread the information to the other processes
C----
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST ijk procs #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST ijk procs data$')
      endif

      return
 999  call pe0('Could not get proc dim$')
      goto 990
 998  call pe0('Not enough proc dims$')
      goto 990
 990  call stop_connections('Demo read proc_grid$')
      return
      end
C----------------------------------------------------------------
C     Read problem format and matrix name if external
C----------------------------------------------------------------
      subroutine demo_read_problem_format(buffer,nitems,cbuffer,
     >     comm_context)

C     Arguments
C----
      integer buffer(*),nitems(1),comm_context(*)
      character*3 cbuffer

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Local
C----
      integer opt,val

C     Functions
C----
      logical i_input_small,trace_setup
      logical all_input_small

C     If I am the inputting process, read problem format
C----
      if (i_input_small()) then
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'fmt.dat',7,'>>> Getting problem format$')
 10      continue
         read(inchan,*,end=20) opt,val
         if (opt.ge.1.and.opt.le.nitems(1)) then
            buffer(opt) = val
         else
            call pe2i('>> Problem format: strange opt/val$',opt,val)
         endif
         goto 10
 20      continue
         if (trace_setup())
     >        call pdai('Format buffer$',buffer,nitems(1))
         call close_in_chan('<< Got format$')

         cbuffer = '   '
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'mat.dat',7,'>>> Getting matrix name$')
         read(inchan,31,end=30) cbuffer
 31      format(a3)
 30      call close_in_chan('<< matrix name$')

      endif

C     Tell the other processes about it
C----
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST problem fmt #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST problem format$')
         if (trace_setup().and..not.i_input_small())
     >        call pdai('Format buffer$',buffer,nitems(1))
         call txspread(cbuffer,3,comm_context,
     >        'BCST matrix name$')
      endif

      return
      end
C----------------------------------------------------------------
C     Read differential equation
C----------------------------------------------------------------
      subroutine demo_read_pde_parameters(ibuf,nitems,buff,ritems,
     >     comm_context)

C     Arguments
C----
      integer ibuf(*),nitems(1),ritems(1),comm_context(*)
      double precision buff(*)
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Functions
C----
      logical i_input_small
      logical all_input_small

C     Local
C---- 
      integer opt,val
      integer funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      data funnum,unsymm,indef/0,0,0/
      data ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
     >     /1.d0,1.d0,0.d0,0.d0,0.d0, 
     >     0.d0,0.d0,0.d0,0.d0/

C     Get function number and parameters
C---- 
      if (i_input_small()) then
         
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'pde.dat',7,'Reading pde parameters$')
         
         write(outchn,*) 
     >        '-------------------------------------------------------'
 10      continue
         read(inchan,*,end=20) opt,val
         if (opt.eq.1) then
            if (log_channel_open) write(logchn,*) '-- Type:',val
            if (val.eq.0) then
               ddx = 1.d0
               ddy = 1.d0
            else if (val.eq.1) then
               if (log_channel_open) write(logchn,*) ' x,y coefficients'
               read(inchan,*) ddx,ddy
               if (log_channel_open) write(logchn,*) '--',ddx,ddy
            else if (val.eq.2) then
               if (log_channel_open) write(logchn,*) 
     >              ' fx=1  for x<sx ; fx=tx for x >= sx'
               if (log_channel_open) write(logchn,*) ' sx and tx'
               read(inchan,*) sx,tx
               if (log_channel_open) write(logchn,*) '--',sx,tx
               if (log_channel_open) write(logchn,*)
     >              ' fy=1  for y<sy ; fy=ty for y >= sy'
               if (log_channel_open) write(logchn,*) ' sy and ty'
               read(inchan,*) sy,ty
               if (log_channel_open) write(logchn,*) '--',sy,ty
            else
               write(outchn,*) '>>>> unrecognized value',val
            endif
         else if (opt.eq.2) then
            unsymm = val
            if (val.eq.0) then
               vx = 0.d0
               vy = 0.d0
            else if (val.eq.1) then
               read(inchan,*) vx,vy
               if (log_channel_open) write(logchn,*) '--',vx,vy
            else
               write(outchn,*) '>>>> unrecognized value',val
            endif
         else if (opt.eq.3) then
            indef = val
            if (val.eq.0) then
               alpha = 0.d0
            else if (val.eq.1) then
              read(inchan,*) alpha
              if (log_channel_open) write(logchn,*) '--',alpha
           else
              write(outchn,*) '>>>> unrecognized value',val
           endif
         else
            write(outchn,*) '>>>> unrecognized option',opt
         endif
         goto 10
 20      continue

         call close_in_chan('<< pde$')
         
         ibuf(1) = funnum
         ibuf(2) = unsymm
         ibuf(3) = indef

         buff(1) = ddx
         buff(2) = ddy
         buff(3) = vx
         buff(4) = vy
         buff(5) = alpha
         buff(6) = sx
         buff(7) = tx
         buff(8) = sy
         buff(9) = ty
         
      endif
      
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST pde #items (int)$')
         call inspread(ibuf,nitems(1),comm_context,
     >        'BCST pde int parameters$')
         call inspread(ritems,1,comm_context,
     >        'BCST pde #items (real)$')
         call dpspread(buff,ritems(1),comm_context,
     >        'BCST pde double parameters$')
      endif

      return
      end
C----------------------------------------------------------------
      subroutine default_pde_parameters(ibuf,nitems,buff,ritems)

C     Arguments
C----
      integer ibuf(*),nitems(1),ritems(1)
      double precision buff(*)

C     Local
C----
      integer funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      nitems(1) = 3

      funnum = 0
      unsymm = 0
      indef = 0

      ibuf(1) = funnum
      ibuf(2) = unsymm
      ibuf(3) = indef
      
      ritems(1) = 9

      ddx = 1.d0
      ddy = 1.d0
      vx = 0.d0
      vy = 0.d0
      alpha = 0.d0
      sx = 1.d0
      tx = 1.d0
      sy = 1.d0
      ty = 1.d0

      buff(1) = ddx
      buff(2) = ddy
      buff(3) = vx
      buff(4) = vy
      buff(5) = alpha
      buff(6) = sx
      buff(7) = tx
      buff(8) = sy
      buff(9) = ty
      
      return
      end
C----------------------------------------------------------------
C     Orthogonal grids only
C----------------------------------------------------------------
      subroutine demo_read_grid_size(ibuf,nitems,comm_context)
      
C     Arguments
C---- 
      integer ibuf(*),nitems(1),comm_context(*)
      
C     Functions
C---- 
      logical i_input_small,trace_setup
      logical all_input_small

C     Read and distribute data
C---- 
      if (i_input_small()) then

         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'siz.dat',7,'>>> Reading domain size$')
         call read_grid_size_line(ibuf,nitems(1))
         call close_in_chan('<< domain$')

      endif

      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST domain size #items$')
         call inspread(ibuf,nitems(1),comm_context,
     >        'BCST domain size data$')
      endif
      if (trace_setup()) call pdai('Demo grid size from siz.dat$',
     >     ibuf,nitems(1))

      return
      end
C----------------------------------------------------------------
      subroutine read_grid_size_line(ibuf,buf_len)

C     Arguments
C----
      integer ibuf(*),buf_len

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Local
C----
      integer dim,pdim

      pdim = 2
      ibuf(1) = 0
      do 10 dim=1,4
         ibuf(dim) = 1
 10   continue
      read(inchan,*,end=99) (ibuf(dim),dim=1,pdim)
      
      buf_len = pdim

      return
 99   call pt0('Read domain size: not enough sizes$')
      call stop_connections('read grid size line$')
      end
C----------------------------------------------------------------
C     Initialize iterative method
C----------------------------------------------------------------
      subroutine get_iteration_parameters(buffer,nitems,cbuffer,
     >     precis,comm_context)

C     Arguments
C----
      integer nitems(1),buffer(*),comm_context(*)
      character*(*) cbuffer
      double precision precis(1)
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Local
C---- 
      integer opt,val

C     Functions
C----
      logical i_input_small,trace_setup
      logical all_input_small
      
C     If I am the inputting process, read the definition
C     of the iterative method
C---- 
      if (i_input_small()) then
         
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'itr.dat',7,'>>> Getting iterative method$')
 98      continue
         read(inchan,*,end=99) opt,val
         if (opt.eq.16) then
            read(inchan,*,end=97) precis(1)
         else if (opt.gt.0.and.opt.le.nitems(1)) then
            buffer(opt) = val
            if (opt.eq.1) then
               buffer(2) = 0
               buffer(3) = 0
               buffer(4) = 0
               buffer(7) = 0
               buffer(8) = 0
               buffer(10) = 0
               if (val.eq.7) buffer(11) = 1
            endif
         else
            call pe1i('Iter parm invalid option$',opt)
         endif
         goto 98
 99      continue
         call force_range(buffer(6),0,4000,
     >        'Demo max itr too high$')
         if (trace_setup())
     >        call pdai('Iter buffer$',buffer,nitems(1))
         call close_in_chan('<<< Got iterative method$')
         
      endif
      
C     Tell the other processes about it
C---- 
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST iter #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST iteration parameters$')
         if (trace_setup().and..not.i_input_small())
     >        call pdai('Iter buffer$',buffer,nitems(1))
         call dpspread(precis,1,comm_context,
     >        'BCST it precision$')
      endif
      
C     Get the name of the iterative method
C----
      if (i_input_small()) then
         cbuffer = '                                                  '
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'itn.dat',7,'>>> Getting method name$')
         read(inchan,31,end=30) cbuffer
 31      format(a50)
 30      call close_in_chan('<< method name$')
         if (trace_setup()) call pd1w('Iteration name$',cbuffer)
      endif

C     Tell the other processes about it
C----
      if (.not.all_input_small()) then
         call txspread(cbuffer,50,comm_context,
     >        'BCST method name$')
      endif

      return
 97   continue
      call pe0('No precision value found$')
      call stop_connections('Read iter pars$')
      return
      end
C----------------------------------------------------------------
C     Initialize integer information for preconditioner
C----------------------------------------------------------------
      subroutine read_preconditioner_params(buffer,nitems,cbuffer,
     >     comm_context)

C     Arguments
C----
      integer buffer(*),nitems(1),comm_context(*)
      character*(*) cbuffer
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Local
C---- 
      integer opt,val

C     Functions
C----
      logical i_input_small,trace_setup
      logical all_input_small

C     If I am the inputting process, read the preconditioner definition
C----
      if (i_input_small()) then

         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'prc.dat',7,'>>> Getting preconditioner$')

 20      continue
         read(inchan,*,end=30) opt,val
         if (opt.ge.1.and.opt.le.nitems(1)) then
            buffer(opt) = val
         endif
         goto 20
 30      continue
         if (trace_setup())
     >        call pdai('Prec buffer$',buffer,nitems(1))
         call close_in_chan('<<< Got preconditioners$')

      endif
      
C     Tell the other processes about it
C----
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST prec #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST preconditioner parameters$')
         if (trace_setup().and..not.i_input_small())
     >        call pdai('Prec buffer$',buffer,nitems(1))
      endif
      
C     Get the name of the preconditioner method
C----
      if (i_input_small()) then
         cbuffer = '                                                  '
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'prn.dat',7,'>>> Getting preconditioner name$')
         read(inchan,41,end=40) cbuffer
 41      format(a50)
 40      call close_in_chan('<< Preconditioner name$')
         if (trace_setup()) call pd1w('Prec name$',cbuffer)
      endif

C     Tell the other processes about it
C----
      if (.not.all_input_small()) then
         call txspread(cbuffer,50,comm_context,
     >        'BCST method name$')
      endif

      return
      end
C----------------------------------------------------------------
C     Initialize Tracing
C----------------------------------------------------------------
      subroutine demo_read_trace_modes(buffer,nitems,comm_context)

C     Arguments
C----
      integer buffer(*),nitems(1),comm_context(*)

C     Dump quantities
C----
      integer dmp_trace_val
      common /dmp_trace/dmp_trace_val

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Functions
C---- 
      logical i_input_small
      logical all_input_small
      
C     Local
C---- 
      integer opt,val
 
C     If I am the inputting process, read the trace mode
C---- 
      if (i_input_small()) then
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        'trc.dat',7,'Getting trace modes$')
         
 20      continue
         read(inchan,*,end=30) opt,val
         if (opt.eq.0) then
            call default_trace_modes(buffer,nitems(1))
         else if (opt.ge.1.and.opt.le.nitems(1)) then
            buffer(opt) = val
         endif
         goto 20

 30      continue
 10      continue
         call close_in_chan('<<< Got trace modes$')
         
      endif

C     Tell the other processes about it
C----
      if (.not.all_input_small()) then
         call inspread(nitems,1,comm_context,
     >        'BCST trace #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST trace parameters$')
      endif

      return
      end
