C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: @(version)                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      subroutine default_trace_modes(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems
      
C     Local
C----
      integer loc

      nitems = 13
      do 10 loc=1,nitems
         buffer(loc) = 0
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine report_trace_parms(chan)

C     Argument
C----
      integer chan

C     Allocation tracing
C----
      integer alloc_mode
      common /alc_trace/alloc_mode

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Dump quantities
C----
      integer dmp_trace_val
      common /dmp_trace/dmp_trace_val

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      write(chan,*) '================ Trace'

      write(chan,*) 'Option / value:'
      write(chan,*) ' (negative values give verbose output)'
      write(chan,*) '[2]',
     >     ' Communication trace? 0=none, 1=yes 2=contents'
      write(chan,*) '[3]',
     >     ' Iteration trace? 0=none, 1=error,'
      write(chan,*) '    2=progress, 3=scalars, 4=iterates'
      write(chan,*) '    (-2,-3 for screen output of proc0)'
      write(chan,*) '[4]',
     >     ' Post mortem stats: 0=no, 1=summary '
      write(chan,*) '     2=popup xgraph, 3=matlab'
      write(chan,*) '[5] Trace progress (0/1)'
      write(chan,*) '[6] Screen mode: 0=everyone 1=master node,'
      write(chan,*) '    everyone to file otherwise'
      write(chan,*) '[7] Keep log file: (0/1)'
      write(chan,*) '[8] Dump solution to file: (0/1)'
      write(chan,*) '[9] Dump matrices: (0/1)'
      write(chan,*) '[10] Allocation trace: (0/1)'
      write(chan,*) '[11] Trace file io: (0/1)'
      write(chan,*) '[12] Trace connectivity setup (0/1)'
      write(chan,*) '[13] Trace connectivity setup (0/1)'

      if (parmod.ne.0) write(chan,*) '---- Paragraph:',parmod
      if (com_trace_val.ne.0) write(chan,*) '---- Communication:',
     >     com_trace_val
      if (dmp_trace_val.eq.0) then
         write(chan,*) '---- Numerical Dump: silent'
      else
         write(chan,*) '---- Numerical Dump:',dmp_trace_val 
      endif
      if (progress_mode.ne.0)
     >     write(chan,*) '---- Regular progress check'
      if (mem_trace_val.ge.1)
     >     write(chan,*) '---- Memory checks performed'
      if (mem_trace_val.ge.2) write(chan,*) '     Frequently.'
      if (alloc_mode.ge.1)
     >     write(chan,*) '---- Trace allocation'
      if (logmod.ne.0) write(chan,*) '---- Log file kept'
      if (pmdmod.ne.0) write(chan,*) '---- Post Mortem:',pmdmod
      if (scrmod.ne.0) write(chan,*) '---- Screen:',scrmod
      if (dmpsol.ne.0) write(chan,*) '---- Dumping solution'
      if (matdump_mode.gt.0) write(chan,*) '---- Dumping Matrices'
      if (fio_mode.gt.0) write(chan,*) '---- Tracing file io'
      if (setup_mode.gt.0) write(chan,*) 
     >     '---- Trace connectivity setup'

      return
      end
C----------------------------------------------------------------
      subroutine init_trace_modes(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems(1)
      
C     Allocation tracing
C----
      integer alloc_mode
      common /alc_trace/alloc_mode

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

C     Dump quantities
C----
      integer dmp_trace_val
      common /dmp_trace/dmp_trace_val

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Check if the trace has been initialized yet
C     (we may attempt output before this has happened;
C     in that case test has_trace).
C----
      logical trace_inited
      common /trace_init/trace_inited

C     Functions
C---- 
      logical tracer_proc,trace_solution
      
C     Local
C----
      integer dmp_length,sol_length
      character*50 dmp_file,sol_file

      call force_range(nitems(1),3,-1,'NITtrc #items$')
      parmod = buffer(1)
      com_trace_val = buffer(2)
      dmp_trace_val = buffer(3)
      pmdmod        = buffer(4)
      progress_mode = buffer(5)
      scrmod        = buffer(6)
      logmod        = buffer(7)
      dmpsol        = buffer(8)
      matdump_mode  = buffer(9)
      alloc_mode    = buffer(10)
      mem_trace_val = buffer(13)
      fio_mode      = buffer(11)
      setup_mode    = buffer(12)

      verbos=0
      if (parmod.lt.0) then
         verbos=1
         parmod = -parmod
      endif
      
      call force_range(parmod,0,2,'NITtrc parmod$')
      call force_range(com_trace_val,0,3,'NITtrc com_trace_val$')
      call force_range(dmp_trace_val,0,4,'NITtrc dmpmod$')
      

      call gen_unique_id

C     Generate unique trace / solution file name
C----
      dmp_length = 4
      call unique_file(dmp_file,'dump',dmp_length)
      sol_length = 3
      call unique_file(sol_file,'sol',sol_length)

      err_channel_open = .false.
      if (scrmod.eq.0 .or. (scrmod.eq.1 .and. tracer_proc())) then
C     write to screen
         dmpchn = outchn
         dmp_channel_open = .false.
      else
C     write to file
         call setup_file(dmpchn,
     >        'pvm3/examples/cg/local.data/',28,
     >        dmp_file,dmp_length,'Dump file open$')
         call pd0('=== PVM CG Dump ===$')
         dmp_channel_open = .true.
      endif
      if (trace_solution()) then
         call setup_file(solchn,
     >        'pvm3/examples/cg/local.data/',28,
     >        sol_file,sol_length,'Solution file open$')
         sol_channel_open = .true.
      else
         sol_channel_open = .false.
      endif
      if (tracer_proc().and.logmod.gt.0) then
         call setup_file(logchn,
     >        'pvm3/examples/cg/',17,
     >        'log.dat',7,'Log file open$')
         log_channel_open = .true.
      else
         log_channel_open = .false.
      endif
      if (log_channel_open) call report_trace_parms(logchn)

      trace_inited = .true.

      return
      end
C----------------------------------------------------------------
      block data set_no_trace_yet

      logical trace_inited
      common /trace_init/trace_inited
      data trace_inited/.false./

      end
C----------------------------------------------------------------
C     Generate 4-digit id for this processor
C----------------------------------------------------------------
      subroutine gen_unique_id

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     4-digit string of processor number
C----
      character*5 pnum_string
      common /pnstrbl/pnum_string

C     Local
C----
      integer div,loc,digit
      character*10 nmbers
      data nmbers/'0123456789'/

      div = 1000
      do 99 loc=1,4
         digit = mod(pnum/div,10)+1
         pnum_string(loc:loc) = nmbers(digit:digit)
         div = div/10
 99   continue
c      call pt00('My id:$',pnum_string)

      return
      end
C----------------------------------------------------------------
      subroutine unique_file(file_name,init_name,name_length)

C     Argument
C----
      character*(*) file_name,init_name
      integer name_length

C     4-digit string of processor number
C----
      character*5 pnum_string
      common /pnstrbl/pnum_string

      file_name(1:name_length) = init_name(1:name_length)
      file_name(name_length+1:name_length+4) = pnum_string(1:4)
      name_length = name_length+4

      return
      end
C----------------------------------------------------------------
      block data pnstri
C     4-digit string of processor number
C----
      character*5 pnum_string
      common /pnstrbl/pnum_string
      data pnum_string/'0000$'/
      end
C----------------------------------------------------------------
      function has_trace()

C     Argument
C----
      logical has_trace

C     Check if the trace has been initialized yet
C----
      logical trace_inited
      common /trace_init/trace_inited

      has_trace = trace_inited

      return
      end
C----------------------------------------------------------------
C     Bookkeeping
C----------------------------------------------------------------
      subroutine addflp(n)

C     Argument
C----
      integer n

C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds

      flops(1) = flops(1)+n

      return
      end
C----------------------------------------------------------------
      subroutine addind(n)

C     Argument
C----
      integer n

C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds

      inds(1) = inds(1)+n

      return
      end
C----------------------------------------------------------------
C     Initialize; typically at start of timing loop
C----------------------------------------------------------------
      subroutine zero_flops

C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds
      
      flops(1) = 0
      inds(1) = 0

      return
      end
C----------------------------------------------------------------
C     Accumulate bookkeeping
C----------------------------------------------------------------
      subroutine tally_flops(final_flops,comm_context)

C     Arguments
C----
      double precision final_flops
      integer comm_context(*)

C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds

      integer one(1)
      data one/1/

      call ingsum(flops,one,comm_context)
      final_flops = flops(1)

      return
      end
C----------------------------------------------------------------
C     Print bookkeeping info
C----------------------------------------------------------------
      subroutine prtbkp(chan)

C     Argument
C----
      integer chan

C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds

      write(chan,*) 'Flops:',flops(1)

      return
      end
C----------------------------------------------------------------
C     Initial zeroing
C----------------------------------------------------------------
      block data init_bookkeep
C     Count them flops
C----
      integer flops(1),inds(1)
      common /globcount/flops,inds
      data flops,inds/0,0/
      end
C----------------------------------------------------------------
C Are we the one who's doing the trace?
C----------------------------------------------------------------
      function tracer_proc()

      logical tracer_proc

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      tracer_proc = pnum.eq.0

      return
      end
C----------------------------------------------------------------
C Do we dump the matrices created
C----------------------------------------------------------------
      function trace_matrices()

      logical trace_matrices

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      trace_matrices = matdump_mode.gt.0
      
      return
      end
C----------------------------------------------------------------
C Do we dump gradient history in Matlab format?
C----------------------------------------------------------------
      function matlab_dump()

      logical matlab_dump

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      matlab_dump = pmdmod.eq.1
      
      return
      end
C----------------------------------------------------------------
C Do we dump gradient history in xgraph format?
C----------------------------------------------------------------
      function xgraph_dump()

      logical xgraph_dump

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      xgraph_dump = pmdmod.eq.2
      
      return
      end
C----------------------------------------------------------------
C Do we trace file io
C----------------------------------------------------------------
      function trace_fileio()

      logical trace_fileio

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      trace_fileio = fio_mode.gt.0
      
      return
      end
C----------------------------------------------------------------
C Do we trace the final solution?
C----------------------------------------------------------------
      function trace_solution()

      logical trace_solution

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      trace_solution = dmpsol.eq.1
      
      return
      end
C----------------------------------------------------------------
C Do we trace setup (mostly for crs format)
C----------------------------------------------------------------
      function trace_setup()

      logical trace_setup

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      trace_setup = setup_mode.gt.0
      
      return
      end
C----------------------------------------------------------------
C Do we trace progress (outside of the iterations)
C----------------------------------------------------------------
      function trace_progress()

      logical trace_progress

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

      trace_progress = progress_mode.gt.0
      
      return
      end
C----------------------------------------------------------------
C     Off tracing
C----------------------------------------------------------------
      subroutine otrtxg

C     Tracing the communication
C---- 
      integer com_trace_val
      common /com_trace/com_trace_val

      com_trace_val = 0
      
      return
      end
C----------------------------------------------------------------
C     Channel initialization
C     The dump channel can be set either to the screen channel,
C     or stay on its initial value.
C     In case the dump goes to screen, there is still the 
C     bulk channel aiming at a file
C----------------------------------------------------------------
      block data init_iochannels
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open


      data inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >    tmp_channel,host_channel
     >    /5,6,1,7,11,8,9,10,4/
      data dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open
     >     /.false.,.false.,.false.,.false./


      end
C----------------------------------------------------------------
      subroutine set_file_channels(p_inchan,p_outchn,p_errchn,
     >     p_dmpchn,p_blkchn,p_solchn,p_logchn,p_tmp_channel)

C     Arguments
C----
      integer p_inchan,p_outchn,p_errchn,
     >     p_dmpchn,p_blkchn,p_solchn,p_logchn,p_tmp_channel

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

      inchan = p_inchan
      outchn = p_outchn
      errchn = p_errchn
      dmpchn = p_dmpchn
      blkchn = p_blkchn
      solchn = p_solchn
      logchn = p_logchn
      tmp_channel = p_tmp_channel
      
      return
      end
C----------------------------------------------------------------
C     Switch to the temporaries channel
C----------------------------------------------------------------
      subroutine to_tmp_channel(file_name)

C     Argument
C----
      character*(*) file_name

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Local
C----
      logical trace_fileio

      if (trace_fileio())
     >     call pd1i0('|| Tmp channel to file$',tmp_channel,file_name)

      if (tmp_channel_open) close(tmp_channel)
      open(tmp_channel,file=file_name(1:index(file_name,'$')-1))
      tmp_channel_open = .true.

      return
      end
C----------------------------------------------------------------
C     Open the error channel
C----------------------------------------------------------------
      subroutine open_err_channel

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Local
C----
      integer err_length
      character*50 err_file

      err_length = 3
      call unique_file(err_file,'err',err_length)

      call setup_file(errchn,
     >     'pvm3/examples/cg/local.data/',28,
     >     err_file,err_length,'Error file open$')
      err_channel_open = .true.

      return
      end
C----------------------------------------------------------------
C     Connect the in channel to a file
C----------------------------------------------------------------
      subroutine setup_in_file(path,path_len,local_file,local_len,msg)

C     Arguments
C----
      character*(*) path,local_file,msg
      integer path_len,local_len

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Local
C----
      character*50 file_name

      call setup_file_name(file_name, inchan,
     >     path,path_len,local_file,local_len,msg)
c      open(inchan,file=file_name,status='old')
      open(inchan,file=file_name)

      return
      end
C----------------------------------------------------------------
      subroutine setup_file(chan,
     >     path,path_len,local_file,local_len,msg)

C     Arguments
C----
      character*(*) path,local_file,msg
      integer path_len,local_len, chan

C     Local
C----
      character*50 file_name

      call setup_file_name(file_name, chan,
     >     path,path_len,local_file,local_len,msg)
      open(chan,file=file_name)
      
      return
      end
C----------------------------------------------------------------
      subroutine setup_file_name(file_name,chan,
     >     path,path_len,local_file,local_len,msg)

C     Arguments
C----
      character*(*) file_name,path,local_file,msg
      integer path_len,local_len, chan

C     Local
C----
      logical trace_fileio
      character*50 tmp_name

      if (trace_fileio()) then
         tmp_name = path
         tmp_name(path_len+1:path_len+1) = '$'
         call pd000('||| Setting up channel to path$',tmp_name,' |||$')
         tmp_name = local_file
         tmp_name(local_len+1:local_len+1) = '$'
         call pd000('||| Setting up channel to file$',tmp_name,' |||$')
      endif

      file_name =
     >     '                                                  '
      file_name(1:path_len) = path(1:path_len)
      file_name(path_len+1:path_len+local_len) = local_file(1:local_len)
      file_name(path_len+local_len+1:path_len+local_len+1) = '$'
      if (trace_fileio()) call pd00(msg,file_name)
      if (chan.eq.0) call pe000('Opening unit 0$',file_name,msg)
      file_name(path_len+local_len+1:path_len+local_len+1) = ' '

      return
      end
C----------------------------------------------------------------
      subroutine close_in_chan(msg)

C     Argument
C----
      character*(*) msg

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Function
C----
      logical trace_fileio

      if (trace_fileio()) call pd0(msg)
      if (inchan.eq.0) then
          call pt00('Warning: closing unit 0 for input$',msg)
       else
          close(inchan)
       endif

      return
      end
C----------------------------------------------------------------
C     Close any channels that correspond to open files
C----------------------------------------------------------------
      subroutine close_channels()

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      if (err_channel_open) then
         if (errchn.eq.0) then
            call pt0('Warning: closing unit 0 for error$')
         else
            close(errchn)
         endif
      endif
      if (dmp_channel_open) then
         if (dmpchn.eq.0) then
            call pt0('Warning: closing unit 0 for dump$')
         else
            close(dmpchn)
         endif
      endif
      if (sol_channel_open) then
         if (solchn.eq.0) then
            call pt0('Warning: closing unit 0 for sol$')
         else
            close(solchn)
         endif
      endif
      if (log_channel_open) then
         if (logchn.eq.0) then
            call pt0('Warning: closing unit 0 for log$')
         else
            close(logchn)
         endif
      endif
      if (tmp_channel_open) then
         if (tmp_channel.eq.0) then
            call pt0('Warning: closing unit 0 for tmp$')
         else
            close(tmp_channel)
         endif
      endif

      return
      end
C----------------------------------------------------------------
C Simple output of scalars and texts
C----------------------------------------------------------------
      subroutine pt0(txt)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd0(txt)
      call pc0(txt,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe0(txt)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt

      if (.not.err_channel_open) call open_err_channel

      call pc0(txt,errchn)

      if (dmp_channel_open) call pd0(txt)
      call pt0(txt)

      return
      end
C----------------------------------------------------------------
      subroutine pd0(txt)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*(*) txt

      call pc0(txt,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc0(txt,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer chan
      character*(*) txt

      write(chan,*) pnum,': ',txt(1:index(txt,'$')-1)

      return
      end
C----------------------------------------------------------------
      subroutine pe0c(txt,chr)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt
      character*1 chr

      if (.not.err_channel_open) call open_err_channel

      call pc0c(txt,chr,errchn)

      if (dmp_channel_open) call pd0c(txt,chr)
      call pt0c(txt,chr)

      return
      end
C----------------------------------------------------------------
      subroutine pt0c(txt,chr)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt
      character*1 chr

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd0c(txt,chr)
      call pc0c(txt,chr,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd0c(txt,chr)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*(*) txt
      character*1 chr

      call pc0c(txt,chr,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc0c(txt,chr,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer chan
      character*(*) txt
      character*1 chr

      write(chan,*) pnum,': ',txt(1:index(txt,'$')-1),' <',chr,'>'

      return
      end
C----------------------------------------------------------------
      subroutine pt00(txt1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd00(txt1,txt2)
      call pc00(txt1,txt2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd00(txt1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*(*) txt1,txt2

      call pc00(txt1,txt2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe00(txt1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc00(txt1,txt2,errchn)

      if (dmp_channel_open) call pd00(txt1,txt2)
      call pt00(txt1,txt2)

      return
      end
C----------------------------------------------------------------
      subroutine pc00(txt1,txt2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer chan
      character*(*) txt1,txt2

      if (index(txt2,'$').eq.0) then
         write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >        ' <',txt2,'>'
      else
         write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),'; ',
     >        txt2(1:index(txt2,'$')-1)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine pt000(txt1,txt2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd000(txt1,txt2,txt3)
      call pc000(txt1,txt2,txt3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd000(txt1,txt2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*(*) txt1,txt2,txt3

      call pc000(txt1,txt2,txt3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe000(txt1,txt2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,txt2,txt3

      call pc000(txt1,txt2,txt3,errchn)

      if (dmp_channel_open) call pd000(txt1,txt2,txt3)
      call pt000(txt1,txt2,txt3)

      return
      end
C----------------------------------------------------------------
      subroutine pc000(txt1,txt2,txt3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      character*(*) txt1,txt2,txt3
      integer chan

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),' ',
     >     txt2(1:index(txt2,'$')-1),
     >     txt3(1:index(txt3,'$')-1)

      return
      end
C----------------------------------------------------------------
      subroutine pt1i(txt1,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i(txt1,i1)
      call pc1i(txt1,i1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i(txt1,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1

      if (.not.err_channel_open) call open_err_channel

      call pc1i(txt1,i1,errchn)

      if (dmp_channel_open) call pd1i(txt1,i1)
      call pt1i(txt1,i1)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i(txt1,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1
      character*(*) txt1

      call pc1i(txt1,i1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i(txt1,i1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1

      return
      end
C----------------------------------------------------------------
      subroutine pt1c(txt1,c1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*1 c1
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1c(txt1,c1)
      call pc1c(txt1,c1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1c(txt1,c1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*1 c1
      character*(*) txt1

      call pc1c(txt1,c1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1c(txt1,c1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*1 c1
      character*(*) txt1

      if (.not.err_channel_open) call open_err_channel

      call pc1c(txt1,c1,errchn)

      if (dmp_channel_open) call pd1c(txt1,c1)
      call pt1c(txt1,c1)

      return
      end
C----------------------------------------------------------------
      subroutine pc1c(txt1,c1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      character*1 c1
      integer chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),' <',c1,'>'

      return
      end
C----------------------------------------------------------------
      subroutine pt1w(txt1,w1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,w1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1w(txt1,w1)
      call pc1w(txt1,w1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1w(txt1,w1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      character*(*) txt1,w1

      call pc1w(txt1,w1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1w(txt1,w1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      character*(*) txt1,w1

      if (.not.err_channel_open) call open_err_channel

      call pc1w(txt1,w1,errchn)

      if (dmp_channel_open) call pd1w(txt1,w1)
      call pt1w(txt1,w1)

      return
      end
C----------------------------------------------------------------
      subroutine pc1w(txt1,w1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer chan
      character*(*) txt1,w1

C     Local
C----
      integer count
      character*50 word

      word(1:1) = '<'
      count = 1
 10   continue
      if (w1(count:count).eq.' '.or.count.gt.50-2) goto 20
      word(count+1:count+1) = w1(count:count)
      count = count+1
      goto 10
 20   continue
      count = count+1
      word(count:count) = '>'

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     ' ',word(1:count)

      return
      end
C----------------------------------------------------------------
      subroutine pt01i(txt1,txt2,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd01i(txt1,txt2,i1)
      call pc01i(txt1,txt2,i1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe01i(txt1,txt2,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc01i(txt1,txt2,i1,errchn)

      if (dmp_channel_open) call pd01i(txt1,txt2,i1)
      call pt01i(txt1,txt2,i1)

      return
      end
C----------------------------------------------------------------
      subroutine pd01i(txt1,txt2,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      call pc01i(txt1,txt2,i1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc01i(txt1,txt2,i1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),'; ',
     >     txt2(1:index(txt2,'$')-1),i1

      return
      end
C----------------------------------------------------------------
      subroutine pt02i(txt1,txt2,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd02i(txt1,txt2,i1,i2)
      call pc02i(txt1,txt2,i1,i2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe02i(txt1,txt2,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc02i(txt1,txt2,i1,i2,errchn)

      if (dmp_channel_open) call pd02i(txt1,txt2,i1,i2)
      call pt02i(txt1,txt2,i1,i2)

      return
      end
C----------------------------------------------------------------
      subroutine pd02i(txt1,txt2,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      call pc02i(txt1,txt2,i1,i2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc02i(txt1,txt2,i1,i2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),'; ',
     >     txt2(1:index(txt2,'$')-1),i1,i2

      return
      end
C----------------------------------------------------------------
      subroutine pd03i(txt1,txt2,i1,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2

      call pc03i(txt1,txt2,i1,i2,i3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc03i(txt1,txt2,i1,i2,i3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),'; ',
     >     txt2(1:index(txt2,'$')-1),i1,i2,i3

      return
      end
C----------------------------------------------------------------
      subroutine pt1d(txt1,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      double precision d1
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1d(txt1,d1)
      call pc1d(txt1,d1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1d(txt1,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      double precision d1
      character*(*) txt1

      call pc1d(txt1,d1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1d(txt1,d1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      double precision d1
      character*(*) txt1
      integer chan

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),d1

      return
      end
C----------------------------------------------------------------
      subroutine pt1d2d(txt1,d1,txt2,d2,d3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      double precision d1,d2,d3
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1d2d(txt1,d1,txt2,d2,d3)
      call pc1d2d(txt1,d1,txt2,d2,d3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1d2d(txt1,d1,txt2,d2,d3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      double precision d1,d2,d3
      character*(*) txt1,txt2

      call pc1d2d(txt1,d1,txt2,d2,d3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1d2d(txt1,d1,txt2,d2,d3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      double precision d1,d2,d3
      character*(*) txt1,txt2
      integer chan

      write(chan,*) pnum,': ',
     >     txt1(1:index(txt1,'$')-1),d1,'; ',
     >     txt2(1:index(txt2,'$')-1),d2,d3

      return
      end
C----------------------------------------------------------------
      subroutine pt2d(txt1,d1,d2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      double precision d1,d2
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd2d(txt1,d1,d2)
      call pc2d(txt1,d1,d2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd2d(txt1,d1,d2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      double precision d1,d2
      character*(*) txt1

      call pc2d(txt1,d1,d2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc2d(txt1,d1,d2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      double precision d1,d2
      character*(*) txt1
      integer chan

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),d1,d2

      return
      end
C----------------------------------------------------------------
      subroutine pt3d(txt1,d1,d2,d3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      double precision d1,d2,d3
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd3d(txt1,d1,d2,d3)
      call pc3d(txt1,d1,d2,d3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd3d(txt1,d1,d2,d3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      double precision d1,d2,d3
      character*(*) txt1

      call pc3d(txt1,d1,d2,d3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc3d(txt1,d1,d2,d3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      double precision d1,d2,d3
      integer chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     d1,d2,d3

      return
      end
C----------------------------------------------------------------
      subroutine pt4d(txt1,d1,d2,d3,d4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      double precision d1,d2,d3,d4
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd4d(txt1,d1,d2,d3,d4)
      call pc4d(txt1,d1,d2,d3,d4,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd4d(txt1,d1,d2,d3,d4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      double precision d1,d2,d3,d4
      character*(*) txt1

      call pc4d(txt1,d1,d2,d3,d4,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc4d(txt1,d1,d2,d3,d4,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      double precision d1,d2,d3,d4
      integer chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     d1,d2,d3,d4

      return
      end
C----------------------------------------------------------------
      subroutine pt1i1d(txt1,i1,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      double precision d1
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i1d(txt1,i1,txt2,d1)
      call pc1i1d(txt1,i1,txt2,d1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i1d(txt1,i1,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      double precision d1
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc1i1d(txt1,i1,txt2,d1,errchn)

      if (dmp_channel_open) call pd1i1d(txt1,i1,txt2,d1)
      call pt1i1d(txt1,i1,txt2,d1)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i1d(txt1,i1,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1
      double precision d1
      character*(*) txt1,txt2

      call pc1i1d(txt1,i1,txt2,d1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i1d(txt1,i1,txt2,d1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,chan
      double precision d1
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),d1

      return
      end
C----------------------------------------------------------------
      subroutine pt1i2d(txt1,i1,txt2,d1,d2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      double precision d1,d2
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i2d(txt1,i1,txt2,d1,d2)
      call pc1i2d(txt1,i1,txt2,d1,d2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i2d(txt1,i1,txt2,d1,d2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1
      double precision d1,d2
      character*(*) txt1,txt2

      call pc1i2d(txt1,i1,txt2,d1,d2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i2d(txt1,i1,txt2,d1,d2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,chan
      double precision d1,d2
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),d1,d2

      return
      end
C----------------------------------------------------------------
      subroutine pt2i(txt1,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd2i(txt1,i1,i2)
      call pc2i(txt1,i1,i2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe2i(txt1,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1

      if (.not.err_channel_open) call open_err_channel

      call pc2i(txt1,i1,i2,errchn)

      if (dmp_channel_open) call pd2i(txt1,i1,i2)
      call pt2i(txt1,i1,i2)

      return
      end
c----------------------------------------------------------------
      subroutine pd2i(txt1,i1,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

c     arguments
c----
      integer i1,i2
      character*(*) txt1

      call pc2i(txt1,i1,i2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc2i(txt1,i1,i2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2, chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,i2

      return
      end
C----------------------------------------------------------------
      subroutine pt3i(txt1,i1,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd3i(txt1,i1,i2,i3)
      call pc3i(txt1,i1,i2,i3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd3i(txt1,i1,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1

      call pc3i(txt1,i1,i2,i3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc3i(txt1,i1,i2,i3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3, chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     i1,i2,i3

      return
      end
C----------------------------------------------------------------
      subroutine pt4i(txt1,i1,i2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd4i(txt1,i1,i2,i3,i4)
      call pc4i(txt1,i1,i2,i3,i4,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd4i(txt1,i1,i2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1

      call pc4i(txt1,i1,i2,i3,i4,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc4i(txt1,i1,i2,i3,i4,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4, chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     i1,i2,i3,i4

      return
      end
C----------------------------------------------------------------
      subroutine pt5i(txt1,i1,i2,i3,i4,i5)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4,i5
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd5i(txt1,i1,i2,i3,i4,i5)
      call pc5i(txt1,i1,i2,i3,i4,i5,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd5i(txt1,i1,i2,i3,i4,i5)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3,i4,i5
      character*(*) txt1

      call pc5i(txt1,i1,i2,i3,i4,i5,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc5i(txt1,i1,i2,i3,i4,i5,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4,i5, chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     i1,i2,i3,i4,i5

      return
      end
C----------------------------------------------------------------
      subroutine pt1i0(txt1,i1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i0(txt1,i1,txt2)
      call  pc1i0(txt1,i1,txt2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i0(txt1,i1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      call  pc1i0(txt1,i1,txt2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i0(txt1,i1,txt2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc1i0(txt1,i1,txt2,errchn)

      if (dmp_channel_open) call pd1i0(txt1,i1,txt2)
      call pt1i0(txt1,i1,txt2)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i0(txt1,i1,txt2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1)

      return
      end
C----------------------------------------------------------------
      subroutine pt1i1i(txt1,i1,txt2,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i1i(txt1,i1,txt2,i2)
      call pc1i1i(txt1,i1,txt2,i2,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i1i(txt1,i1,txt2,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      call pc1i1i(txt1,i1,txt2,i2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i1i(txt1,i1,txt2,i2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc1i1i(txt1,i1,txt2,i2,errchn)

      if (dmp_channel_open) call pd1i1i(txt1,i1,txt2,i2)
      call pt1i1i(txt1,i1,txt2,i2)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i1i(txt1,i1,txt2,i2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2

      return
      end
C----------------------------------------------------------------
      subroutine pt1i1i0(txt1,i1,txt2,i2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i1i0(txt1,i1,txt2,i2,txt3)
      call pc1i1i0(txt1,i1,txt2,i2,txt3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i1i0(txt1,i1,txt2,i2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2,txt3

      call pc1i1i0(txt1,i1,txt2,i2,txt3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i1i0(txt1,i1,txt2,i2,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2
      character*(*) txt1,txt2,txt3

      if (.not.err_channel_open) call open_err_channel

      call pc1i1i0(txt1,i1,txt2,i2,txt3,errchn)

      if (dmp_channel_open) call pd1i1i0(txt1,i1,txt2,i2,txt3)
      call pt1i1i0(txt1,i1,txt2,i2,txt3)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i1i0(txt1,i1,txt2,i2,txt3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,chan
      character*(*) txt1,txt2,txt3

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,
     >     ' ; ',txt3(1:index(txt3,'$')-1)

      return
      end
C----------------------------------------------------------------
      subroutine pt1i1i1i(txt1,i1,txt2,i2,txt3,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i1i1i(txt1,i1,txt2,i2,txt3,i3)
      call pc1i1i1i(txt1,i1,txt2,i2,txt3,i3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i1i1i(txt1,i1,txt2,i2,txt3,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3

      call pc1i1i1i(txt1,i1,txt2,i2,txt3,i3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i1i1i(txt1,i1,txt2,i2,txt3,i3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,chan
      character*(*) txt1,txt2,txt3

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,
     >     ' ; ',txt3(1:index(txt3,'$')-1),i3

      return
      end
C----------------------------------------------------------------
      subroutine pt1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4)
      call pc1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2,txt3

      call pc1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i1i2i(txt1,i1,txt2,i2,txt3,i3,i4,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4,chan
      character*(*) txt1,txt2,txt3

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,
     >     ' ; ',txt3(1:index(txt3,'$')-1),i3,i4

      return
      end
C----------------------------------------------------------------
      subroutine ptar(txt1,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer ir
      double precision vr(*)
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pdar(txt1,vr,ir)
      call pcar(txt1,vr,ir,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pdar(txt1,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir
      double precision vr(*)
      character*(*) txt1

      call pcar(txt1,vr,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pcar(txt1,vr,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir, idum, chan
      double precision vr(*)
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     (vr(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pdair(txt1,vr,iv,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir,iv(*)
      double precision vr(*)
      character*(*) txt1

      call pcair(txt1,vr,iv,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pcair(txt1,vr,iv,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir, idum, chan,iv(*)
      double precision vr(*)
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     (vr(iv(idum)),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pt1d1dar(txt1,x1,txt2,x2,txt3,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer ir
      double precision x1,x2,vr(*)
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1d1dar(txt1,x1,txt2,x2,txt3,vr,ir)
      call pc1d1dar(txt1,x1,txt2,x2,txt3,vr,ir,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1d1dar(txt1,x1,txt2,x2,txt3,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir
      double precision x1,x2,vr(*)
      character*(*) txt1,txt2,txt3

      call pc1d1dar(txt1,x1,txt2,x2,txt3,vr,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1d1dar(txt1,x1,txt2,x2,txt3,vr,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir, idum, chan
      double precision x1,x2,vr(*)
      character*(*) txt1,txt2,txt3

      write(chan,*) pnum,': ',
     >     txt1(1:index(txt1,'$')-1),x1,', ',
     >     txt2(1:index(txt2,'$')-1),x2,', ',
     >     txt3(1:index(txt3,'$')-1),
     >     (vr(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pd1dar(txt1,x1,txt2,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir
      double precision x1,vr(*)
      character*(*) txt1,txt2

      call pc1dar(txt1,x1,txt2,vr,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1dar(txt1,x1,txt2,vr,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir, idum, chan
      double precision x1,vr(*)
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',
     >     txt1(1:index(txt1,'$')-1),x1,', ',
     >     txt2(1:index(txt2,'$')-1),
     >     (vr(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pd1iar(txt1,i1,txt2,vr,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir,i1
      double precision vr(*)
      character*(*) txt1,txt2

      call pc1iar(txt1,i1,txt2,vr,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1iar(txt1,i1,txt2,vr,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir,i1, idum, chan
      double precision vr(*)
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,'; ',
     >     txt2(1:index(txt2,'$')-1),
     >     (vr(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pdar1i(txt1,vr,ir,txt2,i1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir,i1
      double precision vr(*)
      character*(*) txt1,txt2

      call pcar1i(txt1,vr,ir,txt2,i1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pcar1i(txt1,vr,ir,txt2,i1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir,i1, idum, chan
      double precision vr(*)
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     (vr(idum),idum=1,ir),
     >     txt2(1:index(txt2,'$')-1),i1

      return
      end
C----------------------------------------------------------------
      subroutine ptai(txt1,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer ir, vi(*)
      character*(*) txt1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pdai(txt1,vi,ir)
      call pcai(txt1,vi,ir,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pdai(txt1,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir, vi(*)
      character*(*) txt1

      call pcai(txt1,vi,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pcai(txt1,vi,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir, idum, vi(*), chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     (vi(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pdaiai(txt1,vi1,ir1,vi2,ir2)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir1,vi1(*), ir2,vi2(*)
      character*(*) txt1

      call pcaiai(txt1,vi1,ir1,vi2,ir2,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pcaiai(txt1,vi1,ir1,vi2,ir2,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir1,vi1(*), ir2,vi2(*), idum,chan
      character*(*) txt1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     (vi1(idum),idum=1,ir1),' //',(vi2(idum),idum=1,ir2)

      return
      end
C----------------------------------------------------------------
      subroutine pt0ai(txt1,txt2,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer ir,vi(*)
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd0ai(txt1,txt2,vi,ir)
      call pc0ai(txt1,txt2,vi,ir,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd0ai(txt1,txt2,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer ir,vi(*)
      character*(*) txt1,txt2

      call pc0ai(txt1,txt2,vi,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc0ai(txt1,txt2,vi,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer ir,vi(*), chan,idum
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),
     >     '; ',txt2(1:index(txt2,'$')-1),(vi(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine pt1iai(txt1,i1,txt2,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,ir,vi(*)
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1iai(txt1,i1,txt2,vi,ir)
      call pc1iai(txt1,i1,txt2,vi,ir,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1iai(txt1,i1,txt2,vi,ir)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,ir,vi(*)
      character*(*) txt1,txt2

      call pc1iai(txt1,i1,txt2,vi,ir,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1iai(txt1,i1,txt2,vi,ir,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,ir,vi(*), chan,idum
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     '; ',txt2(1:index(txt2,'$')-1),(vi(idum),idum=1,ir)

      return
      end
C----------------------------------------------------------------
      subroutine ptiiai(txt1,i1,txt2,i2,txt3,vi3,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,vi3(*), idum
      character*(*) txt1,txt2,txt3

      write(outchn,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,
     >     ' ; ',txt3(1:index(txt3,'$')-1),
     >     (vi3(idum),idum=1,i3)

      return
      end
C----------------------------------------------------------------
      subroutine pt1i2i(txt1,i1,txt2,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i2i(txt1,i1,txt2,i2,i3)
      call pc1i2i(txt1,i1,txt2,i2,i3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i2i(txt1,i1,txt2,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2

      call pc1i2i(txt1,i1,txt2,i2,i3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i2i(txt1,i1,txt2,i2,i3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc1i2i(txt1,i1,txt2,i2,i3,errchn)

      if (dmp_channel_open) call pd1i2i(txt1,i1,txt2,i2,i3)
      call pt1i2i(txt1,i1,txt2,i2,i3)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i2i(txt1,i1,txt2,i2,i3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3, chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,i3

      return
      end
C----------------------------------------------------------------
      subroutine pt1i2i0(txt1,i1,txt2,i2,i3,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i2i0(txt1,i1,txt2,i2,i3,txt3)
      call pc1i2i0(txt1,i1,txt2,i2,i3,txt3,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i2i0(txt1,i1,txt2,i2,i3,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3

      call pc1i2i0(txt1,i1,txt2,i2,i3,txt3,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i2i0(txt1,i1,txt2,i2,i3,txt3)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3

      if (.not.err_channel_open) call open_err_channel

      call pc1i2i0(txt1,i1,txt2,i2,i3,txt3,errchn)

      if (dmp_channel_open) call pd1i2i0(txt1,i1,txt2,i2,i3,txt3)
      call pt1i2i0(txt1,i1,txt2,i2,i3,txt3)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i2i0(txt1,i1,txt2,i2,i3,txt3,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3, chan
      character*(*) txt1,txt2,txt3

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,i3,
     >     ' ; ',txt3(1:index(txt3,'$')-1)

      return
      end
C----------------------------------------------------------------
      subroutine pt1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3
      double precision r1

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1)
      call pc1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3
      character*(*) txt1,txt2,txt3
      double precision r1

      call pc1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i2i1d(txt1,i1,txt2,i2,i3,txt3,r1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3, chan
      character*(*) txt1,txt2,txt3
      double precision r1

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,i3,
     >     ' ; ',txt3(1:index(txt3,'$')-1),r1

      return
      end
C----------------------------------------------------------------
      subroutine pt1i3i(txt1,i1,txt2,i2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd1i3i(txt1,i1,txt2,i2,i3,i4)
      call pc1i3i(txt1,i1,txt2,i2,i3,i4,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe1i3i(txt1,i1,txt2,i2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

c     arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      call pc1i3i(txt1,i1,txt2,i2,i3,i4,errchn)

      if (dmp_channel_open) call pd1i3i(txt1,i1,txt2,i2,i3,i4)
      call pt1i3i(txt1,i1,txt2,i2,i3,i4)

      return
      end
C----------------------------------------------------------------
      subroutine pd1i3i(txt1,i1,txt2,i2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      call pc1i3i(txt1,i1,txt2,i2,i3,i4,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc1i3i(txt1,i1,txt2,i2,i3,i4,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4, chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i2,i3,i4

      return
      end
C----------------------------------------------------------------
      subroutine pt2i1d(txt1,i1,i2,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2
      double precision d1
      character*(*) txt1,txt2

      call pc2i1d(txt1,i1,i2,txt2,d1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pd2i1d(txt1,i1,i2,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2
      double precision d1
      character*(*) txt1,txt2

      call pc2i1d(txt1,i1,i2,txt2,d1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc2i1d(txt1,i1,i2,txt2,d1,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2, chan
      double precision d1
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,i2,
     >     ' ; ',txt2(1:index(txt2,'$')-1),d1

      return
      end
C----------------------------------------------------------------
      subroutine pti2id(txt0,i0,txt1,i1,i2,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2, i0
      double precision d1
      character*(*) txt1,txt2, txt0

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pdi2id(txt0,i0,txt1,i1,i2,txt2,d1)
      call pci2id(txt0,i0,txt1,i1,i2,txt2,d1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pdi2id(txt0,i0,txt1,i1,i2,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2, i0
      double precision d1
      character*(*) txt1,txt2, txt0

      call pci2id(txt0,i0,txt1,i1,i2,txt2,d1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pci2id(txt0,i0,txt1,i1,i2,txt2,d1, chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i0, chan
      double precision d1
      character*(*) txt1,txt2, txt0

      write(chan,11) pnum,txt0(1:index(txt0,'$')-1),i0,
     >     txt1(1:index(txt1,'$')-1),i1,i2,
     >     txt2(1:index(txt2,'$')-1),d1
 11   format(1x,i3,': ',a,' ',i3,' ; ',a,' ',i4,i4,' ; ',
     >     a,' ',e17.10)

      return
      end
C----------------------------------------------------------------
      subroutine ptiid(txt0,i0,txt1,i1,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1, i0
      double precision d1
      character*(*) txt1,txt2, txt0

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pdiid(txt0,i0,txt1,i1,txt2,d1)
      call pciid(txt0,i0,txt1,i1,txt2,d1,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pdiid(txt0,i0,txt1,i1,txt2,d1)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1, i0
      double precision d1
      character*(*) txt1,txt2, txt0

      call pciid(txt0,i0,txt1,i1,txt2,d1,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pciid(txt0,i0,txt1,i1,txt2,d1, chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i0, chan
      double precision d1
      character*(*) txt1,txt2, txt0

      write(chan,11) pnum,txt0(1:index(txt0,'$')-1),i0,
     >     txt1(1:index(txt1,'$')-1),i1,
     >     txt2(1:index(txt2,'$')-1),d1
 11   format(1x,i3,': ',a,' ',i3,' ; ',a,' ',i4,' ; ',
     >     a,' ',e17.10)

      return
      end
C----------------------------------------------------------------
      subroutine pt2i2i(txt1,i1,i2,txt2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      if (dmp_channel_open.and.dmpchn.ne.outchn)
     >     call pd2i2i(txt1,i1,i2,txt2,i3,i4)
      call pc2i2i(txt1,i1,i2,txt2,i3,i4,outchn)

      return
      end
C----------------------------------------------------------------
      subroutine pe2i2i(txt1,i1,i2,txt2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      if (.not.err_channel_open) call open_err_channel

      call pc2i2i(txt1,i1,i2,txt2,i3,i4,errchn)

      if (dmp_channel_open) call pd2i2i(txt1,i1,i2,txt2,i3,i4)
      call pt2i2i(txt1,i1,i2,txt2,i3,i4)

      return
      end
C----------------------------------------------------------------
      subroutine pd2i2i(txt1,i1,i2,txt2,i3,i4)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Arguments
C----
      integer i1,i2,i3,i4
      character*(*) txt1,txt2

      call pc2i2i(txt1,i1,i2,txt2,i3,i4,dmpchn)

      return
      end
C----------------------------------------------------------------
      subroutine pc2i2i(txt1,i1,i2,txt2,i3,i4,chan)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4, chan
      character*(*) txt1,txt2

      write(chan,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,i2,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i3,i4

      return
      end
C----------------------------------------------------------------
      subroutine pt2i3i(txt1,i1,i2,txt2,i3,i4,i5)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Arguments
C----
      integer i1,i2,i3,i4,i5
      character*(*) txt1,txt2

      write(outchn,*) pnum,': ',txt1(1:index(txt1,'$')-1),i1,i2,
     >     ' ; ',txt2(1:index(txt2,'$')-1),i3,i4,i5

      return
      end
