C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
      Program general_node_code
C================================================================
C
C     This is a demo main program.
C     All routines and arrays with names demo_... are supposed
C     to be replaced by constructs from the user program.
C     The output of the demo routines is usually an array of
C     info items that the library needs. It doesn't matter how
C     you generate them, as long as the next routine (usually with
C     a name set_... ) gets them.
C----------------------------------------------------------------
C----
C     vec_inf
C     estimate: 3* #owned vars + #border vars + 10
C----
      integer leng_vec_inf
      parameter (leng_vec_inf=50 000)
      integer vec_inf(leng_vec_inf)

C====
C     mat_ptr; integer information about the matrix
C     mat_idx; indexes for compressed storage
C====
C     for the reader this is mostly dummy
C----
      integer leng_mat_ptr,leng_mat_idx
      parameter (leng_mat_ptr=200,leng_mat_idx=200)
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx)
C----
C     Global information and main memory array
C----
C     In this demo main program we need an array to store
C     the matrix and preconditioner
C----
      integer leng_demo
      parameter (leng_demo=100)
      double precision demo_storage(leng_demo)
      integer demo_matrix,need_matrix

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Functions
C----
      integer first_open_memloc
      
C     Local data and buffers
C----
      integer leng_comm_context
      parameter (leng_comm_context=3*2000+5)
      integer
     >     comm_context(leng_comm_context),
     >     iter_buffer(30),prec_buffer(30)
      double precision iter_prec(1)
      integer niter_items(1),nprec_items(1),nprec_terms,
     >     iter_it,iter_restart,iter_trunc,mod_gramsch,iter_stop
      character*50 iter_name, prec_name
      data  iter_name,prec_name
     >     /'                                                  ',
     >     '                                                  '/
      data niter_items(1),nprec_items(1)/30,30/

C================================================================
C     Initializations
C================================================================
C----------------------------------------------------------------
C     Set file unit numbers,
C     pvm instance numbers,
C     processor grid dimensions
C----------------------------------------------------------------
      call config_initializations(comm_context,leng_comm_context)

      call trace_initializations(comm_context)

      call problem_initializations(vec_inf,comm_context)

      call demo_method_initializations(
     >     iter_buffer,niter_items(1),
     >     prec_buffer,nprec_items(1),nprec_terms,
     >     iter_name,prec_name,
     >     iter_it,iter_restart,iter_trunc,mod_gramsch,
     >     iter_stop,iter_prec,comm_context)

C     Create the matrix
C     For the demo code we need to do some allocation.
C     Actually, most of the routine matrix_creation will not be
C     necesarry in a true application. 
C     Please take only the relevant bits.
C----
      demo_matrix = first_open_memloc()
      need_matrix = leng_demo-demo_matrix+1
      call matrix_creation(demo_storage(demo_matrix),need_matrix,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)

      call close_reader

      end
C================================================================
C     Initialization calls regarding the processors involved
C     and some other global info.
C================================================================
      subroutine config_initializations(comm_context,leng)

C     Arguments
C----
      integer comm_context(*),leng

C     Local
C----
      integer host,reader
      integer buf_len(1)
      integer buffer(30)

C----------------------------------------------------------------
C     File input/output
C
C     In case you let the library do some output, here are the
C     channels to watch. If you want to change the defaults,
C     alter the call to set_file_channels.
C     input: for input from file
C     output: for standard out
C     error: this is where errors get reported
C     dump: for trace dumps
C     bulk: for dumping/restoring stuff (no used)
C     solution: for dumping the final solution to file
C     log: this writes the file `log.dat'
C     temp: for temporary business
C----
      call set_file_channels(5,6,1,7,11,8,9,10)
C----
C     Open communication
C----
C     We get ids of host&reader (for demo only) and node programs
C----
      buf_len(1) = 30
      call demo_read_pvm_instances(buffer,buf_len(1),host,reader)

C     And we store this data in the appropriate internals;
C     the first call is only for the demo
C----
      call demo_init_pvm(host,reader)
      call init_pvm_instances(comm_context,leng,buffer,buf_len(1))

C     by way of example, shift the lowest msg id
C----
c      call set_msgid_range(101,202)
C----
C     How are the processors divided i/j/k/l?
C     This call is optional. Normally processors act as a linear array.
C----
      buf_len(1) = 30
      call demo_read_processor_grid(buffer,buf_len,comm_context)
      call init_processor_grid(buffer,buf_len)

      return
      end
C================================================================
C     Initialization of trace modes (optional)
C================================================================
      subroutine trace_initializations(comm_context)

C     Local
C----
      integer buf_len(1),comm_context(*)
      integer buffer(30)

C----
C     Determine trace mode
C
C     This call is optional. The default behaviour is to do
C     what libraries usually do: keep silent and work.
C----
      call default_trace_modes(buffer,buf_len(1))
      call demo_read_trace_modes(buffer,buf_len(1),comm_context)
      call init_trace_modes(buffer,buf_len(1))

      return
      end
C================================================================
C     Initialization of the way the matrix is stored.
C================================================================
      subroutine problem_initializations(vec_inf,comm_context)

C     Arguments
C----
      integer vec_inf(*),comm_context(*)

C     Local
C----
      integer buf_len(1),buffer(30),
     >     fmt,fmt_spec,sym_store
      character*3 cbuffer

C----
C     Storage format and read/create matrix; first demo data
C----
      call default_problem_format(buffer,buf_len(1))
      call demo_default_problem_format(buffer(5+1),5+1,buf_len(1))
      call demo_read_problem_format(buffer,buf_len(1),cbuffer,
     >     comm_context)
      call set_demo_matrix_file(cbuffer)
      call demo_set_problem_format(buffer(5+1),5+1,buf_len(1))
      buf_len(1) = min(buf_len(1),5)

C     For the library
C----
      fmt = buffer(1)
      fmt_spec = buffer(2)
      sym_store = buffer(3)
      if (fmt.eq.3) then
         call set_compress_format(vec_inf,fmt_spec,sym_store)
      else if (fmt.eq.2) then
         call set_diag_format(vec_inf,sym_store)
      else if (fmt.eq.1) then
         call set_grid_format(vec_inf,fmt_spec,sym_store)
      endif

      return
      end
C================================================================
C     For matrices generated internally (at the moment
C     only 2d grids-based), get the values of the elliptic PDE
C================================================================
      subroutine pde_initialization(comm_context)

C     Local
C----
      integer ibuffer(30),nitems(1),ritems(1),
     >     comm_context
      double precision rbuffer(30)

C----
C     PDE parameters
C     (only necessary for internally generated test matrices)
C
C     3 integer items
C     buffer(1) : function number 0=Poisson 2=step function
C     buffer(2) : unsymmetry 0=no 1=yes
C     buffer(3) : indefiniteness 0=no 1=yes
C     9 real parameters
C     ddx / ddy : diffusion coefficients
C     vx / vy : convection coefficients
C     alpha : amount identity subtracted from diagonal
C     sx / tx : location / height of step in x direction
C     sy / ty : same for y
C----
      call default_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1))
      call demo_read_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1),comm_context)

      return
      end
C================================================================
C     Initialization of parameters determining
C     iterative method and preconditioner;
C     for demo purposes only
C     (this mostly reads the method/prec names and the precision)
C================================================================
      subroutine demo_method_initializations(
     >     iter_buffer,niter_items,
     >     prec_buffer,nprec_items,nprec_terms,
     >     cbuffer1,cbuffer2,
     >     maxit,restart,trunc,mod_gramsch,
     >     stop_test,precision,comm_context)

C     Arguments
C----
      integer niter_items(1),nprec_items(1),nprec_terms,
     >     maxit,restart,trunc,mod_gramsch, stop_test,comm_context(*)
      integer iter_buffer(*),prec_buffer(*)
      character*(*) cbuffer1,cbuffer2
      double precision precision(1)

C----
C     Iteration parameters
C----
      niter_items(1) = 30
      call default_iteration_parameters(iter_buffer,niter_items(1),
     >     cbuffer1,precision(1))
      call get_iteration_parameters(iter_buffer,niter_items(1),
     >     cbuffer1,precision(1),comm_context)
      restart = iter_buffer(12)
      trunc   = iter_buffer(5)
      maxit   = iter_buffer(6)
      stop_test = iter_buffer(14)
      mod_gramsch = iter_buffer(4)

C----
C     Preconditioner parameters
C----
      call default_preconditioner_params(prec_buffer,nprec_items(1))
      call read_preconditioner_params(prec_buffer,nprec_items(1),
     >     cbuffer2,comm_context)
      nprec_terms = prec_buffer(3)

      return
      end
C================================================================
C     Create the matrix
C
C     Most of the actions here are only for the demo code.
C     
C     Explanation of problem formats:
C     Grid format = 10*(vec_inf(1)/10).eq.10
C     Diagonal format = 10*(vec_inf(1)/10).eq.20
C     Compress format = 10*(vec_inf(1)/10).eq.30
C     Matrix source (demo only):
C     Matrix internally generated = mat_source.eq.1
C     Matrix externally loaded = mat_source.eq.2
C
C================================================================
      subroutine matrix_creation(matrix,leng_mat,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)

C     Arguments
C----
      integer leng_mat,leng_mat_ptr,leng_mat_idx, leng_vec_inf
      double precision matrix(leng_mat)
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx),
     >     vec_inf(leng_vec_inf),comm_context(*)

C     The problem format.
C----
      integer              mat_source,rhs_source
      common /demo_prbfmt/ mat_source,rhs_source

C     Functions
C----
      logical trace_setup,tracer_proc

C     Local
C----

C----
C     Internally generated grid matrix
C----
      if (10*(vec_inf(1)/10).eq.10.and.mat_source.eq.1) then
C     Divide the domain over the processors
C----
         if (tracer_proc()) call pt0('Internal Grid Matrix$')
         call demo_int_grid_mat(matrix,leng_mat,
     >        mat_ptr,vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif

C----
C     Grid matrix from file
C----
      if (10*(vec_inf(1)/10).eq.10.and.mat_source.eq.2) then
         if (tracer_proc()) call pt0('External Grid Matrix$')
         call demo_ext_grid_mat(matrix,leng_mat,
     >        mat_ptr,vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif

C----
C     From file, compressed row or column or diagonal format
C----
      if ((10*(vec_inf(1)/10).eq.30.or.10*(vec_inf(1)/10).eq.20)
     >     .and.mat_source.eq.2) then
         if (tracer_proc()) call pt0('External unstructured Matrix$')
         call demo_ext_unst_mat(matrix,leng_mat,
     >        mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >        vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif


      return
      end
