C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     
C     Compressed Row Storage routines
C     
C     The structure of a compressed vector is as follows.
C     vec_inf(vec_inf(6)...): list of global numbers of the local
C     problem variables. The owned variables are the initial segment of
C     this, so vec_inf(vec_inf(5)) is always one.
C
C================================================================
C----------------------------------------------------------------
C     Local to global numbering map
C----------------------------------------------------------------
      function crs_lc2glb(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), crs_lc2glb

      crs_lc2glb = vec_inf(vec_inf(6)-1+num)

      return
      end
C----------------------------------------------------------------
      function glob2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), glob2loc

C     Local
C----
      integer step

      glob2loc = -1
      do 10 step=1,vec_inf(3)
         if (num.eq.vec_inf(vec_inf(6)-1+step)) then
            glob2loc = step
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
C     Local owned to local numbering map
C----------------------------------------------------------------
      function own2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), own2loc

      if (num.eq.0) then
         own2loc = 0
      else
         own2loc = vec_inf(2+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Local border to local numbering map
C----------------------------------------------------------------
      function brd2loc(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), brd2loc

      if (num.eq.0) then
         brd2loc = 0
      else
         brd2loc = vec_inf(
     >        vec_inf(6)+vec_inf(2)-1+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Local border to global numbering map
C----------------------------------------------------------------
      function brd2glb(num,vec_inf)

C     Arguments
C----
      integer num, vec_inf(*), brd2glb

      if (num.eq.0) then
         brd2glb = 0
      else
         brd2glb = vec_inf(vec_inf(6)-1+vec_inf(2)-1+num)
      endif

      return
      end
C----------------------------------------------------------------
C     Test whether (global) variable is owned
C----------------------------------------------------------------
      function isownv(loc,num,vec_inf)
      
C     Arguments
C---- 
      logical isownv
      integer loc,num,vec_inf(*)
      
C     Local
C---- 
      integer idum
      
      isownv = .false.
      do 110 idum=1,vec_inf(2)
         if (num.eq.vec_inf(vec_inf(6)-1+idum)) then
            isownv = .true.
            loc = idum
            return
         endif
 110  continue
      
      return
      end
C----------------------------------------------------------------
C     Test whether (global) variable is bordering
C     (including owned; use previous routine to filter out that case)
C     (this walks through all local vars; this way it can be used
C     to remap the bordvars themselves)
C----------------------------------------------------------------
      function isbrdv(loc,num,vec_inf)
      
C     Arguments
C---- 
      logical isbrdv
      integer loc,num, vec_inf(*)

C     Has this matrix been remapped?
C----
      integer crs_remap
      common /crs_remapb/crs_remap
      
C     Local
C---- 
      integer idum
      
         isbrdv = .false.
         do 120 idum=1,vec_inf(3)
            if (num.eq.vec_inf(vec_inf(6)-1+idum)) then
               isbrdv = .true.
               loc = idum
               return
            endif
 120     continue
      
      return
      end
C----------------------------------------------------------------
C     Location of rows; both in mat_ptr and matrix
C----------------------------------------------------------------
      subroutine crs_get_pointer(loc,len, var,mat_ptr)

C     Arguments
C----
      integer loc,len, var,mat_ptr(*)

      loc = mat_ptr(var)
      len = mat_ptr(var+1)-loc

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_part(first,last, var,
     >          vec_inf,mat_ptr,part)

C     Arguments
C----
      integer first,last, var,vec_inf(*),mat_ptr(*), part

      if (part.eq.0) then
         first = mat_ptr(var)
         last = mat_ptr(var+1)-1
      else if (part.eq.1) then
         first = mat_ptr(var)
         last = mat_ptr(var)
     >        +mat_ptr(1*vec_inf(2)+2+var-1)-2
      else if (part.eq.2) then
         first = mat_ptr(var)
     >        +mat_ptr(1*vec_inf(2)+2+var-1)-1
         last = mat_ptr(var+1)-1
      endif

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_all(first,last, var,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*)

      first = mat_ptr(var)
      last = mat_ptr(var+1)-1

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_own(first,last, var,
     >          vec_inf,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*),vec_inf(*)

      first = mat_ptr(var)
      last = mat_ptr(var)
     >     +mat_ptr(1*vec_inf(2)+2+var-1)-2

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_row_brd(first,last, var,
     >          vec_inf,mat_ptr)

C     Arguments
C----
      integer first,last, var,mat_ptr(*),vec_inf(*)

      first = mat_ptr(var)
     >     +mat_ptr(1*vec_inf(2)+2+var-1)-1
      last = mat_ptr(var+1)-1

      return
      end
C----------------------------------------------------------------
      subroutine crs_get_ir_pointer(iloc,rloc,len, var,mat_ptr)

C     Arguments
C----
      integer iloc,rloc,len, var,mat_ptr(*)

      iloc = mat_ptr(var)
      len  = mat_ptr(var+1)-iloc
      rloc = iloc

      return
      end
C----------------------------------------------------------------
      function compute_nnzero_cprs(mat_ptr,vec_inf)

C     Arguments and whatever
C----
      integer mat_ptr(*),vec_inf(*),compute_nnzero_cprs,
     >     first,last,var

      compute_nnzero_cprs = 0
      do 10 var=1,vec_inf(2)
         call crs_get_row_all(first,last,var,mat_ptr)
         compute_nnzero_cprs = compute_nnzero_cprs+last-first+1
 10   continue
      
      return
      end
C----------------------------------------------------------------
C     Get element from column 'elt' out of row 'var'. Amazingly enough
C     this does not rely on sorting the indices.
C----------------------------------------------------------------
      subroutine crs_element_from_row(rdi,idi,
     >      var,elt, matrix,mat_ptr,mat_idx)

C     Arguments
C----
      integer idi, var,elt, mat_ptr(*),mat_idx(*)
      double precision rdi, matrix(*)

C     Local
C----
      integer iloc,rloc,len, col

      call crs_get_ir_pointer(iloc,rloc,len,var,mat_ptr)
      
      rdi = 0.d0
      idi = -1
      do 10 col=1,len
         if (mat_idx(iloc+col-1).eq.elt) then
            rdi = matrix(rloc+col-1)
            idi = col
            goto 20
         endif
 10   continue
 20   continue

      return
      end
C----------------------------------------------------------------
      subroutine crs_element_loc_from_row(idi,
     >      var,elt, mat_ptr,mat_idx)

C     Arguments
C----
      integer idi, var,elt, mat_ptr(*),mat_idx(*)

C     Local
C----
      integer iloc,len, col

      call crs_get_pointer(iloc,len,var,mat_ptr)
      
      idi = -1
      do 10 col=1,len
         if (mat_idx(iloc+col-1).eq.elt) then
            idi = col
            goto 20
         endif
 10   continue
 20   continue

      return
      end
C----------------------------------------------------------------
C     Get the matrix diagonal, or at least its location
C----------------------------------------------------------------
      subroutine extract_diagonal_loc(dloc,bdlc,
     >     vec_inf,mat_ptr,mat_idx)

C     Arguments
C----
      integer dloc(*),bdlc(*),
     >     vec_inf(*),mat_ptr(*),mat_idx(*)

C     Local
C----
      integer row,grow,col, first,last
      
      do 10 row=1,vec_inf(2)
         grow = vec_inf(vec_inf(6)-1+row)
         call crs_get_row_own(first,last,row,vec_inf,mat_ptr)
         do 20 col = first,last
            if (vec_inf(vec_inf(6)-1+mat_idx(col)).eq.grow) then
               dloc(row) = col-first+1
               goto 21
            endif
 20      continue
 21      continue
         call crs_get_row_brd(first,last,row,vec_inf,mat_ptr)
         if (vec_inf(vec_inf(6)-1+mat_idx(last)).lt.grow) then
            bdlc(row) = last-first+2
         else
            bdlc(row) = -1
            do 30 col = first,last
               if (vec_inf(vec_inf(6)-1+mat_idx(col)).gt.grow) then
                  bdlc(row) = col-first+1
                  goto 31
               endif
 30         continue
 31         continue
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine extract_cprs_matrix_diagonal
     >     (xtr,dloc,matrix,mat_ptr,vec_inf)

C     Arguments
C----
      integer dloc(*),mat_ptr(*),vec_inf(*)
      double precision xtr(*),matrix(*)

C     Local
C----
      integer row,rfirst,dum

      do 10 row=1,vec_inf(2)
         call crs_get_pointer(rfirst,dum,row,mat_ptr)
         xtr(row) = matrix(rfirst+dloc(row)-1)
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine local_max_connections(maxc,vec_inf,mat_ptr)

C     Arguments
C----
      integer maxc,vec_inf(*),mat_ptr(*)

C     Local
C----
      integer row,locvar,loc,len

      maxc = -1
      do 10 row=1,vec_inf(2)
         locvar = row
         call crs_get_pointer(loc,len,locvar,mat_ptr)
         maxc = max(len-1,maxc)
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump a Compressed Row Storage matrix
C----------------------------------------------------------------
      subroutine dump_matx_cprs(matrix,mat_ptr,mat_idx,vec_inf)

C     Arguments
C----
      integer mat_ptr(*),mat_idx(*),vec_inf(*)
      double precision matrix(*)

C     Local
C----
      integer own,var,glb,col,oth, ifirst,rfirst,rowlen

      do 10 own=1,vec_inf(2)
         var = own
         glb = vec_inf(vec_inf(6)-1+var)
         call crs_get_ir_pointer(ifirst,rfirst,rowlen, var,mat_ptr)
         do 20 col=1,rowlen
            oth = vec_inf(vec_inf(6)-1+mat_idx(ifirst+col-1))
            if (oth.eq.glb)
     >           call pdiid('matdia$',0,
     >           'var:$',glb, 'val:$',matrix(rfirst+col-1))
 20      continue
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump an indirect vector to outchn
C----------------------------------------------------------------
      subroutine dump_vector_i(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar

      do 10 ivar=1,vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',vec_inf(vec_inf(6)-1+ivar),
     >        'val:$',x(ivar))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Dump border vars
C----------------------------------------------------------------
      subroutine dump_border_i(x,vec_inf, txt,itxt)

C     Arguments
C---- 
      integer itxt,vec_inf(*)
      character*(*) txt
      double precision x(*)

C     Local
C----
      integer ivar,brd2glb,brd2loc

      do 10 ivar=1,vec_inf(3)-vec_inf(2)
         call pdiid(txt,itxt,
     >        'var:$',brd2glb(ivar,vec_inf),
     >        'val:$',x(brd2loc(ivar,vec_inf)))
 10   continue

      return
      end
C----------------------------------------------------------------
C     Read an indirect vector
C----------------------------------------------------------------
      subroutine load_global_vector_i(x,vec_inf,itmp)

C     Arguments
C---- 
      integer vec_inf(*),itmp(*)
      double precision x(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Functions
C----
      integer own2loc

C     Local
C----
      integer ivar,file_vars,my_var,local_vars,total
      double precision val

      local_vars = vec_inf(2)

C     How many variables are there? 
C     Check this against what we know
C----
      read(inchan,*,end=99) file_vars
      total = vec_inf(4)
      call force_range(file_vars,total,total,
     >     'Load Global Vector; wrong #vars$')

C     First determine what global numbers we need:
C     convert locally owned numbers and sort them
C----
      do 10 ivar=1,local_vars
         itmp(ivar) = vec_inf(vec_inf(6)-1+ivar)
 10   continue
      call isort(itmp,local_vars)

C     Read global number and value;
C     if this is for us, store it
C----
      my_var = 1
      do 20 ivar=1,file_vars
         read(inchan,*,end=98) val
         if (ivar.eq.itmp(my_var)) then
            x(own2loc(my_var,vec_inf)) = val
            if (my_var.lt.local_vars) my_var=my_var+1
         endif
 20   continue

      return
 99   call pe0('>>>> Load Global: no first line found $')
      call stop_connections('load global vector$')
      return
 98   call pe1i('>>>> Load Global: eof at variable$',ivar)
      call stop_connections('load global vector$')
      return
      end
