C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
C     Store information about global grid size,
C     and partition the problem
C----------------------------------------------------------------
      subroutine set_global_domain(vec_inf,ibuf,nitems,leng_vec_inf)

C     Arguments
C----
      integer vec_inf(*),ibuf(*),nitems(1),leng_vec_inf

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi


C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Function
C----
      integer no_processors

C     Local
C----
      integer dim,totvrs

C     Set a default value for the size of the border
C----
      if (no_processors().eq.1) then
         vec_inf(vec_inf(5)) = 0
      else
         vec_inf(vec_inf(5)) = 1
      endif

      call force_range(nitems(1),2,2,
     >      'Only 2D problems allowed, illegal dim=$')

C     Based on the problem dimension, we can start constructing
C     the vec_inf descriptor vector
C----
      vec_inf(6) = 10
      vec_inf(5) = vec_inf(6)+3*nitems(1)
      vec_inf(7) = vec_inf(5)+nitems(1)+5
      vec_inf(vec_inf(5)+1) = nitems(1)

C     Store this as global information
C----
      call iicopy(vec_inf(vec_inf(5)+2),ibuf,vec_inf(vec_inf(5)+1))
      call iicopy(vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+1))

C     Set total number of variables
C----
      totvrs = 1
      do 20 dim=1,vec_inf(vec_inf(5)+1)
         if (vec_inf(vec_inf(5)+2+dim-1).eq.0) then
            call pe1i('Set global: found zero dimension$',dim)
         else
            totvrs = totvrs
     >           *vec_inf(vec_inf(5)+2+dim-1)
         endif
 20   continue
      call force_range(totvrs,1,-1,'Set dom siz: #points$')
      call force_range(vec_inf(vec_inf(5)),0,-1,'Set dom siz: border$')
      call set_global_variables(totvrs,vec_inf)

      if (dmp_channel_open) then
         call report_domain(vec_inf,dmpchn)
      endif

      return
      end
C----------------------------------------------------------------
      subroutine report_domain(vec_inf,chan)

C     Argument
C----
      integer vec_inf(*),chan

C     Local
C----
      integer dim

      dim = vec_inf(vec_inf(5)+1)

      write(chan,*) '================ Tensor product grid'
      call pc1iai('Global Sizes @$',vec_inf(6)+2*vec_inf(vec_inf(5)+1),
     >     'value$',vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     dim,chan)
      call pc1iai('Local near @$',vec_inf(6),
     >     'value$',vec_inf(vec_inf(6)),
     >     dim,chan)
      call pc1iai('Local far @$',vec_inf(6)+vec_inf(vec_inf(5)+1),
     >     'value$',vec_inf(vec_inf(6)+vec_inf(vec_inf(5)+1)),
     >     dim,chan)

      return
      end
C----------------------------------------------------------------
C     Convert local (i,j) coordinate to global number;
C     assume fortran storage
C----------------------------------------------------------------
      function grd_lc2glb(i,j,vec_inf)

C     Arguments
C----
      integer i,j, grd_lc2glb,vec_inf(*)

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size

      
      grd_lc2glb = (vec_inf(vec_inf(6)-1+2)-1+j-1)
     >     *vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)-1+1)
     >     + vec_inf(vec_inf(6)-1+1)-1+i

      return
      end
