/*===============================================================*
*                                                                *
*     This file is part of the                                   *
*     Distributed Iterative Systems Solvers library              *
*     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              *
*                                                                *
*     Current version: 0.9                                       *
*     This file last generated 94/11/04                          *
*                                                                *
*================================================================*/
#include "cg_headers.h"

void GET_2D_VECTOR(di, dj, cnt)
int  *di;
int  *dj;
int  *cnt;
{
   double *work; int size;

   size = *di * *dj;
/* printf("Mallocing %d\n",size);*/
   work = (double *) malloc( size * sizeof (*work) );
   GET_2D_VECTOR_INNER(
    work, di,dj, cnt
    );
   free(work);
}

void HARBO_MATRIX_FROM_FILE(mat, need, ptr, idx, cnt, iv, chn, row, zro, flg)
double  *mat;
int  *need;
int  *ptr;
int  *idx;
int  *cnt;
int  *iv;
int  *chn;
int  *row;
int  *zro;
int  *flg;
{
   double *work_val; int *work_idx; int *work_ptr;
      int l_index; int l_work; int l_point;

   l_work = *zro; l_point = 2* *row; l_index = *zro;
   work_val = (double *) malloc( l_work*sizeof(*work_val) );
   work_ptr = (int *) malloc ( l_point*sizeof(*work_ptr) );
   work_idx = (int *) malloc ( l_index*sizeof(*work_idx) );

   HARBO_MATRIX_FROM_FILE_INNER(mat,need,ptr,idx, cnt,iv,
    work_val,work_idx,work_ptr, chn,
    row,zro, &l_point,&l_index,&l_work, flg);

   free(work_val); free(work_idx); free(work_ptr);
}

void DIAG_MATRIX_FROM_FILE(mat, ptr, cnt, iv, chn, row, diag, my_first, my_vars, flg)
double  *mat;
int  *ptr;
int  *cnt;
int  *iv;
int  *chn;
int  *row;
int  *diag;
int  *my_first;
int  *my_vars;
int  *flg;
{
   double *work_val; int l_work;

   l_work = *row;
   work_val = (double *) malloc( l_work*sizeof(*work_val) );

   DIAG_MATRIX_FROM_FILE_INNER(mat,ptr, cnt,iv,
    work_val,&l_work, chn,
    row,diag, my_first,my_vars, flg);

   free(work_val);
}
