C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C----------------------------------------------------------------
      function no_processors()

C     Argument
C----
      integer no_processors

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      no_processors = nproc
      call force_range(nproc,1,0,'Number of procs$')

      return
      end
C----------------------------------------------------------------
      subroutine init_processor_grid(buffer,nitems)

C     Arguments
C----
      integer buffer(*),nitems(1)

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      
C     Functions
C----
      logical trace_progress,has_trace

C     Local
C----
      integer dim

      call force_range(buffer(1),1,2,'Nit proc #dimens$')
      call force_range(nitems(1),1+buffer(1),1+buffer(1),
     >     'Nit Proc Grid #items$')

C     The processor grid dimension is (should be) buffer(1) <= 4
C     Just to make sure, we set the rest of the dimensions to length one.
C----
      pgrid_dimension = 4
      do 10 dim=1,buffer(1)
         pgrid_size(dim) = buffer(1+dim)
 10   continue
      do 20 dim=buffer(1)+1,pgrid_dimension
         pgrid_size(dim) = 1
 20   continue

      if (trace_progress().and.has_trace())
     >     call pdai('Processor grid size (ijkl)$',
     >     pgrid_size,pgrid_dimension)
      call pdai('Grid:$',pgrid_size,pgrid_dimension)

      call force_range(pgrid_size(1),1,1 000,
     >     'Nit Proc Grid #iprocs$')
      call force_range(pgrid_size(2),1,1 000,
     >     'Nit Proc Grid #jprocs$')

      return
      end
C----------------------------------------------------------------
C Close connectivity softly
C----------------------------------------------------------------
      subroutine close_connections

C     Function
C----
      logical trace_progress

C     Local
C----
      integer info

      call close_channels
      if (trace_progress()) call pt0('Component signing off$')
      call pvmfexit(info)

      return
      end
C----------------------------------------------------------------
C Close connectivity brusquely
C----------------------------------------------------------------
      subroutine stop_connections(msg_string)

C     Function
C----
      character*(*) msg_string

C     Local
C----
      integer info

      call close_channels
      call pt00('++ Component terminating:$',msg_string)
      call pt0('++ See local.data/err* for more info ++$')
      call pvmfexit(info)
      stop

      end
C----------------------------------------------------------------
C     Is this me? 
C     Used most of the time as thisme(0): the central process
C----------------------------------------------------------------
      function thisme(testnm)

C     Argument
C----
      logical thisme
      integer testnm

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      thisme = pnum.eq.testnm

      return
      end
C================================================================
C     Generate a msgtype;
C     messages ori->tar are encoded on ori and tar
C     as cnt(other)*max_msg_types+sender
C     
C     Send:       type = msgtyp(ori,tar)
C     
C     Recv:       type = msgtyp(ori,ori)
C     
C================================================================
C----------------------------------------------------------------
C     Type for message between two processors
C     update the counter of the other party,
C     which is < iprocs*jprcs
C----------------------------------------------------------------
      function msgtyp(sender,other)
      
      integer sender,other, msgtyp
      
C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

      if (sender.eq.other) then
         msgtyp = low + msgcnt(other,1)*range + sender
         if (msgtyp.ge.hi.and.hi.gt.low) then
            msgcnt(other,1) = 0
         else
            msgcnt(other,1) = msgcnt(other,1)+1
         endif
      else
         msgtyp = low + msgcnt(other,2)*range + sender
         if (msgtyp.ge.hi.and.hi.gt.low) then
            msgcnt(other,2) = 0
         else
            msgcnt(other,2) = msgcnt(other,2)+1
         endif
      endif
      call force_range(msgtyp,0,-1,'Message type$')

      return
      end
C----------------------------------------------------------------
      subroutine set_msgid_range(origin,top)

C     Argument
C----
      integer origin,top

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Function
C----
      logical tracer_proc

      low = origin
      hi = top
      if (top-origin.lt.10*range .and. tracer_proc())
     >     call pt1i('>>>> Warning: recomended type range at least$',
     >     10*range)

      return
      end
C----------------------------------------------------------------
C Type for broadcast message,
C----------------------------------------------------------------
      function bmsgtp()

      integer bmsgtp

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Local
C----
      integer btyp

      btyp=range-1

      bmsgtp = low + msgcnt(btyp,1)*range+btyp
      if (msgcnt(btyp,1).ge.hi.and.hi.gt.low) then
         msgcnt(btyp,1) = low
      else
         msgcnt(btyp,1) = msgcnt(btyp,1)+1
      endif
      call force_range(bmsgtp,0,-1,'Bcst message type$')

      return
      end
C----------------------------------------------------------------
C Type for special broadcast message (pvm reader mode)
C----------------------------------------------------------------
      function rmsgtp()

      integer rmsgtp

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

C     Local
C----
      integer rtyp

      rtyp=range-2

      rmsgtp = low + msgcnt(rtyp,1)*range+rtyp
      msgcnt(rtyp,1) = msgcnt(rtyp,1)+1
      call force_range(rmsgtp,0,-1,'Reader message type$')

      return
      end
C----------------------------------------------------------------
      function send_type(other)

C     Arguments and such
C----
      integer send_type,msgtyp,other

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      send_type = msgtyp(pnum,other)

      return
      end
C----------------------------------------------------------------
      function recv_type(other)

C     Arguments and such
C----
      integer recv_type,msgtyp,other

C     Global architecture info
C----
      integer
     >     nproc,pnum,blacs_context
      common /iume/
     >     nproc,pnum,blacs_context

      recv_type = msgtyp(other,other)

      return
      end
C----------------------------------------------------------------
      subroutine msgtyp_set_hproc(hproc)

C     Arguments
C----
      integer hproc

C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi

      range = hproc+2

      return
      end
C----------------------------------------------------------------
C     Initialize msg counters
C----------------------------------------------------------------
      block data blcmtp
C     Message bookkeeping
C---- 
      integer msgcnt(0:2000,2),range,low,hi
      common /prtxpr/msgcnt,range,low,hi
      integer totsiz
      parameter (totsiz=2*(2000+1))
      data msgcnt/totsiz*1/
      data low,hi/1,0/
      end
C----------------------------------------------------------------
      block data init_proc_grid

C     Processor grid information
C---- 
      integer 
     >     pgrid_dimension,pgrid_size(4),proc_ijk(4),
     >     buffer_size,buffer_pointers(99),
     >     neighbr_buffer_size
      common /prcgrd/
     >     pgrid_dimension,pgrid_size,proc_ijk,
     >     buffer_size,buffer_pointers,
     >     neighbr_buffer_size
      data pgrid_dimension,pgrid_size
     >     /2,1,1,0,0/

      end

