C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
      Program general_node_code
C================================================================
C
C     This is a demo main program.
C     All routines and arrays with names demo_... are supposed
C     to be replaced by constructs from the user program.
C     The output of the demo routines is usually an array of
C     info items that the library needs. It doesn't matter how
C     you generate them, as long as the next routine (usually with
C     a name set_... ) gets them.
C----------------------------------------------------------------
C----
C     Arrays coming from the user program
C----
C     Rhs and solution vector
C     these are allocated here as parts of a work array
C----
      integer rhs,itv
C----
C     vec_inf
C     estimate: 3* #owned vars + #border vars + 10
C----
      integer leng_vec_inf
      parameter (leng_vec_inf=50 000)
      integer vec_inf(leng_vec_inf)

C====
C     mat_ptr; integer information about the matrix
C     mat_idx; indexes for compressed storage
C====
C----
C     mat_ptr / dimensioned case
C     mat_ptr(matnds) : number of diagonals
C     mat_ptr(matdia,matdia+1,...) : location of diagonals in matrix
C     length = max(matnds,matdia+mat_ptr(matnds)-1)
C     where matnds = number of diagonal
C     matdia = location of first diagonal,
C     stored in common block ortmat_loc
C     mat_ptr / indirect case
C     estimate: #nonzeros and then some
C----
      integer leng_mat_ptr,leng_mat_idx
      parameter (leng_mat_ptr=50 000,leng_mat_idx=120 000)
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx)
C----
C     mat_con / dimensioned case: not needed
C     mat_con / indirect case
C     contains info what goes where / comes from where
C     estimate: 2-3 times the number of bordering variables
C----
      integer leng_mat_con
      parameter (leng_mat_con=20 000)
      integer mat_con(leng_mat_con)
C----
C     prec_inf
C     preconditioner data: location of diagonals
C----
      integer leng_prec_inf
      parameter (leng_prec_inf=11 000)
      integer prec_inf(leng_prec_inf)
C----
C     Global information and main memory array
C----
C     In this demo main program we need an array to store
C     the matrix and preconditioner
C----
      integer leng_demo
      parameter (leng_demo=100 000)
      double precision demo_storage(leng_demo)
      integer demo_matrix,need_matrix
      integer check_alloc, preconditioner

C     Inspect dynamic memory for integrity
C     0=no trace, 1=once/iteration, 2=very often
C----
      integer mem_trace_val
      common /mem_trace/mem_trace_val

C     Functions
C----
      logical trace_matrices,trace_solution,trace_setup,tracer_proc
      integer alcate,first_open_memloc
      
C     Local data and buffers
C----
      integer leng_comm_context
      parameter (leng_comm_context=3*2000+5)
      integer
     >     comm_context(leng_comm_context),
     >     iter_buffer(30),prec_buffer(30)
      double precision iter_prec(1)
      integer niter_items(1),nprec_items(1),nprec_terms,
     >     iter_it,iter_restart,iter_trunc,mod_gramsch,iter_stop
      character*50 iter_name, prec_name
      data  iter_name,prec_name
     >     /'                                                  ',
     >     '                                                  '/
      data niter_items(1),nprec_items(1)/30,30/

C================================================================
C     Initializations
C================================================================
C----------------------------------------------------------------
C     Set file unit numbers,
C     pvm instance numbers,
C     processor grid dimensions
C----------------------------------------------------------------
      call config_initializations(comm_context,leng_comm_context)

      call trace_initializations(comm_context)

      call problem_initializations(vec_inf,comm_context)

      call demo_method_initializations(
     >     iter_buffer,niter_items(1),
     >     prec_buffer,nprec_items(1),nprec_terms,
     >     iter_name,prec_name,
     >     iter_it,iter_restart,iter_trunc,mod_gramsch,
     >     iter_stop,iter_prec,comm_context)

C----
C     Initialize allocation
C----
      call reset_allocation(demo_storage,1,leng_demo)

C     Create the matrix
C     For the demo code we need to do some allocation.
C     Actually, most of the routine matrix_creation will not be
C     necesarry in a true application. 
C     Please take only the relevant bits.
C----
      demo_matrix = first_open_memloc()
      need_matrix = leng_demo-demo_matrix+1
      call matrix_creation(demo_storage(demo_matrix),need_matrix,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)
      if (mem_trace_val.ge.2) then
         call nulv(demo_storage,leng_demo)
         demo_matrix = alcate(need_matrix,
     >        'Matrix 2b read$',demo_storage)
         call matrix_creation(demo_storage(demo_matrix),need_matrix,
     >        mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >        vec_inf,leng_vec_inf,comm_context)
      else
         check_alloc = alcate(need_matrix,
     >        'catch up with read-in matrix$',demo_storage)
         call force_range(check_alloc,demo_matrix,demo_matrix,
     >        'Read CRS matrix in wrong place$')
      endif


C----
C     Create rhs and initial / solution vector
C     demo only
C----
      if (trace_setup().and.tracer_proc())
     >     call pt0('Create rhs,x0$')
      rhs = alcate(vec_inf(2),'RHS$',demo_storage)
      itv = alcate(vec_inf(2),'Solution vector$',demo_storage)
      call unitv(demo_storage(rhs), vec_inf(2))
      call unitv(demo_storage(itv), vec_inf(2))

C----
C     Create and allocate preconditioner;
C     for the types available now this takes work space
C     of the length of one vector. 
C     You are welcome to allocate this statically.
C---- 
      call allocate_preconditioner(preconditioner,
     >     prec_inf,leng_prec_inf, vec_inf,demo_storage,
     >     prec_buffer,nprec_items(1))

C----
C     Iterative method
C----
      if (trace_matrices()) call dump_matrix
     >     (demo_storage(demo_matrix),mat_ptr,mat_idx,vec_inf)
      call test_memory_array(demo_storage,
     >    'Memory test before start method$',-1,tracer_proc())
      call sample_main_program
     >     (demo_storage(demo_matrix),
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     mat_con,leng_mat_con,comm_context,
     >     demo_storage(preconditioner),prec_inf,leng_prec_inf,
     >     demo_storage(itv),demo_storage(rhs),
     >     vec_inf,leng_vec_inf,
     >     iter_buffer,niter_items(1),
     >     prec_buffer,nprec_items(1),nprec_terms,
     >     iter_name,prec_name,iter_it,
     >     iter_restart,iter_trunc,mod_gramsch,
     >     iter_stop,iter_prec
     >     )
c      if (trace_solution())
c     >     call dump_solution(demo_storage(itv),vec_inf)

C     Close communication
C----
      call close_connections

      end
C================================================================
C     Initialization calls regarding the processors involved
C     and some other global info.
C================================================================
      subroutine config_initializations(comm_context,leng)

C     Arguments
C----
      integer comm_context(*),leng

C     Local
C----
      integer host,reader
      integer buf_len(1)
      integer buffer(30)

C----------------------------------------------------------------
C     File input/output
C
C     In case you let the library do some output, here are the
C     channels to watch. If you want to change the defaults,
C     alter the call to set_file_channels.
C     input: for input from file
C     output: for standard out
C     error: this is where errors get reported
C     dump: for trace dumps
C     bulk: for dumping/restoring stuff (no used)
C     solution: for dumping the final solution to file
C     log: this writes the file `log.dat'
C     temp: for temporary business
C----
      call set_file_channels(5,6,1,7,11,8,9,10)
C----
C     Open communication
C----
C     We get ids of host&reader (for demo only) and node programs
C----
      buf_len(1) = 30
      call demo_read_pvm_instances(buffer,buf_len(1),host,reader)

C     And we store this data in the appropriate internals;
C     the first call is only for the demo
C----
      call demo_init_pvm(host,reader)
      call init_pvm_instances(comm_context,leng,buffer,buf_len(1))

C     by way of example, shift the lowest msg id
C----
c      call set_msgid_range(101,202)
C----
C     How are the processors divided i/j/k/l?
C     This call is optional. Normally processors act as a linear array.
C----
      buf_len(1) = 30
      call demo_read_processor_grid(buffer,buf_len,comm_context)
      call init_processor_grid(buffer,buf_len)

      return
      end
C================================================================
C     Initialization of trace modes (optional)
C================================================================
      subroutine trace_initializations(comm_context)

C     Local
C----
      integer buf_len(1),comm_context(*)
      integer buffer(30)

C----
C     Determine trace mode
C
C     This call is optional. The default behaviour is to do
C     what libraries usually do: keep silent and work.
C----
      call default_trace_modes(buffer,buf_len(1))
      call demo_read_trace_modes(buffer,buf_len(1),comm_context)
      call init_trace_modes(buffer,buf_len(1))

      return
      end
C================================================================
C     Initialization of the way the matrix is stored.
C================================================================
      subroutine problem_initializations(vec_inf,comm_context)

C     Arguments
C----
      integer vec_inf(*),comm_context(*)

C     Local
C----
      integer buf_len(1),buffer(30),
     >     fmt,fmt_spec,sym_store
      character*3 cbuffer

C----
C     Storage format and read/create matrix; first demo data
C----
      call default_problem_format(buffer,buf_len(1))
      call demo_default_problem_format(buffer(5+1),5+1,buf_len(1))
      call demo_read_problem_format(buffer,buf_len(1),cbuffer,
     >     comm_context)
      call set_demo_matrix_file(cbuffer)
      call demo_set_problem_format(buffer(5+1),5+1,buf_len(1))
      buf_len(1) = min(buf_len(1),5)

C     For the library
C----
      fmt = buffer(1)
      fmt_spec = buffer(2)
      sym_store = buffer(3)
      if (fmt.eq.3) then
         call set_compress_format(vec_inf,fmt_spec,sym_store)
      else if (fmt.eq.2) then
         call set_diag_format(vec_inf,sym_store)
      else if (fmt.eq.1) then
         call set_grid_format(vec_inf,fmt_spec,sym_store)
      endif

      call dump_problem_format(vec_inf)
      return
      end
C================================================================
C     For matrices generated internally (at the moment
C     only 2d grids-based), get the values of the elliptic PDE
C================================================================
      subroutine pde_initialization(comm_context)

C     Local
C----
      integer ibuffer(30),nitems(1),ritems(1),
     >     comm_context
      double precision rbuffer(30)

C----
C     PDE parameters
C     (only necessary for internally generated test matrices)
C
C     3 integer items
C     buffer(1) : function number 0=Poisson 2=step function
C     buffer(2) : unsymmetry 0=no 1=yes
C     buffer(3) : indefiniteness 0=no 1=yes
C     9 real parameters
C     ddx / ddy : diffusion coefficients
C     vx / vy : convection coefficients
C     alpha : amount identity subtracted from diagonal
C     sx / tx : location / height of step in x direction
C     sy / ty : same for y
C----
      call default_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1))
      call demo_read_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1),comm_context)
      call set_pde_parameters
     >     (ibuffer,nitems(1),rbuffer,ritems(1))

      return
      end
C================================================================
C     Initialization of parameters determining
C     iterative method and preconditioner;
C     for demo purposes only
C     (this mostly reads the method/prec names and the precision)
C================================================================
      subroutine demo_method_initializations(
     >     iter_buffer,niter_items,
     >     prec_buffer,nprec_items,nprec_terms,
     >     cbuffer1,cbuffer2,
     >     maxit,restart,trunc,mod_gramsch,
     >     stop_test,precision,comm_context)

C     Arguments
C----
      integer niter_items(1),nprec_items(1),nprec_terms,
     >     maxit,restart,trunc,mod_gramsch, stop_test,comm_context(*)
      integer iter_buffer(*),prec_buffer(*)
      character*(*) cbuffer1,cbuffer2
      double precision precision(1)

C----
C     Iteration parameters
C----
      niter_items(1) = 30
      call default_iteration_parameters(iter_buffer,niter_items(1),
     >     cbuffer1,precision(1))
      call get_iteration_parameters(iter_buffer,niter_items(1),
     >     cbuffer1,precision(1),comm_context)
      restart = iter_buffer(12)
      trunc   = iter_buffer(5)
      maxit   = iter_buffer(6)
      stop_test = iter_buffer(14)
      mod_gramsch = iter_buffer(4)

C----
C     Preconditioner parameters
C----
      call default_preconditioner_params(prec_buffer,nprec_items(1))
      call read_preconditioner_params(prec_buffer,nprec_items(1),
     >     cbuffer2,comm_context)
      nprec_terms = prec_buffer(3)

      return
      end
C================================================================
C     Create the matrix
C
C     Most of the actions here are only for the demo code.
C     
C     Explanation of problem formats:
C     Grid format = 10*(vec_inf(1)/10).eq.10
C     Diagonal format = 10*(vec_inf(1)/10).eq.20
C     Compress format = 10*(vec_inf(1)/10).eq.30
C     Matrix source (demo only):
C     Matrix internally generated = mat_source.eq.1
C     Matrix externally loaded = mat_source.eq.2
C
C================================================================
      subroutine matrix_creation(matrix,leng_mat,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)

C     Arguments
C----
      integer leng_mat,leng_mat_ptr,leng_mat_idx, leng_vec_inf
      double precision matrix(leng_mat)
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx),
     >     vec_inf(leng_vec_inf),comm_context(*)

C     The problem format.
C----
      integer              mat_source,rhs_source
      common /demo_prbfmt/ mat_source,rhs_source

C     Functions
C----
      logical trace_setup,tracer_proc

C     Local
C----
      integer first_var_of_proc,n_vars_of_proc, nitems(1),
     >     long_buffer(11 000)

C----
C     Internally generated grid matrix
C----
      if (10*(vec_inf(1)/10).eq.10.and.mat_source.eq.1) then
C     Divide the domain over the processors
C----
         if (tracer_proc()) call pt0('Internal Grid Matrix$')
         call demo_int_grid_mat(matrix,leng_mat,
     >        mat_ptr,vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif

C----
C     Grid matrix from file
C----
      if (10*(vec_inf(1)/10).eq.10.and.mat_source.eq.2) then
         if (tracer_proc()) call pt0('External Grid Matrix$')
         call demo_ext_grid_mat(matrix,leng_mat,
     >        mat_ptr,vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif

C----
C     From file, compressed row or column or diagonal format
C----
      if ((10*(vec_inf(1)/10).eq.30.or.10*(vec_inf(1)/10).eq.20)
     >     .and.mat_source.eq.2) then
         if (tracer_proc()) call pt0('External unstructured Matrix$')
         call demo_ext_unst_mat(matrix,leng_mat,
     >        mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >        vec_inf,leng_vec_inf,comm_context,trace_setup())
      endif


C     Declare your own variables
C----
C     Case: diagonal storage, we have a consecutive stretch of vars
C----
      if (10*(vec_inf(1)/10).eq.20) then
         call demo_comp_my_consec
     >        (first_var_of_proc,n_vars_of_proc)
         if (trace_setup())
     >        call pd2i('I have vars from/len$',
     >        first_var_of_proc,n_vars_of_proc)
         call diag_set_owned_stretch
     >        (vec_inf,leng_vec_inf,first_var_of_proc,n_vars_of_proc)
C     Case: row/col compressed, enumerate your variables
C----
      else if (10*(vec_inf(1)/10).eq.30) then
         call demo_comp_my_vars(long_buffer,11 000,nitems(1))
         if (trace_setup())
     >        call pdai('I have vars$',long_buffer,nitems(1))
         call cprs_set_my_vars(vec_inf,leng_vec_inf,
     >        long_buffer,nitems(1))
      endif

      return
      end
C================================================================
      subroutine sample_main_program
     >     (matrix,mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >     mat_con,leng_mat_con,comm_context,
     >     preconditioner,prec_inf,leng_prec_inf,
     >     itv,rhs, vec_inf,leng_vec_inf,
     >     iter_buffer,niter_items,
     >     prec_buffer,nprec_items,nprec_terms,
     >     iter_name,prec_name,max_it,restart,trunc,orthog,
     >     stop_test,precision
     >     )

C     Arguments
C----
      double precision matrix(*),preconditioner(*),itv(*),rhs(*),
     >     precision(1)
      integer leng_vec_inf, leng_mat_ptr,leng_mat_idx,
     >     leng_mat_con,
     >     leng_prec_inf,niter_items(1),nprec_items(1),
     >     max_it,restart,trunc,orthog, stop_test,nprec_terms
      integer mat_ptr(leng_mat_ptr),mat_idx(leng_mat_idx),
     >     mat_con(leng_mat_con),comm_context(*),
     >     prec_inf(*),vec_inf(leng_vec_inf),
     >     iter_buffer(*),prec_buffer(*)
      character*(*) iter_name,prec_name

C     Tracing
C---- 
      integer 
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode
      common /ntrace/
     >     parmod,dmpmod,pmdmod,
     >     verbos,scrmod,dmpsol,logmod,
     >     matdump_mode,fio_mode,setup_mode,
     >     progress_mode

C     Functions
C----
      external demo_var2proc
      integer demo_var2proc
      logical tracer_proc

C     Local
C----
      integer success,nhist,lda_gradhist,
     >     stop_quant,stop_type
      parameter (lda_gradhist=4000)
      double precision grad_hist(lda_gradhist,3),
     >     results(7)
      character*50 test_name

C     Preprocess this matrix for parallelism:
C     Information is written in mat_con; this can be reused later.
C
C     We pass a function describing the var->proc map; this can be
C     a dummy, unless you've declared that such a function exists.
C----
      call process_matrix(matrix,
     >     mat_ptr,leng_mat_ptr, mat_idx, mat_con,leng_mat_con,
     >     comm_context, vec_inf,leng_vec_inf)

C     Create the preconditioner
C----
      test_name = '                                                  '
      test_name(1:4) = 'none'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create none preconditioner <<<<$')
         call creat_prec_none(preconditioner,
     >        prec_inf,leng_prec_inf, 
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:11) = 'full_jacobi'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create full_jacobi preconditioner <<<<$')
         call creat_prec_full_jacobi(preconditioner,
     >        prec_inf,leng_prec_inf, 
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:11) = 'ssor_jacobi'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create ssor_jacobi preconditioner <<<<$')
         call creat_prec_ssor_jacobi(preconditioner,
     >        prec_inf,leng_prec_inf, nprec_terms,
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:10) = 'ilu_jacobi'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create ilu_jacobi preconditioner <<<<$')
         call creat_prec_ilu_jacobi(preconditioner,
     >        prec_inf,leng_prec_inf, nprec_terms,
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:9) = 'full_ssor'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create full_ssor preconditioner <<<<$')
         call creat_prec_full_ssor(preconditioner,
     >        prec_inf,leng_prec_inf, nprec_terms,
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:8) = 'full_ilu'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create full_ilu preconditioner <<<<$')
         call creat_prec_full_ilu(preconditioner,
     >        prec_inf,leng_prec_inf, nprec_terms,
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:8) = 'par_ssor'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create par_ssor preconditioner <<<<$')
         call creat_prec_par_ssor(preconditioner,
     >        prec_inf,leng_prec_inf, 
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:7) = 'par_ilu'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create par_ilu preconditioner <<<<$')
         call creat_prec_par_ilu(preconditioner,
     >        prec_inf,leng_prec_inf, 
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      test_name = '                                                  '
      test_name(1:4) = 'none'
      if (prec_name.eq.test_name) then
         if (tracer_proc())
     >     call pt0('>>>> Create none preconditioner <<<<$')
         call creat_prec_none(preconditioner,
     >        prec_inf,leng_prec_inf, 
     >        matrix,mat_ptr,mat_idx,
     >        mat_con,comm_context,
     >        vec_inf,leng_vec_inf)
         goto 91
      endif
      call set_preconditioner_params(prec_buffer,nprec_items(1))
      if (tracer_proc())
     >     call pt0('>>>> Create general preconditioner <<<<$')
      call creat_preconditioner(
     >     preconditioner,prec_inf,leng_prec_inf,
     >     matrix,mat_ptr,mat_idx,
     >     mat_con,comm_context,
     >     vec_inf,leng_vec_inf)
 91   continue

C     Various iterative methods
C---- 
      stop_quant = iter_buffer(13)
      stop_type  = iter_buffer(14)
      success    = 0
      test_name = '                                                  '
      test_name(1:2) = 'cg'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start CG iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call cg
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:4) = 'cgne'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start CGNE iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call cgne
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:6) = 'minres'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start MINRES iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call minres
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:4) = 'bicg'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start BICG iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call bicg
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:4) = 'nscg'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start NSCG iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call nscg
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results, restart,trunc,orthog
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:5) = 'gmres'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start GMRES iteration <<<<$')
         nhist = 2
         if (pmdmod.eq.0) nhist = 0
         call gmres
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results, restart,trunc,orthog
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:3) = 'qmr'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start QMR iteration <<<<$')
         nhist = 2
         if (pmdmod.eq.0) nhist = 0
         call qmr
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:3) = 'cgs'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start CGS iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call cgs
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
      test_name = '                                                  '
      test_name(1:4) = 'bcgs'
      if (iter_name.eq.test_name) then
         if (tracer_proc())
     >        call pt0('>>>> Start BCGS iteration <<<<$')
         nhist = 1
         if (pmdmod.eq.0) nhist = 0
         call bcgs
     >        (matrix, mat_ptr,mat_idx,mat_con, comm_context,
     >        preconditioner,prec_inf, itv,rhs, vec_inf,
     >        success,precision, max_it,stop_quant,stop_type,
     >        grad_hist,lda_gradhist,nhist,
     >        results
     >        )
         if (tracer_proc()) call pt0('>>>> Finished <<<<$')
         goto 92
      endif
 92   continue

      if (tracer_proc()) then
         if (success.eq.0) then
            write(6,*) 'Convergence in #iterations:',
     >           int(results(2))
         else
            write(6,*) 'No convergence; code',success
         endif
         if (nhist.gt.0)
     >        call file_grad_hist(grad_hist,lda_gradhist,nhist,
     >        int(results(2)),iter_name)
         write(6,*) '- true norm final residual:',results(6)
         write(6,*) '- time spent:',results(7)
         write(6,*) '- flops:',int(results(3)),
     >        '; Mrate',(results(3)/results(7))*1.d-6
      endif

      return
      end
C----------------------------------------------------------------
      subroutine file_grad_hist(grads,lda,nhist, nit,name)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      
C     Arguments
C---- 
      integer nit,nhist,lda
      double precision grads(lda,nhist)
      character*(*) name
      
C     Local
C---- 
      integer id,ihist

      call pt0('Dumping Xgraph file$')

C     Dump xgraph format: x,y pairs
      call to_tmp_channel
     >     ('pvm3/examples/cg/local.data/grdhst.xg$')
      write(tmp_channel,*) 'TitleText: Gradient History'
      write(tmp_channel,*) 'LogY: yes'
      write(tmp_channel,*) 'XUnitText: Iterations'
      write(tmp_channel,*) 'YUnitText: Grad Norm (log)'
      write(tmp_channel,*) 'Background: OldLace'
      write(tmp_channel,*) '0.Color: MidnightBlue'
      write(tmp_channel,*) '1.Color: tomato'
      write(tmp_channel,*) '2.Color: green'
      write(tmp_channel,*) 'LineWidth: 2'
      write(tmp_channel,*) ' '
      write(tmp_channel,*) '"',name(1:index(name,' ')+1)

      do 30 id=2,nit
         write(tmp_channel,12) id,grads(id,1)
 30   continue

      do 50 ihist=2,nhist
         write(tmp_channel,*) ' '
         write(tmp_channel,*) '"'
         do 40 id=2,nit
            write(tmp_channel,12) id,grads(id,ihist)
 40      continue
 50   continue
 12   format(1x,i3,1x,e15.8)
      
      close(tmp_channel)

      return
      end
