C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
************************************************************************
************************************************************************
***** HBTC ..... GET MATRIX FROM HARWELL-BOEING COLLECTION     *****
************************************************************************
************************************************************************
*     
*     PURPOSE:
*     THIS SUBROUTINE READS IN A MATRIX PROBLEM FROM A FILE IN THE
*     HARWELL-BOEING TEST COLLECTION.  THE MATRIX IS REPRESENTED
*     COLUMN BY COLUMN.  NOTE THAT ONLY THE COEFFICIENT MATRIX IS
*     EXTRACTED; ANY RIGHT HAND SIDES OR INITIAL GUESSES ARE IGNORED.
*     
*     Modified 11/1/92 to return data set type information. 
*     Modified 11/1/92 to call LSAME to do character compares.
*     
*     INPUT PARAMETERS:
*     (I) INPUT       -   INPUT UNIT.
*     (I) LENPTR      -   LENGTH OF POINTR (SEE BELOW).
*     (I) LENIDX      -   LENGTH OF ROWIND (SEE BELOW).
*     (I) LENV        -   LENGTH OF VALUES (SEE BELOW).
*     
*     OUTPUT PARAMETERS:
*     (I) MTYPE       -   MATRIX TYPE.
*     MTYPE = 0: ASSEMBLED MATRIX.
*     MTYPE = 1: ELEMENTAL MATRICES.
*     (L) NUMVAL      -   TRUE IF NUMERICAL VALUES ARE AVAILABLE;
*     FALSE OTHERWISE.
*     (I) NROWS       -   NUMBER OF ROWS (OR VARIABLES).
*     (I) NCOLS       -   NUMBER OF COLUMNS (FOR MTYPE = 0) OR
*     ELEMENTS (FOR MTYPE = 1).
*     (I) NNZERO      -   NUMBER OF ROW INDICES (FOR MTYPE = 0).
*     (I) NELTVL      -   NUMBER OF ELEMENTS (FOR MTYPE = 1).
*     (I) POINTR(*)   -   ARRAY OF LENGTH NCOLS+1 THAT THAT HOLDS
*     POINTERS TO SUBSCRIPTS.
*     (I) ROWIND(*)   -   ARRAY OF LENGTH POINTR(NCOLS+1)-1 THAT
*     HOLDS THE ROW SUBSCRIPTS.
*     (R) VALUES(*)   -   ARRAY THAT HOLDS THE NUMERICAL VALUES.
*     ITS LENGTH DEPENDS ON THE VALUE OF MTYPE.
*     (I) IFLAG       -   ERROR FLAG.
*     IFLAG =  0: NO ERROR.
*     IFLAG =  1: INSUFFICIENT SPACE FOR POINTERS.
*     IFLAG =  2: INSUFFICIENT SPACE FOR
*     SUBSCRIPTS.
*     IFLAG =  3: INSUFFICIENT SPACE FOR
*     NUMERICAL VALUES.
*     IFLAG =  4: ERROR IN READING INPUT FILE.
*     IFLAG = -1: END OF FILE HAS BEEN REACHED.
*     (C3) CTYPE       -   Type information:
*     First Character:        r       Real Matrix
*     c       Complex Matrix
*     p       Pattern Only (no values supplied)
*     
*     Second Character:       s       Symmetric
*     u       Unsymmetric
*     h       Hermitian
*     z       Skew symmetric
*     r       Rectangular
*     
*     Third Character:        a       Assembled
*     f       Unassembled Finite Elements
*     
*     Local junk:
*     (C) STRING      -   TITLE OF MATRIX PROBLEM (AT LEAST 80
*     CHARACTERS LONG).
*     
************************************************************************
C----------------------------------------------------------------
      SUBROUTINE demo_get_harbo_info
     >     (INPUT, MTYPE, NUMVAL, HB_info_buffer, private, 
     >     comm_context,IFLAG)
      
      CHARACTER           STRING*81
      INTEGER             IFLAG, INPUT, NUMVAL, HB_info_buffer(*),
     &     MTYPE, private,comm_context(*)
      
C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

C     Local variables
C----
      INTEGER INDCRD, PTRCRD, RHSCRD(1),
     >     NROWS,NCOLS, NNZERO,
     &     TOTCRD, VALCRD(1)
      LOGICAL             LSAME,tio,trace_fileio,i_in,a_in,bcst
      logical i_input_big,all_input_big
      character*30 fmt1,fmt2

C     Two common blocks to carry info from one routine to
C     the next. Not terribly important
C----
      integer NELTVL, NRHSIX, NRHS
      common /hbnums/NELTVL, NRHSIX, NRHS

      CHARACTER*3 CTYPE,RHSTYP
      character*16 INDFMT, PTRFMT
      character*20 RHSFMT, VALFMT
      common /hbtypeb3/ctype,rhstyp
      common /hbtypeb16/indfmt,ptrfmt
      common /hbtypeb20/rhsfmt,valfmt
     
************************************************************************
     
      IFLAG = 0
      tio = trace_fileio()
      i_in = i_input_big()
      a_in = all_input_big()
      bcst = .not.a_in .and. private.ne.1
*     
      NRHS = 0
      NRHSIX = 0
*     -------------------------
*     ... READ IN HEADER BLOCK.
*     -------------------------
      if (i_in) then
         READ (INPUT,11,END=200,ERR=101)  STRING
 11      FORMAT ( A80 )
         if (log_channel_open) write(logchn,*) string
         string(81:81) = '$'
         if (tio) call pd0(string)
      endif

C     Second line: numbers of cards
C----
      if (i_in) READ (INPUT,22,END=102,ERR=103)
     &     TOTCRD, PTRCRD, INDCRD, VALCRD(1), RHSCRD(1)
 22   FORMAT ( 5I14 )
      if (bcst) then
         call inspread(VALCRD,1,comm_context,'HB info VALCRD$')
         call inspread(RHSCRD,1,comm_context,'HB info RHSCRD$')
      endif
      if (tio) call pd2i('Harbo size2$',VALCRD(1), RHSCRD(1))


C     Third line: numbers of rows column nonzeros
C----
      if (i_in) READ (INPUT,33,END=104,ERR=105)
     &     CTYPE, NROWS, NCOLS, NNZERO, NELTVL
 33   FORMAT ( A3, 11X, 4I14 )
      if (tio) call pd4i('Harbo size3$',NROWS, NCOLS, NNZERO, NELTVL)
      hb_info_buffer(1) = NROWS
      hb_info_buffer(2) = NCOLS
      hb_info_buffer(3) = NNZERO
      hb_info_buffer(4) = NELTVL
      if (bcst) then
         call txspread(CTYPE,3,comm_context,'HB info CTYPE$')
         call inspread(HB_info_buffer,4,comm_context,'HB info$')
      endif

C     Fourth line: formats; these don't have to be broadcast
C----
      if (i_in) then
         READ (INPUT,44,END=106,ERR=107)
     &        PTRFMT, INDFMT, VALFMT, RHSFMT
         fmt1 = 'Read fmt: <                > $'
         fmt1(12:28) = ptrfmt
         fmt2 = 'also fmt: <                > $'
         fmt2(12:28) = indfmt
         if (tio) call pd00(fmt1,fmt2)
         fmt1 = 'Also: <                    > $'
         fmt1(8:28) = valfmt
         fmt2 = 'also: <                    > $'
         fmt2(8:28) = rhsfmt
         if (tio) call pd00(fmt1,fmt2)
 44      FORMAT ( 2A16, 2A20 )
         IF  ( RHSCRD(1) .GT. 0 )  THEN
            READ (INPUT,55,END=108,ERR=109)  RHSTYP, NRHS, NRHSIX
 55         FORMAT ( A3, 11X, 2I14 )
         ENDIF
      endif
*     
      IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
         MTYPE = 0
      ELSE
         MTYPE = 1
      ENDIF
c$$$      IF  ( VALCRD(1) .NE. 0 )  THEN
c$$$         NUMVAL = .TRUE.
c$$$      ELSE
c$$$         NUMVAL = .FALSE.
c$$$      ENDIF
      numval = VALCRD(1)

      return
      
*     ----------------------------
*     ERRORs IN READING INPUT FILE.
*     ----------------------------
 101  iflag = 1
      return
 102  iflag = 2
      return
 103  iflag = 3
      return
 104  iflag = 4
      return
 105  iflag = 5
      return
 106  iflag = 6
      return
 107  iflag = 7
      return
 108  iflag = 8
      return
 109  iflag = 9
      return
c      IFLAG = 4
*     
 200  CONTINUE
*     -----------------------------
*     END OF FILE HAS BEEN REACHED.
*     -----------------------------
      IFLAG = -1
      NROWS = 0
      NCOLS = 0
      NNZERO = 0
      NELTVL = 0
      RETURN
*     
      end
C----------------------------------------------------------------
      SUBROUTINE  harbo_matrix_from_file_inner
     >     (matrix,need_matrix, pointers,indexes, comm_context,vec_inf,
     >     VALUES,ROWIND,POINTR,
     >     INPUT, Nsize, NNZERO, LENPTR,LENIDX,LENV, IFLAG)
      
      
      double precision matrix(*),VALUES(*)
      integer pointers(*),indexes(*),vec_inf(*),comm_context(*),
     >     ROWIND(*), POINTR(*),
     >     IFLAG, INPUT , LENIDX,LENPTR,LENV, 
     >     nsize, NNZERO, need_matrix
      
C     Two common blocks to carry info from one routine to
C     the next. Not terribly important
C----
      integer NELTVL, NRHSIX, NRHS
      common /hbnums/NELTVL, NRHSIX, NRHS

      CHARACTER*3 CTYPE,RHSTYP
      character*16 INDFMT, PTRFMT
      character*20 RHSFMT, VALFMT
      common /hbtypeb3/ctype,rhstyp
      common /hbtypeb16/indfmt,ptrfmt
      common /hbtypeb20/rhsfmt,valfmt

C     Functions & Locals
C---- 
      logical i_in,a_in, LSAME
      logical i_input_big,all_input_big
      logical isownv,elemp,add_diag, trace_setup,ts
      integer free_loc,cur_size,
     >     local_var,global_var,count,n_pointers, idum
      INTEGER I, ITEMP, NEXACT, NGUESS, NRHSVL,
     >     ncols,nrows
      double precision    TEMP
      
C     Some convenient constants
C----
      nrows = nsize
      ncols = nsize
      i_in = i_input_big()
      a_in = all_input_big()
      ts = trace_setup()
*     
*     --------------------------
*     ... READ MATRIX STRUCTURE.
*     --------------------------
      IF  ( NCOLS+1 .GT. LENPTR )  THEN
         IFLAG = 1
         return
      ELSE
         if (i_in) READ (INPUT,PTRFMT,END=103,ERR=104)
     >        (POINTR(I),I=1,NCOLS+1)
         if (.not.a_in)
     >        call inspread(pointr,ncols+1,comm_context,'HB pointers$')
      ENDIF
      IF  ( NNZERO .GT. LENIDX )  THEN
         IFLAG = 2
         return
      ELSE
         if (i_in) READ (INPUT,INDFMT,END=107,ERR=108)
     >        (ROWIND(I),I=1,NNZERO)
         if (.not.a_in)
     >        call inspread(rowind,nnzero,comm_context,'HB indices$')
      ENDIF
      
*     -----------------------
*     ... READ MATRIX VALUES.
*     -----------------------
      IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
         IF  ( NNZERO .GT. LENV )  THEN
            IFLAG = 3
            return
         ELSE
            if (i_in) READ (INPUT,VALFMT,END=111,ERR=112)
     &           (VALUES(I),I=1,NNZERO)
            if (.not.a_in)
     >           call dpspread(values,nnzero,comm_context,'HB values$')
         ENDIF
      ELSE
         IF  ( NELTVL .GT. LENV )  THEN
            IFLAG = 3
            READ (INPUT,VALFMT,END=113,ERR=114) (TEMP,I=1,NELTVL)
         ELSE
            READ (INPUT,VALFMT,END=115,ERR=116)
     &           (VALUES(I),I=1,NELTVL)
         ENDIF
      ENDIF
      n_pointers = 0
      free_loc = 1
      need_matrix = 0

C     Go through the whole matrix, and keep only the rows/columns you own
C----
      do 10 count=1,ncols
         if (isownv(local_var,count,vec_inf)) then
            global_var = count
            n_pointers = n_pointers+1
            pointers(n_pointers) = free_loc
            cur_size = POINTR(count+1)-POINTR(count)
            add_diag = .not.elemp(global_var,idum,
     >           ROWIND(POINTR(count)),cur_size)
            call vvcopy(matrix(free_loc),VALUES(POINTR(count)),
     >           cur_size)
            call iicopy(indexes(free_loc),ROWIND(POINTR(count)),
     >           cur_size)
            if (add_diag) then
               indexes(free_loc+cur_size) = global_var
               matrix(free_loc+cur_size) = 0.d0
               cur_size = cur_size+1
            endif
            need_matrix = need_matrix+cur_size
            free_loc = free_loc+cur_size
C     This line ultimately only yields the bumper pointer
            pointers(n_pointers+1) = free_loc
            if (ts) 
     >           call pd1i1i('HB var$',count,'used: |col|=$',cur_size)
         else
            if (ts) call pd1i('HB var not used$',count)
         endif
 10   continue

*     -----------------------------------
*     ... READ AND SKIP RIGHT-HAND SIDES.
*     -----------------------------------
*     
      IF  ( NRHS .GT. 0 )  THEN
*     
         IF  ( LSAME(RHSTYP(1:1), 'F') )  THEN
*     --------------------------------
*     ... READ DENSE RIGHT-HAND SIDES.
*     --------------------------------
            NRHSVL = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NRHSVL)
         ELSE
*     ----------------------------------------------
*     ... READ SPARSE OR ELEMENTAL RIGHT-HAND SIDES.
*     ----------------------------------------------
            IF  ( LSAME(CTYPE(3:3), 'A') )  THEN
*     ---------------------------------
*     ... READ SPARSE RIGHT-HAND SIDES.
*     ---------------------------------
*     
*     --------------------------------------------
*     ... READ POINTER ARRAY FOR RIGHT-HAND SIDES.
*     --------------------------------------------
               READ (INPUT,PTRFMT,END=117,ERR=117)
     &              (ITEMP,I=1,NRHS+1)
*     ----------------------------------------
*     ... READ SPARSITY PATTERN FOR RIGHT-HAND
*     SIDES.
*     ----------------------------------------
               READ (INPUT,INDFMT,END=117,ERR=117)
     &              (ITEMP,I=1,NRHSIX)
*     ---------------------------------------
*     ... READ SPARSE RIGHT-HAND SIDE VALUES.
*     ---------------------------------------
               READ (INPUT,RHSFMT,END=117,ERR=117)
     &              (TEMP,I=1,NRHSIX)
            ELSE
*     ------------------------------------
*     ... READ ELEMENTAL RIGHT-HAND SIDES.
*     ------------------------------------
               NRHSVL = NNZERO*NRHS
               READ (INPUT,RHSFMT,END=117,ERR=117)
     &              (TEMP,I=1,NRHSVL)
            ENDIF
         ENDIF
         IF  ( LSAME(RHSTYP(2:2),'G') )  THEN
*     --------------------------
*     ... READ STARTING GUESSES.
*     --------------------------
            NGUESS = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NGUESS)
         ENDIF
         IF  ( LSAME(RHSTYP(3:3), 'X' ))  THEN
*     --------------------------
*     ... READ SOLUTION VECTORS.
*     --------------------------
            NEXACT = NROWS*NRHS
            READ (INPUT,RHSFMT,END=117,ERR=117)
     &           (TEMP,I=1,NEXACT)
         ENDIF
      ENDIF
      RETURN
*     
 100  CONTINUE
*     ----------------------------
*     ERRORs IN READING INPUT FILE.
*     ----------------------------
 101  iflag = 1
      return
 102  iflag = 2
      return
 103  iflag = 3
      return
 104  iflag = 4
      return
 105  iflag = 5
      return
 106  iflag = 6
      return
 107  iflag = 7
      return
 108  iflag = 8
      return
 109  iflag = 9
      return
 110  iflag = 10
      return
 111  iflag = 11
      return
 112  iflag = 12
      return
 113  iflag = 13
      return
 114  iflag = 14
      return
 115  iflag = 15
      return
 116  iflag = 16
      return
 117  iflag = 17
      return
c      IFLAG = 4
*     
      END
C----------------------------------------------------------------
      subroutine diag_matrix_from_file_inner
     >     (matrix, mat_inf, comm_context,vec_inf,
     >     VALUES, LENV,
     >     input, nsize,ndiag, my_first,my_vars, iflag)
      
      double precision matrix(*),VALUES(*)
      integer mat_inf(*),comm_context(*),vec_inf(*), iflag, input,
     >     nsize,ndiag,my_first,my_vars, LENV

C     Functions & Locals
C---- 
      logical i_in,a_in
      logical i_input_big,all_input_big
      integer idiag,ielt,offset(1)
      logical trace_setup,ts
      integer free_loc

      call force_range(lenv,nsize,1,'Diag from file, |values|$')

C     Set up some switches
C----
      i_in = i_input_big()
      a_in = all_input_big()
      ts = trace_setup()

C     What part will we retain as being ours?
C----
      free_loc = 1

      do 10 idiag=1,ndiag
         if (i_in) read(input,*) offset(1)
         if (.not.a_in)
     >        call inspread(offset(1),1,comm_context,'offset$')
         mat_inf(1+idiag) = offset(1)
         if (ts) call pd1i1i('Diag$',idiag,'has offset$',offset(1))
         if (i_in) read(input,*) (values(ielt),ielt=1,nsize)
         if (.not.a_in)
     >        call dpspread(values,nsize,comm_context,'diagonal$')
         call vvcopy(matrix(free_loc),values(my_first),my_vars)
         if (ts) call pd1iar('Inserted at$',free_loc,
     >        'values:$',matrix(free_loc),my_vars)
         free_loc = free_loc+my_vars
 10   continue

      return
      end
C----------------------------------------------------------------
C     Read a 2D matrix from file
C----------------------------------------------------------------
      subroutine demo_grid_size_from_matrix(buffer,nitems,
     >     comm_context)

C     Arguments
C----
      integer buffer(*),nitems(1),comm_context(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Name of the external matrix file
C----
      character*50 matnam
      common /inmatx/matnam
      integer matnam_len
      common /inmatxi/matnam_len

C     Functions
C----
      logical i_input_big,all_input_big, trace_setup

C     Open the matrix file and get the domain size
C----
      if (i_input_big()) then
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        matnam,matnam_len,
     >        'Opening grd mat for local construction$')
         call read_grid_size_line(buffer,nitems(1))
      endif
      if (trace_setup()) call pdai('Demo grid size from matx$',
     >     buffer,nitems(1))
      if (.not.all_input_big()) then
         call inspread(nitems,1,comm_context,
     >        'BCST domain size #items$')
         call inspread(buffer,nitems(1),comm_context,
     >        'BCST domain size data$')
      endif

      return
      end
C----------------------------------------------------------------
      subroutine matrix_grd_load(mat,leng_mat,grid_dimension,
     >     mat_ptr,vec_inf,leng_vec_inf,comm_context)

C     Arguments
C----
      integer leng_mat,leng_vec_inf,grid_dimension,comm_context(*)
      double precision mat(leng_mat)
      integer mat_ptr(*),vec_inf(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Functions
C----
      logical trace_matrices,trace_setup,
     >     i_input_big,all_input_big

C     Local
C----
      integer buffer(4), need,idum,dim,ndiags
      logical ii,ai
      integer vs, max_bord, loc

      ii = i_input_big()
      ai = all_input_big()

C     Decide what part of the global matrix you need to get
C----
      vs = vec_inf(2)
      need = vs
      call force_range(need,1,leng_mat,'Grd load diag storage$')
      max_bord = 0
      if (trace_matrices()) then
         call pdai('Getting domain slice of size$',
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+1))
         call pdai('starting at location$',
     >        vec_inf(vec_inf(6)),vec_inf(vec_inf(5)+1))
      endif
      mat_ptr(1) = vec_inf(vec_inf(5)+1)
      loc = 1

C     First get the matrix main diagonal. We assume we always have one.
C----
      if (trace_setup()) then
         call pdai('About to read from global domain$',
     >        vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >        vec_inf(vec_inf(5)+1))
         call pdai('- piece starting at$',
     >        vec_inf(vec_inf(6)),vec_inf(vec_inf(5)+1))
         call pdai('- size$',
     >        vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+1))
      endif
      if (trace_matrices()) call pd0('Getting main diagonal$')
      call get_2d_vector(
     >     mat(loc), vec_inf(vec_inf(6)),
     >     vec_inf(vec_inf(6)+1),
     >     vec_inf(vec_inf(5)+2),
     >     vec_inf(vec_inf(5)+2+1),
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)+1),comm_context)

C     Now loop until end-of-file: get an (i,j) offset pair,
C     and the diagonal at that displacement
C----
      ndiags = 0
 10   continue
      if (ii) read(inchan,*,end=22) (buffer(dim),dim=1,grid_dimension)
      if (ii.and.trace_setup()) call pdai('read stencil offset$',
     >     buffer,grid_dimension)
      goto 21
 22   call inulv(buffer,grid_dimension)
 21   continue
      if (.not.ai) call inspread(buffer,grid_dimension,comm_context,
     >     'IJoffset of offdiag$')
      idum = 0
C     if this is the zero vector, exit because the file has ended
      do 23 dim=1,grid_dimension
         idum = idum+abs(buffer(dim))
 23   continue
      if (idum.eq.0) goto 20
      loc = loc+vs
      need = need+vs
      call force_range(need,1,leng_mat,'Dia load off-diag; storage$')
      ndiags = ndiags+1
      call iicopy(mat_ptr(3
     >     +(ndiags-1)*grid_dimension),
     >     buffer,grid_dimension)
      if (trace_matrices()) call pdai
     >     ('Getting diag with offset$', buffer,grid_dimension)
      call get_2d_vector(
     >     mat(loc), vec_inf(vec_inf(6)),
     >     vec_inf(vec_inf(6)+1),
     >     vec_inf(vec_inf(5)+2),
     >     vec_inf(vec_inf(5)+2+1),
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)),
     >     vec_inf(vec_inf(6)+2*vec_inf(vec_inf(5)+1)+1),comm_context)

      goto 10
 20   continue
      mat_ptr(2) = ndiags
      if (trace_matrices().or.trace_setup()) then
         do 24 ndiags=1,mat_ptr(2)
            call pd1iai('Matrix offd$',ndiags,
     >           'offset$',mat_ptr(3
     >           +(ndiags-1)*grid_dimension),grid_dimension)
 24      continue
      endif
      if (ii) close(inchan)

      call force_range(vec_inf(vec_inf(5)),max_bord,-1,
     >     'Get 2D: matrix exceeds border$')

      leng_mat = need

      return
      end
C----------------------------------------------------------------
      subroutine get_2d_vector_inner(
     >     mat, imin,jmin, isize,jsize,
     >     work,dom_isize,dom_jsize,comm_context
     >     )

C     Arguments
C----
      integer
     >     imin,jmin, isize,jsize,
     >     dom_isize,dom_jsize,comm_context(*)
      double precision
     >     mat(isize,jsize),
     >     work(dom_isize,dom_jsize)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Functions
C----
      logical i_input_big,all_input_big

C     Local
C----
      integer row,col

      call force_range(dom_isize*dom_jsize,1,-1,
     >     'Get 2D zero domain size$')
      call zerov(work,dom_isize*dom_jsize)
      if (i_input_big()) read(inchan,*,end=999)
     >     ((work(row,col),row=1,dom_isize),col=1,dom_jsize)
      if (.not.all_input_big())
     >     call dpspread(work,dom_isize*dom_jsize,comm_context,
     >     'Get 2d inner: spread elements$')

      do 10 col=1,jsize
         call vvcopy(mat(1,col),work(imin,col+jmin-1),isize)
 10   continue

      return
 999  call pe2i('EOF in row/col$',row,col)
      call stop_connections('Get 2D vector$')
      end
C----------------------------------------------------------------
      subroutine demo_ext_grid_mat(matrix,leng_mat,
     >     mat_ptr,vec_inf,leng_vec_inf,comm_context,trace)

C     Arguments
C----
      double precision matrix(*)
      integer leng_mat,
     >     mat_ptr(*),vec_inf(*),leng_vec_inf,comm_context(*)
      logical trace

C     Local
C----
      integer problem_dimension
      parameter (problem_dimension=2)
      integer
     >     slice(problem_dimension,4),
     >     buffer(30),nitems(1)

      call demo_grid_size_from_matrix(buffer,nitems,comm_context)
      call set_global_domain(vec_inf,buffer,nitems,leng_vec_inf)
      call demo_get_domain_slice(slice,problem_dimension,vec_inf)
      call set_domain_slice(vec_inf,problem_dimension,slice)
      call matrix_grd_load(matrix,leng_mat,vec_inf(vec_inf(5)+1),
     >     mat_ptr,vec_inf,leng_vec_inf,comm_context)
      if (trace) call pd1i('Case 2: I need$',leng_mat)

      return
      end
C----------------------------------------------------------------
      subroutine demo_ext_unst_mat(matrix,leng_mat,
     >     mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context,trace)

C     Arguments
C----
      double precision matrix(*)
      integer leng_mat,leng_mat_ptr,mat_idx,
     >     mat_ptr(*),leng_mat_idx(*),
     >     vec_inf(*),leng_vec_inf,comm_context(*)
      logical trace

C     Local
C----
      integer vec_inf2(50 000)

      call iicopy(vec_inf2,vec_inf,leng_vec_inf)
      call demo_get_matrix(matrix,leng_mat,
     >     mat_ptr,leng_mat_ptr, mat_idx,leng_mat_idx,
     >     vec_inf2,leng_vec_inf,comm_context)
      if (trace) call pd1i('Matrix from file: I need$',leng_mat)

      return
      end
C----------------------------------------------------------------
      subroutine demo_int_grid_mat(matrix,leng_mat,
     >     mat_ptr,vec_inf,leng_vec_inf,comm_context,trace)

C     Arguments
C----
      double precision matrix(*)
      integer leng_mat,
     >     mat_ptr(*),vec_inf(*),leng_vec_inf,comm_context(*)
      logical trace


C     Local
C----
      integer problem_dimension
      parameter (problem_dimension=2)
      integer
     >     slice(problem_dimension,4),
     >     buffer(30),nitems(1)

      call demo_read_grid_size(buffer,nitems,comm_context)
      call set_global_domain(vec_inf,buffer,nitems,leng_vec_inf)
      call demo_get_domain_slice(slice,problem_dimension,vec_inf)
      call set_domain_slice(vec_inf,problem_dimension,slice)

C     Determine how many legs the stencil has, 
C     and what their offsets are
C----
      call demo_get_grid_offsets(mat_ptr,vec_inf)
      leng_mat = (mat_ptr(2)+1)*vec_inf(2)
      if (trace) call pd1i('Case 1: I need$',leng_mat)

C     Get demo pde values
      call pde_initialization(comm_context)

C     create diagonal storage matrix for demo
C----
      call demo_matrix_grid_create(matrix,mat_ptr,vec_inf)

      return
      end
