C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
C     Demo routines. 
C     These should not occur in a real application.
C================================================================
C----------------------------------------------------------------
C     Implement a function var->proc. This one has an internal
C     array, essentially vec_inf
C----------------------------------------------------------------
      subroutine demo_make_var2proc_function

C     Functions
C----
      integer no_processors

      integer demo_vec_inf(2,0:2000)
      common /demo_varmap/demo_vec_inf

C     Local
C----
      logical trace_setup
      integer iproc

      do 10 iproc=0,no_processors()-1
         call demo_comp_consec_of_proc
     >        (demo_vec_inf(1,iproc),demo_vec_inf(2,iproc),iproc)
         if (trace_setup())
     >        call pd1i2i('Proc$',iproc,'has vars from/len$',
     >        demo_vec_inf(1,iproc),demo_vec_inf(2,iproc))
 10   continue

      return
      end
C----------------------------------------------------------------
      function demo_var2proc(ivar)

C     Arguments
C----
      integer demo_var2proc,ivar

      integer demo_vec_inf(2,0:2000)
      common /demo_varmap/demo_vec_inf

C     Local
C----
      integer no_processors,iproc

      demo_var2proc = -1
      do 10 iproc=0,no_processors()-1
         if (ivar.ge.demo_vec_inf(1,iproc).and.
     >        ivar.lt.demo_vec_inf(1,iproc)+demo_vec_inf(2,iproc)) then
            demo_var2proc = iproc
            return
         endif
 10   continue

      return
      end
C----------------------------------------------------------------
C     Variables of a processor; proc num is 0,1,...
C----------------------------------------------------------------
      subroutine demo_comp_consec_of_proc(first,length,proc)

C     Arguments
C----
      integer first,length,proc

C     Global vector info
C----
      integer totvrs
      common /d_gvec_info/totvrs

C     Local
C----
      integer last,no_processors
      logical trace_setup

      call force_range(totvrs,1,0,'Demo comp vars of proc: totvrs$')
      first = 1+(proc*totvrs)/no_processors()
      last = ((proc+1)*totvrs)/no_processors()
      length = last-first+1
      if (trace_setup()) call pd1i2i('Demo comp consec of$',proc,
     >     'as first/length$',first,length)

      return
      end
C----------------------------------------------------------------
      block data demo_init_varloc
C     Common block with map array:
C     case1: 1..nproc pairs of lo_var,hi_var
C     case3: sequence of (location,length) pairs
C----
      dimension var2proc_map(-1 : 3*2000)
      integer
     >     varloc,var2proc_map,map_length
      common /d_var2proc_com/
     >     varloc,var2proc_map,map_length
      data varloc/1/
      end
C----------------------------------------------------------------
      subroutine demo_comp_my_vars(buffer,buflen,nitems)

C     Arguments
C----
      integer buffer(*),buflen,nitems

C     Functions
C----
      integer my_procnum

C     Local
C----
      integer first,count

      call demo_comp_consec_of_proc(first,nitems,my_procnum())
      call force_range(nitems,1,buflen,
     >     'Too many my_vars for demo buffer$')
      do 10 count=1,nitems
         buffer(count) = first+count-1
 10   continue

      return
      end
C----------------------------------------------------------------
      subroutine demo_comp_my_consec(first,nitems)

C     Arguments
C----
      integer first,nitems

C     Functions
C----
      integer my_procnum

      call demo_comp_consec_of_proc(first,nitems,my_procnum())

      return
      end
C----------------------------------------------------------------
C     Get Compressed Row Storage matrix from file;
C     store all rows corresponding to owned & bordered vars
C----------------------------------------------------------------
      subroutine demo_get_matrix(rm,need_rm,mat_ptr,need_mat_ptr,
     >     mat_idx,need_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),comm_context(*),
     >     need_rm,need_mat_ptr,need_mat_idx,
     >     vec_inf(*),leng_vec_inf
      double precision rm(*)

C     Name of the external matrix file
C----
      character*50 matnam
      common /inmatx/matnam
      integer matnam_len
      common /inmatxi/matnam_len

C     Functions
C----
      logical i_input_big,tracer_proc


C     Open the matrix file
C----
      if (i_input_big()) then
         call setup_in_file(
     >        'pvm3/examples/cg/input.data/',28,
     >        matnam,matnam_len,
     >        'Opening crs mat for local construction$')
      endif

      if (10*(vec_inf(1)/10).eq.30) then
         if (tracer_proc()) call pt0('Get Harwell Boeing matrix$')
         call demo_get_harbo_matrix(rm,need_rm,
     >        mat_ptr,need_mat_ptr, mat_idx,need_mat_idx,
     >        vec_inf,leng_vec_inf,comm_context)
      else if (10*(vec_inf(1)/10).eq.20) then
         if (tracer_proc()) call pt0('Get Compr Diagonal matrix$')
         call demo_get_diag_matrix(rm,need_rm,
     >        mat_ptr,need_mat_ptr, mat_idx,need_mat_idx,
     >        vec_inf,leng_vec_inf,comm_context)
      else
         call strange_matrix_fmt(vec_inf,'Demo get matrix$')
      endif

C     Close the matrix file again
C----
      if (i_input_big()) call close_in_chan('<< mat construct$')

      return
      end
C----------------------------------------------------------------
      subroutine demo_get_harbo_matrix(rm,need_rm,
     >     mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),vec_inf(*),leng_vec_inf,
     >     need_rm,leng_mat_ptr,leng_mat_idx,comm_context(*)
      double precision rm(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Global vector info
C----
      integer totvrs
      common /d_gvec_info/totvrs

C     Local
C----
      integer 
     >   long_buffer(11 000),nitems,
     >     mtype, nrows,ncols,nnzero,numval, iflag,
     >     hb_info_buffer(4)

C     Get the size and number of nonzeros etc from file
C     This is necessary for the dynamic allocation of temp space
C----
      call demo_get_harbo_info(inchan,
     >     mtype,numval,hb_info_buffer,0,comm_context,iflag)
      NROWS  = hb_info_buffer(1)
      NCOLS  = hb_info_buffer(2)
      NNZERO = hb_info_buffer(3)
c      NELTVL = hb_info_buffer(4)

C     Checks on whether this is a legal matrix,
C     and whether there is enough work space
C----
      call force_range(iflag,0,0,'Harbo info internal error$')
      call force_range(numval,1,0,'HB matrix valcrds$')
      call force_range(mtype,0,0,'No unassembled matrices!$')
      call force_range(ncols,nrows,nrows,'Matrix not square: #cols=$')
      call force_range(1+nnzero,1,leng_mat_idx,'Idx to nnzero space$')
      call force_range(1+nrows,1,leng_mat_ptr,'Ptrs space$')

      totvrs = nrows

C     What variables are we going to keep, reading the matrix?
C----
      call demo_comp_my_vars(long_buffer,11 000,nitems)
      call cprs_set_my_vars
     >     (vec_inf,leng_vec_inf,long_buffer,nitems)

C     Now get the matrix itself
C----
      call harbo_matrix_from_file(rm,need_rm,
     >     mat_ptr,mat_idx,
     >     comm_context,vec_inf,inchan, nrows,nnzero,iflag)
      call force_range(iflag,0,0,'Harbo matrix internal error$')
      call force_range(need_rm,1,0,'Harbo matrix size$')

      return
      end
C----------------------------------------------------------------
      subroutine demo_get_diag_matrix(rm,need_rm,
     >     mat_ptr,leng_mat_ptr,mat_idx,leng_mat_idx,
     >     vec_inf,leng_vec_inf,comm_context)
      
C     Arguments
C---- 
      integer mat_ptr(*),mat_idx(*),vec_inf(*),leng_vec_inf,
     >     need_rm,leng_mat_ptr,leng_mat_idx,comm_context(*)
      double precision rm(*)

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Global vector info
C----
      integer totvrs
      common /d_gvec_info/totvrs

C     Function
C----
      logical i_input_big,all_input_big,trace_setup

C     Local
C----
      integer my_procnum
      integer first,nvars
      integer ndiag, iflag

C     Get the size and number of nonzeros etc from file
C     This is necessary for the dynamic allocation of temp space
C----
      if (i_input_big()) read(inchan,*) totvrs,ndiag
      if (.not.all_input_big())
     >     call inspread(totvrs,1,comm_context,'Diag #vars$')
      if (.not.all_input_big())
     >     call inspread(ndiag,1,comm_context,'Diag #diag$')
      call force_range(ndiag,1,0,'DIAG #diags$')
      call force_range(totvrs,1,0,'DIAG mat size$')
      if (trace_setup())
     >     call pd2i('Total matrix size/ndiag$',totvrs,ndiag)
      mat_ptr(1) = ndiag

C     What variables are we going to keep, reading the matrix?
C----
      call demo_comp_consec_of_proc(first,nvars,my_procnum())
      if (trace_setup())
     >     call pd2i('I am going to keep from/range$',first,nvars)
      need_rm = ndiag*nvars

C     Now get the matrix itself
C----
      call diag_matrix_from_file(rm,mat_ptr,comm_context,
     >     vec_inf,inchan, totvrs,ndiag,first,nvars,iflag)
      call force_range(iflag,0,0,'Diag matrix internal error$')
      call force_range(need_rm,1,0,'Diag matrix size$')

      return
      end
C----------------------------------------------------------------
      subroutine demo_set_problem_format(buff,lo,hi)

C     Arguments
C----
      integer lo,hi
      integer buff(lo:hi)

C     The problem format.
C----
      integer              mat_source,rhs_source
      common /demo_prbfmt/ mat_source,rhs_source

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      call force_range(hi,7,-1,
     >     'Set prb fmt (demo): #items$')
      rhs_source    = buff(6)
      mat_source    = buff(7)

      if (log_channel_open) then
         write(logchn,*) 'Matrix source:',mat_source
      endif

      return
      end
C----------------------------------------------------------------
      subroutine demo_default_problem_format(buff,lo,hi)

C     Arguments
C----
      integer lo,hi
      integer buff(lo:hi)

      hi = 7
C     rhs : internal unit
      buff(6) = 1
C     matrix internal
      buff(7) = 1

      return
      end
C----------------------------------------------------------------
C     Regular 5-point matrix create symmetric
C     
C     output: 
C     tridiagonal diagonal part, upper and lower single diagonal;
C     note that phantom elements corresponding to lines bordering
C     on the domain have been filled in.
C     
C----------------------------------------------------------------
      subroutine demo_matrix_grid_create(matrix,mat_ptr,vec_inf)
      
C     Arguments
C---- 
      integer mat_ptr(*), vec_inf(*)
      double precision matrix(*)
      
C     Functions
C---- 
      logical tracer_proc,trace_progress

      if (tracer_proc().and.trace_progress())
     >     call pt0('Creating matrix$')
      call five_star_matrix(matrix(1),
     >     matrix(1+vec_inf(2)),mat_ptr,
     >     vec_inf(vec_inf(5)+2),vec_inf(vec_inf(5)+2+1),
     >     vec_inf(vec_inf(5)),vec_inf)
      if (tracer_proc().and.trace_progress())
     >     call pt0('Matrix created$')

      return
      end
C----------------------------------------------------------------
      subroutine five_star_matrix
     >     (diag,offs, mat_ptr, ipts,jpts,bord,vec_inf)
      
C     Arguments
C---- 
      integer ipts,jpts,bord, mat_ptr(*),vec_inf(*)
      double precision
     >     diag(ipts,jpts),
     >     offs(ipts,jpts,*)
      
C     Domain information (coordinates)
C---- 
      double precision h(4),xlo(4),xhi(4),
     >     gxlo(4),gxhi(4)
      common /domgrd/h,xlo,xhi,
     >     gxlo,gxhi

C     Functions
C----
      double precision dcofx,dcofy, ccofx,ccofy, ucof
      logical trace_setup

C     Local
C---- 
      integer dia,row,col, noffs,i_off,j_off
      double precision curx,cury, sh_x,sh_y, contrib,dc,cc, cm
      
C     Sensibility check
C---- 
      call force_range(ipts,1,-1,'R5pmcs ipts$')
      call force_range(jpts,1,-1,'R5pmcs jpts$')

      noffs = mat_ptr(2)

C     Step through physical domain, evaluating coefficients
C     at x+h/2, y+h/2 points for symmetric matrix
C----
      cm = 1.d0
      if (mod(vec_inf(1),2).eq.1) cm = 2.d0
      call nulv(diag,ipts*jpts)

C     First set the constant term on the diagonal
C----
      curx = xlo(1)
      do 40 col=1,jpts
         cury = xlo(2)
         do 50 row=1,ipts
            diag(row,col) = -ucof(curx,cury)
            cury = cury+h(2)
 50      continue
         curx = curx+h(1)
 40   continue

C     Then set all diagonals, plus their part on the main diagonal
C----
      do 30 dia=1,noffs
         call nulv(offs(1,1,dia),(ipts+2*bord)*(jpts+2*bord))
         call get_dia_offset(i_off,j_off,mat_ptr,dia)
         curx = xlo(1)
         do 10 col=1,jpts
            cury = xlo(2)
            do 20 row=1,ipts
C     Current coordinate plus shift for offdiagonal
               sh_x = curx+i_off*h(1)/2
               sh_y = cury+j_off*h(2)/2
               dc = 0.d0
C     Diffusion in x direction
               contrib = abs(i_off)*dcofx(sh_x,sh_y)
               dc = dc+contrib
C     Diffusion in y direction
               contrib = abs(j_off)*dcofy(sh_x,sh_y)
               dc = dc+contrib
C     Convection coefficient
               sh_x = curx+i_off*h(1)
               sh_y = cury+j_off*h(2)
               cc = abs(i_off)*ccofx(sh_x,sh_y) +
     >              abs(j_off)*ccofy(sh_x,sh_y)
               diag(row,col) = diag(row,col)+cm*dc
               offs(row,col,dia) =
     >              -dc+sign(cc,(i_off+1.d-1)*(j_off+1.d-1))
               cury = cury+h(2)
 20         continue
            curx = curx+h(1)
 10      continue
         if (trace_setup()) call pd2i1d('Offdiag at offset$',
     >        i_off,j_off,'value$',offs(1,1,dia))
 30   continue
      if (trace_setup()) call pd1d('Main diag value$',diag(1,1))
      
      return
      end
C----------------------------------------------------------------
C     Diffusion coefficients
C----------------------------------------------------------------
      function dcofx(x,y)
      double precision x,y, dcofx

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      dcofx = ddx
      if (funnum.eq.stepfun) then
         dcofx = 1.d0
         if (x.gt.sx) dcofx = tx
      endif

      return
      end
C----------------------------------------------------------------
      function dcofy(x,y)
      double precision x,y, dcofy

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      dcofy = ddy
      if (funnum.eq.stepfun) then
         dcofy = 1.d0
         if (y.gt.sy) dcofy = ty
      endif

      return
      end
C----------------------------------------------------------------
C     Convection coefficients
C----------------------------------------------------------------
      function ccofx(x,y)
      double precision x,y, ccofx
      
C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ccofx = vx

      return
      end
C----------------------------------------------------------------
      function ccofy(x,y)
      double precision x,y, ccofy

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ccofy = vy

      return
      end
C----------------------------------------------------------------
C     Reaction coefficient
C----------------------------------------------------------------
      function ucof(x,y)
      double precision x,y, ucof

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

      ucof = alpha

      return
      end
C----------------------------------------------------------------
      subroutine set_pde_parameters(ibuf,ilen,buff,rlen)

C     Arguments
C----
      integer ilen,rlen
      integer ibuf(ilen)
      double precision buff(rlen)

C     Coefficient function parameters
C---- 
      integer stepfun
      parameter (stepfun=2)
      integer funnum,unsymm,indef
      common /coffni/funnum,unsymm,indef
      double precision ddx,ddy,vx,vy,alpha, sx,tx,sy,ty
      common /coffnd/ddx,ddy,vx,vy,alpha, sx,tx,sy,ty

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      funnum = ibuf(1)
      unsymm = ibuf(2)
      indef = ibuf(3)
      
      ddx = buff(1)
      ddy = buff(2)
      vx = buff(3)
      vy = buff(4)
      alpha = buff(5)
      sx = buff(6)
      tx = buff(7)
      sy = buff(8)
      ty = buff(9)

      if (log_channel_open) then

      write(logchn,*) '================ PDE'
      write(logchn,*) 
     >     'Define problem: (option/value, newline, parameters)'
      write(logchn,*) ' [1] DE: 0=Poisson (default)'
      write(logchn,*) '     1=const coef (supply ddx,ddy)'
      write(logchn,*) '     2=steps (supply sx,tx, sy,ty)'
      write(logchn,*) ' [2] Unsymmetry: 0=no (default)'
      write(logchn,*) '     1=yes (supply vx,vy)'
      write(logchn,*) ' [3] Indefiniteness: 0=no (default)'
      write(logchn,*) '     1=yes (supply alpha>0 shift down)'
      write(logchn,*) '------------------------------------'
      if (funnum.eq.0) then
         write(logchn,*) 'Poisson equation'
      else if (funnum.eq.1) then
         write(logchn,*) 'Constant coefficients',ddx,ddy
      endif
      if (unsymm.gt.0) then
         write(logchn,*) 'Unsymmetry:',vx,vy
      endif
      if (indef.gt.0) then
         write(logchn,*) 'Indefiniteness:',alpha
      endif

      endif

      return
      end
C----------------------------------------------------------------
      subroutine demo_read_pvm_instances(buffer,nitems,host,reader)

C     Arguments
C----
      integer buffer(*),nitems,host,reader


c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     Local
C----
      integer mynum,info

      call force_range(nitems,5,-1,'Read pvm insts buffer length$')
      call pvmfmytid(mynum)
      write(6,*) '<<>> Node about to enroll',mynum
      call force_range(mynum,0,-1,
     >     '**** Help     ! I don''t exist$')

C     Receive demo host & node & reader info from the host program
C----
      call pvmfrecv(-1,1234,info)
      if (info.lt.0) then
         write(6,*) 'NODE: unable to receive'
         stop
      endif

C     Unpack to find host, node, reader task ids
C----
      call pvmfunpack(INTEGER4,buffer(2),1,1,info)
      if (info.lt.0) then
         write(6,*) 'NODE: unable to get host no'
         stop
      endif

C     get input mode: 1 if there is a reader, 0 otherwise
      call pvmfunpack(INTEGER4,buffer(3),1,1,info)
      if (info.lt.0) then
         write(6,*) 'NODE: unable to get input mode'
         stop
      endif

      call pvmfunpack(INTEGER4,buffer(4),1,1,info)
      if (info.lt.0) then
         write(6,*) 'NODE: unable to get nproc'
         stop
      endif
      call force_range(nitems,4+buffer(4)+buffer(3),-1,
     >     'Read pvm insts buffer length$')

      call pvmfunpack(INTEGER4,buffer(5),buffer(4)+buffer(3),
     >     1,info)
      if (info.lt.0) then
         write(6,*) 'NODE: unable to get instances'
         stop
      endif

C     Now return all this information in the proper parameters
C----
      host = buffer(2)
      if (buffer(3).eq.1) then
         reader = buffer(4+buffer(4)+1)
      else
         reader = -1
      endif
      nitems = buffer(4)
      call ishift(buffer(5),nitems,-4)

      write(6,*) '<> Successful'

      return
      end
C----------------------------------------------------------------
      subroutine demo_init_pvm(host_id,reader_id)

C     Arguments
C----
      integer host_id,reader_id

C     Global architecture info
C----
      integer
     >     host,input_mode,reader
      common /demo_iume/
     >     host,input_mode,reader

C     Store host and reder id
C----
      host = host_id
      if (reader_id.gt.0) then
         input_mode = 1
      else
         input_mode = 0
      endif
      reader = reader_id

      return
      end
