C================================================================C
C                                                                C
C     This file is part of the                                   C
C     Distributed Iterative Systems Solvers library              C
C     (c) 1994 Victor Eijkhout, eijkhout@cs.utk.edu              C
C                                                                C
C     Current version: 0.9                                       C
C     This file last generated 94/11/04                          C
C                                                                C
C================================================================C
C================================================================
      Program PVM_kick_off
      

c  -------------------------------------------------------------------
c          PVM version 3.3:  Parallel Virtual Machine System
c                University of Tennessee, Knoxville TN.
c            Oak Ridge National Laboratory, Oak Ridge TN.
c                    Emory University, Atlanta GA.
c       Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
c     W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
c                    (C) 1992 All Rights Reserved
c 
c                               NOTICE
c 
c  Permission to use, copy, modify, and distribute this software and
c  its documentation for any purpose and without fee is hereby granted
c  provided that the above copyright notice appear in all copies and
c  that both the copyright notice and this permission notice appear in
c  supporting documentation.
c 
c  Neither the Institutions (Emory University, Oak Ridge National
c  Laboratory, and University of Tennessee) nor the Authors make any
c  representations about the suitability of this software for any
c  purpose.  This software is provided ``as is'' without express or
c  implied warranty.
c 
c  PVM version 3 was funded in part by the U.S. Department of Energy,
c  the National Science Foundation and the State of Tennessee.
c  -------------------------------------------------------------------

c     ----------------------------------
c         fpvm3.h
c
c     Definitions to be included with
c     User's Fortran application
c     ----------------------------------

      integer PVMTASKDEFAULT, PVMTASKHOST, PVMTASKARCH, PVMTASKDEBUG
      integer PVMTASKTRACE, PVMMPPFRONT, PVMHOSTCOMPL
      integer PVMHOST, PVMARCH, PVMDEBUG, PVMTRACE
      integer PVMDATADEFAULT, PVMDATARAW, PVMDATAINPLACE
      integer PVMDEFAULT, PVMRAW, PVMINPLACE
      integer PVMTASKEXIT, PVMHOSTDELETE, PVMHOSTADD
      integer PVMROUTE, PVMDEBUGMASK, PVMAUTOERR
      integer PVMOUTPUTTID, PVMOUTPUTCODE, PVMRESVTIDS
      integer PVMTRACETID, PVMTRACECODE, PVMFRAGSIZE
      integer PVMDONTROUTE, PVMALLOWDIRECT, PVMROUTEDIRECT
      integer STRING, BYTE1, INTEGER2, INTEGER4
      integer REAL4, COMPLEX8, REAL8, COMPLEX16

      integer PvmOk, PvmSysErr, PvmBadParam, PvmMismatch
      integer PvmNoData, PvmNoHost, PvmNoFile, PvmNoMem
      integer PvmBadMsg, PvmNoBuf, PvmNoSuchBuf
      integer PvmNullGroup, PvmDupGroup, PvmNoGroup
      integer PvmNotInGroup, PvmNoinst, PvmHostFail, PvmNoParent
      integer PvmNotImpl, PvmDSysErr, PvmBadVersion, PvmOutOfRes
      integer PvmDupHost, PvmCantStart, PvmAlready, PvmNoTask
      integer PvmNoEntry, PvmDupEntry

c     --------------------
c     spawn 'flag' options
c     --------------------
      parameter( PVMTASKDEFAULT  =  0)
      parameter( PVMTASKHOST     =  1)
      parameter( PVMTASKARCH     =  2)
      parameter( PVMTASKDEBUG    =  4)
      parameter( PVMTASKTRACE    =  8)
      parameter( PVMMPPFRONT     = 16)
      parameter( PVMHOSTCOMPL    = 32)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMHOST  =  1)
      parameter( PVMARCH  =  2)
      parameter( PVMDEBUG =  4)
      parameter( PVMTRACE =  8)

c     -------------------------
c     buffer 'encoding' options
c     -------------------------
      parameter( PVMDATADEFAULT = 0)
      parameter( PVMDATARAW     = 1)
      parameter( PVMDATAINPLACE = 2)
c     --------------------------------
c     old option names still supported
c     --------------------------------
      parameter( PVMDEFAULT = 0)
      parameter( PVMRAW     = 1)
      parameter( PVMINPLACE = 2)

c     ----------------------
c     notify 'about' options
c     ----------------------
      parameter( PVMTASKEXIT   = 1 )
      parameter( PVMHOSTDELETE = 2 )
      parameter( PVMHOSTADD    = 3 )

c     --------------------------------
c     packing/unpacking 'what' options
c     --------------------------------
      parameter( STRING   = 0)
      parameter( BYTE1    = 1)
      parameter( INTEGER2 = 2)
      parameter( INTEGER4 = 3)
      parameter( REAL4    = 4)
      parameter( COMPLEX8 = 5)
      parameter( REAL8    = 6)
      parameter( COMPLEX16= 7)

c     --------------------------------
c     setopt/getopt options for 'what'
c     --------------------------------
      parameter( PVMROUTE      = 1)
      parameter( PVMDEBUGMASK  = 2)
      parameter( PVMAUTOERR    = 3)
      parameter( PVMOUTPUTTID  = 4)
      parameter( PVMOUTPUTCODE = 5)
      parameter( PVMTRACETID   = 6)
      parameter( PVMTRACECODE  = 7)
      parameter( PVMFRAGSIZE   = 8)
      parameter( PVMRESVTIDS   = 9)

c     --------------------------------------------
c     routing options for 'how' in setopt function
c     --------------------------------------------
      parameter( PVMDONTROUTE  = 1)
      parameter( PVMALLOWDIRECT= 2)
      parameter( PVMROUTEDIRECT= 3)

c     --------------------------
c     error 'info' return values
c     --------------------------
      parameter( PvmOk         =   0)
      parameter( PvmBadParam   =  -2)
      parameter( PvmMismatch   =  -3)
      parameter( PvmNoData     =  -5)
      parameter( PvmNoHost     =  -6)
      parameter( PvmNoFile     =  -7)
      parameter( PvmNoMem      = -10)
      parameter( PvmBadMsg     = -12)
      parameter( PvmSysErr     = -14)
      parameter( PvmNoBuf      = -15)
      parameter( PvmNoSuchBuf  = -16)
      parameter( PvmNullGroup  = -17)
      parameter( PvmDupGroup   = -18)
      parameter( PvmNoGroup    = -19)
      parameter( PvmNotInGroup = -20)
      parameter( PvmNoInst     = -21)
      parameter( PvmHostFail   = -22)
      parameter( PvmNoParent   = -23)
      parameter( PvmNotImpl    = -24)
      parameter( PvmDSysErr    = -25)
      parameter( PvmBadVersion = -26)
      parameter( PvmOutOfRes   = -27)
      parameter( PvmDupHost    = -28)
      parameter( PvmCantStart  = -29)
      parameter( PvmAlready    = -30)
      parameter( PvmNoTask     = -31)
      parameter( PvmNoEntry    = -32)
      parameter( PvmDupEntry   = -33)


C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     Local
C---- 
      integer mynum, instances(1000),ninst,inst, info,
     >    pdim,ip,jp, iread, inst_return,
     >    dodbx
      character*4 arch

C     Start up yourself
C---- 
      call pvmfmytid(mynum)
      write(6,*) 'Host is instance',mynum
      
      
C     How many ordinary nodes are there going to be?
C----
      open(host_channel,file='con.dat')
      write(6,*) 'How many nodes?'
      read(host_channel,*) pdim,ip,jp
      ninst = ip*jp
      write(6,*) '----',ip,' x',jp,' =',ninst
      close(host_channel)
      
      open(host_channel,file='dbx.dat')
      dodbx = 0
 21   read(host_channel,*,end=22) dodbx
      goto 21
 22   continue
      write(6,*) '---- Debugger:',dodbx
      close(host_channel)

C     Activate the reader node as last instance+1
C     if necessary
C----
      open(host_channel,file='rdr.dat')
      iread = 1
      read(host_channel,*,end=23) iread
 23   continue
      close(host_channel)
      if (iread.eq.1) then
         write(6,*) 'Creating reader node'
         call pvmfspawn('cgreader',
     >        PVMDEFAULT+dodbx*PVMDEBUG,'SUN4',1,inst_return,info)
         instances(ninst+1) = inst_return
         if (info.lt.0 .or. instances(ninst+1).lt.0) then
            write(6,*) 'Could not spawn reader',inst_return,info
            stop
         else
            write(6,*) 'Spawned reader as',instances(ninst+1)
         endif
      else
         iread = 0
         write(6,*) 'No separate reader node'
      endif

C     Activate the runner nodes
C---- 
      arch = '\0'
      do 10 inst=1,ninst
         call pvmfspawn('cgnode', PVMDEFAULT+dodbx*PVMDEBUG,
     >        'SUN4\0',1,inst_return,info)
         instances(inst) = inst_return
         if (info.lt.0) then
            write(6,*) 'Could not spawn node',inst_return,info
            stop
         endif
 10   continue
      write(6,*) 'HOST: initiation finished.',
     >     (instances(inst),inst=1,ninst+iread)
      
      call pvmfinitsend(PVMDEFAULT,info)
      if (info.lt.0) write(6,*) 'HOST: could not init send'
      call pvmfpack(INTEGER4,mynum,1,1,info)
      if (info.lt.0) write(6,*) 'HOST: unable to put host num'
      call pvmfpack(INTEGER4,iread,1,1,info)
      if (info.lt.0) write(6,*) 'HOST: unable to put iread'
      call pvmfpack(INTEGER4,ninst,1,1,info)
      if (info.lt.0) write(6,*) 'HOST: unable to put ninst'
      call pvmfpack(INTEGER4,instances,ninst+iread,1,info)
      if (info.lt.0) write(6,*) 'HOST: unable to put instances'
      call pvmfmcast(ninst+iread,instances,1234,info)
      if (info.lt.0) write(6,*) 'HOST: unable to send'
      
      write(6,*) 'HOST: data sent; waiting for nodes to complete'
      
C     We only check for termination of the reader node.
C---- 
      if (iread.eq.1) then
         call pvmfrecv(-1,5432,info)
         write(6,*) 'HOST: reader has closed'
      endif
      call pvmfexit(info)

      end
C----------------------------------------------------------------
      block data host_nit_channels

C     I/O channels
C     initialized in comp/v
C----
      integer 
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel
      common /io_channels/
     >     inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >     tmp_channel,host_channel

C     I/O channel status
C----
      logical
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open
      common /io_channel_status/
     >     dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open,err_channel_open

      data inchan,outchn,errchn,dmpchn,blkchn,solchn,logchn,
     >    tmp_channel,host_channel
     >    /5,6,1,7,11,8,9,10,4/
      data dmp_channel_open,sol_channel_open,log_channel_open,
     >     tmp_channel_open
     >     /.false.,.false.,.false.,.false./


      end
