      SUBROUTINE SGET54( N, A, LDA, B, LDB, S, LDS, T, LDT, U, LDU, V,
     $                   LDV, WORK, RESULT )
*
*  -- LAPACK test routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      INTEGER            LDA, LDB, LDS, LDT, LDU, LDV, N
      REAL               RESULT
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * ), B( LDB, * ), S( LDS, * ),
     $                   T( LDT, * ), U( LDU, * ), V( LDV, * ),
     $                   WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  SGET54 checks a generalized decomposition of the form
*
*           A = U*S*V'  and B = U*T* V'
*
*  where ' means transpose and U and V are orthogonal.
*
*  Specifically,
*
*   RESULT = ||( A - U*S*V', B - U*T*V' )|| / (||( A, B )||*n*ulp )
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The size of the matrix.  If it is zero, SGET54 does nothing.
*          It must be at least zero.
*
*  A       (input) REAL array, dimension (LDA, N)
*          The original (unfactored) matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of A.  It must be at least 1
*          and at least N.
*
*  B       (input) REAL array, dimension (LDB, N)
*          The original (unfactored) matrix B.
*
*  LDB     (input) INTEGER
*          The leading dimension of B.  It must be at least 1
*          and at least N.
*
*  S       (input) REAL array, dimension (LDS, N)
*          The factored matrix S.
*
*  LDS     (input) INTEGER
*          The leading dimension of S.  It must be at least 1
*          and at least N.
*
*  T       (input) REAL array, dimension (LDT, N)
*          The factored matrix T.
*
*  LDT     (input) INTEGER
*          The leading dimension of T.  It must be at least 1
*          and at least N.
*
*  U       (input) REAL array, dimension (LDU, N)
*          The orthogonal matrix on the left-hand side in the
*          decomposition.
*
*  LDU     (input) INTEGER
*          The leading dimension of U.  LDU must be at least N and
*          at least 1.
*
*  V       (input) REAL array, dimension (LDV, N)
*          The orthogonal matrix on the left-hand side in the
*          decomposition.
*
*  LDV     (input) INTEGER
*          The leading dimension of V.  LDV must be at least N and
*          at least 1.
*
*  WORK    (workspace) REAL array, dimension (3*N**2)
*
*  RESULT  (output) REAL
*          The value RESULT, It is currently limited to 1/ulp, to
*          avoid overflow. Errors are flagged by RESULT=10/ulp.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ZERO, ONE
      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
*     ..
*     .. Local Scalars ..
      REAL               ABNORM, ULP, UNFL, WNORM
*     ..
*     .. Local Arrays ..
      REAL               DUM( 1 )
*     ..
*     .. External Functions ..
      REAL               SLAMCH, cslange
      EXTERNAL           SLAMCH, cslange
*     ..
*     .. External Subroutines ..
      EXTERNAL           SGEMM, cslacpy
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, REAL
*     ..
*     .. Executable Statements ..
*
      RESULT = ZERO
      IF( N.LE.0 )
     $   RETURN
*
*     Constants
*
      UNFL = SLAMCH( 'Safe minimum' )
      ULP = SLAMCH( 'Epsilon' )*SLAMCH( 'Base' )
*
*     compute the norm of (A,B)
*
      CALL cslacpy( 'Full', N, N, A, LDA, WORK, N )
      CALL cslacpy( 'Full', N, N, B, LDB, WORK( N*N+1 ), N )
      ABNORM = MAX( cslange( '1', N, 2*N, WORK, N, DUM ), UNFL )
*
*     Compute W1 = A - U*S*V', and put in the array WORK(1:N*N)
*
      CALL cslacpy( ' ', N, N, A, LDA, WORK, N )
      CALL SGEMM( 'N', 'N', N, N, N, ONE, U, LDU, S, LDS, ZERO,
     $            WORK( N*N+1 ), N )
*
      CALL SGEMM( 'N', 'C', N, N, N, -ONE, WORK( N*N+1 ), N, V, LDV,
     $            ONE, WORK, N )
*
*     Compute W2 = B - U*T*V', and put in the workarray W(N*N+1:2*N*N)
*
      CALL cslacpy( ' ', N, N, B, LDB, WORK( N*N+1 ), N )
      CALL SGEMM( 'N', 'N', N, N, N, ONE, U, LDU, T, LDT, ZERO,
     $            WORK( 2*N*N+1 ), N )
*
      CALL SGEMM( 'N', 'C', N, N, N, -ONE, WORK( 2*N*N+1 ), N, V, LDV,
     $            ONE, WORK( N*N+1 ), N )
*
*     Compute norm(W)/ ( ulp*norm((A,B)) )
*
      WNORM = cslange( '1', N, 2*N, WORK, N, DUM )
*
      IF( ABNORM.GT.WNORM ) THEN
         RESULT = ( WNORM / ABNORM ) / ( 2*N*ULP )
      ELSE
         IF( ABNORM.LT.ONE ) THEN
            RESULT = ( MIN( WNORM, 2*N*ABNORM ) / ABNORM ) / ( 2*N*ULP )
         ELSE
            RESULT = MIN( WNORM / ABNORM, REAL( 2*N ) ) / ( 2*N*ULP )
         END IF
      END IF
*
      RETURN
*
*     End of SGET54
*
      END
