      SUBROUTINE SERRBD( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  SERRBD tests the error exits for csgebrd, csorgbr, csormbr, csbdsqr and
*  csbdsdc.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 4, LW = NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, INFO, J, NT
*     ..
*     .. Local Arrays ..
      INTEGER            IQ( NMAX, NMAX ), IW( NMAX )
      REAL               A( NMAX, NMAX ), D( NMAX ), E( NMAX ),
     $                   Q( NMAX, NMAX ), TP( NMAX ), TQ( NMAX ),
     $                   U( NMAX, NMAX ), V( NMAX, NMAX ), W( LW )
*     ..
*     .. External Functions ..
      LOGICAL            lsamen
      EXTERNAL           lsamen
*     ..
*     .. External Subroutines ..
      EXTERNAL           CHKXER, csbdsdc, csbdsqr, csgebd2, csgebrd, 
     $  csorgbr, 
     $                   csormbr
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          REAL
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / REAL( I+J )
   10    CONTINUE
   20 CONTINUE
      OK = .TRUE.
      NT = 0
*
*     Test error exits of the SVD routines.
*
      IF( lsamen( 2, C2, 'BD' ) ) THEN
*
*        csgebrd
*
         SRNAMT = 'csgebrd'
         INFOT = 1
         CALL csgebrd( -1, 0, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'csgebrd', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csgebrd( 0, -1, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'csgebrd', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL csgebrd( 2, 1, A, 1, D, E, TQ, TP, W, 2, INFO )
         CALL CHKXER( 'csgebrd', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL csgebrd( 2, 1, A, 2, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'csgebrd', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        csgebd2
*
         SRNAMT = 'csgebd2'
         INFOT = 1
         CALL csgebd2( -1, 0, A, 1, D, E, TQ, TP, W, INFO )
         CALL CHKXER( 'csgebd2', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csgebd2( 0, -1, A, 1, D, E, TQ, TP, W, INFO )
         CALL CHKXER( 'csgebd2', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL csgebd2( 2, 1, A, 1, D, E, TQ, TP, W, INFO )
         CALL CHKXER( 'csgebd2', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        csorgbr
*
         SRNAMT = 'csorgbr'
         INFOT = 1
         CALL csorgbr( '/', 0, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csorgbr( 'Q', -1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csorgbr( 'Q', 0, -1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csorgbr( 'Q', 0, 1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csorgbr( 'Q', 1, 0, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csorgbr( 'P', 1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csorgbr( 'P', 0, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL csorgbr( 'Q', 0, 0, -1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL csorgbr( 'Q', 2, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL csorgbr( 'Q', 2, 2, 1, A, 2, TQ, W, 1, INFO )
         CALL CHKXER( 'csorgbr', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        csormbr
*
         SRNAMT = 'csormbr'
         INFOT = 1
         CALL csormbr( '/', 'L', 'T', 0, 0, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csormbr( 'Q', '/', 'T', 0, 0, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csormbr( 'Q', 'L', '/', 0, 0, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL csormbr( 'Q', 'L', 'T', -1, 0, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL csormbr( 'Q', 'L', 'T', 0, -1, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL csormbr( 'Q', 'L', 'T', 0, 0, -1, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL csormbr( 'Q', 'L', 'T', 2, 0, 0, A, 1, TQ, U, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL csormbr( 'Q', 'R', 'T', 0, 2, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL csormbr( 'P', 'L', 'T', 2, 0, 2, A, 1, TQ, U, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL csormbr( 'P', 'R', 'T', 0, 2, 2, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL csormbr( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL csormbr( 'Q', 'L', 'T', 0, 2, 0, A, 1, TQ, U, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL csormbr( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, U, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'csormbr', INFOT, NOUT, LERR, OK )
         NT = NT + 13
*
*        csbdsqr
*
         SRNAMT = 'csbdsqr'
         INFOT = 1
         CALL csbdsqr( '/', 0, 0, 0, 0, D, E, V, 1, U, 1, A, 1, W, INFO 
     $  ) 
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csbdsqr( 'U', -1, 0, 0, 0, D, E, V, 1, U, 1, A, 1, W,
     $                INFO )
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csbdsqr( 'U', 0, -1, 0, 0, D, E, V, 1, U, 1, A, 1, W,
     $                INFO )
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL csbdsqr( 'U', 0, 0, -1, 0, D, E, V, 1, U, 1, A, 1, W,
     $                INFO )
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL csbdsqr( 'U', 0, 0, 0, -1, D, E, V, 1, U, 1, A, 1, W,
     $                INFO )
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL csbdsqr( 'U', 2, 1, 0, 0, D, E, V, 1, U, 1, A, 1, W, INFO 
     $  ) 
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL csbdsqr( 'U', 0, 0, 2, 0, D, E, V, 1, U, 1, A, 1, W, INFO 
     $  ) 
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL csbdsqr( 'U', 2, 0, 0, 1, D, E, V, 1, U, 1, A, 1, W, INFO 
     $  ) 
         CALL CHKXER( 'csbdsqr', INFOT, NOUT, LERR, OK )
         NT = NT + 8
*
*        csbdsdc
*
         SRNAMT = 'csbdsdc'
         INFOT = 1
         CALL csbdsdc( '/', 'N', 0, D, E, U, 1, V, 1, Q, IQ, W, IW,
     $                INFO )
         CALL CHKXER( 'csbdsdc', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL csbdsdc( 'U', '/', 0, D, E, U, 1, V, 1, Q, IQ, W, IW,
     $                INFO )
         CALL CHKXER( 'csbdsdc', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL csbdsdc( 'U', 'N', -1, D, E, U, 1, V, 1, Q, IQ, W, IW,
     $                INFO )
         CALL CHKXER( 'csbdsdc', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL csbdsdc( 'U', 'I', 2, D, E, U, 1, V, 1, Q, IQ, W, IW,
     $                INFO )
         CALL CHKXER( 'csbdsdc', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL csbdsdc( 'U', 'I', 2, D, E, U, 2, V, 1, Q, IQ, W, IW,
     $                INFO )
         CALL CHKXER( 'csbdsdc', INFOT, NOUT, LERR, OK )
         NT = NT + 5
      END IF
*
*     Print a summary line.
*
      IF( OK ) THEN
         WRITE( NOUT, FMT = 9999 )PATH, NT
      ELSE
         WRITE( NOUT, FMT = 9998 )PATH
      END IF
*
 9999 FORMAT( 1X, A3, ' routines passed the tests of the error exits',
     $      ' (', I3, ' tests done)' )
 9998 FORMAT( ' *** ', A3, ' routines failed the tests of the error ',
     $      'exits ***' )
*
      RETURN
*
*     End of SERRBD
*
      END
