      SUBROUTINE CERRGG( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  CERRGG tests the error exits for ccgges, ccggesX, ccggev, ccggevX,
*  ccggglm, ccgghrd, ccgglse, ccggqrf, ccggrqf, ccggsvd, ccggsvp, cchgeqz,
*  cctgevc, cctgexc, cctgsen, cctgsja, cctgsna, and cctgsyl.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = 6*NMAX )
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E+0, ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            DUMMYK, DUMMYL, I, IFST, ILST, INFO, J, M,
     $                   NCYCLE, NT, SDIM
      REAL               ANRM, BNRM, DIF, SCALE, TOLA, TOLB
*     ..
*     .. Local Arrays ..
      LOGICAL            BW( NMAX ), SEL( NMAX )
      INTEGER            IW( LW )
      REAL               LS( NMAX ), R1( NMAX ), R2( NMAX ),
     $                   RCE( NMAX ), RCV( NMAX ), RS( NMAX ), RW( LW )
      COMPLEX            A( NMAX, NMAX ), ALPHA( NMAX ),
     $                   B( NMAX, NMAX ), BETA( NMAX ), Q( NMAX, NMAX 
     $  ), 
     $                   TAU( NMAX ), U( NMAX, NMAX ), V( NMAX, NMAX ),
     $                   W( LW ), Z( NMAX, NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            CLCTES, CLCTSX, lsamen
      EXTERNAL           CLCTES, CLCTSX, lsamen
*     ..
*     .. External Subroutines ..
      EXTERNAL           ccgges, ccggesX, ccggev, ccggevX, ccggglm, 
     $  ccgghrd, 
     $                   ccgglse, ccggqrf, ccggrqf, ccggsvd, ccggsvp, 
     $  cchgeqz, 
     $                   CHKXER, cctgevc, cctgexc, cctgsen, cctgsja, 
     $  cctgsna, 
     $                   cctgsyl
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         SEL( J ) = .TRUE.
         DO 10 I = 1, NMAX
            A( I, J ) = ZERO
            B( I, J ) = ZERO
   10    CONTINUE
   20 CONTINUE
      DO 30 I = 1, NMAX
         A( I, I ) = ONE
         B( I, I ) = ONE
   30 CONTINUE
      OK = .TRUE.
      TOLA = 1.0E0
      TOLB = 1.0E0
      IFST = 1
      ILST = 1
      NT = 0
*
*     Test error exits for the GG path.
*
      IF( lsamen( 2, C2, 'GG' ) ) THEN
*
*        ccgghrd
*
         SRNAMT = 'ccgghrd'
         INFOT = 1
         CALL ccgghrd( '/', 'N', 0, 1, 0, A, 1, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccgghrd( 'N', '/', 0, 1, 0, A, 1, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccgghrd( 'N', 'N', -1, 0, 0, A, 1, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ccgghrd( 'N', 'N', 0, 0, 0, A, 1, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccgghrd( 'N', 'N', 0, 1, 1, A, 1, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccgghrd( 'N', 'N', 2, 1, 1, A, 1, B, 2, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ccgghrd( 'N', 'N', 2, 1, 1, A, 2, B, 1, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ccgghrd( 'V', 'N', 2, 1, 1, A, 2, B, 2, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ccgghrd( 'N', 'V', 2, 1, 1, A, 2, B, 2, Q, 1, Z, 1, INFO 
     $  ) 
         CALL CHKXER( 'ccgghrd', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        cchgeqz
*
         SRNAMT = 'cchgeqz'
         INFOT = 1
         CALL cchgeqz( '/', 'N', 'N', 0, 1, 0, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cchgeqz( 'E', '/', 'N', 0, 1, 0, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL cchgeqz( 'E', 'N', '/', 0, 1, 0, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cchgeqz( 'E', 'N', 'N', -1, 0, 0, A, 1, B, 1, ALPHA, 
     $  BETA, 
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL cchgeqz( 'E', 'N', 'N', 0, 0, 0, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cchgeqz( 'E', 'N', 'N', 0, 1, 1, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL cchgeqz( 'E', 'N', 'N', 2, 1, 1, A, 1, B, 2, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cchgeqz( 'E', 'N', 'N', 2, 1, 1, A, 2, B, 1, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 14
         CALL cchgeqz( 'E', 'V', 'N', 2, 1, 1, A, 2, B, 2, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL cchgeqz( 'E', 'N', 'V', 2, 1, 1, A, 2, B, 2, ALPHA, BETA,
     $                Q, 1, Z, 1, W, 1, RW, INFO )
         CALL CHKXER( 'cchgeqz', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        cctgevc
*
         SRNAMT = 'cctgevc'
         INFOT = 1
         CALL cctgevc( '/', 'A', SEL, 0, A, 1, B, 1, Q, 1, Z, 1, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cctgevc( 'R', '/', SEL, 0, A, 1, B, 1, Q, 1, Z, 1, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cctgevc( 'R', 'A', SEL, -1, A, 1, B, 1, Q, 1, Z, 1, 0, M,
     $                W, RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cctgevc( 'R', 'A', SEL, 2, A, 1, B, 2, Q, 1, Z, 2, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL cctgevc( 'R', 'A', SEL, 2, A, 2, B, 1, Q, 1, Z, 2, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cctgevc( 'L', 'A', SEL, 2, A, 2, B, 2, Q, 1, Z, 1, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL cctgevc( 'R', 'A', SEL, 2, A, 2, B, 2, Q, 1, Z, 1, 0, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL cctgevc( 'R', 'A', SEL, 2, A, 2, B, 2, Q, 1, Z, 2, 1, M, 
     $  W, 
     $                RW, INFO )
         CALL CHKXER( 'cctgevc', INFOT, NOUT, LERR, OK )
         NT = NT + 8
*
*     Test error exits for the GSV path.
*
      ELSE IF( lsamen( 3, PATH, 'GSV' ) ) THEN
*
*        ccggsvd
*
         SRNAMT = 'ccggsvd'
         INFOT = 1
         CALL ccggsvd( '/', 'N', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggsvd( 'N', '/', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggsvd( 'N', 'N', '/', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ccggsvd( 'N', 'N', 'N', -1, 0, 0, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggsvd( 'N', 'N', 'N', 0, -1, 0, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ccggsvd( 'N', 'N', 'N', 0, 0, -1, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ccggsvd( 'N', 'N', 'N', 2, 1, 1, DUMMYK, DUMMYL, A, 1, B,
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ccggsvd( 'N', 'N', 'N', 1, 1, 2, DUMMYK, DUMMYL, A, 1, B,
     $                1, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL ccggsvd( 'U', 'N', 'N', 2, 2, 2, DUMMYK, DUMMYL, A, 2, B,
     $                2, R1, R2, U, 1, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 18
         CALL ccggsvd( 'N', 'V', 'N', 2, 2, 2, DUMMYK, DUMMYL, A, 2, B,
     $                2, R1, R2, U, 2, V, 1, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         INFOT = 20
         CALL ccggsvd( 'N', 'N', 'Q', 2, 2, 2, DUMMYK, DUMMYL, A, 2, B,
     $                2, R1, R2, U, 2, V, 2, Q, 1, W, RW, IW, INFO )
         CALL CHKXER( 'ccggsvd', INFOT, NOUT, LERR, OK )
         NT = NT + 11
*
*        ccggsvp
*
         SRNAMT = 'ccggsvp'
         INFOT = 1
         CALL ccggsvp( '/', 'N', 'N', 0, 0, 0, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggsvp( 'N', '/', 'N', 0, 0, 0, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggsvp( 'N', 'N', '/', 0, 0, 0, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ccggsvp( 'N', 'N', 'N', -1, 0, 0, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggsvp( 'N', 'N', 'N', 0, -1, 0, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ccggsvp( 'N', 'N', 'N', 0, 0, -1, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ccggsvp( 'N', 'N', 'N', 2, 1, 1, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ccggsvp( 'N', 'N', 'N', 1, 2, 1, A, 1, B, 1, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL ccggsvp( 'U', 'N', 'N', 2, 2, 2, A, 2, B, 2, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 1, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 18
         CALL ccggsvp( 'N', 'V', 'N', 2, 2, 2, A, 2, B, 2, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 2, V, 1, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         INFOT = 20
         CALL ccggsvp( 'N', 'N', 'Q', 2, 2, 2, A, 2, B, 2, TOLA, TOLB,
     $                DUMMYK, DUMMYL, U, 2, V, 2, Q, 1, IW, RW, TAU, W,
     $                INFO )
         CALL CHKXER( 'ccggsvp', INFOT, NOUT, LERR, OK )
         NT = NT + 11
*
*        cctgsja
*
         SRNAMT = 'cctgsja'
         INFOT = 1
         CALL cctgsja( '/', 'N', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cctgsja( 'N', '/', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL cctgsja( 'N', 'N', '/', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cctgsja( 'N', 'N', 'N', -1, 0, 0, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL cctgsja( 'N', 'N', 'N', 0, -1, 0, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cctgsja( 'N', 'N', 'N', 0, 0, -1, DUMMYK, DUMMYL, A, 1, 
     $  B, 
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cctgsja( 'N', 'N', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 0, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL cctgsja( 'N', 'N', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                0, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 18
         CALL cctgsja( 'U', 'N', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 0, V, 1, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 20
         CALL cctgsja( 'N', 'V', 'N', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 0, Q, 1, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         INFOT = 22
         CALL cctgsja( 'N', 'N', 'Q', 0, 0, 0, DUMMYK, DUMMYL, A, 1, B,
     $                1, TOLA, TOLB, R1, R2, U, 1, V, 1, Q, 0, W,
     $                NCYCLE, INFO )
         CALL CHKXER( 'cctgsja', INFOT, NOUT, LERR, OK )
         NT = NT + 11
*
*     Test error exits for the GLM path.
*
      ELSE IF( lsamen( 3, PATH, 'GLM' ) ) THEN
*
*        ccggglm
*
         SRNAMT = 'ccggglm'
         INFOT = 1
         CALL ccggglm( -1, 0, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggglm( 0, -1, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggglm( 0, 1, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggglm( 0, 0, -1, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggglm( 1, 0, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggglm( 0, 0, 0, A, 0, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccggglm( 0, 0, 0, A, 1, B, 0, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ccggglm( 1, 1, 1, A, 1, B, 1, TAU, ALPHA, BETA, W, 1,
     $                INFO )
         CALL CHKXER( 'ccggglm', INFOT, NOUT, LERR, OK )
         NT = NT + 8
*
*     Test error exits for the LSE path.
*
      ELSE IF( lsamen( 3, PATH, 'LSE' ) ) THEN
*
*        ccgglse
*
         SRNAMT = 'ccgglse'
         INFOT = 1
         CALL ccgglse( -1, 0, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccgglse( 0, -1, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccgglse( 0, 0, -1, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccgglse( 0, 0, 1, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccgglse( 0, 1, 0, A, 1, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccgglse( 0, 0, 0, A, 0, B, 1, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccgglse( 0, 0, 0, A, 1, B, 0, TAU, ALPHA, BETA, W, LW,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL ccgglse( 1, 1, 1, A, 1, B, 1, TAU, ALPHA, BETA, W, 1,
     $                INFO )
         CALL CHKXER( 'ccgglse', INFOT, NOUT, LERR, OK )
         NT = NT + 8
*
*     Test error exits for the GQR path.
*
      ELSE IF( lsamen( 3, PATH, 'GQR' ) ) THEN
*
*        ccggqrf
*
         SRNAMT = 'ccggqrf'
         INFOT = 1
         CALL ccggqrf( -1, 0, 0, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggqrf( 0, -1, 0, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggqrf( 0, 0, -1, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggqrf( 0, 0, 0, A, 0, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ccggqrf( 0, 0, 0, A, 1, ALPHA, B, 0, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ccggqrf( 1, 1, 2, A, 1, ALPHA, B, 1, BETA, W, 1, INFO )
         CALL CHKXER( 'ccggqrf', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
*        ccggrqf
*
         SRNAMT = 'ccggrqf'
         INFOT = 1
         CALL ccggrqf( -1, 0, 0, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggrqf( 0, -1, 0, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggrqf( 0, 0, -1, A, 1, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggrqf( 0, 0, 0, A, 0, ALPHA, B, 1, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ccggrqf( 0, 0, 0, A, 1, ALPHA, B, 0, BETA, W, LW, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ccggrqf( 1, 1, 2, A, 1, ALPHA, B, 1, BETA, W, 1, INFO )
         CALL CHKXER( 'ccggrqf', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
*     Test error exits for the CGS, CGV, CGX, and CXV paths.
*
      ELSE IF( lsamen( 3, PATH, 'CGS' ) .OR.
     $         lsamen( 3, PATH, 'CGV' ) .OR.
     $         lsamen( 3, PATH, 'CGX' ) .OR. lsamen( 3, PATH, 'CXV' ) 
     $  ) 
     $          THEN
*
*        ccgges
*
         SRNAMT = 'ccgges '
         INFOT = 1
         CALL ccgges( '/', 'N', 'S', CLCTES, 1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccgges( 'N', '/', 'S', CLCTES, 1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccgges( 'N', 'V', '/', CLCTES, 1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccgges( 'N', 'V', 'S', CLCTES, -1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccgges( 'N', 'V', 'S', CLCTES, 1, A, 0, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ccgges( 'N', 'V', 'S', CLCTES, 1, A, 1, B, 0, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 14
         CALL ccgges( 'N', 'V', 'S', CLCTES, 1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 0, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 14
         CALL ccgges( 'V', 'V', 'S', CLCTES, 2, A, 2, B, 2, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 2, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL ccgges( 'N', 'V', 'S', CLCTES, 1, A, 1, B, 1, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 1, U, 0, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL ccgges( 'V', 'V', 'S', CLCTES, 2, A, 2, B, 2, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 2, U, 1, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         INFOT = 18
         CALL ccgges( 'V', 'V', 'S', CLCTES, 2, A, 2, B, 2, SDIM, 
     $  ALPHA, 
     $               BETA, Q, 2, U, 2, W, 1, RW, BW, INFO )
         CALL CHKXER( 'ccgges ', INFOT, NOUT, LERR, OK )
         NT = NT + 11
*
*        ccggesX
*
         SRNAMT = 'ccggesX'
         INFOT = 1
         CALL ccggesX( '/', 'N', 'S', CLCTSX, 'N', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggesX( 'N', '/', 'S', CLCTSX, 'N', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggesX( 'V', 'V', '/', CLCTSX, 'N', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, '/', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', -1, A, 1, B, 1, 
     $  SDIM, 
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 1, A, 0, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 1, A, 1, B, 0, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 0, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 2, A, 2, B, 2, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 17
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 0, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 17
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 2, A, 2, B, 2, SDIM,
     $                ALPHA, BETA, Q, 2, U, 1, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 21
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'B', 2, A, 2, B, 2, SDIM,
     $                ALPHA, BETA, Q, 2, U, 2, RCE, RCV, W, 1, RW, IW,
     $                1, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         INFOT = 24
         CALL ccggesX( 'V', 'V', 'S', CLCTSX, 'V', 1, A, 1, B, 1, SDIM,
     $                ALPHA, BETA, Q, 1, U, 1, RCE, RCV, W, 32, RW, IW,
     $                0, BW, INFO )
         CALL CHKXER( 'ccggesX', INFOT, NOUT, LERR, OK )
         NT = NT + 13
*
*        ccggev
*
         SRNAMT = 'ccggev '
         INFOT = 1
         CALL ccggev( '/', 'N', 1, A, 1, B, 1, ALPHA, BETA, Q, 1, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggev( 'N', '/', 1, A, 1, B, 1, ALPHA, BETA, Q, 1, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggev( 'V', 'V', -1, A, 1, B, 1, ALPHA, BETA, Q, 1, U, 
     $  1, 
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggev( 'V', 'V', 1, A, 0, B, 1, ALPHA, BETA, Q, 1, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccggev( 'V', 'V', 1, A, 1, B, 0, ALPHA, BETA, Q, 1, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ccggev( 'N', 'V', 1, A, 1, B, 1, ALPHA, BETA, Q, 0, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL ccggev( 'V', 'V', 2, A, 2, B, 2, ALPHA, BETA, Q, 1, U, 2,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ccggev( 'V', 'N', 2, A, 2, B, 2, ALPHA, BETA, Q, 2, U, 0,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ccggev( 'V', 'V', 2, A, 2, B, 2, ALPHA, BETA, Q, 2, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL ccggev( 'V', 'V', 1, A, 1, B, 1, ALPHA, BETA, Q, 1, U, 1,
     $               W, 1, RW, INFO )
         CALL CHKXER( 'ccggev ', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        ccggevX
*
         SRNAMT = 'ccggevX'
         INFOT = 1
         CALL ccggevX( '/', 'N', 'N', 'N', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL ccggevX( 'N', '/', 'N', 'N', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL ccggevX( 'N', 'N', '/', 'N', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL ccggevX( 'N', 'N', 'N', '/', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL ccggevX( 'N', 'N', 'N', 'N', -1, A, 1, B, 1, ALPHA, BETA,
     $                Q, 1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, 
     $  W, 
     $                1, RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL ccggevX( 'N', 'N', 'N', 'N', 1, A, 0, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL ccggevX( 'N', 'N', 'N', 'N', 1, A, 1, B, 0, ALPHA, BETA, 
     $  Q, 
     $                1, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ccggevX( 'N', 'N', 'N', 'N', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                0, U, 1, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL ccggevX( 'N', 'V', 'N', 'N', 2, A, 2, B, 2, ALPHA, BETA, 
     $  Q, 
     $                1, U, 2, 1, 2, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL ccggevX( 'N', 'N', 'N', 'N', 1, A, 1, B, 1, ALPHA, BETA, 
     $  Q, 
     $                1, U, 0, 1, 1, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL ccggevX( 'N', 'N', 'V', 'N', 2, A, 2, B, 2, ALPHA, BETA, 
     $  Q, 
     $                2, U, 1, 1, 2, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  1, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         INFOT = 25
         CALL ccggevX( 'N', 'N', 'V', 'N', 2, A, 2, B, 2, ALPHA, BETA, 
     $  Q, 
     $                2, U, 2, 1, 2, LS, RS, ANRM, BNRM, RCE, RCV, W, 
     $  0, 
     $                RW, IW, BW, INFO )
         CALL CHKXER( 'ccggevX', INFOT, NOUT, LERR, OK )
         NT = NT + 12
*
*        cctgexc
*
         SRNAMT = 'cctgexc'
         INFOT = 3
         CALL cctgexc( .TRUE., .TRUE., -1, A, 1, B, 1, Q, 1, Z, 1, 
     $  IFST, 
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL cctgexc( .TRUE., .TRUE., 1, A, 0, B, 1, Q, 1, Z, 1, IFST,
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL cctgexc( .TRUE., .TRUE., 1, A, 1, B, 0, Q, 1, Z, 1, IFST,
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL cctgexc( .FALSE., .TRUE., 1, A, 1, B, 1, Q, 0, Z, 1, 
     $  IFST, 
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL cctgexc( .TRUE., .TRUE., 1, A, 1, B, 1, Q, 0, Z, 1, IFST,
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL cctgexc( .TRUE., .FALSE., 1, A, 1, B, 1, Q, 1, Z, 0, 
     $  IFST, 
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL cctgexc( .TRUE., .TRUE., 1, A, 1, B, 1, Q, 1, Z, 0, IFST,
     $                ILST, INFO )
         CALL CHKXER( 'cctgexc', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        cctgsen
*
         SRNAMT = 'cctgsen'
         INFOT = 1
         CALL cctgsen( -1, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, -1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, 1, A, 0, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, 1, A, 1, B, 0, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 0, Z, 1, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 0, M, TOLA, TOLB, RCV, W, 1, IW, 
     $  1, 
     $                INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 21
         CALL cctgsen( 3, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, -5, IW,
     $                1, INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 23
         CALL cctgsen( 0, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 20, IW,
     $                0, INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 23
         CALL cctgsen( 1, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 20, IW,
     $                0, INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         INFOT = 23
         CALL cctgsen( 5, .TRUE., .TRUE., SEL, 1, A, 1, B, 1, ALPHA,
     $                BETA, Q, 1, Z, 1, M, TOLA, TOLB, RCV, W, 20, IW,
     $                1, INFO )
         CALL CHKXER( 'cctgsen', INFOT, NOUT, LERR, OK )
         NT = NT + 11
*
*        cctgsna
*
         SRNAMT = 'cctgsna'
         INFOT = 1
         CALL cctgsna( '/', 'A', SEL, 1, A, 1, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cctgsna( 'B', '/', SEL, 1, A, 1, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cctgsna( 'B', 'A', SEL, -1, A, 1, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cctgsna( 'B', 'A', SEL, 1, A, 0, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL cctgsna( 'B', 'A', SEL, 1, A, 1, B, 0, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cctgsna( 'E', 'A', SEL, 1, A, 1, B, 1, Q, 0, U, 1, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL cctgsna( 'E', 'A', SEL, 1, A, 1, B, 1, Q, 1, U, 0, R1, 
     $  R2, 
     $                1, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 15
         CALL cctgsna( 'E', 'A', SEL, 1, A, 1, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                0, M, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         INFOT = 18
         CALL cctgsna( 'E', 'A', SEL, 1, A, 1, B, 1, Q, 1, U, 1, R1, 
     $  R2, 
     $                1, M, W, 0, IW, INFO )
         CALL CHKXER( 'cctgsna', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        cctgsyl
*
         SRNAMT = 'cctgsyl'
         INFOT = 1
         CALL cctgsyl( '/', 0, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cctgsyl( 'N', -1, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL cctgsyl( 'N', 0, 0, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cctgsyl( 'N', 0, 1, 0, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cctgsyl( 'N', 0, 1, 1, A, 0, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL cctgsyl( 'N', 0, 1, 1, A, 1, B, 0, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cctgsyl( 'N', 0, 1, 1, A, 1, B, 1, Q, 0, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL cctgsyl( 'N', 0, 1, 1, A, 1, B, 1, Q, 1, U, 0, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 14
         CALL cctgsyl( 'N', 0, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 0, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 16
         CALL cctgsyl( 'N', 0, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  0, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 20
         CALL cctgsyl( 'N', 1, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         INFOT = 20
         CALL cctgsyl( 'N', 2, 1, 1, A, 1, B, 1, Q, 1, U, 1, V, 1, Z, 
     $  1, 
     $                SCALE, DIF, W, 1, IW, INFO )
         CALL CHKXER( 'cctgsyl', INFOT, NOUT, LERR, OK )
         NT = NT + 12
      END IF
*
*     Print a summary line.
*
      IF( OK ) THEN
         WRITE( NOUT, FMT = 9999 )PATH, NT
      ELSE
         WRITE( NOUT, FMT = 9998 )PATH
      END IF
*
 9999 FORMAT( 1X, A3, ' routines passed the tests of the error exits 
     $  (', 
     $      I3, ' tests done)' )
 9998 FORMAT( ' *** ', A3, ' routines failed the tests of the error ',
     $      'exits ***' )
*
      RETURN
*
*     End of CERRGG
*
      END
