/*
 * lapack_slarrf.c
 *
 *This program is a C interface to slarrf.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slarrf(const int n, const float * d, const float * l, const float * ld, const int clstrt, const int clend, const float * w, float * wgap, const float * werr, const float spdiam, const float clgapl, const float clgapr, const double pivmin, float * sigma, float * dplus, float * lplus, float * work )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_clstrt=clstrt, F77_clend=clend;
#else
	#define F77_n n
	#define F77_clstrt clstrt
	#define F77_clend clend
#endif

	f77_slarrf(&F77_n, d, l, ld, &F77_clstrt, &F77_clend, w, wgap, werr, &spdiam, &clgapl, &clgapr, &pivmin, sigma, dplus, lplus, work);

#ifdef F77_INT
#endif

}
