/*
 * lapack_slaqr1.c
 *
 *This program is a C interface to slaqr1.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slaqr1(const int n, const float * h, const int ldh, const float sr1, float * v )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_ldh=ldh;
#else
	#define F77_n n
	#define F77_ldh ldh
#endif

	f77_slaqr1(&F77_n, h, &F77_ldh, &sr1, v);

#ifdef F77_INT
#endif

}
