/*
 * lapack_iparmq.c
 *
 *This program is a C interface to iparmq.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

int lapack_iparmq(const int ispec, const char * name, const char * opts, const int n, const int ilo, const int ihi, const int lwork )
{

	int output;

#ifdef F77_INT
	F77_INT F77_ispec=ispec, F77_n=n, F77_ilo=ilo, F77_ihi=ihi, F77_lwork=lwork;
#else
	#define F77_ispec ispec
	#define F77_n n
	#define F77_ilo ilo
	#define F77_ihi ihi
	#define F77_lwork lwork
#endif

#ifdef F77_CHAR
	F77_CHAR F77_name = C2F_STR(name, strlen(name)) , F77_opts = C2F_STR(opts, strlen(opts)) ;
#else
	#define F77_name name
	#define F77_opts opts
#endif

	f77_iparmq(&output, &F77_ispec, name, opts, &F77_n, &F77_ilo, &F77_ihi, &F77_lwork);

#ifdef F77_INT
#endif

return output;
}
