/*
 * lapack_dlaneg.c
 *
 *This program is a C interface to dlaneg.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

int lapack_dlaneg(const int n, const double * d, const double * lld, const double sigma, const double pivmin, const int r )
{

	int output;

#ifdef F77_INT
	F77_INT F77_n=n, F77_r=r;
#else
	#define F77_n n
	#define F77_r r
#endif

	f77_dlaneg(&output, &F77_n, d, lld, &sigma, &pivmin, &F77_r);

#ifdef F77_INT
#endif

return output;
}
