/*
 * lapack_claqr2.c
 *
 *This program is a C interface to claqr2.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_claqr2(const long int wantt, const long int wantz, const int n, const int ktop, const int kbot, const int nw, void * h, const int ldh, const int iloz, const int ihiz, void * z, const int ldz, int * ns, int * nd, void * sh, void * v, const int ldv, const int nh, void * t, const int ldt, const int nv, void * wv, const int ldwv, void * work, const int lwork )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_ktop=ktop, F77_kbot=kbot, F77_nw=nw, F77_ldh=ldh, F77_iloz=iloz, F77_ihiz=ihiz, F77_ldz=ldz, F77_ldv=ldv, F77_nh=nh, F77_ldt=ldt, F77_nv=nv, F77_ldwv=ldwv, F77_lwork=lwork;
	int i_local;
	F77_INT F77_ns[1];
	F77_INT F77_nd[1];
#else
	#define F77_n n
	#define F77_ktop ktop
	#define F77_kbot kbot
	#define F77_nw nw
	#define F77_ldh ldh
	#define F77_iloz iloz
	#define F77_ihiz ihiz
	#define F77_ldz ldz
	#define F77_ns ns
	#define F77_nd nd
	#define F77_ldv ldv
	#define F77_nh nh
	#define F77_ldt ldt
	#define F77_nv nv
	#define F77_ldwv ldwv
	#define F77_lwork lwork
#endif

#ifdef F77_LOG
	F77_LOG F77_wantt=wantt, F77_wantz=wantz;
#else
	#define F77_wantt wantt
	#define F77_wantz wantz
#endif

	f77_claqr2(&F77_wantt, &F77_wantz, &F77_n, &F77_ktop, &F77_kbot, &F77_nw, h, &F77_ldh, &F77_iloz, &F77_ihiz, z, &F77_ldz, F77_ns, F77_nd, sh, v, &F77_ldv, &F77_nh, t, &F77_ldt, &F77_nv, wv, &F77_ldwv, work, &F77_lwork);

#ifdef F77_INT
	ns[0]=(int) F77_ns[0];
	nd[0]=(int) F77_nd[0];
#endif

#ifdef F77_LOG
#endif

}
