import AT.Ac.univie.imp.loeffler.pde.threeD.fd.*;
import AT.Ac.univie.imp.loeffler.util.*;
import java.util.*;

/**
 * A test observer for observables of class FMG.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */

class TestObserver implements Observer {
     /**
      * will be called if the FMG algorithm (invoced via FMG.fmg()) has produced a result.
      * <p>
      * Prints out some sample values of the result and that's it.
      *
      * @arg o   the object of type FMG that we observe
      * @arg arg the result of of the FMG algorithm which is of type BoundaryGrid
      */
     public void update(Observable o, Object arg) {
     	Contract.pre(o instanceof FMG,"o of type FMG");
     	Contract.pre(arg instanceof BoundaryGrid,"arg of type BoundaryGrid");
     	
     	ConstBoundaryGrid result = (BoundaryGrid) arg;
     	
     	System.out.println("Observer: 0  0  0:  " + result.get(0,0,0));
          System.out.println("Observer: 1  2  3:  " + result.get(1,2,3));
          System.out.println("Observer: 30 20 10: " + result.get(30,20,10));
     }
}
