package AT.Ac.univie.imp.loeffler.util;

/**
 * Exception class that is thrown if a precondition of a method is not met.
 *
 * Since this class is a subclass of RuntimeException it is not enforced by the compiler to catch objects of this class.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public class PreconditionNotMetException extends RuntimeException {
     /**
      * construct with no particular message
      */
     public PreconditionNotMetException() {};
     
     /**
      * construct with the given message
      *
      * @param msg the message
      */
     public PreconditionNotMetException(String msg) {super(msg);};
}
