package AT.Ac.univie.imp.loeffler.util;

/**
 * Exception class that is thrown if an assertion failed.
 *
 * Since this class is a subclass of RuntimeException it is not enforced by the compiler to catch objects of this class.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public class AssertionFailedException extends RuntimeException {
     /**
      * construct with no particular message
      */
     public AssertionFailedException() {};
     
     /**
      * construct with the given message
      *
      * @param msg the message
      */
     public AssertionFailedException(String msg) {super(msg);};
}
