package AT.Ac.univie.imp.loeffler.pde.threeD.fd;

/**
 * A Stencil contains 27 doubles and can be used to represent the relationship between a grid element and its
 * 26 nearest neighbours in 3D.
 *
 * Positions are identified by integer indices relative to the central element, which consequently has the
 * position (0,0,0).
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public interface Stencil {
     /**
      * gets the element at the specified position.
      *
      * @param x the index in the x-direction of the desired element (-1 <= x <= 1)
      * @param y the index in the y-direction of the desired element (-1 <= y <= 1)
      * @param z the index in the z-direction of the desired element (-1 <= z <= 1)
      * @returns the element at the specified position
      */
     double get(int x, int y, int z);
}
