package AT.Ac.univie.imp.loeffler.pde.threeD.fd;

/**
 * The interface to objects that exactly solve a linear elliptic partial differential equation (PDE) on a regular cubic 
 * grid in 3D.
 * <p>
 * Part of the (Full) Multigrid ((F)MG) algorithm is the exact solving of the PDE at the coarsest grid level. This step 
 * must be efficient, because it is performed several times during the course of the MG algorithm and once at the 
 * beginning of the FMG algorithm.
 * <p>
 * Not all algorithms suited for exactly solving a PDE work on all grid sizes, so it is important that the coarsest
 * grid of the (F)MG algorithm is of a size that is compatible with the solving algorithm that is implemented by
 * implementing this interface.
 *
 * @see FMG
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public interface Solver {
     /**
      * exactly solve a linear elliptic PDE on a regular cubic grid in 3D given an approximation to the solution and the
      * right hand side (source term) of the PDE
      *
      * If Ax = f defines the PDE, this method solves for the true solution x given an approximation u of x and the 
      * right hand side f.
      *
      * @see PDE
      *
      * @param u an approximation to the true solution. Even if the solution algorithm doesn't need to start from an 
      *          approximation this argument is needed because it serves as a prototype for the construction of the 
      *          solution grid.
      * @param f the right hand side of the PDE
      * @return the exact solution x
      */
     BoundaryGrid solve(ConstBoundaryGrid u, ConstNoBoundaryGrid f);
}
