package AT.Ac.univie.imp.loeffler.pde.threeD.fd;

/**
 * This interface defines the restrict() method which produces a coarse grid from the next finer grid by restriction.
 * <p>
 * The Full Multigrid (FMG) algorithm works with grids of different sizes corresponding to different levels through
 * the relation size = 2^level + 1, where size is the number of grid elements in one dimension. Restriction is the 
 * process of taking a function whose value is known at the grid elements of a grid at a certain level (the fine grid)
 * and producing the values of the function at the grid elements of a grid at the next coarser level (the coarse grid).
 * The fine grid and the coarse grid are oriented such that their corner elements coincide.
 * 
 * @see FMG
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public interface Restrictor {
     /**
      * restricts a function sampled on a specific grid to the next coarser grid
      *
      * @param grid the input function sampled on a grid at a certain level (size of grid must be 2^level + 1 where 
      *             level > 1)
      * @return the function sampled on a grid at the next coarser (lower) level
      */
     Grid restrict(ConstGrid grid);
}
