package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.parallel.*;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class RestrictorByStencil that helps parallelizing method RestrictorByStencil.restrict().
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
final class RestrictByStencilParallelizer extends Parallelizer {
     /**
      * construct.
      */
     public RestrictByStencilParallelizer(RestrictorByStencil res, Grid coarse, ConstGrid fine) {
          this.res    = res;
          this.coarse = coarse;
          this.fine   = fine;
          
          start();
     }
     
     /**
      * re-route.
      */
     public void runParallel(int myNum, int totalNum) {
          res.restrictProper(coarse,fine,myNum,totalNum);
     }
     
     private RestrictorByStencil res;
     private Grid                coarse;
     private ConstGrid           fine;
}
