package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.parallel.*;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class InterpolatorByStencil that helps parallelizing method InterpolatorByStencil.interpolate().
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
final class InterpolateByStencilParallelizer extends Parallelizer {
     /**
      * construct.
      */
     public InterpolateByStencilParallelizer(InterpolatorByStencil inter, BoundaryGrid fine, ConstBoundaryGrid coarse) {
          this.inter  = inter;
          this.fine   = fine;
          this.coarse = coarse;
          
          start();
     }
     
     /**
      * re-route.
      */
     public void runParallel(int myNum, int totalNum) {
          inter.interpolateProper(fine,coarse,myNum,totalNum);
     }
     
     private InterpolatorByStencil inter;
     private BoundaryGrid          fine;
     private ConstBoundaryGrid     coarse;
}
