package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * An implementation of BoundaryGrid where all the boundary elements are set once at construction time to a
 * single, common value and remain fixed thereafter.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class FixedBoundaryGrid extends BoundaryGrid {
     /**
      * construct from size, initial value for all elements in the interior and initial value for all elements
      * at the boundary.
      *
      * @param size          the size of the grid ( > 0)
      * @param interiorValue the value to which all interior grid elements will be set
      * @param boundaryValue the value to which all boundary grid elements will be set
      */
     public FixedBoundaryGrid(int size, double interiorValue, double boundaryValue) {
          super(size,boundaryValue);
          this.boundaryValue = boundaryValue;
          for (int i = 1; i < (s - 1); i++) {
               for (int j = 1; j < (s - 1); j++) {
                    for (int k = 1; k < (s - 1); k++) {
                         g[i][j][k] = interiorValue;
                    }
               }
          }
     }

     /**
      * implements method from ConstGrid.
      *
      * @see ConstGrid#newInstance
      */
     public Grid newInstance(int size, double value) {
          return new FixedBoundaryGrid(size,value,boundaryValue);
     }

     /**
      * implements method from Grid.
      *
      * the given grid element must lie at the boundary of the grid
      *
      * @see Grid#getBoundary
      */
     protected double getBoundary(int x, int y, int z) {
          Contract.pre(isBoundary(x,y,z),"grid element must be part of the boundary");
          
          return g[x][y][z];
     }

     private double boundaryValue;
}
