package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.parallel.*;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class DampedJacobi that implements method DampedJacobi.smooth() in a parallel manner.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
final class DampedJacobiSmoothParallelizer extends Parallelizer {
     /**
      * construct.
      *
      */
     public DampedJacobiSmoothParallelizer(DampedJacobi dj, BoundaryGrid g, ConstBoundaryGrid u,
                                           ConstNoBoundaryGrid f) {
          this.dj = dj;
          this.g  = g;
          this.u  = u;
          this.f  = f;
          
          start();
     }
     
     /**
      * re-route.
      */
     public void runParallel(int myNum, int totalNum) {
          dj.smoothProper(g,u,f,myNum,totalNum);
     }
     
     private DampedJacobi        dj;
     private BoundaryGrid        g;
     private ConstBoundaryGrid   u;
     private ConstNoBoundaryGrid f;
}
