package AT.Ac.univie.imp.loeffler.parallel;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * Customized implementation of class Thread that works closely with class Parallelizer and actually calls
 * the parallel algorithm in each thread.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */

class ParallelRunner extends Thread {
     /**
      * create a new thread working with the given Parallelizer and having the given thread number.
      *
      * @param p the parallelizer to work with
      * @param num the number of this thread (0 <= num < total number of threads)
      */
     ParallelRunner(Parallelizer p, int num) {
          super(p.threadGroup,"ParallelRunner-" + num);
          
          // if p were a null-object we would have noticed it in the call top super() above - so no need to check this.
          Contract.pre(0 <= num && num < p.numThreads,"0 <= num < total number of threads");
          
          this.p   = p;
          this.num = num;
     }

     /**
      * the Threads main method
      */
     public void run() {
          p.target.runParallel(num,p.numThreads);
          p.finished();
     }

     private Parallelizer p;
     private int          num;
}
