/* rasremap.c  --  routine to remap a raster file from color (through its */
/*                 color map) to grayscale.                               */
/* includes: main */

/* depends on: ReadRasterFile, WriteRasterFile, ExtractLuminance */

/* version 2.0     14 Jan 1993 */

/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */


#include "stdio.h"
#include "malloc.h"
#include "rasterio.h"

#define ALLOC    1


char *Img;
struct rasterfile RasHd;	/* raster file header */



main( argc, argv )
   unsigned int argc;
   char * argv[];
   {
   int X = 512;
   int Y = 512;
   int i,n;
   byte pix;
   char *InName, *OutName;
   FILE *fpi, *fpo;
   byte *CMap;
   byte *C;
   byte *I;
   int strip = 0;  /* non zero ==> strip off cmap */
   int N;
   int std = 0;   /* non zero implies use stdin, stdout */

   /* check args */

   if ( argc < 2 )
      {
      fprintf(stderr, "usage: rasremap [-r] [-s] [<] RasFileIn [>] RasfileOut\n");
      exit(0);
      }


   /* get args */
   for ( i=argc-1; i>0; --i)
      {
      if ( argv[i][0] == '-' )
         {
         if ( argv[i][1] == 'r'  ||  argv[i][2] == 'r' ) strip = 1;
         if ( argv[i][1] == 's'  ||  argv[i][2] == 's' )   std = 1;
         }
      }


   /* use stdin, stdout? */
   if ( std )
      {
      fpi = stdin;
      fpo = stdout;
      InName = "stdin";
      OutName = "stdout";
      }
   else 
      {
      InName  = argv[argc-2];
      OutName = argv[argc-1];
      /* open input file */
      fpi = OpenFile( InName, NULL, "r" );
      }

   /* read the input image into memory */
   if ( ReadRasterFile( fpi, &RasHd, &CMap, &I, 0, 0, 0, 0, ALLOC ) ) 
      exit(0);

   /* get the size */
   X = RasHd.ras_width ;
   Y = RasHd.ras_height;

   /* calculate image data structure length */
   if ( X % 2 )
      {
      N = (X+1) * Y;
      }
   else
      {
      N = X * Y;
      }


   /* If we are to strip nonexistant cmap, quit */
   if ( strip && !CMap )
      {
      fprintf(stderr,"There is no colormap in %s\n", InName);
      fprintf(stderr,"%s not modified (or created).\n", OutName);
      exit(0);
      }


   /* remap the image */
   ExtractLuminance( &RasHd, CMap, I, 0, 0, 0, 0 );


   /* create new rasterfile header */
   RasHd.ras_magic  = RAS_MAGIC;
   RasHd.ras_width  = X;
   RasHd.ras_height = Y;
   RasHd.ras_depth  = 8;
   RasHd.ras_length = N;
   RasHd.ras_type   = RT_STANDARD;
   RasHd.ras_maptype   = strip ? RMT_NONE : RMT_EQUAL_RGB;
   RasHd.ras_maplength = strip ? 0 : CMAPSZ;


   /* color map manipulations */
   if ( strip )  /* write without colormap */
      {
      free( CMap );
      CMap = NULL;
      }
   else if ( CMap == NULL ) /* create a gray color map */
      {
      if ( !(CMap = (byte *)malloc( CMAPSZ )) )
         {
         fprintf(stderr,"Unable to allocate space for colormap\n");
         exit( 0 );
         }
      C = CMap;
      N = CMAPSZ / 3;
      for ( i=0; i<N; ++i )
         {
         *C = i;
         *(C+N) = i;
         *(C+2*N) = i;
         ++C;
         }
      }


   /* open output file */
   if ( !std )
      {
      fclose( fpi );
      fpo = OpenFile( OutName, NULL, "w" );
      }

   /* write out file */
   WriteRasterFile( fpo, &RasHd, CMap, I, 0, 0, 0, 0 );

   if ( !std ) fclose( fpo );
   if ( CMap ) free( CMap );
   free ( I );
   }




 
