#define CMD_CREATE	1	/* (filename, filesize, modtime) */
#define CMD_OPEN	2	/* (filename) */
#define CMD_STAT	3	/* (filename) */
#define CMD_WRITE	4	/* (length, bytes) */
#define CMD_READ	5	/* (length) */
#define CMD_SPAWN	6	/* (argc, argv) */
#define CMD_QUIT	7	/* () */

#define MSGBUFSIZE	1024
#define FILEBUFSIZE	8*1024

/*
 * format of server-to-client message codes:
 * only the lower 16 bits are used for now.  Of these:
 * 1.  the high order nybble is the message type
 * message types are basically success reply, error reply, and informational,
 * where the latter two indicate that the contents of the message is text
 * to be printed out to the client's standard output or standard error file.
 * 2.  the next nybble is the source of the error code: client or server,
 * and whether the error came pvm or unix or the client/server code itself.
 * 3.  The low order byte is the error code from that particular facility
 *
 */

#define MSG_REPLY_MASK	0x8000	/* "reply" bit */

#define MSG_REPLY	0x0000	/* reply */
#define MSG_SIGNAL	0x8000	/* signal */

#define MSG_TYPE_MASK	0xf000

#define MSG_OK_REPLY	(MSG_REPLY | 0x0000) /* success reply */
#define MSG_ERR_REPLY	(MSG_REPLY | 0x1000) /* error reply */
#define MSG_STDOUT	(MSG_SIGNAL | 0x2000) /* informational (stdout) */
#define MSG_STDERR	(MSG_SIGNAL | 0x3000) /* informational (stdout) */
#define MSG_SRVR_EXIT	(MSG_SIGNAL | 0x4000) /* server voluntarily exited */
#define MSG_PROC_EXIT	(MSG_SIGNAL | 0x5000) /* spawned process completed */

/*
 * message formats:
 *
 * REPL_STAT file-size(integer) mod-time(long)
 * REPL_READ num-bytes(ingeger) buf(bytes)
 * [other-success-reply-code]
 *
 * [any-error-reply-code] text-length(integer) text(bytes)
 *
 * MSG_STDOUT text-length(integer) text(bytes)
 * MSG_STDERR text-length(integer) text(bytes)
 * MSG_SRVR_EXIT 
 * MSG_PROC_EXIT code(integer)
/*
 * reply codes for successful completion of a command
 */

#define REPL_OK		(MSG_OK_REPLY)
#define REPL_STAT	(MSG_OK_REPLY | CMD_STAT)
#define REPL_READ	(MSG_OK_REPLY | CMD_READ)

/*
 * So that we can combine a lot of different error codes (pvm return
 * values, UNIX errno, server errors), each error code has a source
 * field that indicates where the error came from.  Also, if the
 * source field is non-zero, the code is universal error code.
 */

#define ERR_SRC_MASK	0x0f00	/* source of error code */

#define SRC_UNKNOWN	0x0000	/* unknown */
#define SRC_CLNT	0x0100	/* client */
#define SRC_SRVR	0x0200	/* server */
#define SRC_CLNT_PVM	0x0500	/* pvm on client */
#define SRC_SRVR_PVM	0x0600	/* pvm on server */
#define SRC_CLNT_UNIX	0x0900	/* unix on client */
#define SRC_SRVR_UNIX	0x0a00	/* unix on server */

#define IS_ERROR_CODE(x) (((x) & ERR_SRC_MASK) == SRC_UNKNOWN)

#define ERR_CODE_MASK	0x00ff

/*
 * "system" error codes (i.e. from UNIX)
 *
 * since some UNIX systems may vary in what the different values of errno
 * mean, we standardize on the following, which should be sufficient for
 * the basic file i/o and process stuff that we do.  Others get lumped
 * into ERR_UNKNOWN.
 */

#define ERR_UNKNOWN	0	/* unknown error */
#define ERR_EPERM	1	/* not owner */
#define ERR_ENOENT	2	/* no such file or directory */
#define ERR_ESRCH	3	/* no such process */
#define ERR_EINTR	4	/* interrupted system call */
#define ERR_EIO		5	/* i/o error */
#define ERR_ENXIO	6	/* no such device or address */
#define ERR_E2BIG	7	/* arg list too long */
#define ERR_ENOEXEC	8	/* exec format error */
#define ERR_EBADF	9	/* bad file number */
#define ERR_ECHILD	10	/* no children */
#define ERR_EAGAIN	11	/* no more processes */
#define ERR_ENOMEM	12	/* out of memory */
#define ERR_EACCES	13	/* permission denied */
#define ERR_EFAULT	14	/* bad address */
#define ERR_ENOTBLK	15	/* block device required */
#define ERR_EBUSY	16	/* mount device busy */
#define ERR_EEXIST	17	/* file exists */
#define	ERR_EXDEV	18	/* cross-device link */
#define	ERR_ENODEV	19	/* no such device */
#define	ERR_ENOTDIR	20	/* not a directory*/
#define	ERR_EISDIR	21	/* is a directory */
#define	ERR_EINVAL	22	/* invalid argument */
#define	ERR_ENFILE	23	/* file table overflow */
#define	ERR_EMFILE	24	/* too many open files */
#define	ERR_ENOTTY	25	/* not a typewriter */
#define	ERR_ETXTBSY	26	/* text file busy */
#define	ERR_EFBIG	27	/* file too large */
#define	ERR_ENOSPC	28	/* no space left on device */
#define	ERR_ESPIPE	29	/* illegal seek */
#define	ERR_EROFS	30	/* read-only file system */
#define	ERR_EMLINK	31	/* too many links */
#define	ERR_EPIPE	32	/* broken pipe */

/*
 * client/server error codes
 */
#define ERR_BADINST	1	/* bad instance number */

#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(A) A
#else
#define __(A) ()
#endif

int cmd_start __((char *machine, int *instno));
int cmd_create __((int instno, char *filename, long filesize, long modtime));
int cmd_open __((int instno, char *filename));
int cmd_stat __((int instno, char *filename, long *filesize,
		unsigned long *modtime));
int cmd_write __((int instno, char *buf, int nbytes));
int cmd_read __((int instno, char *buf, int *nbytes));
int cmd_spawn __((int instno, int argc, char **argv));
int cmd_quit __((int instno));
int cmd_wait __((int *instno));
void cmd_exit_hook __((void (*proc)()));
void cmd_stdout_hook __((void (*proc)()));
void cmd_stderr_hook __((void (*proc)()));

#undef __
