typedef struct dlist {
  struct dlist *flink;
  struct dlist *blink;
  char *val;
} *Dlist;

/* Nil, first, next, and prev are macro expansions for list traversal 
 * primitives. */

#ifndef nil
#define nil(l) (l)
#endif

#ifndef first
#define first(l) ((l)->flink)
#endif

#ifndef last
#define last(l) ((l)->blink)
#endif

#ifndef next
#define next(n) ((n)->flink)
#endif

#ifndef prev
#define prev(n) ((n)->blink)
#endif

/* These are the routines for manipluating lists */

extern Dlist make_dl();
extern dl_insert_b(/* node, val */); /* Makes a new node, and inserts it before
                                        the given node -- if that node is the 
                                        head of the list, the new node is 
                                        inserted at the end of the list */
#define dl_insert_a(n, val) dl_insert_b((n)->flink, (val))

extern dl_delete_node(/* node */);    /* Deletes and free's a node */

extern dl_delete_list(/* head_node */);  /* Deletes the entire list from
                                            existance */
#define dl_traverse(ptr, list) \
  for ((ptr) = first(list); (ptr) != nil(list); (ptr) = next(ptr))
#define dl_empty(list) ((list)->flink == (list))

