/*
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/RCS/wrap.c,v $
 * $Revision: 1.1 $
 * $Date: 1992/04/08 05:53:29 $
 * $Author: moore $
 */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

hence_exp_coerce(v, type, inds, exp)
void *v;
int type;
int inds;
Exp exp;
{
  Param p;
  Array a;
  
  if (inds == 0) {
    switch(exp->type) {
      case INT: type_coerce(v, (void *) &(exp->val.i), type, exp->type);
                break;
      case CHAR: type_coerce(v, (void *) &(exp->val.c), type, exp->type);
                  break;
      case FLOAT: type_coerce(v, (void *) &(exp->val.f), type, exp->type);
                  break;
      case DOUBLE: type_coerce(v, (void *) &(exp->val.d), type, exp->type);
                   break;
      default: 
        bail("INTE: hence_exp_coerce: exp should be scalar\n");
    }
  } else {
    if (exp->type == ARRAY) {
      if (inds == 1) {
        type_coerce(v, (void *) exp->val.a->v.c, ARRAY, ARRAY);
      } else { 
        type_coerce(v, exp->val.a->ptr, ARRAY, ARRAY);
      } 
    } else if (exp->elt_type == 'A') {
      p = exp->args[0]->val.p;
      if (p->val == ENULL) {
        bail ("INTE: hence_exp_coerce: p->val == ENULL\n");
      } else if (p->val->type != ARRAY) {
        switch(p->val->type) {
          case INT:       *((int **)v) = &(p->val->val.i); break;
          case CHAR:     *((char **)v) = &(p->val->val.c); break;
          case FLOAT:   *((float **)v) = &(p->val->val.f); break;
          case DOUBLE: *((double **)v) = &(p->val->val.d); break;
          default: bail("INTE: h_e_coerce: p->val: bad type\n");
        }
      } else {
        a = p->val->val.a;
        if (inds == 2) {
          if (a->refd.ptr) print_double_warning(p);
          a->refd.v = 1;
          switch(a->type) {
            case INT:       *((int ***)v) = &(a->v.i); break;
            case CHAR:     *((char ***)v) = &(a->v.c); break;
            case FLOAT:   *((float ***)v) = &(a->v.f); break;
            case DOUBLE: *((double ***)v) = &(a->v.d); break;
            default: bail("INTE: h_e_coerce: a->val: bad type\n");
          }
        } else {
          if (a->refd.v) print_double_warning(p);
          a->refd.ptr = 1;
          *((void ***)v) = &(a->ptr);
        }
      }
    }   
  }
}


set_returned_param(rv, type, inds, p, nm)
void *rv;
int type;
int inds;
Param p;
char *nm;
{
  int tp;
  Array a;
  if (p == PNULL) return;
  
  if (inds == 0) {
    free_exp(p->val);
    if (p->type == ARRAY && p->a->nadims != 0)
      bail("INTE: set_returned_param: p->a->nadims != 0\n");
    if (p->type == ARRAY) tp = p->a->type; else tp = p->type;
    p->val = make_null_exp(tp);
    type_coerce((void *) &(p->val->val.i), rv, tp, type);
  } else if (inds == 1) {
    /* This is a potential memory leak -- oh well */
    a = p->val->val.a;
    a->v.c = (char *)rv;
    a->refd.ptr = 0;
    a->refd.v = 1;
    a->refd.init = 1;
    build_ptr_tree(a);
  } else {
    /* Again -- a memory leak */
    a = p->val->val.a;
    a->ptr = rv;
    a->refd.ptr = 1;
    a->refd.v = 0;
    a->refd.init = 1;
  }
}

hence_narg_check(wargs, gargs, nm)
int wargs, gargs;
char *nm;
{
  if (wargs != gargs) {
    fprintf(stderr, "ERROR: Function %s uses %d arguments,\n", nm, wargs);
    fprintf(stderr, "  but was called with %d.\n", gargs);
    nice_bail(CNULL);
  }
}

static stars(n)
int n;
{
  while(n-- > 0) {
    fputc('*', stderr);
  }
}

hence_check_arg(n, args, type, inds, nm)
int n;
Exp *args;
int type;
int inds;
char *nm;
{
  Exp e;
  Param p;
  int tp, ninds;

  e = args[n];
  if (inds > 0) {
    if (e->elt_type == 'A') {
      if (e->args[0] == ENULL || e->args[0]->elt_type != 'P') {
        bail("INTE: hence_check_arg: &(not param)\n");
      } 
      p = e->args[0]->val.p;
      if (p->type == ARRAY) {
        ninds = 1 + p->a->nadims;
        tp = p->a->type;
      } else {
        ninds = 1;
        tp = p->type;
      }
      if (type != tp) {
        fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
        fprintf(stderr, "  Wrapper expects an array of %s,\n", types[type]);
        fprintf(stderr, "  but received a pointer to %ss.\n", types[tp]);
        nice_bail(CNULL);
      } else if (ninds != inds && inds != 2) {
        fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
        fprintf(stderr, "  Wrapper expects a (%s ", types[type]);
        stars(inds);
        fprintf(stderr, "),\n  but received &(%s ", types[tp]);
        stars(ninds - 1);
        printf(").\n");
        nice_bail(CNULL);
      }
    } else if (e->type != ARRAY) {
      fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
      fprintf(stderr, "  Wrapper expects an pointer or array (%s ", 
        types[type]);
      stars(inds);
      fprintf(stderr, "),\n  but received the scalar: ");
      fprint_exp(stderr, e);
      nice_bail("\n");
    } else if (e->val.a->type != type) {
      fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
      fprintf(stderr, "  Wrapper expects an array of %s,\n", types[type]);
      fprintf(stderr, "  but received an array of %s.\n", 
              types[e->val.a->type]);
      nice_bail(CNULL);
    } else if (e->val.a->ndims != inds && inds != 1) {
      fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
      fprintf(stderr, "  Wrapper expects a (%s ", types[type]);
      stars(inds);
      fprintf(stderr, "),\n  but received (%s ", types[e->val.a->type]);
      stars(e->val.a->ndims);
      printf(").\n");
      nice_bail(CNULL);
    }
  } else {
    if (e->type == ARRAY) {
      fprintf(stderr, "ERROR: Function %s, argument %d\n", nm, n);
      fprintf(stderr, "  Wrapper expects a scalar (%s),\n", types[type]);
      fprintf(stderr, "  but received an array: (%s ", types[e->val.a->type]);
      stars(e->val.a->ndims);
      printf(").\n");
      nice_bail(CNULL);
    }
  }
}

hence_check_retp(p, nm, type, ind)
Param p;
char *nm;
int type;
int ind;
{
  if (p != PNULL && type == -1) {
    fprintf(stderr, "ERROR: Wrapper for Function %s:\n", nm);
    fprintf(stderr, "  %s has no return value, yet was bound to", nm);
    fprintf(stderr, " the parameter:\n    ");
    fprint_param(stderr, p);
    nice_bail("\n");
  } else if (p == PNULL) {
    /* This is ok -- the return value won't be used */
  } else if (ind == 0 && p->type == ARRAY && p->a->nadims != 0) {
    fprintf(stderr, "ERROR: Function %s, return value:", nm);
    fprintf(stderr, "  Wrapper expects a scalar (%s),\n", types[type]);
    fprintf(stderr, "  but received an array: (%s ", types[p->a->type]);
    stars(p->a->nadims);
    printf(").\n");
    nice_bail(CNULL);
  } else if (ind > 0 && (p->type != ARRAY || p->a->ndims == 0)) {
    fprintf(stderr, "ERROR: Function %s, return value:", nm);
    fprintf(stderr, "  Wrapper expects a (%s ", types[type]);
    stars(ind);
    if (p->type != ARRAY) {
      fprintf(stderr, "),\n  but received a scalar: (%s)\n", types[p->type]);
    } else {
      fprintf(stderr, "),\n  but received a scalar: (%s)\n", 
        types[p->a->type]);
    }
    nice_bail(CNULL);
  } else if (ind > 0 && (p->a->type != type ||
                         (p->a->ndims != ind && ind != 1))) {
    fprintf(stderr, "ERROR: Function %s, return value:", nm);
    fprintf(stderr, "  Wrapper expects a (%s ", types[type]);
    stars(ind);
    fprintf(stderr, ")\n  but received a (%s ", types[p->a->type]);
    stars(p->a->nadims);
    fprintf(stderr, ")\n");
    nice_bail(CNULL);
  }
}

print_double_warning(p)
Param p;
{
  fprintf(stderr, "%sWARNING: Array Parameter: ", sl_id());
  fprint_param(stderr, p);
  fprintf(stderr, "\n%s  Addresses to pointer tree and to chunk", sl_id());
  fprintf(stderr, " of bytes\n%s  have both been ", sl_id());
  fprintf(stderr, "passed as arguments\n");
}
